/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.util.List;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DuplicateAction
extends NodeAction {
    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && DuplicateAction.getParent(comps) != null;
    }

    public String getName() {
        return NbBundle.getMessage(AlignAction.class, (String)"ACT_Duplicate");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodes) {
        DuplicateAction.duplicate(nodes, -1, -1);
    }

    public static void performAction(Node[] nodes, int keyCode) {
        int dimension = keyCode == 37 || keyCode == 39 ? 0 : 1;
        int direction = keyCode == 37 || keyCode == 38 ? 0 : 1;
        DuplicateAction.duplicate(nodes, dimension, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void duplicate(Node[] nodes, int dimension, int direction) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        RADVisualContainer parent = DuplicateAction.getParent(comps);
        if (parent != null) {
            FormModel formModel = parent.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit layoutEdit = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            String[] sourceIds = new String[comps.size()];
            String[] targetIds = new String[comps.size()];
            int i = 0;
            MetaComponentCreator creator = formModel.getComponentCreator();
            try {
                for (RADComponent comp : comps) {
                    RADComponent copiedComp = creator.copyComponent(comp, parent);
                    if (copiedComp == null) {
                        return;
                    }
                    sourceIds[i] = comp.getId();
                    targetIds[i] = copiedComp.getId();
                    ++i;
                }
                FormEditor.getFormDesigner(formModel).getLayoutDesigner().duplicateLayout(sourceIds, targetIds, dimension, direction);
                autoUndo = false;
            }
            finally {
                if (layoutUndoMark != null && !layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(layoutEdit);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    private static RADVisualContainer getParent(List components) {
        RADVisualContainer commonParent = null;
        for (Object comp : components) {
            if (comp instanceof RADVisualComponent) {
                RADVisualContainer parent = ((RADVisualComponent)comp).getParentContainer();
                if (parent == null || commonParent != null && parent != commonParent) {
                    return null;
                }
                if (commonParent != null) continue;
                commonParent = parent;
                continue;
            }
            return null;
        }
        return commonParent != null && commonParent.getLayoutSupport() == null ? commonParent : null;
    }
}

