/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class SelectLayoutAction
extends CallableSystemAction {
    private static String name;

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(SelectLayoutAction.class).getString("ACT_SelectLayout");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        Node[] nodes = SelectLayoutAction.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            RADVisualContainer container = SelectLayoutAction.getContainer(nodes[i]);
            if (container != null && !container.hasDedicatedLayoutSupport()) continue;
            return false;
        }
        return true;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LayoutMenu layoutMenu = new LayoutMenu(this.getName());
        ((JMenuItem)((Object)layoutMenu)).setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)((Object)layoutMenu), (String)SelectLayoutAction.class.getName());
        return layoutMenu;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
    }

    private static Node[] getNodes() {
        return ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
    }

    private static RADVisualContainer getContainer(Node node) {
        RADComponent metacomp;
        RADComponentCookie radCookie = (RADComponentCookie)node.getCookie(RADComponentCookie.class);
        if (radCookie != null && (metacomp = radCookie.getRADComponent()) instanceof RADVisualContainer) {
            return (RADVisualContainer)metacomp;
        }
        return null;
    }

    private static PaletteItem[] getAllLayouts() {
        PaletteItem[] allItems = PaletteUtils.getAllItems();
        ArrayList<PaletteItem> layoutsList = new ArrayList<PaletteItem>();
        for (int i = 0; i < allItems.length; ++i) {
            if (!allItems[i].isLayout()) continue;
            layoutsList.add(allItems[i]);
        }
        PaletteItem[] layouts = new PaletteItem[layoutsList.size()];
        layoutsList.toArray(layouts);
        return layouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertToNewLayout(RADVisualContainer metacont) {
        FormModel formModel = metacont.getFormModel();
        LayoutModel layoutModel = formModel.getLayoutModel();
        Object layoutUndoMark = layoutModel.getChangeMark();
        UndoableEdit ue = layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            Border border;
            formModel.setNaturalContainerLayout(metacont);
            FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
            Container cont = metacont.getContainerDelegate(formDesigner.getComponent(metacont));
            Insets insets = new Insets(0, 0, 0, 0);
            if (cont instanceof JComponent && (border = ((JComponent)cont).getBorder()) != null) {
                insets = border.getBorderInsets(cont);
            }
            HashMap<String, Rectangle> idToBounds = new HashMap<String, Rectangle>();
            Rectangle notKnown = new Rectangle();
            for (RADVisualComponent metacomp : metacont.getSubComponents()) {
                Component comp = (Component)formDesigner.getComponent(metacomp);
                if (comp == null) {
                    comp = (Component)metacomp.getBeanInstance();
                }
                Rectangle bounds = comp.getBounds();
                Dimension dim = comp.getPreferredSize();
                if (bounds.equals(notKnown)) {
                    bounds.setSize(dim);
                }
                bounds = new Rectangle(bounds.x - insets.left, bounds.y - insets.top, bounds.width, bounds.height);
                idToBounds.put(metacomp.getId(), bounds);
            }
            formDesigner.getLayoutDesigner().copyLayoutFromOutside(idToBounds, metacont.getId(), false);
            autoUndo = false;
        }
        finally {
            if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                formModel.addUndoableEdit(ue);
            }
            if (autoUndo) {
                formModel.forceUndoOfCompoundEdit();
            } else {
                FormEditor.getFormEditor(formModel).updateProjectForNaturalLayout();
            }
        }
    }

    private static class LayoutActionListener
    implements ActionListener {
        private PaletteItem paletteItem;

        LayoutActionListener(PaletteItem paletteItem) {
            this.paletteItem = paletteItem;
        }

        public void actionPerformed(ActionEvent evt) {
            Node[] nodes = SelectLayoutAction.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                RADVisualContainer container = SelectLayoutAction.getContainer(nodes[i]);
                if (container == null) continue;
                if (this.paletteItem != null) {
                    container.getFormModel().getComponentCreator().createComponent(this.paletteItem.getComponentClassSource(), container, null);
                    continue;
                }
                if (container.getLayoutSupport() == null) continue;
                SelectLayoutAction.convertToNewLayout(container);
            }
        }
    }

    private static class LayoutMenu
    extends JMenuPlus {
        private boolean initialized = false;

        private LayoutMenu(String name) {
            super(name);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            Node[] nodes = SelectLayoutAction.getNodes();
            if (nodes.length != 0 && !this.initialized) {
                popup.removeAll();
                JMenuItem mi = new JMenuItem(NbBundle.getMessage(SelectLayoutAction.class, (String)"NAME_FreeDesign"));
                popup.add(mi);
                mi.addActionListener(new LayoutActionListener(null));
                popup.addSeparator();
                RADVisualContainer container = SelectLayoutAction.getContainer(nodes[0]);
                boolean hasFreeDesignSupport = RADVisualContainer.isFreeDesignContainer(container);
                if (hasFreeDesignSupport) {
                    LayoutMenu.setBoldFontForMenuText(mi);
                }
                PaletteItem[] layouts = SelectLayoutAction.getAllLayouts();
                for (int i = 0; i < layouts.length; ++i) {
                    mi = new JMenuItem(layouts[i].getNode().getDisplayName());
                    HelpCtx.setHelpIDString((JComponent)mi, (String)SelectLayoutAction.class.getName());
                    LayoutMenu.addSortedMenuItem(popup, mi);
                    mi.addActionListener(new LayoutActionListener(layouts[i]));
                    if (hasFreeDesignSupport || !this.isContainersLayout(container, layouts[i])) continue;
                    LayoutMenu.setBoldFontForMenuText(mi);
                }
                this.initialized = true;
            }
            return popup;
        }

        private boolean isContainersLayout(RADVisualContainer container, PaletteItem layout) {
            return container != null && (container.getLayoutSupport().getLayoutDelegate().getSupportedClass() == layout.getComponentClass() || container.getLayoutSupport().getLayoutDelegate().getClass() == NullLayoutSupport.class && layout.getComponentClass() == NullLayoutSupport.class);
        }

        private static void addSortedMenuItem(JPopupMenu menu, JMenuItem menuItem) {
            int n = menu.getComponentCount();
            String text = menuItem.getText();
            for (int i = 2; i < n; ++i) {
                String tx;
                if (!(menu.getComponent(i) instanceof JMenuItem) || text.compareTo(tx = ((JMenuItem)menu.getComponent(i)).getText()) >= 0) continue;
                menu.add((Component)menuItem, i);
                return;
            }
            menu.add(menuItem);
        }

        private static void setBoldFontForMenuText(JMenuItem mi) {
            Font font = mi.getFont();
            mi.setFont(font.deriveFont(font.getStyle() | 1));
        }
    }
}

