/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class SetResizabilityAction
extends NodeAction {
    private JCheckBoxMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && comps.size() > 0;
    }

    public String getName() {
        return NbBundle.getMessage(SetResizabilityAction.class, (String)"ACT_SetResizability");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(SetResizabilityAction.class, (String)"ACT_SetResizability"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)SetResizabilityAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                SetResizabilityAction.this.createResizabilitySubmenu(menu);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createResizabilitySubmenu(JMenu menu) {
        Node[] nodes = this.getActivatedNodes();
        List<RADComponent> components = FormUtils.getSelectedLayoutComponents(nodes);
        if (components == null || components.size() < 1) {
            return;
        }
        if (menu.getMenuComponentCount() <= 0) {
            ResourceBundle bundle = NbBundle.getBundle(SetResizabilityAction.class);
            ResizabilityMenuItem hItem = new ResizabilityMenuItem(bundle.getString("CTL_ResizabilityH"), components, 0);
            ResizabilityMenuItem vItem = new ResizabilityMenuItem(bundle.getString("CTL_ResizabilityV"), components, 1);
            this.items = new JCheckBoxMenuItem[]{hItem, vItem};
            for (int i = 0; i < 2; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)SetResizabilityAction.class.getName());
                menu.add(this.items[i]);
            }
        }
        this.updateState(components);
    }

    private void updateState(List components) {
        if (components == null || components.size() < 1) {
            return;
        }
        RADComponent rc = (RADComponent)components.get(0);
        FormDesigner formDesigner = FormEditor.getFormDesigner(rc.getFormModel());
        formDesigner.updateResizabilityActions();
        for (int i = 0; i < 2; ++i) {
            this.items[i].setEnabled(formDesigner.getResizabilityButtons()[i].isEnabled());
            this.items[i].setSelected(formDesigner.getResizabilityButtons()[i].isSelected());
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new ResizabilityMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class ResizabilityMenuItem
    extends JCheckBoxMenuItem {
        private int direction;
        private List components;

        ResizabilityMenuItem(String text, List components, int direction) {
            super(text);
            this.components = components;
            this.direction = direction;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }

    private static class ResizabilityMenuItemListener
    implements ActionListener {
        private ResizabilityMenuItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof ResizabilityMenuItem)) {
                return;
            }
            ResizabilityMenuItem mi = (ResizabilityMenuItem)source;
            if (!mi.isEnabled()) {
                return;
            }
            int index = mi.getDirection();
            RADComponent radC = (RADComponent)mi.getRADComponents().get(0);
            FormModel fm = radC.getFormModel();
            FormDesigner fd = FormEditor.getFormDesigner(fm);
            fd.getResizabilityButtons()[index].setSelected(!fd.getResizabilityButtons()[index].isSelected());
            ((Action)fd.getResizabilityActions().toArray()[index]).actionPerformed(evt);
        }
    }
}

