/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public class TestAction
extends CallableSystemAction
implements Runnable {
    private static String name;
    private FormDesigner formDesigner;
    private Class selectedLaf;

    public TestAction() {
        this.setEnabled(false);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(TestAction.class).getString("ACT_TestMode");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.testing");
    }

    protected String iconResource() {
        return "org/netbeans/modules/form/resources/test_form.png";
    }

    public void performAction() {
        if (this.formDesigner != null) {
            this.selectedLaf = null;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }
    }

    public void run() {
        RADVisualComponent topComp = this.formDesigner.getTopDesignComponent();
        if (topComp == null) {
            return;
        }
        RADVisualContainer parent = topComp.getParentContainer();
        while (parent != null) {
            topComp = parent;
            parent = topComp.getParentContainer();
        }
        FormModel formModel = this.formDesigner.getFormModel();
        RADVisualFormContainer formContainer = topComp instanceof RADVisualFormContainer ? (RADVisualFormContainer)topComp : null;
        Object formInstance = topComp.getBeanInstance();
        Class<JFrame> frameClass = formInstance instanceof JComponent || formInstance instanceof JFrame || formInstance instanceof JDialog || formInstance instanceof JApplet || formInstance instanceof JWindow || !(formInstance instanceof Window) && !(formInstance instanceof Panel) ? JFrame.class : Frame.class;
        try {
            Frame frame;
            String title;
            if (this.selectedLaf == null) {
                this.selectedLaf = UIManager.getLookAndFeel().getClass();
            }
            if ((title = (frame = (Frame)FormDesigner.createFormView(topComp, frameClass, this.selectedLaf)).getTitle()) == null || "".equals(title)) {
                title = topComp == formModel.getTopRADComponent() ? formModel.getName() : topComp.getName();
                frame.setTitle(MessageFormat.format(NbBundle.getBundle(TestAction.class).getString("FMT_TestingForm"), title));
            }
            if (frame instanceof JFrame) {
                ((JFrame)frame).setDefaultCloseOperation(2);
                HelpCtx.setHelpIDString((JComponent)((JFrame)frame).getRootPane(), (String)"gui.modes");
            } else {
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        frame.dispose();
                    }
                });
            }
            boolean shouldPack = false;
            if (formContainer != null && formContainer.getFormSizePolicy() == 0 && formContainer.getGenerateSize()) {
                Dimension size = formContainer.getFormSize();
                if (frame.isUndecorated()) {
                    Dimension diffSize = formContainer.getDecoratedWindowContentDimensionDiff();
                    size = new Dimension(size.width + diffSize.width, size.height + diffSize.height);
                }
                frame.setSize(size);
            } else {
                shouldPack = true;
            }
            frame.setUndecorated(false);
            frame.setFocusableWindowState(true);
            final boolean pack = shouldPack;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (pack) {
                        frame.pack();
                    }
                    frame.setBounds(Utilities.findCenterBounds((Dimension)frame.getSize()));
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LAFMenu layoutMenu = new LAFMenu(this.getName());
        layoutMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)layoutMenu, (String)SelectLayoutAction.class.getName());
        return layoutMenu;
    }

    public void setFormDesigner(FormDesigner designer) {
        this.formDesigner = designer;
        this.setEnabled(this.formDesigner != null && this.formDesigner.getTopDesignComponent() != null);
    }

    private class LAFMenu
    extends JMenu
    implements ActionListener {
        private boolean initialized;

        private LAFMenu(String name) {
            super(name);
            this.initialized = false;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            if (!this.initialized) {
                JMenuItem mi;
                popup.removeAll();
                UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lafs.length; ++i) {
                    mi = new JMenuItem(lafs[i].getName());
                    mi.putClientProperty("lafInfo", new LookAndFeelItem(lafs[i].getClassName()));
                    mi.addActionListener(this);
                    popup.add(mi);
                }
                Node[] cats = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false);
                for (int i = 0; i < cats.length; ++i) {
                    if (!"LookAndFeels".equals(cats[i].getName())) continue;
                    Node lafNode = cats[i];
                    Node[] items = PaletteUtils.getItemNodes(lafNode, true);
                    if (items.length != 0) {
                        popup.add(new JSeparator());
                    }
                    for (int j = 0; j < items.length; ++j) {
                        PaletteItem pitem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                        boolean supported = false;
                        try {
                            Class clazz = pitem.getComponentClass();
                            if (clazz != null && LookAndFeel.class.isAssignableFrom(clazz)) {
                                LookAndFeel laf = (LookAndFeel)clazz.newInstance();
                                supported = laf.isSupportedLookAndFeel();
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        catch (LinkageError ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        if (!supported) continue;
                        mi = new JMenuItem(items[j].getDisplayName());
                        mi.putClientProperty("lafInfo", new LookAndFeelItem(pitem));
                        mi.addActionListener(this);
                        popup.add(mi);
                    }
                }
                this.initialized = true;
            }
            return popup;
        }

        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o instanceof JComponent) {
                JComponent source = (JComponent)o;
                LookAndFeelItem item = (LookAndFeelItem)source.getClientProperty("lafInfo");
                try {
                    TestAction.this.selectedLaf = item.getLAFClass();
                    TestAction.this.run();
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    static class LookAndFeelItem {
        private String className;
        private PaletteItem pitem;

        public LookAndFeelItem(String className) {
            this.className = className;
        }

        public LookAndFeelItem(PaletteItem pitem) {
            this.pitem = pitem;
            this.className = pitem.getComponentClassName();
        }

        public String getClassName() {
            return this.className;
        }

        public Class getLAFClass() throws ClassNotFoundException {
            Class<?> clazz = this.pitem == null ? (this.className == null ? UIManager.getLookAndFeel().getClass() : Class.forName(this.className)) : this.pitem.getComponentClass();
            return clazz;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LookAndFeelItem)) {
                return false;
            }
            LookAndFeelItem item = (LookAndFeelItem)obj;
            return this.pitem == item.pitem && (this.pitem != null || (this.className == null ? item.className == null : this.className.equals(item.className)));
        }

        public int hashCode() {
            return this.className == null ? this.pitem.hashCode() : this.className.hashCode();
        }
    }
}

