/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.assistant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.openide.util.Utilities;

public class AssistantView
extends JPanel {
    private JLabel messageLabel;
    private AssistantModel model;

    public AssistantView(AssistantModel model) {
        this.model = model;
        Listener listener = new Listener();
        model.addPropertyChangeListener(listener);
        this.setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getForeground()));
        this.setToolTipText(null);
        this.messageLabel = new JLabel();
        this.messageLabel.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/form/resources/lightbulb.gif")));
        JButton closeButton = new JButton("x");
        closeButton.setFont(Font.getFont("SansSerif"));
        closeButton.setOpaque(false);
        closeButton.setFocusPainted(false);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.setBorderPainted(false);
        closeButton.setContentAreaFilled(false);
        closeButton.addActionListener(listener);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setOpaque(false);
        panel.add(closeButton);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().add(12).add((Component)this.messageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)panel, -2, -1, -2).add(12));
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().add(2).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.messageLabel, -2, 36, -2).add((Component)panel, -2, -1, -2)).add(2));
    }

    private class Listener
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            FormLoaderSettings.getInstance().setAssistantShown(false);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object[] params;
            int index;
            String[] messages = AssistantView.this.model.getMessages();
            String message = null;
            if (messages != null) {
                index = (int)(Math.random() * (double)messages.length);
                message = messages[index];
            }
            if (AssistantView.this.model.getAdditionalContext() != null && (messages = AssistantView.this.model.getAdditionalMessages()) != null) {
                index = (int)(Math.random() * (double)messages.length);
                message = "<html>" + message + "<br>" + messages[index];
            }
            if ((params = AssistantView.this.model.getParameters()) != null) {
                message = MessageFormat.format(message, params);
            }
            AssistantView.this.messageLabel.setText(message);
        }
    }
}

