/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.codestructure.AbstractCodeStatement;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.ErrorManager;

class CodeSupport {
    private CodeSupport() {
    }

    static String getSourceClassName(Class cls) {
        return cls.getName().replace('$', '.').replace('+', '.').replace('/', '.');
    }

    static final class AssignVariableStatement
    extends AbstractCodeStatement {
        private CodeVariable variable;

        public AssignVariableStatement(CodeVariable var, CodeExpression exp) {
            super(exp);
            this.variable = var;
        }

        public Object getMetaObject() {
            return this.parentExpression;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parentExpression.getOrigin().getCreationParameters();
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            int declareMask;
            StringBuffer buf = new StringBuffer();
            int varType = this.variable.getType();
            if ((varType & (declareMask = 28672)) == 4096) {
                if ((varType & 0x10) == 16) {
                    buf.append("final ");
                }
                buf.append(CodeSupport.getSourceClassName(this.variable.getDeclaredType()));
                buf.append(" ");
            }
            buf.append(this.variable.getName());
            buf.append(" = ");
            buf.append(this.parentExpression.getOrigin().getJavaCodeString(parentStr, paramsStr));
            buf.append(";");
            return buf.toString();
        }
    }

    static final class ConstructorOrigin
    implements CodeExpressionOrigin {
        private Constructor constructor;
        private CodeExpression[] parameters;

        public ConstructorOrigin(Constructor ctor, CodeExpression[] params) {
            this.constructor = ctor;
            this.parameters = params != null ? params : CodeStructure.EMPTY_PARAMS;
        }

        public Class getType() {
            return this.constructor.getDeclaringClass();
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getMetaObject() {
            return this.constructor;
        }

        public Object getValue() {
            Object[] params = new Object[this.parameters.length];
            for (int i = 0; i < params.length; ++i) {
                CodeExpressionOrigin paramOrigin = this.parameters[i].getOrigin();
                Object value = paramOrigin.getValue();
                Class type = paramOrigin.getType();
                if (value == null && type.isPrimitive()) {
                    return null;
                }
                params[i] = value;
            }
            try {
                return this.constructor.newInstance(params);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        public CodeExpression[] getCreationParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            buf.append("new ");
            buf.append(this.constructor.getName());
            buf.append("(");
            for (int i = 0; i < paramsStr.length; ++i) {
                buf.append(paramsStr[i]);
                if (i + 1 >= this.parameters.length) continue;
                buf.append(", ");
            }
            buf.append(")");
            return buf.toString();
        }
    }

    static final class DeclareVariableStatement
    extends AbstractCodeStatement {
        private CodeVariable variable;

        public DeclareVariableStatement(CodeVariable var) {
            super(null);
            this.variable = var;
        }

        public Object getMetaObject() {
            return this.variable;
        }

        public CodeExpression[] getStatementParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            int type = this.variable.getType();
            if ((type & 0x3000) == 8192) {
                switch (type & 7) {
                    case 1: {
                        buf.append("public ");
                        break;
                    }
                    case 2: {
                        buf.append("private ");
                        break;
                    }
                    case 4: {
                        buf.append("protected ");
                    }
                }
                if ((type & 8) == 8) {
                    buf.append("static ");
                }
                if ((type & 0x10) == 16) {
                    buf.append("final ");
                }
                if ((type & 0x80) == 128) {
                    buf.append("transient ");
                }
                if ((type & 0x40) == 64) {
                    buf.append("volatile ");
                }
            } else if ((type & 0x10) == 16) {
                buf.append("final ");
            }
            buf.append(CodeSupport.getSourceClassName(this.variable.getDeclaredType()));
            String typeParameters = this.variable.getDeclaredTypeParameters();
            if (typeParameters != null && !"".equals(typeParameters)) {
                buf.append(typeParameters);
            }
            buf.append(" ");
            buf.append(this.variable.getName());
            buf.append(";");
            return buf.toString();
        }
    }

    static final class DefaultCodeGroup
    implements CodeGroup {
        private List statements = new ArrayList();

        DefaultCodeGroup() {
        }

        public void addStatement(CodeStatement statement) {
            this.statements.add(statement);
        }

        public void addStatement(int index, CodeStatement statement) {
            this.statements.add(index, statement);
        }

        public void addGroup(CodeGroup group) {
            this.statements.add(group);
        }

        public void addGroup(int index, CodeGroup group) {
            this.statements.add(index, group);
        }

        public CodeStatement getStatement(int index) {
            Object obj = this.statements.get(index);
            if (obj instanceof CodeStatement) {
                return (CodeStatement)obj;
            }
            if (obj instanceof CodeGroup) {
                return ((CodeGroup)obj).getStatement(0);
            }
            return null;
        }

        public int indexOf(Object object) {
            return this.statements.indexOf(object);
        }

        public void remove(Object object) {
            this.statements.remove(object);
        }

        public void remove(int index) {
            this.statements.remove(index);
        }

        public void removeAll() {
            this.statements.clear();
        }

        public Iterator getStatementsIterator() {
            return new StatementsIterator();
        }

        class StatementsIterator
        implements Iterator {
            int index = 0;
            int count = DefaultCodeGroup.access$000(DefaultCodeGroup.this).size();
            Iterator subIter;

            StatementsIterator() {
            }

            public boolean hasNext() {
                if (this.subIter != null) {
                    if (this.subIter.hasNext()) {
                        return true;
                    }
                    this.subIter = null;
                    ++this.index;
                }
                while (this.index < this.count) {
                    Object item = DefaultCodeGroup.this.statements.get(this.index);
                    if (item instanceof CodeGroup) {
                        this.subIter = ((CodeGroup)item).getStatementsIterator();
                        if (this.subIter.hasNext()) {
                            return true;
                        }
                        this.subIter = null;
                    } else if (item instanceof CodeStatement) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.subIter != null ? this.subIter.next() : DefaultCodeGroup.this.statements.get(this.index++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class FieldOrigin
    implements CodeExpressionOrigin {
        private CodeExpression parentExpression;
        private Field originField;

        public FieldOrigin(CodeExpression parent, Field f) {
            this.parentExpression = parent;
            this.originField = f;
        }

        public Class getType() {
            return this.originField.getType();
        }

        public CodeExpression getParentExpression() {
            return this.parentExpression;
        }

        public Object getMetaObject() {
            return this.originField;
        }

        public Object getValue() {
            return null;
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            if (this.parentExpression != null) {
                if (parentStr != null && !parentStr.equals("")) {
                    buf.append(parentStr);
                    buf.append(".");
                }
            } else {
                buf.append(CodeSupport.getSourceClassName(this.originField.getDeclaringClass()));
                buf.append(".");
            }
            buf.append(this.originField.getName());
            return buf.toString();
        }
    }

    static final class FieldStatement
    extends AbstractCodeStatement {
        private Field assignField;
        private CodeExpression[] parameters;

        public FieldStatement(CodeExpression exp, Field f, CodeExpression assignedExp) {
            super(exp);
            this.assignField = f;
            this.parameters = new CodeExpression[]{assignedExp};
        }

        public Object getMetaObject() {
            return this.assignField;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            if (parentStr != null && !parentStr.equals("")) {
                buf.append(parentStr);
                buf.append(".");
            }
            buf.append(this.assignField.getName());
            buf.append(" = ");
            buf.append(paramsStr[0]);
            buf.append(";");
            return buf.toString();
        }
    }

    static final class MethodOrigin
    implements CodeExpressionOrigin {
        private CodeExpression parentExpression;
        private Method creationMethod;
        private CodeExpression[] parameters;

        public MethodOrigin(CodeExpression parent, Method m, CodeExpression[] params) {
            this.parentExpression = parent;
            this.creationMethod = m;
            this.parameters = params != null ? params : CodeStructure.EMPTY_PARAMS;
        }

        public Class getType() {
            return this.creationMethod.getReturnType();
        }

        public CodeExpression getParentExpression() {
            return this.parentExpression;
        }

        public Object getMetaObject() {
            return this.creationMethod;
        }

        public Object getValue() {
            return null;
        }

        public CodeExpression[] getCreationParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            if (this.parentExpression != null) {
                if (parentStr != null && !parentStr.equals("")) {
                    buf.append(parentStr);
                    buf.append(".");
                }
            } else {
                buf.append(CodeSupport.getSourceClassName(this.creationMethod.getDeclaringClass()));
                buf.append(".");
            }
            buf.append(this.creationMethod.getName());
            buf.append("(");
            for (int i = 0; i < paramsStr.length; ++i) {
                buf.append(paramsStr[i]);
                if (i + 1 >= this.parameters.length) continue;
                buf.append(", ");
            }
            buf.append(")");
            return buf.toString();
        }
    }

    static final class MethodStatement
    extends AbstractCodeStatement {
        private Method performMethod;
        private CodeExpression[] parameters;

        public MethodStatement(CodeExpression exp, Method m, CodeExpression[] params) {
            super(exp);
            this.performMethod = m;
            this.parameters = params != null ? params : CodeStructure.EMPTY_PARAMS;
        }

        public Object getMetaObject() {
            return this.performMethod;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            StringBuffer buf = new StringBuffer();
            if (parentStr != null && !parentStr.equals("")) {
                buf.append(parentStr);
                buf.append(".");
            }
            buf.append(this.performMethod.getName());
            buf.append("(");
            for (int i = 0; i < paramsStr.length; ++i) {
                buf.append(paramsStr[i]);
                if (i + 1 >= this.parameters.length) continue;
                buf.append(", ");
            }
            buf.append(");");
            return buf.toString();
        }
    }

    static final class ValueOrigin
    implements CodeExpressionOrigin {
        private Class expressionType;
        private Object expressionValue;
        private String javaString;

        public ValueOrigin(Class type, Object value, String javaStr) {
            this.expressionType = type;
            this.expressionValue = value;
            this.javaString = javaStr;
        }

        public Class getType() {
            return this.expressionType;
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getMetaObject() {
            return null;
        }

        public Object getValue() {
            return this.expressionValue;
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            return this.javaString;
        }
    }
}

