/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class ImportImageWizard
extends WizardDescriptor {
    private WizardDescriptor.Iterator wizardIterator;
    private File[] selectedFiles;
    private FileObject targetFolder;
    private FileObject fileInProject;

    ImportImageWizard(File[] files, FileObject targetFolder, FileObject fileInProject) {
        this((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(new WizardDescriptor.Panel[]{new SourceWizardPanel(), new TargetWizardPanel()}));
        if (targetFolder != null) assert (FileOwnerQuery.getOwner((FileObject)targetFolder) == FileOwnerQuery.getOwner((FileObject)fileInProject));
        this.selectedFiles = files;
        this.targetFolder = targetFolder;
        this.fileInProject = fileInProject;
    }

    private ImportImageWizard(WizardDescriptor.Iterator iterator) {
        super(iterator);
        this.wizardIterator = iterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
        this.putProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"), NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2")});
    }

    FileObject[] show() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        dialog.setVisible(true);
        dialog.dispose();
        return this.getValue() == FINISH_OPTION ? this.copyFiles() : null;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    private FileObject[] copyFiles() {
        if (this.selectedFiles == null || this.selectedFiles.length == 0 || this.targetFolder == null) {
            return null;
        }
        final FileObject[] copied = new FileObject[this.selectedFiles.length];
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    for (int i = 0; i < ImportImageWizard.this.selectedFiles.length; ++i) {
                        File f = ImportImageWizard.this.selectedFiles[i];
                        FileInputStream is = new FileInputStream(f);
                        FileObject fo = ImportImageWizard.this.targetFolder.createData(f.getName());
                        FileLock lock = fo.lock();
                        OutputStream os = fo.getOutputStream(lock);
                        byte[] buf = new byte[4096];
                        try {
                            int count;
                            while ((count = is.read(buf)) != -1) {
                                os.write(buf, 0, count);
                            }
                        }
                        finally {
                            os.close();
                            lock.releaseLock();
                        }
                        copied[i] = fo;
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return copied;
    }

    static /* synthetic */ File[] access$202(ImportImageWizard x0, File[] x1) {
        x0.selectedFiles = x1;
        return x1;
    }

    private static class SourceWizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel {
        private ImportImageWizard wizard;
        private JFileChooser fileChooser;
        private EventListenerList listenerList;
        private boolean setSelectedFiles;

        private SourceWizardPanel() {
        }

        public Component getComponent() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setAcceptAllFileFilterUsed(true);
                this.fileChooser.setControlButtonsAreShown(false);
                this.fileChooser.setMultiSelectionEnabled(true);
                this.fileChooser.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        if ("ApproveSelection".equals(ev.getActionCommand())) {
                            SourceWizardPanel.this.wizard.stepToNext();
                        } else if ("CancelSelection".equals(ev.getActionCommand())) {
                            SourceWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                        }
                    }
                });
                this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent ev) {
                        if (!SourceWizardPanel.this.setSelectedFiles && "SelectedFilesChangedProperty".equals(ev.getPropertyName())) {
                            SourceWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.fileChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"));
                this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            }
            if (this.setSelectedFiles) {
                this.fileChooser.setSelectedFiles(this.wizard.selectedFiles);
                this.setSelectedFiles = false;
            }
            return this.fileChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object settings) {
            this.wizard = (ImportImageWizard)((Object)settings);
            this.setSelectedFiles = true;
        }

        public void storeSettings(Object settings) {
            if (this.fileChooser != null) {
                ImportImageWizard.access$202((ImportImageWizard)((Object)settings), this.fileChooser.getSelectedFiles());
            }
        }

        public boolean isValid() {
            return this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0;
        }

        public boolean isFinishPanel() {
            return this.wizard != null && this.wizard.targetFolder != null;
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, l);
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, l);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }

    private static class TargetWizardPanel
    implements WizardDescriptor.Panel {
        private ImportImageWizard wizard;
        private ClassPathFileChooser cpfChooser;
        private EventListenerList listenerList;
        private boolean setTargetFolder;

        private TargetWizardPanel() {
        }

        public Component getComponent() {
            if (this.cpfChooser == null) {
                this.cpfChooser = new ClassPathFileChooser(this.wizard.fileInProject, new ClassPathFileChooser.Filter(){

                    public boolean accept(FileObject fo) {
                        return fo.isFolder();
                    }
                }, true, false);
                this.cpfChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent ev) {
                        if (!TargetWizardPanel.this.setTargetFolder && "selectedFile".equals(ev.getPropertyName())) {
                            TargetWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.cpfChooser.setPreferredSize(new Dimension(200, 200));
                this.cpfChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2"));
                this.cpfChooser.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            }
            if (this.setTargetFolder) {
                this.cpfChooser.setSelectedFile(this.wizard.targetFolder);
                this.setTargetFolder = false;
            }
            return this.cpfChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object settings) {
            this.wizard = (ImportImageWizard)((Object)settings);
            this.setTargetFolder = true;
        }

        public void storeSettings(Object settings) {
            if (this.cpfChooser != null) {
                this.wizard.targetFolder = this.cpfChooser.getSelectedFile();
            }
        }

        public boolean isValid() {
            if (this.cpfChooser != null) {
                FileObject fo = this.cpfChooser.getSelectedFile();
                return fo != null && fo.isFolder();
            }
            if (this.wizard != null) {
                return this.wizard.targetFolder != null;
            }
            return false;
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, l);
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, l);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }
}

