/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.border.Border;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class BorderDesignSupport
implements FormDesignValue {
    private Border theBorder;
    private boolean borderNeedsUpdate;
    private boolean propertiesNeedInit;
    private CreationDescriptor creationDesc;
    private FormPropertyContext propertyContext = null;
    private FormProperty[] properties = null;

    public BorderDesignSupport(Class borderClass) throws Exception {
        this.creationDesc = CreationFactory.getDescriptor(borderClass);
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(borderClass);
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.theBorder = (Border)CreationFactory.createInstance(borderClass);
    }

    public BorderDesignSupport(Border border) {
        this.creationDesc = CreationFactory.getDescriptor(border.getClass());
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(border.getClass());
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.setBorder(border);
    }

    public BorderDesignSupport(BorderDesignSupport borderDesignSupport, FormPropertyContext propertyContext) throws Exception {
        this(borderDesignSupport.getBorderClass());
        this.createProperties();
        this.setPropertyContext(propertyContext);
        int copyMode = 3;
        FormUtils.copyProperties(borderDesignSupport.getProperties(), this.properties, copyMode);
    }

    public FormDesignValue copy(FormProperty formProperty) {
        FormModel formModel = formProperty.getPropertyContext().getFormModel();
        try {
            return new BorderDesignSupport(this, new FormPropertyContext.EmptyImpl());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public Border getBorder() {
        if (this.borderNeedsUpdate) {
            this.updateBorder();
        }
        return this.theBorder;
    }

    public void setBorder(Border border) {
        this.theBorder = border;
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                try {
                    this.properties[i].reinstateProperty();
                    continue;
                }
                catch (IllegalAccessException e1) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            this.propertiesNeedInit = false;
        } else {
            this.propertiesNeedInit = true;
        }
        this.borderNeedsUpdate = false;
    }

    public Class getBorderClass() {
        return this.creationDesc.getDescribedClass();
    }

    public String getDisplayName() {
        return Utilities.getShortClassName(this.theBorder.getClass());
    }

    public void setPropertyContext(FormPropertyContext propertyContext) {
        if (this.properties != null && this.propertyContext != propertyContext) {
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].getValueType().isPrimitive()) continue;
                this.properties[i].setPropertyContext(propertyContext);
            }
        }
        this.propertyContext = propertyContext;
    }

    public Node.Property[] getProperties() {
        if (this.properties == null) {
            this.createProperties();
        }
        return this.properties;
    }

    public Node.Property getPropertyOfName(String name) {
        Node.Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            return props[i];
        }
        return null;
    }

    private void createProperties() {
        BeanInfo bInfo;
        try {
            bInfo = FormUtils.getBeanInfo(this.theBorder.getClass());
        }
        catch (IntrospectionException ex) {
            return;
        }
        PropertyDescriptor[] props = bInfo.getPropertyDescriptors();
        ArrayList<BorderProperty> nodeProps = new ArrayList<BorderProperty>();
        for (int i = 0; i < props.length; ++i) {
            PropertyDescriptor pd = props[i];
            if (pd.isHidden() || pd.getWriteMethod() == null && !CreationFactory.containsProperty(this.creationDesc, pd.getName())) continue;
            BorderProperty prop = new BorderProperty(pd.getPropertyType().isPrimitive() ? null : this.propertyContext, pd);
            if (this.propertiesNeedInit) {
                try {
                    prop.reinstateProperty();
                }
                catch (IllegalAccessException e1) {
                }
                catch (InvocationTargetException e2) {
                    // empty catch block
                }
            }
            nodeProps.add(prop);
        }
        this.properties = new FormProperty[nodeProps.size()];
        nodeProps.toArray(this.properties);
        this.propertiesNeedInit = false;
    }

    public String getJavaInitializationString() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        return creator.getJavaCreationCode(this.properties, Border.class);
    }

    void updateBorder() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        try {
            this.theBorder = (Border)CreationFactory.createInstance(this.creationDesc.getDescribedClass(), this.properties, 3);
            FormProperty[] otherProps = CreationFactory.getRemainingProperties(creator, this.properties);
            for (int i = 0; i < otherProps.length; ++i) {
                otherProps[i].reinstateTarget();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public Object getDesignValue() {
        return this.getBorder();
    }

    public Object getDesignValue(Object target) {
        return null;
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public class BorderProperty
    extends FormProperty {
        private PropertyDescriptor desc;

        public BorderProperty(FormPropertyContext propertyContext, PropertyDescriptor desc) {
            super(propertyContext, desc.getName(), desc.getPropertyType(), desc.getDisplayName(), desc.getShortDescription());
            this.desc = desc;
            if (desc.getWriteMethod() == null) {
                this.setAccessType(2);
            } else if (desc.getReadMethod() == null) {
                this.setAccessType(1);
            }
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            Method readMethod = this.desc.getReadMethod();
            return readMethod.invoke((Object)BorderDesignSupport.this.theBorder, new Object[0]);
        }

        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method writeMethod = this.desc.getWriteMethod();
            writeMethod.invoke((Object)BorderDesignSupport.this.theBorder, value);
        }

        protected Object getRealValue(Object value) {
            Object realValue = super.getRealValue(value);
            if (realValue == FormDesignValue.IGNORED_VALUE && "title".equals(this.desc.getName())) {
                realValue = ((FormDesignValue)value).getDescription();
            }
            return realValue;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            Method readMethod = this.desc.getReadMethod();
            Object value = null;
            if (readMethod != null) {
                try {
                    value = readMethod.invoke(BeanSupport.getDefaultInstance(BorderDesignSupport.this.theBorder.getClass()), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return value;
        }

        public PropertyEditor getExpliciteEditor() {
            try {
                return this.desc.createPropertyEditor(BorderDesignSupport.this.theBorder);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        protected Method getWriteMethod() {
            return this.desc.getWriteMethod();
        }

        protected void propertyValueChanged(Object old, Object current) {
            super.propertyValueChanged(old, current);
            BorderDesignSupport.this.borderNeedsUpdate = (this.getAccessType() & 2) != 0;
        }
    }
}

