/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.PersistenceObjectRegistry;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableColumnModelEditor
extends PropertyEditorSupport
implements NamedPropertyEditor,
FormCodeAwareEditor,
XMLPropertyEditor {
    private FormProperty property;
    private static final String XML_TABLE_COLUMN_MODEL = "TableColumnModel";
    private static final String ATTR_SELECTION_MODEL = "selectionModel";
    private static final String XML_COLUMN = "Column";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_RESIZABLE = "resizable";
    private static final String ATTR_WIDTH_MIN = "minWidth";
    private static final String ATTR_WIDTH_PREF = "prefWidth";
    private static final String ATTR_WIDTH_MAX = "maxWidth";
    private static final String XML_TITLE = "Title";
    private static final String XML_EDITOR = "Editor";
    private static final String XML_RENDERER = "Renderer";
    private static final String ATTR_PROP_EDITOR = "editor";
    private static final String ATTR_VALUE = "value";

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"TableColumnModelEditor");
    }

    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        JLabel label = new JLabel(NbBundle.getMessage(this.getClass(), (String)"TableColumnModelEditor_Customizer"));
        label.setHorizontalAlignment(0);
        return label;
    }

    public String getSourceCode() {
        Object value;
        RADProperty property = (RADProperty)this.property;
        RADComponent comp = property.getRADComponent();
        CodeVariable var = comp.getCodeExpression().getVariable();
        String varName = var == null ? null : var.getName();
        String readMethod = property.getPropertyDescriptor().getReadMethod().getName();
        String getter = readMethod + "()";
        if (varName != null) {
            getter = varName + '.' + getter;
        }
        if ((value = this.getValue()) instanceof FormTableColumnModel) {
            FormTableColumnModel columnModel = (FormTableColumnModel)value;
            StringBuilder code = new StringBuilder();
            int selectionModel = columnModel.getSelectionModel();
            if (selectionModel > 0) {
                code.append(getter).append(".getSelectionModel().setSelectionMode(javax.swing.ListSelectionModel.");
                switch (selectionModel) {
                    case 1: {
                        code.append("SINGLE_SELECTION");
                        break;
                    }
                    case 2: {
                        code.append("SINGLE_INTERVAL_SELECTION");
                        break;
                    }
                    case 3: {
                        code.append("MULTIPLE_INTERVAL_SELECTION");
                    }
                }
                code.append(");\n");
            }
            List<FormTableColumn> columns = columnModel.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                FormProperty prop;
                FormTableColumn column = columns.get(i);
                String columnGetter = getter + ".getColumn(" + i + ")";
                if (!column.isResizable()) {
                    code.append(columnGetter).append(".setResizable(").append(Boolean.toString(column.isResizable())).append(");\n");
                }
                if (column.getMinWidth() != -1) {
                    code.append(columnGetter).append(".setMinWidth(").append(Integer.toString(column.getMinWidth())).append(");\n");
                }
                if (column.getPrefWidth() != -1) {
                    code.append(columnGetter).append(".setPreferredWidth(").append(Integer.toString(column.getPrefWidth())).append(");\n");
                }
                if (column.getMaxWidth() != -1) {
                    code.append(columnGetter).append(".setMaxWidth(").append(Integer.toString(column.getMaxWidth())).append(");\n");
                }
                if ((prop = column.getTitle()).isChanged()) {
                    code.append(columnGetter).append(".setHeaderValue(").append(prop.getJavaInitializationString()).append(");\n");
                }
                if ((prop = column.getEditor()).isChanged()) {
                    code.append(columnGetter).append(".setCellEditor(").append(prop.getJavaInitializationString()).append(");\n");
                }
                if (!(prop = column.getRenderer()).isChanged()) continue;
                code.append(columnGetter).append(".setCellRenderer(").append(prop.getJavaInitializationString()).append(");\n");
            }
            return code.length() == 0 ? null : code.toString();
        }
        return null;
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        String selectionModelTxt = attributes.getNamedItem(ATTR_SELECTION_MODEL).getNodeValue();
        int selectionModel = Integer.parseInt(selectionModelTxt);
        FormTableColumnModel model = new FormTableColumnModel(this.property);
        model.setSelectionModel(selectionModel);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!XML_COLUMN.equals(node.getNodeName())) continue;
            FormTableColumn column = new FormTableColumn(this.property);
            NamedNodeMap colAttrs = node.getAttributes();
            String resizableTxt = colAttrs.getNamedItem(ATTR_RESIZABLE).getNodeValue();
            String minWidthTxt = colAttrs.getNamedItem(ATTR_WIDTH_MIN).getNodeValue();
            String prefWidthTxt = colAttrs.getNamedItem(ATTR_WIDTH_PREF).getNodeValue();
            String maxWidthTxt = colAttrs.getNamedItem(ATTR_WIDTH_MAX).getNodeValue();
            boolean resizable = Boolean.parseBoolean(resizableTxt);
            int minWidth = Integer.parseInt(minWidthTxt);
            int prefWidth = Integer.parseInt(prefWidthTxt);
            int maxWidth = Integer.parseInt(maxWidthTxt);
            column.setResizable(resizable);
            column.setMinWidth(minWidth);
            column.setPrefWidth(prefWidth);
            column.setMaxWidth(maxWidth);
            NodeList subNodes = node.getChildNodes();
            for (int j = 0; j < subNodes.getLength(); ++j) {
                Node subNode = subNodes.item(j);
                String nodeName = subNode.getNodeName();
                if (XML_TITLE.equals(nodeName)) {
                    this.loadProperty(column.getTitle(), subNode);
                    continue;
                }
                if (XML_EDITOR.equals(nodeName)) {
                    this.loadProperty(column.getEditor(), subNode);
                    continue;
                }
                if (!XML_RENDERER.equals(nodeName)) continue;
                this.loadProperty(column.getRenderer(), subNode);
            }
            model.getColumns().add(column);
        }
        this.setValue(model);
    }

    private void loadProperty(FormProperty property, Node node) {
        block9: {
            NamedNodeMap attributes = node.getAttributes();
            Node valueNode = attributes.getNamedItem(ATTR_VALUE);
            try {
                if (valueNode != null) {
                    property.setValue(valueNode.getNodeValue());
                    break block9;
                }
                NodeList nodes = node.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node subNode = nodes.item(i);
                    if (subNode.getNodeType() != 1) continue;
                    FormModel formModel = property.getPropertyContext().getFormModel();
                    String propEdName = attributes.getNamedItem(ATTR_PROP_EDITOR).getNodeValue();
                    RADConnectionPropertyEditor xmlPropEd = null;
                    if (propEdName.equals(RADConnectionPropertyEditor.class.getName())) {
                        xmlPropEd = new RADConnectionPropertyEditor(property.getValueType());
                        ((FormAwareEditor)xmlPropEd).setContext(formModel, property);
                    } else {
                        Class propEdClass = PersistenceObjectRegistry.loadClass(propEdName, FormEditor.getFormDataObject(formModel).getFormFile());
                        Object propEd = propEdClass.newInstance();
                        if (propEd instanceof XMLPropertyEditor) {
                            xmlPropEd = (XMLPropertyEditor)propEd;
                            if (propEd instanceof FormAwareEditor) {
                                ((FormAwareEditor)propEd).setContext(formModel, property);
                            }
                        }
                    }
                    if (xmlPropEd != null) {
                        xmlPropEd.readFromXML(subNode);
                        property.setValue(new FormProperty.ValueWithEditor(xmlPropEd.getValue(), xmlPropEd));
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Node storeToXML(Document doc) {
        Object value = this.getValue();
        Element el = null;
        if (value instanceof FormTableColumnModel) {
            FormTableColumnModel model = (FormTableColumnModel)value;
            el = doc.createElement(XML_TABLE_COLUMN_MODEL);
            el.setAttribute(ATTR_SELECTION_MODEL, Integer.toString(model.getSelectionModel()));
            for (FormTableColumn column : model.getColumns()) {
                Element columnEl = doc.createElement(XML_COLUMN);
                columnEl.setAttribute(ATTR_RESIZABLE, Boolean.toString(column.isResizable()));
                columnEl.setAttribute(ATTR_WIDTH_MIN, Integer.toString(column.getMinWidth()));
                columnEl.setAttribute(ATTR_WIDTH_PREF, Integer.toString(column.getPrefWidth()));
                columnEl.setAttribute(ATTR_WIDTH_MAX, Integer.toString(column.getMaxWidth()));
                Element titleEl = doc.createElement(XML_TITLE);
                Element editorEl = doc.createElement(XML_EDITOR);
                Element rendererEl = doc.createElement(XML_RENDERER);
                this.storeProperty(doc, titleEl, column.getTitle());
                this.storeProperty(doc, editorEl, column.getEditor());
                this.storeProperty(doc, rendererEl, column.getRenderer());
                columnEl.appendChild(titleEl);
                columnEl.appendChild(editorEl);
                columnEl.appendChild(rendererEl);
                el.appendChild(columnEl);
            }
        }
        return el;
    }

    private void storeProperty(Document doc, Element element, FormProperty property) {
        if (property.isChanged()) {
            PropertyEditor editor = property.getCurrentEditor();
            if (editor instanceof XMLPropertyEditor) {
                element.setAttribute(ATTR_PROP_EDITOR, editor.getClass().getName());
                Node node = ((XMLPropertyEditor)editor).storeToXML(doc);
                element.appendChild(node);
            } else {
                try {
                    Object value = property.getValue();
                    if (value instanceof String) {
                        element.setAttribute(ATTR_VALUE, (String)value);
                    } else {
                        System.err.println("Unable to store " + (Object)((Object)property));
                    }
                }
                catch (IllegalAccessException iaex) {
                    iaex.printStackTrace();
                }
                catch (InvocationTargetException itex) {
                    itex.printStackTrace();
                }
            }
        }
    }

    public static class FormTableColumn {
        private int minWidth = -1;
        private int prefWidth = -1;
        private int maxWidth = -1;
        private boolean resizable = true;
        private Property title;
        private Property editor;
        private Property renderer;

        public FormTableColumn(FormProperty prop) {
            this.title = new Property(prop, "title", String.class, null, null);
            this.editor = new Property(prop, TableColumnModelEditor.ATTR_PROP_EDITOR, TableCellEditor.class, null, null);
            this.renderer = new Property(prop, "renderer", TableCellRenderer.class, null, null);
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
        }

        public int getPrefWidth() {
            return this.prefWidth;
        }

        public void setPrefWidth(int prefWidth) {
            this.prefWidth = prefWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public void setResizable(boolean resizable) {
            this.resizable = resizable;
        }

        public FormProperty getTitle() {
            return this.title;
        }

        public FormProperty getEditor() {
            return this.editor;
        }

        public FormProperty getRenderer() {
            return this.renderer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormTableColumnModel
    extends FormDesignValueAdapter {
        private FormProperty property;
        private int selectionModel;
        private List<FormTableColumn> columns;
        private TableColumn defaultColumn;

        public FormTableColumnModel(FormProperty property) {
            this.property = property;
            this.columns = new LinkedList<FormTableColumn>();
        }

        public void setSelectionModel(int selectionModel) {
            this.selectionModel = selectionModel;
        }

        public int getSelectionModel() {
            return this.selectionModel;
        }

        public List<FormTableColumn> getColumns() {
            return this.columns;
        }

        @Override
        public Object getDesignValue() {
            Object value = null;
            try {
                value = this.property.getTargetValue();
                if (value instanceof TableColumnModel) {
                    TableColumnModel columnModel = (TableColumnModel)value;
                    this.designValue(columnModel);
                }
            }
            catch (IllegalAccessException iaex) {
                iaex.printStackTrace();
            }
            catch (InvocationTargetException itex) {
                itex.printStackTrace();
            }
            return value;
        }

        @Override
        public Object getDesignValue(Object target) {
            TableColumnModel columnModel = null;
            if (target instanceof JTable) {
                columnModel = ((JTable)target).getColumnModel();
                this.designValue(columnModel);
            }
            return columnModel;
        }

        private void designValue(TableColumnModel columnModel) {
            int selectionModel = this.getSelectionModel();
            switch (selectionModel) {
                case 0: {
                    break;
                }
                case 1: {
                    columnModel.getSelectionModel().setSelectionMode(0);
                    break;
                }
                case 2: {
                    columnModel.getSelectionModel().setSelectionMode(1);
                    break;
                }
                case 3: {
                    columnModel.getSelectionModel().setSelectionMode(2);
                }
            }
            for (int i = 0; i < this.columns.size() && i < columnModel.getColumnCount(); ++i) {
                FormTableColumn formColumn = this.columns.get(i);
                TableColumn column = columnModel.getColumn(i);
                column.setResizable(formColumn.isResizable());
                int width = formColumn.getMinWidth() == -1 ? this.defaultColumn().getMinWidth() : formColumn.getMinWidth();
                column.setMinWidth(width);
                width = formColumn.getPrefWidth() == -1 ? this.defaultColumn().getPreferredWidth() : formColumn.getPrefWidth();
                column.setPreferredWidth(width);
                width = formColumn.getMaxWidth() == -1 ? this.defaultColumn().getMaxWidth() : formColumn.getMaxWidth();
                column.setMaxWidth(width);
                FormProperty prop = formColumn.getTitle();
                try {
                    if (prop.isChanged()) {
                        column.setHeaderValue(prop.getRealValue());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                prop = formColumn.getEditor();
                try {
                    Object editor;
                    if (prop.isChanged() && (editor = prop.getRealValue()) instanceof TableCellEditor) {
                        column.setCellEditor((TableCellEditor)editor);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                prop = formColumn.getRenderer();
                try {
                    Object renderer;
                    if (!prop.isChanged() || !((renderer = prop.getRealValue()) instanceof TableCellRenderer)) continue;
                    column.setCellRenderer((TableCellRenderer)renderer);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private TableColumn defaultColumn() {
            if (this.defaultColumn == null) {
                this.defaultColumn = new TableColumn();
            }
            return this.defaultColumn;
        }
    }

    static class Property
    extends FormProperty {
        private Object value;

        Property(FormProperty prop, String name, Class type, String displayName, String description) {
            super(new FormPropertyContext.SubProperty(prop), name, type, displayName, description);
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }

        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.value = value;
        }
    }
}

