/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutComponent
implements LayoutConstants {
    private String componentId;
    private LayoutComponent parentComponent;
    private LayoutInterval[] layoutIntervals;
    private boolean[] resizability;
    private List<LayoutInterval[]> layoutRoots;
    private List<LayoutComponent> subComponents;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int horizontalLinkId = -1;
    private int verticalLinkId = -1;

    public LayoutComponent(String id, boolean isContainer) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.componentId = id;
        this.layoutIntervals = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            this.layoutIntervals[i] = new LayoutInterval(101);
            this.layoutIntervals[i].setComponent(this);
            this.layoutIntervals[i].setSizes(-2, -1, -2);
        }
        if (isContainer) {
            this.createRoots();
        }
    }

    public LayoutComponent(String id, boolean isContainer, int initialWidth, int initialHeight) {
        this(id, isContainer);
        if (isContainer) {
            LayoutInterval[] defaultRoots = this.layoutRoots.get(0);
            for (int i = 0; i < 2; ++i) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSizes(0, i == 0 ? initialWidth : initialHeight, Short.MAX_VALUE);
                defaultRoots[i].add(gap, 0);
            }
        } else {
            this.layoutIntervals[0].setPreferredSize(initialWidth);
            this.layoutIntervals[1].setPreferredSize(initialHeight);
        }
    }

    private void createRoots() {
        this.layoutRoots = new LinkedList<LayoutInterval[]>();
        this.addNewLayoutRoots();
    }

    void setId(String id) {
        this.componentId = id;
    }

    public String getId() {
        return this.componentId;
    }

    public LayoutComponent getParent() {
        return this.parentComponent;
    }

    public boolean isParentOf(LayoutComponent comp) {
        do {
            if ((comp = comp.getParent()) != this) continue;
            return true;
        } while (comp != null);
        return false;
    }

    static LayoutComponent getCommonParent(LayoutComponent comp1, LayoutComponent comp2) {
        Iterator parents1 = LayoutComponent.parentsOfComponent(comp1).iterator();
        Iterator parents2 = LayoutComponent.parentsOfComponent(comp2).iterator();
        LayoutComponent parent1 = (LayoutComponent)parents1.next();
        LayoutComponent parent2 = (LayoutComponent)parents2.next();
        LayoutComponent parent = null;
        while (parent1 == parent2) {
            parent = parent1;
            if (!parents1.hasNext()) break;
            parent1 = (LayoutComponent)parents1.next();
            if (!parents2.hasNext()) break;
            parent2 = (LayoutComponent)parents2.next();
        }
        return parent;
    }

    private static List parentsOfComponent(LayoutComponent comp) {
        LinkedList<LayoutComponent> parents = new LinkedList<LayoutComponent>();
        while (comp != null) {
            parents.add(0, comp);
            comp = comp.getParent();
        }
        return parents;
    }

    public LayoutInterval getLayoutInterval(int dimension) {
        return this.layoutIntervals[dimension];
    }

    void setLayoutInterval(LayoutInterval interval, int dimension) {
        this.layoutIntervals[dimension] = interval;
    }

    public boolean isLayoutContainer() {
        return this.layoutRoots != null;
    }

    void setResizability(boolean[] resizability) {
        this.resizability = resizability;
    }

    boolean[] getResizability() {
        return this.resizability;
    }

    public List<LayoutComponent> getSubcomponents() {
        return this.subComponents != null && this.subComponents.size() > 0 ? Collections.unmodifiableList(this.subComponents) : Collections.EMPTY_LIST;
    }

    int getSubComponentCount() {
        return this.subComponents == null ? 0 : this.subComponents.size();
    }

    LayoutComponent getSubComponent(int index) {
        return this.subComponents.get(index);
    }

    int indexOf(LayoutComponent comp) {
        return this.subComponents != null ? this.subComponents.indexOf(comp) : -1;
    }

    int addComponent(LayoutComponent comp, int index) {
        assert (this.isLayoutContainer());
        if (this.subComponents == null) {
            this.subComponents = new LinkedList<LayoutComponent>();
        }
        if (index < 0) {
            index = this.subComponents.size();
        }
        this.subComponents.add(index, comp);
        comp.parentComponent = this;
        return index;
    }

    int removeComponent(LayoutComponent comp) {
        if (this.subComponents != null) {
            Iterator<LayoutComponent> it = this.subComponents.iterator();
            int index = -1;
            while (it.hasNext()) {
                ++index;
                if (comp != it.next()) continue;
                it.remove();
                comp.parentComponent = null;
                return index;
            }
        }
        return -1;
    }

    public int getLayoutRootCount() {
        return this.layoutRoots != null ? this.layoutRoots.size() : 0;
    }

    public LayoutInterval getLayoutRoot(int rootIndex, int dimension) {
        return this.layoutRoots.get(rootIndex)[dimension];
    }

    LayoutInterval getDefaultLayoutRoot(int dimension) {
        return this.layoutRoots.get(0)[dimension];
    }

    List<LayoutInterval[]> getLayoutRoots() {
        return this.layoutRoots;
    }

    void setLayoutRoots(List<LayoutInterval[]> roots) {
        if (roots == null && this.layoutRoots != null) {
            this.createRoots();
        } else {
            this.layoutRoots = roots;
        }
    }

    LayoutInterval[] getLayoutRoots(LayoutInterval interval) {
        interval = LayoutInterval.getRoot(interval);
        for (LayoutInterval[] roots : this.layoutRoots) {
            for (int dim = 0; dim < 2; ++dim) {
                if (interval != roots[dim]) continue;
                return roots;
            }
        }
        return null;
    }

    int getLayoutRootsIndex(LayoutInterval interval) {
        interval = LayoutInterval.getRoot(interval);
        int index = -1;
        for (LayoutInterval[] roots : this.layoutRoots) {
            ++index;
            for (int dim = 0; dim < 2; ++dim) {
                if (interval != roots[dim]) continue;
                return index;
            }
        }
        return -1;
    }

    void addLayoutRoots(LayoutInterval[] roots, int index) {
        if (index < 0) {
            index = this.layoutRoots.size();
        }
        this.layoutRoots.add(index, roots);
    }

    int removeLayoutRoots(LayoutInterval[] roots) {
        Iterator<LayoutInterval[]> it = this.layoutRoots.iterator();
        int index = -1;
        while (it.hasNext()) {
            ++index;
            if (roots != it.next()) continue;
            it.remove();
            return index;
        }
        return -1;
    }

    LayoutInterval[] addNewLayoutRoots() {
        LayoutInterval[] roots = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            roots[i] = new LayoutInterval(103);
        }
        this.layoutRoots.add(roots);
        return roots;
    }

    void setLayoutContainer(boolean isContainer, List<LayoutInterval[]> roots) {
        if (isContainer != this.isLayoutContainer()) {
            if (isContainer) {
                if (roots == null) {
                    this.createRoots();
                } else {
                    this.layoutRoots = roots;
                }
            } else {
                this.layoutRoots = null;
                this.subComponents = null;
            }
        }
    }

    void setCurrentBounds(Rectangle bounds, int baseline) {
        LayoutRegion space = this.layoutIntervals[0].getCurrentSpace();
        space.set(bounds, baseline > 0 ? bounds.y + baseline : Integer.MIN_VALUE);
        for (int i = 1; i < this.layoutIntervals.length; ++i) {
            this.layoutIntervals[i].setCurrentSpace(space);
        }
    }

    void setCurrentInterior(Rectangle bounds) {
        LayoutRegion space = null;
        for (LayoutInterval[] roots : this.layoutRoots) {
            for (int i = 0; i < roots.length; ++i) {
                if (space == null) {
                    space = roots[i].getCurrentSpace();
                    space.set(bounds, Integer.MIN_VALUE);
                    continue;
                }
                roots[i].setCurrentSpace(space);
            }
        }
    }

    public boolean isLinkSized(int dimension) {
        if (dimension == 0) {
            return -1 != this.horizontalLinkId;
        }
        return -1 != this.verticalLinkId;
    }

    public int getLinkSizeId(int dimension) {
        if (dimension == 0) {
            return this.horizontalLinkId;
        }
        return this.verticalLinkId;
    }

    public void setLinkSizeId(int id, int dimension) {
        if (dimension == 0) {
            this.horizontalLinkId = id;
        } else {
            this.verticalLinkId = id;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

