/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

class LayoutDragger
implements LayoutConstants {
    private VisualMapper visualMapper;
    private int operation;
    private static final int ADDING = 0;
    private static final int MOVING = 1;
    private static final int RESIZING = 2;
    private LayoutComponent[] movingComponents;
    private int[] movingEdges;
    private LayoutRegion[] movingFormation;
    private int[] startCursorPosition;
    private SizeDef[] sizing;
    private int[] lastCursorPosition = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] moveDirection = new int[]{0, 0};
    private int lockedDimension = -1;
    private LayoutComponent targetContainer;
    private LayoutInterval[] targetRoots;
    private LayoutRegion[] movingBounds;
    private PositionDef[] bestPositions = new PositionDef[2];
    private boolean canSnapToBaseline;
    private LayoutRegion movingSpace;
    private int dimension;
    private boolean snapping;
    private PositionDef[][] findingsNextTo;
    private PositionDef[][] findingsAligned;
    static final int[] ALL_EDGES = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    private static final int GL_TIP = 8;
    private static final int SNAP_DISTANCE = 8;
    private static final int ORT_DISTANCE = 8;
    private static BasicStroke dashedStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f, 2.0f}, 0.0f);

    LayoutDragger(LayoutComponent[] comps, LayoutRegion[] compBounds, int[] initialCursorPos, int[] movingEdges, VisualMapper mapper) {
        int i;
        int i2;
        for (i2 = 0; i2 < 2; ++i2) {
            if (movingEdges[i2] != 0 && movingEdges[i2] != 1) continue;
            this.operation = 2;
            break;
        }
        if (this.operation != 2) {
            this.operation = comps[0].getParent() == null ? 0 : 1;
        }
        this.movingComponents = comps;
        this.movingFormation = compBounds;
        this.startCursorPosition = initialCursorPos;
        this.movingEdges = movingEdges;
        this.visualMapper = mapper;
        this.movingBounds = new LayoutRegion[compBounds.length];
        this.movingSpace = new LayoutRegion();
        for (i2 = 0; i2 < compBounds.length; ++i2) {
            this.movingBounds[i2] = new LayoutRegion();
            this.movingSpace.expand(compBounds[i2]);
        }
        LayoutInterval parent = comps[0].getLayoutInterval(1).getParent();
        for (i = 0; i < comps.length; ++i) {
            if (comps[i].getLayoutInterval(1).getParent() == parent) continue;
            parent = null;
            break;
        }
        this.canSnapToBaseline = comps.length == 1 || parent != null && parent.getGroupAlignment() == 3;
        this.findingsNextTo = new PositionDef[2][];
        this.findingsAligned = new PositionDef[2][];
        for (i = 0; i < 2; ++i) {
            int n = LayoutRegion.POINT_COUNT[i];
            this.findingsNextTo[i] = new PositionDef[n];
            this.findingsAligned[i] = new PositionDef[n];
            for (int j = 0; j < n; ++j) {
                this.findingsNextTo[i][j] = new PositionDef();
                this.findingsAligned[i][j] = new PositionDef();
            }
        }
        if (this.operation == 2) {
            this.prepareResizing();
        }
    }

    private void prepareResizing() {
        this.sizing = new SizeDef[2];
        LayoutComponent comp = this.movingComponents[0];
        LayoutRegion space = this.movingFormation[0];
        Dimension prefSize = null;
        for (int i = 0; i < 2; ++i) {
            SizeDef sizeDef;
            if (!this.isResizing(i)) continue;
            this.sizing[i] = sizeDef = new SizeDef();
            sizeDef.originalSize = space.size(i);
            if (comp.isLayoutContainer()) {
                LayoutInterval resGap = this.findResizingGap(comp.getDefaultLayoutRoot(i));
                if (resGap != null) {
                    sizeDef.resizingGap = resGap;
                    sizeDef.originalGapSize = LayoutInterval.getIntervalCurrentSize(resGap, i);
                    sizeDef.preferredGapSize = LayoutUtils.getSizeOfDefaultGap(resGap, this.visualMapper);
                    sizeDef.preferredSize = sizeDef.originalSize - sizeDef.originalGapSize + sizeDef.preferredGapSize;
                    sizeDef.zeroPreferredSize = LayoutDragger.isZeroResizingGap(resGap) ? sizeDef.originalSize - sizeDef.originalGapSize : Short.MIN_VALUE;
                    continue;
                }
                if (prefSize == null) {
                    prefSize = this.visualMapper.getComponentMinimumSize(comp.getId());
                }
                sizeDef.preferredSize = i == 0 ? prefSize.width : prefSize.height;
                continue;
            }
            if (prefSize == null) {
                prefSize = this.visualMapper.getComponentPreferredSize(comp.getId());
            }
            sizeDef.preferredSize = i == 0 ? prefSize.width : prefSize.height;
        }
    }

    private LayoutInterval findResizingGap(LayoutInterval group) {
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval gap;
            LayoutInterval li = (LayoutInterval)it.next();
            if (li.isEmptySpace() && li.hasAttribute(4)) {
                return li;
            }
            if (!li.isGroup() || (gap = this.findResizingGap(li)) == null) continue;
            return gap;
        }
        return null;
    }

    private static boolean isZeroResizingGap(LayoutInterval gap) {
        return LayoutInterval.getNeighbor(gap, 0, false, true, false) == null || LayoutInterval.getNeighbor(gap, 1, false, true, false) == null;
    }

    void setTargetContainer(LayoutComponent container, LayoutInterval[] roots) {
        this.targetContainer = container;
        this.targetRoots = roots;
    }

    LayoutComponent getTargetContainer() {
        return this.targetContainer;
    }

    LayoutInterval[] getTargetRoots() {
        return this.targetRoots;
    }

    boolean isResizing() {
        return this.operation == 2;
    }

    boolean isResizing(int dim) {
        return this.movingEdges[dim] == 0 || this.movingEdges[dim] == 1;
    }

    int getResizingEdge(int dim) {
        return this.movingEdges[dim];
    }

    LayoutComponent[] getMovingComponents() {
        return this.movingComponents;
    }

    VisualMapper getVisualMapper() {
        return this.visualMapper;
    }

    LayoutRegion[] getMovingBounds() {
        return this.movingBounds;
    }

    LayoutRegion getMovingSpace() {
        return this.movingSpace;
    }

    PositionDef[] getPositions() {
        return this.bestPositions;
    }

    SizeDef[] getSizes() {
        return this.sizing;
    }

    boolean snappedToDefaultSize(int dimension) {
        if (this.isResizing(dimension) && this.bestPositions[dimension] == null) {
            int size = this.movingSpace.size(dimension);
            return size == this.sizing[dimension].preferredSize || size == this.sizing[dimension].zeroPreferredSize;
        }
        return false;
    }

    void move(int[] cursorPos, boolean autoPositioning, boolean lockDimension) {
        int j;
        int i;
        int lockCandidate = -1;
        int minDelta = Integer.MAX_VALUE;
        for (i = 0; i < 2; ++i) {
            PositionDef pos;
            int n = i;
            cursorPos[n] = cursorPos[n] - this.startCursorPosition[i];
            int currentPos = cursorPos[i];
            int lastPos = this.lastCursorPosition[i];
            this.lastCursorPosition[i] = currentPos;
            if (lastPos == Integer.MIN_VALUE) {
                lockDimension = false;
                continue;
            }
            int delta = currentPos - lastPos;
            if (delta != 0) {
                int n2 = this.moveDirection[i] = delta > 0 ? 1 : 0;
            }
            if (this.movingEdges[i] != Integer.MAX_VALUE) {
                lockDimension = false;
                continue;
            }
            if (this.lockedDimension >= 0 || (pos = this.bestPositions[i]) == null || pos.nextTo || delta >= minDelta) continue;
            lockCandidate = i;
            minDelta = delta;
        }
        if (lockDimension) {
            if (this.lockedDimension < 0) {
                this.lockedDimension = lockCandidate;
            }
        } else {
            this.lockedDimension = -1;
        }
        for (i = 0; i < this.movingBounds.length; ++i) {
            for (j = 0; j < 2; ++j) {
                if (j == this.lockedDimension) continue;
                this.movingBounds[i].set(j, this.movingFormation[i]);
                this.movingBounds[i].reshape(j, this.movingEdges[j], cursorPos[j]);
            }
        }
        this.movingSpace = new LayoutRegion();
        for (i = 0; i < this.movingBounds.length; ++i) {
            this.movingSpace.expand(this.movingBounds[i]);
        }
        if (this.canSnapToBaseline) {
            this.movingSpace.positions[1][3] = this.movingBounds[0].positions[1][3];
        }
        for (i = 0; i < 2; ++i) {
            if (i == this.lockedDimension) continue;
            this.bestPositions[i] = null;
            for (j = 0; j < LayoutRegion.POINT_COUNT[i]; ++j) {
                this.findingsNextTo[i][j].reset();
                this.findingsAligned[i][j].reset();
            }
        }
        this.snapping = autoPositioning;
        if (autoPositioning) {
            this.dimension = 1;
            while (this.dimension >= 0) {
                int snapDistance;
                if (this.dimension != this.lockedDimension && this.movingEdges[this.dimension] != Integer.MIN_VALUE && (snapDistance = this.findBestPosition()) != Integer.MIN_VALUE) {
                    int n = this.dimension;
                    cursorPos[n] = cursorPos[n] - snapDistance;
                    for (int i2 = 0; i2 < this.movingBounds.length; ++i2) {
                        this.movingBounds[i2].reshape(this.dimension, this.movingEdges[this.dimension], -snapDistance);
                    }
                    this.movingSpace.reshape(this.dimension, this.movingEdges[this.dimension], -snapDistance);
                }
                --this.dimension;
            }
        }
        for (i = 0; i < 2; ++i) {
            int n = i;
            cursorPos[n] = cursorPos[n] + this.startCursorPosition[i];
        }
    }

    void paintMoveFeedback(Graphics2D g) {
        int OVERLAP = 10;
        for (int i = 0; i < 2; ++i) {
            PositionDef position = this.bestPositions[i];
            if (position != null) {
                boolean parentUsed;
                boolean inRoot = position.interval.getParent() == null;
                int dir = 1 - i;
                int align = position.alignment;
                LayoutInterval interval = position.interval;
                LayoutInterval parent = interval.getParent();
                do {
                    parentUsed = false;
                    if (parent != null && parent.isParallel()) {
                        if (align == 0 || align == 1) {
                            LayoutRegion parRegion = parent.getCurrentSpace();
                            if (!position.nextTo && LayoutRegion.distance(parRegion, this.movingSpace, i, align, align) == 0) {
                                parentUsed = true;
                            }
                        } else if (align == parent.getGroupAlignment()) {
                            parentUsed = true;
                        }
                    }
                    if (!parentUsed) continue;
                    interval = parent;
                    parent = LayoutInterval.getFirstParent(parent, 103);
                } while (parentUsed);
                LayoutRegion posRegion = interval.getCurrentSpace();
                LayoutRegion contRegion = this.targetRoots[0].getCurrentSpace();
                int conty1 = contRegion.positions[dir][0];
                int conty2 = contRegion.positions[dir][1];
                int posx = posRegion.positions[i][inRoot || !position.nextTo ? align : 1 - align];
                int posy1 = posRegion.positions[dir][0] - 10;
                posy1 = Math.max(posy1, conty1);
                int posy2 = posRegion.positions[dir][1] + 10;
                posy2 = Math.min(posy2, conty2);
                int x = this.movingSpace.positions[i][align];
                int y1 = this.movingSpace.positions[dir][0] - 10;
                y1 = Math.max(y1, conty1);
                int y2 = this.movingSpace.positions[dir][1] + 10;
                y2 = Math.min(y2, conty2);
                Stroke oldStroke = g.getStroke();
                g.setStroke(dashedStroke);
                if (position.nextTo) {
                    int padIndex = -1;
                    int paintedPad = 0;
                    if (position.paddingSizes != null && position.paddingSizes.length > 1) {
                        assert (position.paddingType != null && position.snapped);
                        for (int j = 0; j < PADDINGS.length; ++j) {
                            if (PADDINGS[j] != position.paddingType) continue;
                            padIndex = j;
                            if (j <= 0) break;
                            paintedPad = position.paddingSizes[j];
                            break;
                        }
                    }
                    if (i == 0) {
                        g.drawLine(x, Math.min(y1, posy1), x, Math.max(y2, posy2));
                    } else {
                        g.drawLine(Math.min(y1, posy1), x, Math.max(y2, posy2), x);
                    }
                    while (--padIndex >= 0) {
                        if (PADDINGS[padIndex] == LayoutConstants.PaddingType.INDENT) continue;
                        int pad = position.paddingSizes[padIndex];
                        int dx = paintedPad - pad;
                        x -= align == 0 ? dx : -dx;
                        if (i == 0) {
                            g.drawLine(x, Math.min(y1, posy1), x, Math.max(y2, posy2));
                        } else {
                            g.drawLine(Math.min(y1, posy1), x, Math.max(y2, posy2), x);
                        }
                        paintedPad = pad;
                    }
                } else if (x == posx) {
                    if (i == 0) {
                        g.drawLine(posx, Math.min(y1, posy1), posx, Math.max(y2, posy2));
                    } else {
                        g.drawLine(Math.min(y1, posy1), posx, Math.max(y2, posy2), posx);
                    }
                } else if (i == 0) {
                    g.drawLine(posx, posy1, posx, posy2);
                    g.drawLine(x, y1, x, y2);
                } else {
                    g.drawLine(posy1, posx, posy2, posx);
                    g.drawLine(y1, x, y2, x);
                }
                g.setStroke(oldStroke);
                continue;
            }
            if (!this.snappedToDefaultSize(i)) continue;
            int align = this.movingEdges[i];
            int x1 = this.movingSpace.positions[i][align];
            int x2 = this.movingSpace.positions[i][align ^ 1];
            int y = this.movingSpace.positions[i ^ 1][2];
            Stroke oldStroke = g.getStroke();
            g.setStroke(dashedStroke);
            if (i == 0) {
                g.drawLine(x1, y, x2, y);
            } else {
                g.drawLine(y, x1, y, x2);
            }
            g.setStroke(oldStroke);
        }
    }

    String[] positionCode() {
        String[] code = new String[2];
        for (int i = 0; i < 2; ++i) {
            PositionDef position = this.bestPositions[i];
            if (position != null) {
                int alignment = position.alignment;
                if (position.nextTo) {
                    String paddingCode = position.interval.getParent() == null ? "Container" : LayoutDragger.paddingTypeCode(position.paddingType);
                    code[i] = "nextTo" + paddingCode + LayoutDragger.dimensionCode(i) + LayoutDragger.alignmentCode(alignment);
                    continue;
                }
                int x = this.movingSpace.positions[i][alignment];
                int posx = position.interval.getCurrentSpace().positions[i][alignment];
                if (x == posx) {
                    code[i] = "align" + LayoutDragger.dimensionCode(i) + LayoutDragger.alignmentCode(alignment);
                    continue;
                }
                code[i] = "indent";
                continue;
            }
            if (!this.snappedToDefaultSize(i)) continue;
            code[i] = "snappedToDefault" + LayoutDragger.dimensionCode(i);
        }
        if (code[0] == null) {
            code[0] = code[1];
            code[1] = null;
        }
        if (code[0] == null) {
            code[0] = this.isResizing() ? "generalResizing" : "generalPosition";
        }
        return code;
    }

    private static String dimensionCode(int dim) {
        return dim == 0 ? "Horizontal" : "Vertical";
    }

    private static String alignmentCode(int alignment) {
        String code = null;
        switch (alignment) {
            case 0: {
                code = "Leading";
                break;
            }
            case 1: {
                code = "Trailing";
                break;
            }
            case 3: {
                code = "Baseline";
            }
        }
        return code;
    }

    private static String paddingTypeCode(LayoutConstants.PaddingType paddingType) {
        if (paddingType == LayoutConstants.PaddingType.UNRELATED) {
            return "Unrelated";
        }
        if (paddingType == LayoutConstants.PaddingType.SEPARATE) {
            return "Separate";
        }
        return "Related";
    }

    private int findBestPosition() {
        PositionDef best;
        int snapDistance = Integer.MIN_VALUE;
        if (this.targetContainer != null) {
            PositionDef bestAligned;
            LayoutInterval layoutRoot = this.targetRoots[this.dimension];
            int edges = this.movingEdges[this.dimension];
            this.checkRootForNextTo(layoutRoot, edges);
            this.scanLayoutForNextTo(layoutRoot, edges);
            PositionDef bestNextTo = this.chooseBestNextTo();
            if (this.snapping) {
                this.checkRootForAligned(layoutRoot, edges);
                this.scanLayoutForAligned(layoutRoot, edges);
                bestAligned = this.chooseBestAligned();
            } else {
                bestAligned = null;
            }
            if (bestAligned == null) {
                best = bestNextTo;
            } else if (bestNextTo == null) {
                best = bestAligned;
            } else {
                PositionDef equalAligned;
                boolean preferredNextTo = this.isPreferredNextTo(bestNextTo, bestAligned);
                int nextToDst = LayoutDragger.smallestDistance(this.findingsNextTo[this.dimension]);
                int alignedDst = LayoutDragger.smallestDistance(this.findingsAligned[this.dimension]);
                if (!LayoutDragger.relatedPositions(bestNextTo, bestAligned)) {
                    int alignedOrtDst = Math.abs(LayoutRegion.nonOverlapDistance(bestAligned.interval.getCurrentSpace(), this.movingSpace, this.dimension ^ 1));
                    alignedDst = LayoutDragger.getDistanceScore(alignedDst, alignedOrtDst);
                }
                if (preferredNextTo) {
                    best = alignedDst * 2 <= nextToDst && nextToDst - alignedDst >= 4 ? bestAligned : bestNextTo;
                } else {
                    PositionDef positionDef = best = nextToDst * 2 <= alignedDst && alignedDst - nextToDst >= 4 ? bestNextTo : bestAligned;
                }
                if (best == bestNextTo && (equalAligned = this.getAlignedEqualToNextTo(bestNextTo)) != null) {
                    best = equalAligned;
                }
            }
        } else {
            best = null;
        }
        if (this.snapping) {
            if (this.isResizing(this.dimension)) {
                int prefSizeDiff = this.movingSpace.size(this.dimension) - this.sizing[this.dimension].preferredSize;
                int zeroSizeDiff = this.movingSpace.size(this.dimension) - this.sizing[this.dimension].zeroPreferredSize;
                int sizeDiff = Math.abs(prefSizeDiff) <= Math.abs(zeroSizeDiff) ? prefSizeDiff : zeroSizeDiff;
                int absDiff = Math.abs(sizeDiff);
                if (absDiff < 8 && (best == null || absDiff < Math.abs(best.distance))) {
                    best = null;
                    int n = snapDistance = this.movingEdges[this.dimension] == 0 ? -sizeDiff : sizeDiff;
                }
            }
            if (best != null) {
                snapDistance = best.distance;
            }
        }
        this.bestPositions[this.dimension] = best;
        return snapDistance;
    }

    private void checkRootForNextTo(LayoutInterval layoutRoot, int alignment) {
        assert (alignment == Integer.MAX_VALUE || alignment == 0 || alignment == 1);
        if (this.operation == 2 && this.isValidNextToResizing(layoutRoot, alignment) != 1) {
            return;
        }
        LayoutRegion rootSpace = layoutRoot.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            if (alignment != Integer.MAX_VALUE && alignment != i) continue;
            int distance = LayoutRegion.distance(rootSpace, this.movingSpace, this.dimension, i, i);
            assert (distance != Integer.MIN_VALUE);
            if (this.snapping) {
                int pad = this.findPaddings(null, this.movingComponents[0].getLayoutInterval(this.dimension), null, this.dimension, i)[0];
                distance += i == 0 ? -pad : pad;
            }
            if (this.snapping && Math.abs(distance) >= 8) continue;
            PositionDef bestSoFar = this.findingsNextTo[this.dimension][i];
            assert (!bestSoFar.isSet());
            bestSoFar.interval = layoutRoot;
            bestSoFar.alignment = i;
            bestSoFar.distance = distance;
            bestSoFar.nextTo = true;
            bestSoFar.snapped = this.snapping && Math.abs(distance) < 8;
            bestSoFar.paddingType = null;
            PositionDef.access$702(bestSoFar, null);
        }
    }

    private int scanLayoutForNextTo(LayoutInterval interval, int alignment) {
        assert (alignment == Integer.MAX_VALUE || alignment == 0 || alignment == 1);
        int groupOuterAlignment = -1;
        int count = interval.getSubIntervalCount();
        for (int idx = 0; idx < count; ++idx) {
            LayoutInterval sub = interval.getSubInterval(idx);
            if (sub.isEmptySpace() || !this.orthogonalOverlap(interval, idx)) continue;
            int nextToAlignment = -1;
            if (sub.isComponent()) {
                if (this.isValidInterval(sub) && (this.operation != 2 || this.isValidNextToResizing(sub, alignment) == 1)) {
                    nextToAlignment = this.checkNextToPosition(sub, alignment);
                }
            } else if (sub.isSequential()) {
                nextToAlignment = this.scanLayoutForNextTo(sub, alignment);
            } else {
                int subGroupOuterAlign;
                int validResizing;
                boolean validForRef = this.isValidInterval(sub);
                int n = validResizing = validForRef && this.operation == 2 ? this.isValidNextToResizing(sub, alignment) : 1;
                if (validResizing != -1 && LayoutDragger.canGoInsideForNextTo(sub, validForRef)) {
                    int align = alignment;
                    for (int i = 0; i <= 1; ++i) {
                        if (alignment != Integer.MAX_VALUE && i != alignment) continue;
                        int insideDst = LayoutRegion.distance(sub.getCurrentSpace(), this.movingSpace, this.dimension, i, i) * (i == 0 ? 1 : -1);
                        if (insideDst >= -8) continue;
                        align = align == Integer.MAX_VALUE ? i ^ 1 : Integer.MIN_VALUE;
                    }
                    subGroupOuterAlign = align != Integer.MIN_VALUE ? this.scanLayoutForNextTo(sub, align) : -1;
                } else {
                    subGroupOuterAlign = alignment;
                }
                if (validForRef && validResizing == 1 && subGroupOuterAlign != -1) {
                    nextToAlignment = this.checkNextToPosition(sub, subGroupOuterAlign);
                }
            }
            if (nextToAlignment == -1) continue;
            if (interval.isSequential()) {
                if (groupOuterAlignment != -1 || idx != 0 && idx + 1 != count) continue;
                if (idx != 0) {
                    nextToAlignment = nextToAlignment == 1 ? -1 : 0;
                } else if (idx + 1 != count) {
                    nextToAlignment = nextToAlignment == 0 ? -1 : 1;
                }
                groupOuterAlignment = nextToAlignment;
                continue;
            }
            if (LayoutInterval.wantResize(sub)) {
                if (nextToAlignment == Integer.MAX_VALUE) {
                    groupOuterAlignment = Integer.MAX_VALUE;
                    continue;
                }
                if (groupOuterAlignment != -1) continue;
                groupOuterAlignment = nextToAlignment;
                continue;
            }
            if (nextToAlignment != Integer.MAX_VALUE && (nextToAlignment ^ 1) != sub.getAlignment() || groupOuterAlignment != -1) continue;
            groupOuterAlignment = sub.getAlignment() ^ 1;
        }
        return groupOuterAlignment;
    }

    private boolean orthogonalOverlap(LayoutInterval interval, int index) {
        LayoutInterval sub = interval.getSubInterval(index);
        LayoutRegion subSpace = sub.getCurrentSpace();
        if (LayoutRegion.overlap(this.movingSpace, subSpace, this.dimension ^ 1, 0)) {
            return true;
        }
        if (this.dimension == 1) {
            if (sub.isSequential()) {
                return true;
            }
            if (interval.getParent() != null && interval.getParent().getSubIntervalCount() > 1) {
                return false;
            }
            if (!LayoutRegion.overlap(this.movingSpace, interval.getCurrentSpace(), this.dimension, 0)) {
                return true;
            }
            if (interval.isSequential()) {
                if (LayoutRegion.distance(this.movingSpace, subSpace, this.dimension, 1, 0) > 0) {
                    LayoutInterval li;
                    while (--index >= 0 && ((li = interval.getSubInterval(index)).isEmptySpace() || !this.isValidInterval(li))) {
                    }
                    if (index < 0) {
                        return true;
                    }
                } else if (LayoutRegion.distance(subSpace, this.movingSpace, this.dimension, 1, 0) > 0) {
                    LayoutInterval li;
                    while (++index < interval.getSubIntervalCount() && ((li = interval.getSubInterval(index)).isEmptySpace() || !this.isValidInterval(li))) {
                    }
                    if (index == interval.getSubIntervalCount()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private int checkNextToPosition(LayoutInterval sub, int alignment) {
        int nextToAlignment = -1;
        LayoutRegion subSpace = sub.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            boolean validDistance;
            if (alignment != Integer.MAX_VALUE && i != alignment) continue;
            int distance = LayoutRegion.distance(subSpace, this.movingSpace, this.dimension, i ^ 1, i);
            LayoutConstants.PaddingType paddingType = null;
            int[] pads = null;
            if (this.snapping) {
                LayoutInterval neighbor;
                LayoutInterval gap = LayoutInterval.getNeighbor(sub, i ^ 1, false, true, false);
                if (gap != null && LayoutInterval.isFixedDefaultPadding(gap) && (neighbor = LayoutInterval.getNeighbor(gap, i ^ 1, true, true, false)) != null && this.isValidInterval(neighbor) && (paddingType = gap.getPaddingType()) == null) {
                    paddingType = LayoutConstants.PaddingType.RELATED;
                }
                pads = this.findPaddings(sub, this.movingComponents[0].getLayoutInterval(this.dimension), paddingType, this.dimension, i);
                int orient = i == 0 ? -1 : 1;
                int padDst = distance + orient * pads[0];
                if (paddingType == null) {
                    paddingType = LayoutConstants.PaddingType.RELATED;
                    for (int j = 1; j < pads.length; ++j) {
                        int d;
                        if (PADDINGS[j] == LayoutConstants.PaddingType.INDENT || Math.abs(d = distance + orient * pads[j]) >= Math.abs(padDst)) continue;
                        padDst = d;
                        paddingType = PADDINGS[j];
                    }
                }
                validDistance = Math.abs(distance = padDst) < 8;
            } else {
                boolean bl = i == 0 ? distance > 0 : (validDistance = distance < 0);
            }
            if (!validDistance) continue;
            nextToAlignment = nextToAlignment == -1 ? i : Integer.MAX_VALUE;
            PositionDef bestSoFar = this.findingsNextTo[this.dimension][i];
            if (bestSoFar.isSet() && this.compareNextToPosition(sub, distance, bestSoFar) <= 0) continue;
            bestSoFar.interval = sub;
            bestSoFar.alignment = i;
            bestSoFar.distance = distance;
            bestSoFar.nextTo = true;
            bestSoFar.snapped = this.snapping;
            bestSoFar.paddingType = paddingType;
            PositionDef.access$702(bestSoFar, pads);
        }
        return nextToAlignment;
    }

    private int compareNextToPosition(LayoutInterval newInterval, int newDistance, PositionDef bestSoFar) {
        int oldOrtDst;
        if (!bestSoFar.isSet()) {
            return 1;
        }
        LayoutRegion newSpace = newInterval.getCurrentSpace();
        LayoutRegion oldSpace = bestSoFar.interval.getCurrentSpace();
        int oldDistance = Math.abs(bestSoFar.distance);
        if (newDistance < 0) {
            newDistance = -newDistance;
        }
        if (newDistance != oldDistance) {
            return newDistance < oldDistance ? 1 : -1;
        }
        if (newInterval.isParentOf(bestSoFar.interval)) {
            return 1;
        }
        int newOrtDst = Math.abs(LayoutRegion.minDistance(newSpace, this.movingSpace, this.dimension ^ 1));
        if (newOrtDst != (oldOrtDst = Math.abs(LayoutRegion.minDistance(oldSpace, this.movingSpace, this.dimension ^ 1)))) {
            return newOrtDst < oldOrtDst ? 1 : -1;
        }
        return 0;
    }

    private static boolean canGoInsideForNextTo(LayoutInterval subGroup, boolean valid) {
        return subGroup.isSequential() || subGroup.isParallel() && (!valid || subGroup.getGroupAlignment() != 2 && subGroup.getGroupAlignment() != 3);
    }

    private void checkRootForAligned(LayoutInterval layoutRoot, int alignment) {
        assert (alignment == Integer.MAX_VALUE || alignment == 0 || alignment == 1);
        if (this.operation == 2 && !this.isValidAlignedResizing(layoutRoot, alignment)) {
            return;
        }
        LayoutRegion rootSpace = layoutRoot.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            int distance;
            if (alignment != Integer.MAX_VALUE && alignment != i || (distance = LayoutRegion.distance(rootSpace, this.movingSpace, this.dimension, i, i)) == Integer.MIN_VALUE || Math.abs(distance) >= 8) continue;
            PositionDef bestSoFar = this.findingsAligned[this.dimension][i];
            assert (!bestSoFar.isSet());
            bestSoFar.interval = layoutRoot;
            bestSoFar.alignment = i;
            bestSoFar.distance = distance;
            bestSoFar.nextTo = false;
            bestSoFar.snapped = true;
        }
    }

    private void scanLayoutForAligned(LayoutInterval interval, int alignment) {
        assert (alignment == Integer.MAX_VALUE || alignment == 0 || alignment == 1);
        Iterator it = interval.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sub = (LayoutInterval)it.next();
            if (sub.isEmptySpace()) continue;
            if (sub.isComponent() && this.isValidInterval(sub) && (this.operation != 2 || this.isValidAlignedResizing(sub, alignment))) {
                for (int i = 0; i < LayoutRegion.POINT_COUNT[this.dimension]; ++i) {
                    PositionDef bestSoFar;
                    int distance;
                    if (alignment != Integer.MAX_VALUE && i != alignment) continue;
                    int indentedDst = this.getIndentedDistance(sub, i);
                    int directDst = this.getDirectDistance(sub, i);
                    int n = distance = Math.abs(indentedDst) < Math.abs(directDst) ? indentedDst : directDst;
                    if (!this.checkAlignedDistance(distance, sub.getCurrentSpace(), i) || this.compareAlignedPosition(sub, distance, bestSoFar = this.findingsAligned[this.dimension][i]) < 0) continue;
                    bestSoFar.interval = sub;
                    bestSoFar.alignment = i;
                    bestSoFar.distance = distance;
                    bestSoFar.nextTo = false;
                    bestSoFar.snapped = true;
                }
            }
            if (sub.getSubIntervalCount() <= 0 || !LayoutRegion.overlap(sub.getCurrentSpace(), this.movingSpace, this.dimension, 4)) continue;
            this.scanLayoutForAligned(sub, alignment);
        }
    }

    private int getIndentedDistance(LayoutInterval interval, int alignment) {
        int indent;
        LayoutRegion examinedSpace;
        int verticalDst;
        if (this.dimension == 0 && alignment == 0 && (verticalDst = LayoutRegion.distance(examinedSpace = interval.getCurrentSpace(), this.movingSpace, 1, 1, 0)) >= 0 && verticalDst < 16 && (indent = this.findIndent(interval.getComponent(), this.movingComponents[0], this.dimension, alignment)) > 0) {
            return LayoutRegion.distance(examinedSpace, this.movingSpace, this.dimension, alignment, alignment) - indent;
        }
        return Integer.MAX_VALUE;
    }

    private int getDirectDistance(LayoutInterval interval, int alignment) {
        return this.checkValidAlignment(interval, alignment) ? LayoutRegion.distance(interval.getCurrentSpace(), this.movingSpace, this.dimension, alignment, alignment) : Integer.MAX_VALUE;
    }

    private boolean checkValidAlignment(LayoutInterval interval, int alignment) {
        int presentAlign = interval.getAlignment();
        if (presentAlign != -1) {
            boolean lastOne = true;
            Iterator it = interval.getParent().getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = (LayoutInterval)it.next();
                if (li == interval || !this.isValidInterval(li)) continue;
                lastOne = false;
                break;
            }
            if (lastOne) {
                presentAlign = -1;
            }
        }
        return !(alignment == 0 || alignment == 1 ? presentAlign == 2 || presentAlign == 3 : (alignment == 2 ? presentAlign != 2 : alignment == 3 && presentAlign == 2));
    }

    private boolean checkAlignedDistance(int distance, LayoutRegion examinedSpace, int alignment) {
        if (distance != Integer.MIN_VALUE && Math.abs(distance) < 8) {
            int y2;
            int x2;
            int x1;
            int indent = this.movingSpace.positions[this.dimension][alignment] - examinedSpace.positions[this.dimension][alignment] - distance;
            if (indent == 0) {
                x1 = examinedSpace.positions[this.dimension][alignment] - 4;
                x2 = examinedSpace.positions[this.dimension][alignment] + 4;
                y2 = this.movingSpace.positions[this.dimension ^ 1][0];
            } else {
                x1 = examinedSpace.positions[this.dimension][alignment];
                x2 = x1 + indent + 4;
                y2 = this.movingSpace.positions[this.dimension ^ 1][1];
            }
            int y1 = examinedSpace.positions[this.dimension ^ 1][1];
            if (y1 > y2 && (y1 = this.movingSpace.positions[this.dimension ^ 1][1]) > (y2 = examinedSpace.positions[this.dimension ^ 1][0])) {
                return true;
            }
            return !this.contentOverlap(this.targetRoots[this.dimension], x1, x2, y1, y2, this.dimension);
        }
        return false;
    }

    private boolean contentOverlap(LayoutInterval group, int x1, int x2, int y1, int y2, int dim) {
        int[][] groupPos = group.getCurrentSpace().positions;
        int n = group.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            int _y2;
            int _y1;
            int _x2;
            int _x1;
            LayoutInterval li = group.getSubInterval(i);
            if (li.isEmptySpace()) {
                if (group.isParallel()) continue;
                _x1 = i == 0 ? groupPos[dim][0] : group.getSubInterval((int)(i - 1)).getCurrentSpace().positions[dim][1];
                _x2 = i + 1 == n ? groupPos[dim][1] : group.getSubInterval((int)(i + 1)).getCurrentSpace().positions[dim][0];
                _y1 = groupPos[dim ^ 1][0];
                _y2 = groupPos[dim ^ 1][1];
                if (_y1 < y1) {
                    _y2 = _y1;
                } else if (_y2 > y2) {
                    _y1 = _y2;
                }
            } else {
                int[][] positions = li.getCurrentSpace().positions;
                _x1 = positions[dim][0];
                _x2 = positions[dim][1];
                _y1 = positions[dim ^ 1][0];
                _y2 = positions[dim ^ 1][1];
            }
            if (_x1 >= x2 || _x2 <= x1 || _y1 >= y2 || _y2 <= y1) continue;
            if (li.isComponent()) {
                if (!this.isValidInterval(li)) continue;
                return true;
            }
            if (li.isEmptySpace()) {
                if (!(i <= 0 || i + 1 >= n || li.getMinimumSize() != -1 && li.getMinimumSize() != -2 || li.getPreferredSize() != -1 || li.getMaximumSize() != -1 && li.getMaximumSize() != -2)) {
                    LayoutInterval prev = group.getSubInterval(i - 1);
                    LayoutInterval next = group.getSubInterval(i + 1);
                    if (!(prev.isComponent() && !this.isValidInterval(prev) || next.isComponent() && !this.isValidInterval(next))) {
                        return true;
                    }
                }
                if (_x1 < x1 || _x2 > x2) continue;
                return false;
            }
            if (!li.isGroup() || !this.contentOverlap(li, x1, x2, y1, y2, dim)) continue;
            return true;
        }
        return false;
    }

    private int compareAlignedPosition(LayoutInterval newInterval, int newDistance, PositionDef bestSoFar) {
        int oldScore;
        if (!bestSoFar.isSet()) {
            return 1;
        }
        if (newDistance < 0) {
            newDistance = -newDistance;
        }
        int oldDistance = Math.abs(bestSoFar.distance);
        if (newInterval.getParent() == null) {
            return newDistance < oldDistance ? 1 : -1;
        }
        if (bestSoFar.interval.getParent() == null) {
            return oldDistance < newDistance ? -1 : 1;
        }
        LayoutRegion newSpace = newInterval.getCurrentSpace();
        LayoutRegion oldSpace = bestSoFar.interval.getCurrentSpace();
        int newOrtDst = Math.abs(LayoutRegion.nonOverlapDistance(newSpace, this.movingSpace, this.dimension ^ 1));
        int oldOrtDst = Math.abs(LayoutRegion.nonOverlapDistance(oldSpace, this.movingSpace, this.dimension ^ 1));
        int newScore = LayoutDragger.getDistanceScore(newDistance, newOrtDst);
        if (newScore != (oldScore = LayoutDragger.getDistanceScore(oldDistance, oldOrtDst))) {
            return newScore < oldScore ? 1 : -1;
        }
        return 0;
    }

    private static int getDistanceScore(int directDistance, int ortDistance) {
        return directDistance + ortDistance / 8;
    }

    private PositionDef chooseBestNextTo() {
        PositionDef[] positions = this.findingsNextTo[this.dimension];
        PositionDef bestPos = null;
        int bestDst = 0;
        for (int i = 0; i < positions.length; ++i) {
            PositionDef pos = positions[i];
            if (!pos.isSet()) continue;
            int dst = Math.abs(pos.distance);
            if (bestPos != null && dst >= bestDst && (dst != bestDst || this.moveDirection[this.dimension] != i)) continue;
            bestPos = pos;
            bestDst = dst;
        }
        return bestPos;
    }

    private PositionDef chooseBestAligned() {
        PositionDef[] positions = this.findingsAligned[this.dimension];
        PositionDef bestPos = null;
        for (int i = positions.length - 1; i >= 0; --i) {
            PositionDef pos = positions[i];
            if (!pos.isSet()) continue;
            if (i == 3 || i == 2) {
                return pos;
            }
            if (bestPos == null) {
                bestPos = pos;
                continue;
            }
            int c = this.compareAlignedPosition(pos.interval, pos.distance, bestPos);
            if (c == 0) {
                c = this.compareAlignedDirection(pos, bestPos);
            }
            if (c <= 0) continue;
            bestPos = pos;
        }
        return bestPos;
    }

    private int compareAlignedDirection(PositionDef pos1, PositionDef pos2) {
        boolean p2;
        boolean p1 = LayoutDragger.isSuitableAlignment(pos1);
        if (p1 == (p2 = LayoutDragger.isSuitableAlignment(pos2))) {
            p1 = pos1.alignment == this.moveDirection[this.dimension];
            boolean bl = p2 = pos2.alignment == this.moveDirection[this.dimension];
            if (p1 == p2) {
                return 0;
            }
        }
        return p1 ? 1 : -1;
    }

    private static boolean isSuitableAlignment(PositionDef pos) {
        assert (pos.alignment == 0 || pos.alignment == 1);
        LayoutInterval parParent = LayoutInterval.getFirstParent(pos.interval, 103);
        return LayoutInterval.isAlignedAtBorder(pos.interval, parParent, pos.alignment) || !LayoutInterval.isAlignedAtBorder(pos.interval, parParent, pos.alignment ^ 1);
    }

    private static int smallestDistance(PositionDef[] positions) {
        int bestDst = -1;
        for (int i = 0; i < positions.length; ++i) {
            PositionDef pos = positions[i];
            if (!pos.isSet()) continue;
            int dst = Math.abs(pos.distance);
            if (bestDst >= 0 && dst >= bestDst) continue;
            bestDst = dst;
        }
        return bestDst;
    }

    private boolean isPreferredNextTo(PositionDef bestNextTo, PositionDef bestAligned) {
        if (bestNextTo != null && bestAligned != null && this.operation == 2) {
            LayoutInterval commonParent;
            LayoutInterval resizing = this.movingComponents[0].getLayoutInterval(this.dimension);
            int fixedEdge = this.movingEdges[this.dimension] ^ 1;
            return !(bestAligned.interval.isParentOf(resizing) ? LayoutInterval.isAlignedAtBorder(resizing, bestAligned.interval, fixedEdge) : LayoutInterval.isAlignedAtBorder(resizing, commonParent = LayoutInterval.getCommonParent(resizing, bestAligned.interval), fixedEdge) && LayoutInterval.isAlignedAtBorder(bestAligned.interval, commonParent, fixedEdge));
        }
        return this.dimension == 0;
    }

    private static boolean relatedPositions(PositionDef nextTo, PositionDef aligned) {
        if (nextTo.interval == null || aligned.interval == null) {
            return false;
        }
        LayoutInterval neighbor = LayoutInterval.getNeighbor(aligned.interval, nextTo.alignment, true, true, false);
        return neighbor == nextTo.interval || neighbor == null && nextTo.interval.getParent() == null;
    }

    private PositionDef getAlignedEqualToNextTo(PositionDef bestNextTo) {
        LayoutInterval neighbor;
        if (this.operation == 2 || !bestNextTo.snapped) {
            return null;
        }
        int alignment = bestNextTo.alignment;
        PositionDef alignedAlternative = this.findingsAligned[this.dimension][alignment];
        if (alignedAlternative != null && alignedAlternative.distance == bestNextTo.distance && (neighbor = LayoutInterval.getNeighbor(alignedAlternative.interval, alignment, true, true, false)) != null && (neighbor == bestNextTo.interval || neighbor.isParentOf(bestNextTo.interval))) {
            return alignedAlternative;
        }
        return null;
    }

    private boolean isValidInterval(LayoutInterval interval) {
        if (this.operation == 0) {
            return true;
        }
        if (interval.isGroup()) {
            int count = 0;
            Iterator it = interval.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = (LayoutInterval)it.next();
                if (li.isEmptySpace() && !interval.isSequential() || !this.isValidInterval(li) || ++count <= 1) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.movingComponents.length; ++i) {
            if (this.movingComponents[i].getLayoutInterval(this.dimension) != interval) continue;
            return false;
        }
        return true;
    }

    private int isValidNextToResizing(LayoutInterval interval, int alignment) {
        assert (alignment == 0 || alignment == 1);
        LayoutInterval resizing = this.movingComponents[0].getLayoutInterval(this.dimension);
        if (interval.isParentOf(resizing)) {
            return interval.getParent() == null && LayoutDragger.clearWayToParent(resizing, interval, this.dimension, alignment) && (!LayoutDragger.toDeepToMerge(resizing, interval, alignment) || LayoutInterval.getNeighbor(resizing, alignment, true, true, false) == null) ? 1 : 0;
        }
        LayoutInterval commonParent = LayoutInterval.getCommonParent(interval, resizing);
        if (commonParent.isSequential()) {
            if (LayoutDragger.toDeepToMerge(resizing, commonParent, alignment) && LayoutInterval.getNeighbor(resizing, alignment, true, true, false) != interval) {
                return -1;
            }
            if ((resizing = LayoutDragger.getClearWayToParent(resizing, commonParent, this.dimension, alignment)) == null) {
                return -1;
            }
            while (interval.getParent() != commonParent) {
                interval = interval.getParent();
            }
            int startIndex = commonParent.indexOf(alignment == 0 ? interval : resizing) + 1;
            int endIndex = commonParent.indexOf(alignment == 0 ? resizing : interval) - 1;
            return startIndex <= endIndex && !LayoutUtils.contentOverlap(this.movingSpace, commonParent, startIndex, endIndex, this.dimension ^ 1) ? 1 : -1;
        }
        return -1;
    }

    private boolean isValidAlignedResizing(LayoutInterval interval, int alignment) {
        int dst = LayoutRegion.distance(this.movingSpace, interval.getCurrentSpace(), this.dimension, alignment ^ 1, alignment);
        if (alignment == 0 && dst <= 0 || alignment == 1 && dst >= 0) {
            int endIndex;
            int startIndex;
            LayoutInterval resizing = this.movingComponents[0].getLayoutInterval(this.dimension);
            if (interval.isParentOf(resizing)) {
                LayoutInterval neighbor;
                if (!LayoutDragger.clearWayToParent(resizing, interval, this.dimension, alignment)) {
                    return false;
                }
                return !LayoutDragger.toDeepToMerge(resizing, interval, alignment) || (neighbor = LayoutInterval.getNeighbor(resizing, alignment, true, true, false)) == null || !interval.isParentOf(neighbor);
            }
            LayoutInterval commonParent = LayoutInterval.getCommonParent(interval, resizing);
            if (commonParent.isParallel()) {
                return true;
            }
            if (LayoutDragger.toDeepToMerge(resizing, commonParent, alignment)) {
                return false;
            }
            if ((resizing = LayoutDragger.getClearWayToParent(resizing, commonParent, this.dimension, alignment)) == null) {
                return false;
            }
            while (interval.getParent() != commonParent) {
                interval = interval.getParent();
            }
            if (alignment == 0) {
                startIndex = commonParent.indexOf(interval);
                endIndex = commonParent.indexOf(resizing) - 1;
            } else {
                startIndex = commonParent.indexOf(resizing) + 1;
                endIndex = commonParent.indexOf(interval);
            }
            return startIndex <= endIndex && !LayoutUtils.contentOverlap(this.movingSpace, commonParent, startIndex, endIndex, this.dimension ^ 1);
        }
        return false;
    }

    private static boolean clearWayToParent(LayoutInterval interval, LayoutInterval parent, int dimension, int alignment) {
        return LayoutDragger.getClearWayToParent(interval, parent, dimension, alignment) != null;
    }

    private static LayoutInterval getClearWayToParent(LayoutInterval interval, LayoutInterval topParent, int dimension, int alignment) {
        LayoutRegion space = interval.getCurrentSpace();
        LayoutInterval parent = interval.getParent();
        while (parent != topParent) {
            if (parent.isSequential()) {
                int endIndex;
                int startIndex;
                if (alignment == 0) {
                    startIndex = 0;
                    endIndex = parent.indexOf(interval) - 1;
                } else {
                    startIndex = parent.indexOf(interval) + 1;
                    endIndex = parent.getSubIntervalCount() - 1;
                }
                if (startIndex <= endIndex && LayoutUtils.contentOverlap(space, parent, startIndex, endIndex, dimension ^ 1)) {
                    return null;
                }
            }
            interval = parent;
            parent = interval.getParent();
        }
        return interval;
    }

    private static boolean toDeepToMerge(LayoutInterval interval, LayoutInterval parent, int alignment) {
        int level = 0;
        int a = -1;
        LayoutInterval prev = null;
        LayoutInterval p = interval.getParent();
        while (p != parent) {
            if (p.isParallel()) {
                if (a == -1) {
                    a = interval.getAlignment();
                    if (a != alignment) {
                        ++level;
                    }
                } else if (!LayoutInterval.isAlignedAtBorder(prev, p, a) && ++level > 1) {
                    return true;
                }
                prev = p;
            }
            interval = p;
            p = interval.getParent();
        }
        return level >= 2;
    }

    int[] findPaddings(LayoutInterval interval, LayoutInterval moving, LayoutConstants.PaddingType paddingType, int dimension, int alignment) {
        int oppAlignment = alignment == 0 ? 1 : 0;
        List movingComps = LayoutUtils.edgeSubComponents(moving, alignment);
        List fixedComps = LayoutUtils.edgeSubComponents(interval, oppAlignment);
        List sources = alignment == 0 ? fixedComps : movingComps;
        List targets = alignment == 0 ? movingComps : fixedComps;
        HashMap<String, LayoutRegion> map = new HashMap<String, LayoutRegion>();
        for (int i = 0; i < this.movingComponents.length; ++i) {
            map.put(this.movingComponents[i].getId(), this.movingBounds[i]);
        }
        return LayoutUtils.getSizesOfDefaultGap(sources, targets, paddingType, this.visualMapper, this.targetContainer.getId(), map);
    }

    int findIndent(LayoutComponent mainComp, LayoutComponent indentedComp, int dimension, int alignment) {
        return this.visualMapper.getPreferredPadding(mainComp.getId(), indentedComp.getId(), dimension, alignment, LayoutConstants.PaddingType.INDENT);
    }

    static class PositionDef {
        private int distance = Integer.MIN_VALUE;
        LayoutInterval interval;
        int alignment = Integer.MIN_VALUE;
        boolean nextTo;
        boolean snapped;
        LayoutConstants.PaddingType paddingType;
        private int[] paddingSizes;

        PositionDef() {
        }

        private void reset() {
            this.distance = Integer.MIN_VALUE;
            this.interval = null;
            this.alignment = Integer.MIN_VALUE;
        }

        private boolean isSet() {
            return this.interval != null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("distance=").append(this.distance);
            sb.append(",alignment=").append(this.alignment);
            sb.append(",nextTo=").append(this.nextTo);
            sb.append(",snapped=").append(this.snapped);
            return sb.toString();
        }

        static /* synthetic */ int[] access$702(PositionDef x0, int[] x1) {
            x0.paddingSizes = x1;
            return x1;
        }
    }

    static class SizeDef {
        private int originalSize;
        private int preferredSize;
        private int zeroPreferredSize;
        private LayoutInterval resizingGap;
        private int originalGapSize;
        private int preferredGapSize;

        SizeDef() {
        }

        LayoutInterval getResizingGap() {
            return this.resizingGap;
        }

        int getResizingGapSize(int currentSize) {
            if (this.resizingGap == null) {
                return Integer.MIN_VALUE;
            }
            if (currentSize == this.zeroPreferredSize) {
                return 0;
            }
            int gapSize = this.originalGapSize - this.originalSize + currentSize;
            return currentSize == this.preferredSize || gapSize < 0 ? -1 : gapSize;
        }
    }
}

