/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.awt.Rectangle;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public class LayoutTestUtils
implements LayoutConstants {
    static void writeString(List codeList, String name, String value) {
        if (value != null) {
            codeList.add("String " + name + "= \"" + value + "\";");
        } else {
            codeList.add("String " + name + " = null;");
        }
    }

    static void writeLayoutComponentArray(List codeList, String arrayName, String lcName) {
        codeList.add("LayoutComponent[] " + arrayName + " = new LayoutComponent[] { " + lcName + " };");
    }

    static void writeCollection(List codeList, String name, Collection c) {
        codeList.add("Collection " + name + " = new ArrayList();");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            codeList.add(name + ".add(\"" + (String)i.next() + "\");");
        }
    }

    static void writeStringArray(List codeList, String name, String[] compIds) {
        codeList.add("String[] " + name + " = new String[] {");
        for (int i = 0; i < compIds.length; ++i) {
            codeList.add("\"" + compIds[i] + "\"" + (i + 1 < compIds.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeIntArray(List codeList, String name, int[] values) {
        codeList.add("int[] " + name + " = new int[] {");
        for (int i = 0; i < values.length; ++i) {
            codeList.add(Integer.toString(values[i]) + (i + 1 < values.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeRectangleArray(List codeList, String name, Rectangle[] bounds) {
        codeList.add("Rectangle[] " + name + " = new Rectangle[] {");
        for (int i = 0; i < bounds.length; ++i) {
            codeList.add("new Rectangle(" + bounds[i].x + ", " + bounds[i].y + ", " + bounds[i].width + ", " + bounds[i].height + (i + 1 < bounds.length ? "), " : ")"));
        }
        codeList.add("};");
    }

    static void dumpTestcode(List codeList, DataObject form, final int modelCounter) {
        FileWriter fw = null;
        StringBuffer template = new StringBuffer();
        if (form == null) {
            return;
        }
        try {
            FileObject primaryFile = form.getPrimaryFile();
            InputStream in = LayoutTestUtils.class.getResourceAsStream("/org/netbeans/modules/form/resources/LayoutModelAutoTest_template");
            LineNumberReader lReader = new LineNumberReader(new InputStreamReader(in));
            while (lReader.ready()) {
                template.append(lReader.readLine()).append('\n');
            }
            lReader.close();
            final StringBuffer code = new StringBuffer();
            for (String line : codeList) {
                code.append(line).append('\n');
            }
            ClassPath cpath = ClassPath.getClassPath((FileObject)primaryFile, (String)"classpath/source");
            final String primaryFileClassFQN = cpath.getResourceName(primaryFile, '.', false);
            final boolean[] resolved = new boolean[1];
            JavaSource js = JavaSource.forFileObject((FileObject)primaryFile);
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement clazz = controller.getElements().getTypeElement(primaryFileClassFQN);
                    resolved[0] = clazz != null;
                }
            }, true);
            if (!resolved[0]) {
                return;
            }
            String testClassName = primaryFile.getName() + "Test";
            FileObject testFO = primaryFile.getParent().getFileObject(testClassName, "java");
            if (testFO == null) {
                testFO = primaryFile.getParent().createData(testClassName, "java");
                String output = Utilities.replaceString((String)template.toString(), (String)"${CLASS_NAME}", (String)testFO.getName());
                fw = new FileWriter(FileUtil.toFile((FileObject)testFO));
                fw.write(output);
                fw.close();
            }
            final String testClassFQN = "org.netbeans.modules.form.layoutdesign." + testFO.getName();
            js = JavaSource.forFileObject((FileObject)testFO);
            js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy wcopy) throws Exception {
                    wcopy.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement classElm = wcopy.getElements().getTypeElement(testClassFQN);
                    if (classElm != null) {
                        ClassTree classTree = wcopy.getTrees().getTree(classElm);
                        TreeMaker make = wcopy.getTreeMaker();
                        MethodTree method = make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)("doChanges" + modelCounter), (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), code.toString(), null);
                        ClassTree classCopy = make.addClassMember(classTree, (Tree)method);
                        wcopy.rewrite((Tree)classTree, (Tree)classCopy);
                    }
                }
            }).commit();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static FileObject getTargetFolder(FileObject file) {
        FileObject targetFolder = file.getParent();
        try {
            FileObject folder = file.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getFileObject("data/goldenfiles");
            if (folder != null) {
                targetFolder = folder;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return targetFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTest(FormDesigner fd, FormDataObject formDO, Map idToNameMap, LayoutModel lm) {
        FileObject formFO = formDO.getFormFile();
        fd.getLayoutDesigner().dumpTestcode((DataObject)formDO);
        OutputStreamWriter fw = null;
        try {
            FileObject targetFolder = LayoutTestUtils.getTargetFolder(formFO);
            FileObject fo = targetFolder.createData(formFO.getName() + "Test-ExpectedEndModel" + Integer.toString(fd.getLayoutDesigner().getModelCounter()), "txt");
            fw = new FileWriter(FileUtil.toFile((FileObject)fo));
            fw.write(lm.dump(idToNameMap));
            StatusDisplayer.getDefault().setStatusText("The test was successfully written: " + fo.getPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException io) {}
        }
    }
}

