/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;

public class SwingLayoutUtils {
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_NON_RESIZABLE = 0;
    public static final int STATUS_RESIZABLE = 1;
    private static Set nonResizableComponents = new HashSet();
    private static Set resizableComponents;

    public static int getResizableStatus(Class componentClass) {
        String className = componentClass.getName();
        if (resizableComponents.contains(className)) {
            return 1;
        }
        if (nonResizableComponents.contains(className)) {
            return 0;
        }
        return -1;
    }

    public static Map createLinkSizeGroups(LayoutComponent layoutComponent, int dimension) {
        HashMap<Integer, ArrayList<String>> linkSizeGroup = new HashMap<Integer, ArrayList<String>>();
        if (layoutComponent.isLayoutContainer()) {
            for (LayoutComponent lc : layoutComponent.getSubcomponents()) {
                if (lc == null || !lc.isLinkSized(dimension)) continue;
                String cid = lc.getId();
                Integer id = new Integer(lc.getLinkSizeId(dimension));
                ArrayList<String> l = (ArrayList<String>)linkSizeGroup.get(id);
                if (l == null) {
                    l = new ArrayList<String>();
                    l.add(cid);
                    linkSizeGroup.put(id, l);
                    continue;
                }
                l.add(cid);
            }
        }
        return linkSizeGroup;
    }

    static {
        nonResizableComponents.addAll(Arrays.asList("javax.swing.JLabel", "javax.swing.JButton", "javax.swing.JToggleButton", "javax.swing.JCheckBox", "javax.swing.JRadioButton", "javax.swing.JList"));
        resizableComponents = new HashSet();
        resizableComponents.addAll(Arrays.asList("javax.swing.JComboBox", "javax.swing.JTextField", "javax.swing.JTextArea", "javax.swing.JTabbedPane", "javax.swing.JScrollPane", "javax.swing.JSplitPane", "javax.swing.JFormattedTextField", "javax.swing.JPasswordField", "javax.swing.JSpinner", "javax.swing.JSeparator", "javax.swing.JTextPane", "javax.swing.JEditorPane", "javax.swing.JInternalFrame", "javax.swing.JLayeredPane", "javax.swing.JDesktopPane"));
    }
}

