/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.FormCodeSupport;

final class BeanCodeManager {
    private Class beanClass;
    private FormProperty[] properties;
    private CodeExpression[] propertyExpressions;
    private int creationStyle;
    private boolean forceEmptyConstructor;
    private CreationDescriptor creationDesc;
    private CreationDescriptor.Creator currentCreator;
    private CodeStructure codeStructure;
    private CodeExpression beanExpression;
    private CodeGroup beanCode;
    private boolean isVariableSet;
    private int variableType;
    private boolean readingDone;

    public BeanCodeManager(Class beanClass, FormProperty[] beanProperties, int creationStyle, boolean forceEmptyCtor, CodeStructure codeStructure, int defaultVariableType, CodeGroup beanCode) {
        this.beanClass = beanClass;
        this.properties = beanProperties;
        this.creationStyle = creationStyle | 1;
        this.forceEmptyConstructor = forceEmptyCtor;
        this.codeStructure = codeStructure;
        this.variableType = defaultVariableType;
        this.beanCode = beanCode;
        this.isVariableSet = false;
        this.creationDesc = CreationFactory.getDescriptor(beanClass);
        this.beanExpression = codeStructure.createDefaultExpression();
        this.readingDone = true;
        this.updateCode();
    }

    public BeanCodeManager(Class beanClass, FormProperty[] beanProperties, int creationStyle, boolean forceEmptyCtor, boolean allowChangesFiring, CodeExpression beanExpression, CodeGroup beanCode) {
        this.beanClass = beanClass;
        this.properties = beanProperties;
        this.creationStyle = creationStyle | 1;
        this.forceEmptyConstructor = forceEmptyCtor;
        this.beanExpression = beanExpression;
        this.codeStructure = beanExpression.getCodeStructure();
        this.beanCode = beanCode;
        this.readingDone = false;
        CodeVariable var = beanExpression.getVariable();
        CodeStatement variableStatement = var != null ? var.getAssignment(beanExpression) : null;
        this.isVariableSet = variableStatement != null;
        this.variableType = var != null ? var.getType() : 4096;
        this.creationDesc = CreationFactory.getDescriptor(beanClass);
        if (this.creationDesc != null) {
            CodeExpression[] creationExpressions = beanExpression.getOrigin().getCreationParameters();
            Class[] paramTypes = new Class[creationExpressions.length];
            for (int i = 0; i < creationExpressions.length; ++i) {
                paramTypes[i] = creationExpressions[i].getOrigin().getType();
            }
            this.currentCreator = CreationFactory.findCreator(this.creationDesc, paramTypes);
            if (this.currentCreator != null) {
                String[] creatorPropNames = this.currentCreator.getPropertyNames();
                block1: for (int i = 0; i < creatorPropNames.length; ++i) {
                    String propName = creatorPropNames[i];
                    for (int j = 0; j < this.properties.length; ++j) {
                        if (!this.properties[j].getName().equals(propName)) continue;
                        FormCodeSupport.readPropertyExpression(creationExpressions[i], this.properties[j], allowChangesFiring);
                        this.setPropertyExpression(j, creationExpressions[i]);
                        continue block1;
                    }
                }
                beanExpression.setOrigin(this.currentCreator.getCodeOrigin(creationExpressions));
            }
        }
        Iterator it = CodeStructure.getDefinedStatementsIterator(beanExpression);
        block3: while (it.hasNext()) {
            CodeStatement statement = (CodeStatement)it.next();
            for (int j = 0; j < this.properties.length; ++j) {
                Method propMethod;
                FormProperty prop = this.properties[j];
                if (!(prop instanceof RADProperty) || (propMethod = ((RADProperty)prop).getPropertyDescriptor().getWriteMethod()) == null || !propMethod.equals(statement.getMetaObject())) continue;
                CodeExpression propExp = statement.getStatementParameters()[0];
                FormCodeSupport.readPropertyExpression(propExp, prop, allowChangesFiring);
                this.setPropertyExpression(j, propExp);
                if (beanCode == null) continue block3;
                beanCode.addStatement(statement);
                continue block3;
            }
        }
        if (beanCode != null && variableStatement != null) {
            beanCode.addStatement(0, variableStatement);
        }
        this.readingDone = true;
    }

    public CodeExpression getCodeExpression() {
        return this.beanExpression;
    }

    public void updateCode() {
        CodeExpression[] creationExpressions;
        String[] creatorPropNames;
        CreationDescriptor.Creator newCreator;
        if (!this.readingDone) {
            return;
        }
        CreationDescriptor.Creator creator = newCreator = this.creationDesc != null && !this.forceEmptyConstructor ? this.creationDesc.findBestCreator(this.properties, this.creationStyle) : null;
        if (newCreator != null) {
            creatorPropNames = newCreator.getPropertyNames();
            creationExpressions = new CodeExpression[newCreator.getParameterCount()];
        } else {
            creatorPropNames = null;
            creationExpressions = CodeStructure.EMPTY_PARAMS;
        }
        boolean anyPropertyStatement = false;
        for (int i = 0; i < this.properties.length; ++i) {
            Method statementMethod;
            boolean removeStatement;
            FormProperty property = this.properties[i];
            boolean bl = removeStatement = !property.isChanged();
            if (newCreator != null) {
                String propName = property.getName();
                for (int j = 0; j < creatorPropNames.length; ++j) {
                    if (!creatorPropNames[j].equals(propName)) continue;
                    creationExpressions[j] = this.getPropertyExpression(i);
                    removeStatement = true;
                    break;
                }
            }
            if (!(property instanceof RADProperty) || (statementMethod = ((RADProperty)property).getPropertyDescriptor().getWriteMethod()) == null) continue;
            Iterator it = CodeStructure.getDefinedStatementsIterator(this.beanExpression);
            CodeStatement[] existingStatements = CodeStructure.filterStatements(it, statementMethod);
            if (removeStatement) {
                for (int j = 0; j < existingStatements.length; ++j) {
                    CodeStatement toRemove = existingStatements[j];
                    CodeStructure.removeStatement(toRemove);
                    if (this.beanCode == null) continue;
                    this.beanCode.remove(toRemove);
                }
                continue;
            }
            anyPropertyStatement = true;
            if (existingStatements.length != 0) continue;
            CodeStatement statement = CodeStructure.createStatement(this.beanExpression, statementMethod, new CodeExpression[]{this.getPropertyExpression(i)});
            if (this.beanCode == null) continue;
            this.beanCode.addStatement(statement);
        }
        if (newCreator != null) {
            if (newCreator != this.currentCreator) {
                this.currentCreator = newCreator;
                this.beanExpression.setOrigin(newCreator.getCodeOrigin(creationExpressions));
            }
        } else if (newCreator != this.currentCreator || this.beanExpression.getOrigin() == null) {
            CodeExpressionOrigin origin;
            block21: {
                this.currentCreator = null;
                origin = null;
                try {
                    Constructor ctor = this.beanClass.getConstructor(new Class[0]);
                    origin = CodeStructure.createOrigin(ctor, new CodeExpression[0]);
                }
                catch (NoSuchMethodException ex) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block21;
                    System.out.println("[WARNING] No default constructor for " + this.beanClass.getName());
                    ex.printStackTrace();
                    return;
                }
            }
            this.beanExpression.setOrigin(origin);
        }
        if (anyPropertyStatement) {
            if (!this.isVariableSet) {
                CodeVariable var = this.codeStructure.createVariableForExpression(this.beanExpression, this.variableType, null);
                if (this.beanCode != null) {
                    this.beanCode.addStatement(0, var.getAssignment(this.beanExpression));
                }
                this.isVariableSet = true;
            }
        } else if (this.isVariableSet) {
            CodeVariable var = this.beanExpression.getVariable();
            if (var != null) {
                if (this.beanCode != null) {
                    this.beanCode.remove(var.getAssignment(this.beanExpression));
                }
                this.variableType = var.getType();
                this.codeStructure.removeExpressionFromVariable(this.beanExpression);
            }
            this.isVariableSet = false;
        }
    }

    private CodeExpression getPropertyExpression(int index) {
        CodeExpression expression;
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new CodeExpression[this.properties.length];
        }
        if ((expression = this.propertyExpressions[index]) == null) {
            FormProperty prop = this.properties[index];
            this.propertyExpressions[index] = expression = this.codeStructure.createExpression(FormCodeSupport.createOrigin(prop));
        }
        return expression;
    }

    private void setPropertyExpression(int index, CodeExpression propExp) {
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new CodeExpression[this.properties.length];
        }
        this.propertyExpressions[index] = propExp;
    }
}

