/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.PopupMenuUI;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.menu.MenuItemReceiverAndSender;
import org.netbeans.modules.form.menu.VisualDesignerItemDropTargetListener;
import org.netbeans.modules.form.menu.VisualDesignerPopupFactory;
import org.netbeans.modules.form.menu.VisualDesignerPopupMenuUI;

public class MenuEditLayer
extends JPanel {
    private static final boolean DEBUG = false;
    private static final boolean newDnD = true;
    JPopupMenu globalPopup;
    public VisualDesignerPopupFactory hackedPopupFactory = new VisualDesignerPopupFactory(this);
    MenuItemReceiverAndSender menuItemTransferHandler;
    VisualDesignerItemDropTargetListener globalDropListener = new VisualDesignerItemDropTargetListener(this);
    private Map<JComponent, MouseInputAdapter> menuitemListenerMap;
    private Map<JMenu, PopupMenuUI> menuPopupUIMap;
    public FormDesigner formDesigner;
    private Map<JComponent, JComponent> menuParentMap;
    private JComponent selectedComponent;
    public static final Border INSERTION_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.RED), BorderFactory.createEmptyBorder(0, 2, 2, 2));
    public static final Border INSERTION_BORDER_MENU_RIGHT = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 2, Color.RED), BorderFactory.createEmptyBorder(2, 2, 2, 0));
    public static final Border UNSELECTED_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    public static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.ORANGE, 2);
    public static final Border DRAG_MENU_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    private RADVisualContainer currentMenuRAD;
    private JMenu currentMenu;
    private RADVisualComponent selectedRADComponent;
    private RADVisualContainer menuBarRAD;
    private KeyListener keyListener;
    private Map<RADVisualContainer, FormModelListener> formModelListeners;
    public JLayeredPane layers;
    private JComponent prevRollover = null;

    public MenuEditLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.menuitemListenerMap = new HashMap<JComponent, MouseInputAdapter>();
        this.menuPopupUIMap = new HashMap<JMenu, PopupMenuUI>();
        this.menuItemTransferHandler = new MenuItemReceiverAndSender(this);
        this.menuParentMap = new HashMap<JComponent, JComponent>();
        this.formModelListeners = new HashMap<RADVisualContainer, FormModelListener>();
        AbstractAction editActionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MenuEditLayer.this.openActionEditor();
            }
        };
        editActionAction.putValue("Name", "Edit Action");
        this.globalPopup = new JPopupMenu("Edit Menu");
        this.globalPopup.add(new JMenuItem(editActionAction));
        this.globalPopup.add(new JMenuItem("Insert Menu Item"));
        this.globalPopup.add(new JMenuItem("Insert Radio Button Menu Item"));
        this.globalPopup.add(new JMenuItem("Insert Checkbox Menu Item"));
        this.globalPopup.add(new JMenuItem("Insert Separator"));
        this.globalPopup.add(new JMenuItem("Delete"));
        this.setLayout(null);
        this.layers = new JLayeredPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layers, "Center");
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private void openActionEditor() {
        for (RADComponent rADComponent : this.formDesigner.getSelectedComponents()) {
        }
    }

    public void closeMenu(RADComponent menuComp, Component comp) {
    }

    public void openMenu(RADComponent metacomp, Component comp) {
        JMenu menu;
        this.currentMenu = menu = (JMenu)comp;
        this.registerKeyListeners();
        this.configureMenu(null, menu);
        this.showMenuPopup(menu);
        if (metacomp instanceof RADVisualContainer) {
            this.currentMenuRAD = (RADVisualContainer)metacomp;
            this.menuBarRAD = this.currentMenuRAD.getParentContainer();
        }
    }

    void showMenuPopup(JMenu menu) {
        if (this.hackedPopupFactory.containerMap.containsKey(menu)) {
            this.hackedPopupFactory.containerMap.get(menu).setVisible(true);
        } else {
            JPopupMenu popup = menu.getPopupMenu();
            popup.show(menu, 0, menu.getHeight());
        }
        this.validate();
    }

    public boolean isMenuLayerComponent(RADComponent metacomp) {
        if (metacomp == null) {
            return false;
        }
        return metacomp.getBeanClass().equals(JMenuItem.class);
    }

    public void hideMenuLayer() {
        for (JMenu m : this.menuPopupUIMap.keySet()) {
            this.unconfigureMenu(m);
        }
        this.menuPopupUIMap.clear();
        this.menuitemListenerMap.clear();
        this.setVisible(false);
        this.removeKeyListener(this.keyListener);
        this.keyListener = null;
    }

    void configureMenu(JComponent parent, JMenu menu) {
        menu.setBorderPainted(true);
        this.menuParentMap.put(menu, parent);
        JPopupMenu popup = menu.getPopupMenu();
        this.menuPopupUIMap.put(menu, popup.getUI());
        popup.setUI(new VisualDesignerPopupMenuUI(this, popup.getUI()));
        Component[] subComps = menu.getMenuComponents();
        JPanel popupPanel = this.hackedPopupFactory.containerMap.get(menu);
        if (popupPanel != null) {
            subComps = popupPanel.getComponents();
        }
        this.menuItemTransferHandler.registerTransferComponent(menu, menu);
        menu.setTransferHandler(this.menuItemTransferHandler);
        try {
            menu.getDropTarget().addDropTargetListener(this.globalDropListener);
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
        this.configMouseListener(menu);
        RADVisualContainer menuRAD = (RADVisualContainer)this.formDesigner.getMetaComponent(menu);
        this.registerForm(menuRAD, menu);
        for (Component c : subComps) {
            if (c instanceof JMenu) {
                this.configureMenu(menu, (JMenu)c);
                RADComponent rad = this.formDesigner.getMetaComponent(c);
                this.registerForm((RADVisualContainer)rad, (JMenu)c);
                continue;
            }
            this.configureMenuItem(menu, (JComponent)c);
        }
    }

    private void unconfigureMenu(JMenu menu) {
        menu.getPopupMenu().setUI(this.menuPopupUIMap.get(menu));
        try {
            menu.getDropTarget().removeDropTargetListener(this.globalDropListener);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JPanel popup = this.hackedPopupFactory.containerMap.get(menu);
        if (popup != null) {
            for (Component c : popup.getComponents()) {
                if (c instanceof JMenu) continue;
                this.unconfigureMenuItem((JComponent)c);
            }
            if (menu.getPopupMenu() != null) {
                menu.getPopupMenu().setVisible(false);
            }
            popup.setVisible(false);
        }
    }

    private boolean isConfigured(JComponent c) {
        return this.menuParentMap.containsKey(c);
    }

    void configureMenuItem(JMenu parent, JComponent c) {
        this.menuParentMap.put(c, parent);
        this.menuItemTransferHandler.registerTransferComponent(c, c);
        c.setTransferHandler(this.menuItemTransferHandler);
        try {
            c.getDropTarget().addDropTargetListener(this.globalDropListener);
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
        this.configMouseListener(c);
    }

    void unconfigureMenuItem(JComponent c) {
        if (c instanceof JMenuItem) {
            // empty if block
        }
        try {
            c.getDropTarget().removeDropTargetListener(this.globalDropListener);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        c.setTransferHandler(null);
        c.removeMouseListener(this.menuitemListenerMap.get(c));
        c.removeMouseMotionListener(this.menuitemListenerMap.get(c));
        this.menuParentMap.remove(c);
    }

    private void configMouseListener(JComponent c) {
        for (MouseListener mouseListener : c.getMouseListeners()) {
            c.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : c.getMouseMotionListeners()) {
            c.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        MenuItemMouseHandler mia = new MenuItemMouseHandler(c);
        c.addMouseListener(mia);
        c.addMouseMotionListener(mia);
        this.menuitemListenerMap.put(c, mia);
    }

    public boolean isOpaque() {
        return false;
    }

    boolean isAncestor(JMenu target, JMenu parent) {
        JComponent possibleParent = this.menuParentMap.get(target);
        return parent == possibleParent;
    }

    JComponent getMenuParent(JComponent menu) {
        return this.menuParentMap.get(menu);
    }

    private void setSelectedComponent(JComponent c) {
        this.requestFocusInWindow(false);
        try {
            RADVisualComponent rad;
            if (this.selectedComponent != null) {
                this.selectedComponent.setBorder(UNSELECTED_BORDER);
            }
            this.selectedComponent = c;
            if (c == null) {
                return;
            }
            this.selectedRADComponent = rad = (RADVisualComponent)this.formDesigner.getMetaComponent(c);
            this.formDesigner.setSelectedComponent(rad);
            this.selectedComponent.setBorder(SELECTED_BORDER);
            if (this.selectedComponent instanceof JMenu) {
                JMenu menu = (JMenu)this.selectedComponent;
                this.showMenuPopup(menu);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean canHighlightContainer(RADVisualContainer targetContainer, RADVisualComponent tcomp) {
        Class beanclass = tcomp.getBeanClass();
        return targetContainer != null && targetContainer.isMenuComponent() && targetContainer.canAddComponent(beanclass);
    }

    public void rolloverContainer(RADVisualContainer targetContainer) {
        if (targetContainer == null && this.prevRollover != null) {
            this.clearRollover();
        }
        if (targetContainer != null) {
            JComponent rollover = (JComponent)this.formDesigner.getComponent(targetContainer);
            if (rollover != this.prevRollover) {
                this.clearRollover();
            }
            this.prevRollover = rollover;
            this.prevRollover.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
            this.prevRollover.repaint();
            if (rollover instanceof JMenu) {
                this.formDesigner.openMenu(targetContainer);
            }
        }
    }

    public void clearRollover() {
        if (this.prevRollover == null) {
            return;
        }
        this.prevRollover.setBorder(BorderFactory.createEmptyBorder());
        this.prevRollover.repaint();
        this.prevRollover = null;
    }

    private void registerForm(final RADVisualContainer metacomp, final JMenu menu) {
        if (!this.formModelListeners.containsKey(metacomp)) {
            FormModelListener fml = new FormModelListener(){

                public void formChanged(FormModelEvent[] events) {
                    for (FormModelEvent evt : events) {
                        MenuEditLayer.p("event = " + evt);
                        MenuEditLayer.p("type = " + evt.getChangeType());
                        MenuEditLayer.p("prop changed = " + 10);
                        MenuEditLayer.p("comp added = " + 7);
                        MenuEditLayer.p("comp removed = " + 8);
                        MenuEditLayer.p("comp reordered = " + 9);
                        if (evt.getComponent() != null) {
                            MenuEditLayer.p(" " + evt.getComponent().getName());
                        }
                        if (evt.getChangeType() == 10) {
                            MenuEditLayer.this.rebuildOnScreenMenu(metacomp);
                        }
                        if (evt.getChangeType() == 8 && evt.getComponent() == metacomp) {
                            MenuEditLayer.p("this component was removed");
                            MenuEditLayer.this.unconfigureMenu(menu);
                            continue;
                        }
                        if (evt.getChangeType() != 7) {
                            if (evt.getChangeType() != 9) {
                                if (evt.getChangeType() != 8) continue;
                            }
                        }
                        if (evt.getContainer() != metacomp) continue;
                        MenuEditLayer.this.rebuildOnScreenMenu(metacomp);
                    }
                }
            };
            this.formModelListeners.put(metacomp, fml);
            metacomp.getFormModel().addFormModelListener(fml);
        }
    }

    private void rebuildOnScreenMenu(RADVisualContainer menuRAD) {
        MenuEditLayer.p("rebuild called");
        JMenu menu = (JMenu)this.formDesigner.getComponent(menuRAD);
        if (this.hackedPopupFactory.containerMap.containsKey(menu)) {
            JPanel popupContainer = this.hackedPopupFactory.containerMap.get(menu);
            popupContainer.removeAll();
            for (Component c : popupContainer.getComponents()) {
                if (c instanceof JMenu) {
                    this.unconfigureMenu((JMenu)c);
                    continue;
                }
                this.unconfigureMenuItem((JComponent)c);
            }
            for (RADVisualComponent child : menuRAD.getSubComponents()) {
                JComponent jchild = (JComponent)this.formDesigner.getComponent(child);
                MenuEditLayer.p("checking: " + jchild);
                if (!this.isConfigured(jchild)) {
                    MenuEditLayer.p("not configured!");
                    if (jchild instanceof JMenu) {
                        this.configureMenu(menu, (JMenu)jchild);
                    } else {
                        this.configureMenuItem(menu, jchild);
                    }
                }
                popupContainer.add(jchild);
            }
            popupContainer.setSize(popupContainer.getLayout().preferredLayoutSize(popupContainer));
            this.validate();
            popupContainer.repaint();
        } else {
            MenuEditLayer.p("menu popup not built yet");
        }
    }

    private void registerKeyListeners() {
        this.requestFocusInWindow(false);
        if (this.keyListener == null) {
            this.keyListener = new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        MenuEditLayer.this.selectOffsetMenuItem(1);
                    }
                    if (e.getKeyCode() == 38) {
                        MenuEditLayer.this.selectOffsetMenuItem(-1);
                    }
                    if (e.getKeyCode() == 37) {
                        MenuEditLayer.this.selectOffsetMenu(-1);
                    }
                    if (e.getKeyCode() == 39) {
                        MenuEditLayer.this.selectOffsetMenu(1);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            };
            this.addKeyListener(this.keyListener);
        }
    }

    private void selectOffsetMenuItem(int offset) {
        int index;
        if (this.currentMenuRAD.getSubComponents().length == 0) {
            this.setSelectedComponent(null);
            return;
        }
        if (this.selectedRADComponent == null) {
            this.selectedRADComponent = this.currentMenuRAD.getSubComponent(0);
        }
        this.selectedRADComponent = (index = this.currentMenuRAD.getIndexOf(this.selectedRADComponent)) + offset >= 0 && index + offset < this.currentMenuRAD.getSubComponents().length ? this.currentMenuRAD.getSubComponent(index + offset) : this.currentMenuRAD.getSubComponent(index);
        JComponent item = (JComponent)this.formDesigner.getComponent(this.selectedRADComponent);
        this.setSelectedComponent(item);
    }

    private void selectOffsetMenu(int offset) {
        this.setSelectedComponent(null);
        if (this.formDesigner.getComponent(this.selectedRADComponent) instanceof JMenu) {
            this.showMenuPopup((JMenu)this.formDesigner.getComponent(this.selectedRADComponent));
            this.currentMenuRAD = (RADVisualContainer)this.selectedRADComponent;
            RADVisualComponent firstItemRad = this.currentMenuRAD.getSubComponent(0);
            if (firstItemRad != null) {
                this.setSelectedComponent((JComponent)this.formDesigner.getComponent(firstItemRad));
            }
            return;
        }
        int index = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
        if (index < 0) {
            if (offset < 0) {
                this.setSelectedComponent((JComponent)this.formDesigner.getComponent(this.currentMenuRAD));
                this.currentMenuRAD = this.currentMenuRAD.getParentContainer();
                return;
            }
            if (offset > 0) {
                this.currentMenuRAD = this.getTopLevelMenu(this.currentMenuRAD);
                index = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
            }
        }
        if ((index += offset) < 0) {
            index = this.menuBarRAD.getSubComponents().length - 1;
        }
        if (index >= this.menuBarRAD.getSubComponents().length) {
            index = 0;
        }
        this.currentMenuRAD = (RADVisualContainer)this.menuBarRAD.getSubComponent(index);
        JMenu menu = (JMenu)this.formDesigner.getComponent(this.currentMenuRAD);
        this.openMenu(this.currentMenuRAD, menu);
        if (this.currentMenuRAD.getSubComponents().length > 0) {
            this.selectedRADComponent = this.currentMenuRAD.getSubComponents()[0];
            this.setSelectedComponent((JComponent)this.formDesigner.getComponent(this.selectedRADComponent));
        }
    }

    private static void p(String string) {
    }

    private RADVisualContainer getTopLevelMenu(RADVisualContainer currentMenuRAD) {
        if (this.menuBarRAD.getIndexOf(currentMenuRAD) >= 0) {
            return currentMenuRAD;
        }
        return this.getTopLevelMenu(currentMenuRAD.getParentContainer());
    }

    public static boolean containsMenuTypeComponent(RADVisualComponent[] comps) {
        if (comps == null) {
            return false;
        }
        if (comps.length < 1) {
            return false;
        }
        for (RADVisualComponent c : comps) {
            if (JMenuItem.class.isAssignableFrom(c.getBeanClass())) {
                return true;
            }
            if (JMenuBar.class.isAssignableFrom(c.getBeanClass())) {
                return true;
            }
            if (!JMenu.class.isAssignableFrom(c.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMenuContainer(RADVisualContainer cont) {
        if (cont == null) {
            return false;
        }
        if (JMenuBar.class.isAssignableFrom(cont.getBeanClass())) {
            return true;
        }
        return JMenu.class.isAssignableFrom(cont.getBeanClass());
    }

    private class MenuItemMouseHandler
    extends MouseInputAdapter {
        private JComponent c;
        private boolean isEditing = false;
        private Point start;
        private boolean started = false;
        private JComponent dragComponent = null;
        private JComponent targetComponent = null;
        private JComponent payloadComponent = null;

        public MenuItemMouseHandler(JComponent c) {
            this.c = c;
        }

        public void mousePressed(MouseEvent e) {
            this.started = false;
            if (this.started || e.isPopupTrigger()) {
                // empty if block
            }
            if (e.getClickCount() > 1 && this.c instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)this.c;
                RADComponent radcomp = MenuEditLayer.this.formDesigner.getMetaComponent(item);
                this.isEditing = true;
                MenuEditLayer.this.formDesigner.startInPlaceEditing(radcomp);
            }
            this.start = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.isEditing) {
                MenuEditLayer.this.setSelectedComponent(this.c);
            }
            this.isEditing = false;
            if (this.started) {
                this.finishDragOperation(e);
            }
            this.started = false;
            this.start = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.started) {
                this.updateDragOperation(e);
                return;
            }
            if (e.getPoint().distance(this.start) > 10.0) {
                this.started = true;
                JComponent comp = (JComponent)e.getSource();
                this.startDragOperation(this.start, comp);
                return;
            }
        }

        private void startDragOperation(Point pt, JComponent comp) {
            pt = SwingUtilities.convertPoint(comp, pt, MenuEditLayer.this);
            Component child = SwingUtilities.getDeepestComponentAt(MenuEditLayer.this.layers, pt.x, pt.y);
            MenuEditLayer.p("payload = " + child);
            if (child instanceof JMenuItem) {
                this.payloadComponent = (JComponent)child;
                JMenuItem payload = (JMenuItem)child;
                JMenuItem item = new JMenuItem();
                item.setText(payload.getText());
                item.setIcon(payload.getIcon());
                item.setBorder(DRAG_MENU_BORDER);
                item.setMargin(new Insets(1, 1, 1, 1));
                item.setBorderPainted(true);
                this.dragComponent = item;
                this.dragComponent.setSize(this.dragComponent.getPreferredSize());
                this.dragComponent.setLocation(pt);
                MenuEditLayer.this.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
                MenuEditLayer.this.repaint();
            } else {
                this.started = false;
            }
        }

        private void updateDragOperation(MouseEvent e) {
            Point pt = SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), MenuEditLayer.this);
            Component child = SwingUtilities.getDeepestComponentAt(MenuEditLayer.this.layers, pt.x, pt.y);
            MenuEditLayer.p("child = " + child);
            if (child instanceof JMenuItem && child != this.payloadComponent && child != this.dragComponent) {
                if (this.targetComponent != null) {
                    this.targetComponent.setBorder(UNSELECTED_BORDER);
                }
                this.targetComponent = (JComponent)child;
                if (this.targetComponent != null) {
                    this.targetComponent.setBorder(INSERTION_BORDER);
                }
                MenuEditLayer.this.repaint();
            }
            pt.translate(5, 5);
            this.dragComponent.setLocation(pt);
            MenuEditLayer.this.repaint();
        }

        private void finishDragOperation(MouseEvent e) {
            this.moveRadComponentToBefore(this.payloadComponent, this.targetComponent);
            MenuEditLayer.this.layers.remove(this.dragComponent);
            if (this.targetComponent != null) {
                this.targetComponent.setBorder(UNSELECTED_BORDER);
            }
            this.dragComponent = null;
        }

        private void moveRadComponentToBefore(JComponent payload, JComponent target) {
            try {
                if (payload == target) {
                    MenuEditLayer.p("can't move onto self");
                    return;
                }
                JComponent payloadParent = MenuEditLayer.this.getMenuParent(payload);
                MenuEditLayer.p("payload parent = " + payloadParent);
                JComponent targetParent = MenuEditLayer.this.getMenuParent(target);
                MenuEditLayer.p("target parent = " + targetParent);
                RADVisualComponent payloadRad = (RADVisualComponent)MenuEditLayer.this.formDesigner.getMetaComponent(payload);
                MenuEditLayer.p("payload rad = " + payloadRad);
                RADVisualComponent targetRad = (RADVisualComponent)MenuEditLayer.this.formDesigner.getMetaComponent(target);
                MenuEditLayer.p("target rad = " + targetRad);
                RADVisualContainer payloadParentRad = (RADVisualContainer)MenuEditLayer.this.formDesigner.getMetaComponent(payloadParent);
                MenuEditLayer.p("payload parent rad = " + payloadParentRad);
                RADVisualContainer targetParentRad = (RADVisualContainer)MenuEditLayer.this.formDesigner.getMetaComponent(targetParent);
                MenuEditLayer.p("target parent rad = " + targetParentRad);
                MenuEditLayer.p("=== removing ===");
                int index = payloadParentRad.getIndexOf(payloadRad);
                payloadParentRad.remove(payloadRad);
                FormModelEvent fme = MenuEditLayer.this.formDesigner.getFormModel().fireComponentRemoved(payloadRad, payloadParentRad, index, false);
                MenuEditLayer.p("=== inserting ===");
                if (targetParentRad != null) {
                    int index2 = targetParentRad.getIndexOf(targetRad);
                    targetParentRad.add(payloadRad, index2);
                    targetParentRad.getLayoutSupport().addComponents(new RADVisualComponent[]{payloadRad}, null, index2);
                    FormModelEvent fme2 = MenuEditLayer.this.formDesigner.getFormModel().fireComponentAdded(payloadRad, false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

