/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

class ChooseProjectWizardPanel
implements WizardDescriptor.Panel {
    private JFileChooser projectChooser;
    private static String lastDirectoryUsed;
    private EventListenerList listenerList;

    ChooseProjectWizardPanel() {
    }

    public Component getComponent() {
        if (this.projectChooser == null) {
            this.projectChooser = ProjectChooser.projectChooser();
            this.projectChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.projectChooser.setName(PaletteUtils.getBundleString("CTL_SelectProject_Caption"));
            this.projectChooser.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            if (lastDirectoryUsed != null) {
                this.projectChooser.setCurrentDirectory(new File(lastDirectoryUsed));
            }
            this.projectChooser.setControlButtonsAreShown(false);
            this.projectChooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    String propName = ev.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(propName) || "directoryChanged".equals(propName)) {
                        ChooseProjectWizardPanel.this.fireStateChanged();
                    }
                }
            });
        }
        return this.projectChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        File file;
        if (this.projectChooser != null && (file = this.projectChooser.getSelectedFile()) != null) {
            file = FileUtil.normalizeFile((File)file);
            FileObject projectDir = FileUtil.toFileObject((File)file);
            try {
                Project project = ProjectManager.getDefault().findProject(projectDir);
                if (project != null) {
                    lastDirectoryUsed = this.projectChooser.getCurrentDirectory().getAbsolutePath();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        if (this.projectChooser == null) {
            return;
        }
        File file = this.projectChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        file = FileUtil.normalizeFile((File)file);
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (project == null) {
            return;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        for (int i = 0; i < artifacts.length; ++i) {
            URI scriptLocation = artifacts[i].getScriptLocation().toURI();
            URI[] artifactLocations = artifacts[i].getArtifactLocations();
            for (int j = 0; j < artifactLocations.length; ++j) {
                File outputFile = new File(scriptLocation.resolve(artifactLocations[j]).normalize());
                fileList.add(outputFile);
            }
        }
        File[] outputFiles = new File[fileList.size()];
        fileList.toArray(outputFiles);
        ((AddToPaletteWizard)((Object)settings)).setJARFiles(outputFiles);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

