/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.palette.FormPaletteActions;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class PaletteUtils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    private static FileObject context;
    private static Map<Project, ProjectPaletteInfo> palettes;

    private PaletteUtils() {
    }

    static String getItemComponentDescription(PaletteItem item) {
        ClassSource classSource = item.getComponentClassSource();
        if (classSource == null || classSource.getCPRootCount() == 0) {
            String className = classSource.getClassName();
            if (className != null) {
                if (className.startsWith("javax.") || className.startsWith("java.")) {
                    return PaletteUtils.getBundleString("MSG_StandardJDKComponent");
                }
                if (className.startsWith("org.netbeans.")) {
                    return PaletteUtils.getBundleString("MSG_NetBeansComponent");
                }
            }
        } else {
            String type = classSource.getCPRootType(0);
            String name = classSource.getCPRootName(0);
            if ("jar".equals(type)) {
                return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromJar"), name);
            }
            if ("library".equals(type)) {
                Library lib = LibraryManager.getDefault().getLibrary(name);
                return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromLibrary"), lib != null ? lib.getDisplayName() : name);
            }
            if ("project".equals(type)) {
                try {
                    Project project = FileOwnerQuery.getOwner((URI)new File(name).toURI());
                    return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromProject"), project == null ? name : FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return PaletteUtils.getBundleString("MSG_UnspecifiedComponent");
    }

    public static FileObject getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            paletteFolder = Repository.getDefault().getDefaultFileSystem().findResource("FormDesignerPalette");
            if (paletteFolder == null) {
                paletteFolder = Repository.getDefault().getDefaultFileSystem().getRoot().createFolder("FormDesignerPalette");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Palette folder not found and cannot be created.");
        }
        return paletteFolder;
    }

    public static Node getPaletteNode() {
        return PaletteUtils.getPaletteDataFolder().getNodeDelegate();
    }

    public static void showPaletteManager() {
        try {
            PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)new FormPaletteActions(), (PaletteFilter)new ClassPathFilter(null), null).showCustomizer();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public static void setContext(FileObject fileInProject) {
        context = fileInProject;
    }

    public static synchronized void addPaletteListener(PropertyChangeListener listener, FileObject context) {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        if (pInfo != null) {
            if (pInfo.paletteListeners == null) {
                pInfo.paletteListeners = new LinkedList<PropertyChangeListener>();
            }
            pInfo.paletteListeners.add(listener);
            pInfo.getPalette().addPropertyChangeListener(listener);
        }
    }

    public static synchronized void removePaletteListener(PropertyChangeListener listener, FileObject context) {
        ProjectPaletteInfo pInfo;
        Project project = FileOwnerQuery.getOwner((FileObject)context);
        if (project != null && (pInfo = palettes.get(project)) != null && pInfo.paletteListeners != null) {
            pInfo.paletteListeners.remove(listener);
            pInfo.getPalette().removePropertyChangeListener(listener);
        }
    }

    public static Lookup getPaletteLookup(FileObject context) {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        return pInfo != null ? pInfo.paletteLookup : Lookups.fixed((Object[])new Object[0]);
    }

    private static PaletteController getPalette() {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        return pInfo != null ? pInfo.getPalette() : null;
    }

    private static ClassPathFilter getPaletteFilter() {
        ProjectPaletteInfo pInfo;
        Project project;
        if (context != null && (project = FileOwnerQuery.getOwner((FileObject)context)) != null && (pInfo = palettes.get(project)) != null) {
            return pInfo.paletteFilter;
        }
        return null;
    }

    private static ProjectPaletteInfo preparePalette(FileObject context) {
        if (context == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)context);
        if (project == null) {
            return null;
        }
        ProjectPaletteInfo pInfo = palettes.get(project);
        if (pInfo == null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)context, (String)"classpath/boot");
            classPath.addPropertyChangeListener((PropertyChangeListener)new ClassPathListener(classPath, project));
            PaletteLookup lookup = new PaletteLookup();
            ClassPathFilter filter = new ClassPathFilter(classPath);
            lookup.setPalette(PaletteUtils.createPalette(filter));
            pInfo = new ProjectPaletteInfo();
            pInfo.paletteLookup = lookup;
            pInfo.paletteFilter = filter;
            palettes.put(project, pInfo);
        }
        return pInfo;
    }

    private static PaletteController createPalette(ClassPathFilter filter) {
        try {
            return PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)new FormPaletteActions(), (PaletteFilter)filter, null);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    private static synchronized void bootClassPathChanged(Project p, ClassPath cp) {
        ProjectPaletteInfo pInfo = palettes.get(p);
        if (pInfo != null) {
            PaletteLookup lookup = pInfo.paletteLookup;
            PaletteController oldPalette = pInfo.getPalette();
            oldPalette.clearSelection();
            ClassPathFilter newFilter = new ClassPathFilter(cp);
            PaletteController newPalette = PaletteUtils.createPalette(newFilter);
            if (pInfo.paletteListeners != null) {
                for (PropertyChangeListener l : pInfo.paletteListeners) {
                    oldPalette.removePropertyChangeListener(l);
                    newPalette.addPropertyChangeListener(l);
                }
            }
            lookup.setPalette(newPalette);
            pInfo.paletteFilter = newFilter;
        }
    }

    static DataFolder getPaletteDataFolder() {
        if (paletteDataFolder == null) {
            paletteDataFolder = DataFolder.findFolder((FileObject)PaletteUtils.getPaletteFolder());
        }
        return paletteDataFolder;
    }

    public static void clearPaletteSelection() {
        PaletteUtils.getPalette().clearSelection();
    }

    public static PaletteItem getSelectedItem() {
        PaletteController palette = PaletteUtils.getPalette();
        if (palette == null) {
            return null;
        }
        Lookup lkp = palette.getSelectedItem();
        return (PaletteItem)lkp.lookup(PaletteItem.class);
    }

    public static void selectItem(PaletteItem item) {
        if (null == item) {
            PaletteUtils.getPalette().clearSelection();
        } else {
            Node paletteNode = (Node)PaletteUtils.getPalette().getRoot().lookup(Node.class);
            Node[] categories = PaletteUtils.getCategoryNodes(paletteNode, true, true, true);
            for (int i = 0; i < categories.length; ++i) {
                Node[] items = PaletteUtils.getItemNodes(categories[i], true);
                for (int j = 0; j < items.length; ++j) {
                    PaletteItem formItem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                    if (!item.equals(formItem)) continue;
                    PaletteUtils.getPalette().setSelectedItem(categories[i].getLookup(), items[j].getLookup());
                }
            }
        }
    }

    public static PaletteItem[] getAllItems() {
        HashSet<PaletteItem> uniqueItems = null;
        Node[] categories = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false, true, false);
        for (int i = 0; i < categories.length; ++i) {
            Node[] items = PaletteUtils.getItemNodes(categories[i], true);
            for (int j = 0; j < items.length; ++j) {
                PaletteItem formItem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                if (null == formItem) continue;
                if (null == uniqueItems) {
                    uniqueItems = new HashSet<PaletteItem>();
                }
                uniqueItems.add(formItem);
            }
        }
        PaletteItem[] res = null != uniqueItems ? uniqueItems.toArray(new PaletteItem[uniqueItems.size()]) : new PaletteItem[]{};
        return res;
    }

    static String getBundleString(String key) {
        return NbBundle.getBundle(PaletteUtils.class).getString(key);
    }

    public static Node[] getItemNodes(Node categoryNode, boolean mustBeValid) {
        Node[] nodes = categoryNode.getChildren().getNodes(true);
        if (!mustBeValid) {
            return nodes;
        }
        ClassPathFilter filter = PaletteUtils.getPaletteFilter();
        if (filter == null) {
            return nodes;
        }
        ArrayList<Node> validList = null;
        for (int i = 0; i < nodes.length; ++i) {
            PaletteItem item = (PaletteItem)nodes[i].getCookie(PaletteItem.class);
            if (filter.isValidItem(item)) {
                if (validList == null) continue;
                validList.add(nodes[i]);
                continue;
            }
            if (validList != null) continue;
            validList = new ArrayList<Node>(nodes.length);
            for (int j = 0; j < i; ++j) {
                validList.add(nodes[j]);
            }
        }
        if (validList != null) {
            nodes = validList.toArray(new Node[validList.size()]);
        }
        return nodes;
    }

    public static Node[] getCategoryNodes(Node paletteNode, boolean mustBeVisible) {
        return PaletteUtils.getCategoryNodes(paletteNode, mustBeVisible, mustBeVisible, true);
    }

    private static Node[] getCategoryNodes(Node paletteNode, boolean mustBeVisible, boolean mustBeValid, boolean mustBePaletteCategory) {
        if (mustBeVisible) {
            mustBePaletteCategory = true;
            mustBeValid = true;
        }
        Node[] nodes = paletteNode.getChildren().getNodes(true);
        ClassPathFilter filter = mustBeValid ? PaletteUtils.getPaletteFilter() : null;
        ArrayList<Node> list = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!(mustBeVisible && !PaletteUtils.isVisibleCategoryNode(nodes[i]) || mustBeValid && filter != null && !filter.isValidCategory(nodes[i]) || mustBePaletteCategory && !PaletteUtils.representsShowableCategory(nodes[i]))) {
                if (list == null) continue;
                list.add(nodes[i]);
                continue;
            }
            if (list != null) continue;
            list = new ArrayList<Node>(nodes.length);
            for (int j = 0; j < i; ++j) {
                list.add(nodes[j]);
            }
        }
        if (list != null) {
            nodes = new Node[list.size()];
            list.toArray(nodes);
        }
        return nodes;
    }

    private static boolean isVisibleCategoryNode(Node node) {
        DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
        if (df != null) {
            Object value = node.getValue("psa_isVisible");
            if (null == value || "null".equals(value)) {
                value = df.getPrimaryFile().getAttribute("isVisible");
            }
            if (value == null) {
                value = Boolean.TRUE;
            }
            return Boolean.valueOf(value.toString());
        }
        return false;
    }

    private static boolean representsShowableCategory(Node node) {
        DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
        return df != null && !Boolean.TRUE.equals(df.getPrimaryFile().getAttribute("isNoPaletteCategory"));
    }

    static {
        palettes = new WeakHashMap<Project, ProjectPaletteInfo>();
    }

    private static class ClassPathFilter
    extends PaletteFilter {
        private ClassPath classPath;
        private Set<PaletteItem> validItems;
        private Set<PaletteItem> invalidItems;

        ClassPathFilter(ClassPath cp) {
            if (cp != null) {
                this.validItems = new WeakSet();
                this.invalidItems = new WeakSet();
            }
            this.classPath = cp;
        }

        public boolean isValidCategory(Lookup lkp) {
            Node categoryNode = (Node)lkp.lookup(Node.class);
            if (!PaletteUtils.representsShowableCategory(categoryNode)) {
                return false;
            }
            return this.isValidCategory(categoryNode);
        }

        boolean isValidCategory(Node node) {
            if (this.classPath == null) {
                return true;
            }
            DataFolder folder = (DataFolder)node.getCookie(DataFolder.class);
            if (folder == null) {
                return false;
            }
            DataObject[] dobjs = folder.getChildren();
            for (int i = 0; i < dobjs.length; ++i) {
                PaletteItem item = (PaletteItem)dobjs[i].getCookie(PaletteItem.class);
                if (item != null && !this.isValidItem(item)) continue;
                return true;
            }
            return dobjs.length == 0;
        }

        public boolean isValidItem(Lookup lkp) {
            return this.isValidItem((PaletteItem)lkp.lookup(PaletteItem.class));
        }

        boolean isValidItem(PaletteItem item) {
            if (this.classPath == null) {
                return true;
            }
            if (item == null) {
                return false;
            }
            if (item.getComponentClassSource().getCPRootCount() > 0 || "chooseBean".equals(item.getExplicitComponentType()) || "org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport".equals(item.getComponentClassName())) {
                return true;
            }
            if (this.validItems.contains(item)) {
                return true;
            }
            if (this.invalidItems.contains(item)) {
                return false;
            }
            String resName = item.getComponentClassName().replace('.', '/').concat(".class");
            if (this.classPath.findResource(resName) != null) {
                this.validItems.add(item);
                return true;
            }
            this.invalidItems.add(item);
            return false;
        }
    }

    private static class ClassPathListener
    implements PropertyChangeListener {
        private ClassPath classPath;
        private WeakReference projRef;

        ClassPathListener(ClassPath cp, Project p) {
            this.classPath = cp;
            this.projRef = new WeakReference<Project>(p);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("roots".equals(evt.getPropertyName())) {
                Project p = (Project)this.projRef.get();
                if (p != null) {
                    PaletteUtils.bootClassPathChanged(p, this.classPath);
                } else {
                    this.classPath.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    private static class PaletteLookup
    extends AbstractLookup {
        private InstanceContent content;

        PaletteLookup() {
            this(new InstanceContent());
        }

        private PaletteLookup(InstanceContent content) {
            super((AbstractLookup.Content)content);
            this.content = content;
        }

        void setPalette(PaletteController palette) {
            this.content.set(Arrays.asList(palette), null);
        }
    }

    private static class ProjectPaletteInfo {
        PaletteLookup paletteLookup;
        ClassPathFilter paletteFilter;
        List<PropertyChangeListener> paletteListeners;

        private ProjectPaletteInfo() {
        }

        PaletteController getPalette() {
            return (PaletteController)this.paletteLookup.lookup(PaletteController.class);
        }
    }
}

