/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.InputStream;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;

class ProjectClassLoader
extends ClassLoader {
    private ClassLoader projectClassLoaderDelegate;
    private ClassPath sources;
    private ClassLoader systemClassLoader;

    private ProjectClassLoader(ClassLoader projectClassLoaderDelegate, ClassPath sources) {
        this.projectClassLoaderDelegate = projectClassLoaderDelegate;
        this.sources = sources;
        this.systemClassLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    }

    static ClassLoader getUpToDateClassLoader(FileObject fileInProject, ClassLoader clSoFar) {
        ClassLoader actualCL;
        ClassLoader existingCL = clSoFar instanceof ProjectClassLoader ? ((ProjectClassLoader)clSoFar).projectClassLoaderDelegate : clSoFar;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        ClassLoader classLoader = actualCL = classPath != null ? classPath.getClassLoader(true) : null;
        if (actualCL == existingCL) {
            return clSoFar;
        }
        if (actualCL == null) {
            return null;
        }
        return new ProjectClassLoader(actualCL, ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source"));
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.apache.commons.logging.")) {
            try {
                return this.systemClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfex) {
                // empty catch block
            }
        }
        Class<?> c = null;
        String filename = name.replace('.', '/').concat(".class");
        URL url = this.projectClassLoaderDelegate.getResource(filename);
        if (url != null) {
            try {
                String packageName;
                Package pakcage;
                int first;
                InputStream is = url.openStream();
                byte[] data = null;
                int available = is.available();
                while ((first = is.read()) != -1) {
                    int count;
                    int read;
                    int length = is.available();
                    if (length != available) {
                        ++length;
                    }
                    byte[] b = new byte[length];
                    b[0] = (byte)first;
                    for (count = 1; count < length; count += read) {
                        read = is.read(b, count, length - count);
                        assert (read != -1);
                    }
                    if (data == null) {
                        data = b;
                        continue;
                    }
                    byte[] temp = new byte[data.length + count];
                    System.arraycopy(data, 0, temp, 0, data.length);
                    System.arraycopy(b, 0, temp, data.length, count);
                    data = temp;
                }
                int dot = name.lastIndexOf(46);
                if (dot != -1 && (pakcage = this.getPackage(packageName = name.substring(0, dot))) == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                c = this.defineClass(name, data, 0, data.length);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        } else if (ClassPathUtils.getClassLoadingType(name) == 1) {
            c = this.systemClassLoader.loadClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    protected URL findResource(String name) {
        FileObject fo = this.sources.findResource(name);
        if (fo != null) {
            try {
                return fo.getURL();
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return this.projectClassLoaderDelegate.getResource(name);
    }
}

