/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.wizard;

import java.awt.Dialog;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel1;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel2;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel3;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class ConnectionWizard
extends WizardDescriptor {
    ConnectionIterator iterator;
    private boolean finished = false;
    private Event selEvent;
    private String eventName;
    private int actionType;
    private Method targetMethod;
    private String paramsText;
    private Object[] paramValues;

    public ConnectionWizard(FormModel model, RADComponent source, RADComponent target) {
        this(model, source, target, new ConnectionIterator(model, source, target));
    }

    private ConnectionWizard(FormModel model, RADComponent source, RADComponent target, ConnectionIterator it) {
        super((WizardDescriptor.Iterator)it);
        this.iterator = it;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getBundle(ConnectionWizard.class).getString("CTL_CW_Title"));
        MessageFormat format = new MessageFormat("{0}");
        this.setTitleFormat(format);
    }

    public boolean show() {
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        this.finished = false;
        d.setVisible(true);
        boolean bl = this.finished = this.getValue() == FINISH_OPTION;
        if (this.finished) {
            this.selEvent = this.iterator.panel1.getSelectedEvent();
            this.eventName = this.iterator.panel1.getEventName();
            this.actionType = this.iterator.panel2.getActionType();
            this.targetMethod = this.iterator.getMethodFromPanel2();
            this.paramsText = this.iterator.anyParameters() ? this.iterator.panel3.getParametersText() : null;
            this.paramValues = this.iterator.anyParameters() ? this.iterator.panel3.getParameters() : null;
        }
        d.dispose();
        return this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public RADComponent getSource() {
        return this.iterator.source;
    }

    public RADComponent getTarget() {
        return this.iterator.target;
    }

    public FormModel getFormModel() {
        return this.iterator.formModel;
    }

    public Event getSelectedEvent() {
        return this.finished ? this.selEvent : null;
    }

    public String getEventName() {
        return this.finished ? this.eventName : null;
    }

    public String getGeneratedCode() {
        if (!this.finished || this.actionType == 2) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        HashSet allExceptions = new HashSet();
        if (this.paramValues != null) {
            for (int i = 0; i < this.paramValues.length; ++i) {
                RADConnectionPropertyEditor.RADConnectionDesignValue val;
                if (!(this.paramValues[i] instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || (val = (RADConnectionPropertyEditor.RADConnectionDesignValue)this.paramValues[i]).getType() != 1) continue;
                Class<?>[] except = val.getMethod().getMethod().getExceptionTypes();
                for (int j = 0; j < except.length; ++j) {
                    allExceptions.add(except[j]);
                }
            }
        }
        Class<?>[] methodExceptions = this.targetMethod.getExceptionTypes();
        for (int k = 0; k < methodExceptions.length; ++k) {
            allExceptions.add(methodExceptions[k]);
        }
        if (allExceptions.size() > 0) {
            buf.append("try {\n  ");
        }
        if (this.getTarget() != this.getFormModel().getTopRADComponent()) {
            buf.append(this.getTarget().getName());
            buf.append(".");
        }
        buf.append(this.targetMethod.getName());
        buf.append("(");
        if (this.paramsText != null) {
            buf.append(this.paramsText);
        }
        buf.append(");\n");
        int varCount = 1;
        for (Class clazz : allExceptions) {
            buf.append("} catch (");
            buf.append(clazz.getName());
            buf.append(" ");
            String excName = "e" + varCount;
            ++varCount;
            buf.append(excName);
            buf.append(") {\n");
            buf.append("  " + excName);
            buf.append(".printStackTrace();\n");
        }
        if (!allExceptions.isEmpty()) {
            buf.append("}\n");
        }
        return buf.toString();
    }

    protected void updateState() {
        super.updateState();
        ResourceBundle bundle = NbBundle.getBundle(ConnectionWizard.class);
        if (this.iterator.getPanelsCount() > 2) {
            this.putProperty("WizardPanel_contentData", new String[]{bundle.getString("CTL_CW_Step1_Title"), bundle.getString("CTL_CW_Step2_Title"), bundle.getString("CTL_CW_Step3_Title")});
        } else {
            this.putProperty("WizardPanel_contentData", new String[]{bundle.getString("CTL_CW_Step1_Title"), bundle.getString("CTL_CW_Step2_Title")});
        }
    }

    static class ConnectionIterator
    implements WizardDescriptor.Iterator,
    ChangeListener {
        FormModel formModel;
        RADComponent source;
        RADComponent target;
        ConnectionWizardPanel1 panel1;
        ConnectionWizardPanel2 panel2;
        ConnectionWizardPanel3 panel3;
        WizardDescriptor.Panel[] panels;
        boolean panel2Changed = false;
        int stage;
        private EventListenerList listenerList = null;

        ConnectionIterator(FormModel model, RADComponent source, RADComponent target) {
            this.formModel = model;
            this.source = source;
            this.target = target;
            this.stage = 1;
            this.panel1 = new ConnectionWizardPanel1(source);
            this.panel2 = new ConnectionWizardPanel2(target);
            this.panel2.addChangeListener(this);
            this.panel3 = new ConnectionWizardPanel3(this.formModel);
            this.panels = new WizardDescriptor.Panel[]{this.panel1, this.panel2, this.panel3};
        }

        public int getPanelsCount() {
            return this.anyParameters() ? 3 : 2;
        }

        public WizardDescriptor.Panel current() {
            return this.panels[this.stage - 1];
        }

        public boolean hasNext() {
            return this.stage < this.getPanelsCount();
        }

        public boolean hasPrevious() {
            return this.stage > 1;
        }

        public String name() {
            return "";
        }

        public void nextPanel() {
            if (this.stage < this.getPanelsCount()) {
                if (this.stage == 1 && this.panel1.handlerAlreadyExists() && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getBundle(ConnectionWizard.class).getString("MSG_RewritingEvent"), 2, 2)) == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                ++this.stage;
                if (this.stage == 3 && this.panel2Changed) {
                    Method method = this.getMethodFromPanel2();
                    if (method != null) {
                        this.panel3.setMethod(method);
                    }
                    this.panel2Changed = false;
                }
            }
        }

        public void previousPanel() {
            if (this.stage > 1) {
                --this.stage;
            }
        }

        public void addChangeListener(ChangeListener listener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, listener);
            }
        }

        public void stateChanged(ChangeEvent p1) {
            if (this.stage == 2) {
                this.panel2Changed = true;
            }
        }

        private Method getMethodFromPanel2() {
            PropertyDescriptor desc;
            Method method = null;
            if (this.panel2.getActionType() == 0) {
                MethodDescriptor desc2 = this.panel2.getSelectedMethod();
                if (desc2 != null) {
                    method = desc2.getMethod();
                }
            } else if (this.panel2.getActionType() == 1 && (desc = this.panel2.getSelectedProperty()) != null) {
                method = desc.getWriteMethod();
            }
            return method;
        }

        private boolean anyParameters() {
            Method m = this.getMethodFromPanel2();
            return m != null && m.getParameterTypes().length > 0;
        }
    }
}

