/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.border.Border;

public class FakeDropShadowBorder
implements Border {
    private static final int WIDTH = 17;
    private static final int HEIGHT = 17;
    public static final int ARC = 12;
    private final Color xpar = new Color(255, 255, 255, 0);
    private static final String upLeft = "upLeft.png";
    private static final String downRight = "downRight.png";
    private static final String downLeft = "upRight.png";
    private static final String upRight = "downLeft.png";
    private static final String bottom = "bottom.png";
    private static final String leftEdge = "leftEdge.png";
    private static final String rightEdge = "rightEdge.png";
    private static final String top = "top.png";
    private static Map<String, BufferedImage> imgs = new HashMap<String, BufferedImage>();

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 13, 25, 13);
    }

    public void fillBackground(Component c, Graphics2D gg, int x, int y, int w, int h) {
        Shape clip = gg.getClip();
        gg.setColor(Color.WHITE);
        Insets ins = this.getBorderInsets(c);
        int bottom = h - ins.bottom + 6;
        int bottomOffCurve = bottom - 20;
        int top = ins.top + 3;
        int left = ins.left - 2;
        int shoulderTop = top + 16;
        int shoulderTopOffCurve = shoulderTop + 9;
        int rightOffCurve = x + w - 34;
        int right = rightOffCurve + 24;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(left, bottomOffCurve);
        gp.lineTo(left, shoulderTopOffCurve);
        gp.curveTo(left, shoulderTop, left + 6, shoulderTop, left + 8, shoulderTop + 1);
        gp.curveTo(left + 11, top, left + 19, top + 1, left + 25, top);
        gp.lineTo(rightOffCurve, top);
        gp.curveTo(rightOffCurve + 6, top, rightOffCurve + 17, top + 5, rightOffCurve + 16, shoulderTop);
        gp.curveTo(right - 4, shoulderTop + 1, right, shoulderTop, right, shoulderTop + 9);
        gp.lineTo(right, bottomOffCurve);
        gp.curveTo(right + 1, bottom, right - 1, bottom + 1, right - 12, bottom);
        gp.lineTo(left + 14, bottom);
        gp.curveTo(left + 1, bottom, left - 1, bottom, left, bottomOffCurve);
        gp.closePath();
        gg.fill(gp);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics2D gg = (Graphics2D)g;
        this.fillBackground(c, gg, x, y, w, h);
        BufferedImage b = FakeDropShadowBorder.getImage(upLeft);
        int yoff = b.getHeight();
        int topL = b.getWidth();
        this.draw(gg, b, x, y);
        b = FakeDropShadowBorder.getImage(downRight);
        this.draw(gg, b, x + w - b.getWidth(), y + h - b.getHeight());
        int woff = b.getWidth();
        b = FakeDropShadowBorder.getImage(upRight);
        this.draw(gg, b, x + w - b.getWidth(), y);
        int topR = b.getWidth();
        b = FakeDropShadowBorder.getImage(downLeft);
        int hoff = b.getHeight();
        int xoff = b.getWidth();
        this.draw(gg, b, x, y + h - b.getHeight());
        b = FakeDropShadowBorder.getImage(leftEdge);
        this.tileVertical(x, y, yoff, hoff, h, b, gg);
        b = FakeDropShadowBorder.getImage(rightEdge);
        this.tileVertical(x + w - b.getWidth(), y, yoff, hoff, h, b, gg);
        b = FakeDropShadowBorder.getImage(bottom);
        this.tileHorizontal(x, y + h - (b.getHeight() + 0), xoff, woff, w, b, gg);
        b = FakeDropShadowBorder.getImage(top);
        this.tileHorizontal(x, y, xoff, woff, w, b, gg);
    }

    private void draw(Graphics2D g, BufferedImage b, int x, int y) {
        g.setColor(this.xpar);
        g.fillRect(x, y, b.getWidth(), b.getHeight());
        g.drawRenderedImage(b, AffineTransform.getTranslateInstance(x, y));
    }

    private void tileVertical(int x, int y, int yoff, int hoff, int h, BufferedImage img, Graphics2D g) {
        int times = (h -= hoff + yoff) / img.getHeight();
        int rem = h % img.getHeight();
        y += yoff;
        for (int i = 0; i < times; ++i) {
            g.drawRenderedImage(img, AffineTransform.getTranslateInstance(x, y));
            y += img.getHeight();
        }
        if (rem > 0) {
            img = img.getSubimage(0, 0, img.getWidth(), rem);
            g.drawRenderedImage(img, AffineTransform.getTranslateInstance(x, y));
        }
    }

    private void tileHorizontal(int x, int y, int xoff, int woff, int w, BufferedImage img, Graphics2D g) {
        int times = (w -= woff + xoff) / img.getWidth();
        int rem = w % img.getWidth();
        x += xoff;
        for (int i = 0; i < times; ++i) {
            this.draw(g, img, x, y);
            x += img.getWidth();
        }
        if (rem > 0) {
            img = img.getSubimage(0, 0, rem, img.getHeight());
            this.draw(g, img, x, y);
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private static BufferedImage getImage(String s) {
        BufferedImage result = imgs.get(s);
        if (result == null) {
            Exception e1 = null;
            try {
                result = ImageIO.read(FakeDropShadowBorder.class.getResourceAsStream(s));
            }
            catch (Exception e) {
                result = new BufferedImage(1, 1, 2);
                e1 = e;
            }
            imgs.put(s, result);
            if (e1 != null) {
                throw new IllegalStateException(e1);
            }
        }
        return result;
    }
}

