/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.netbeans.swing.plaf.aqua.AquaToolBarButtonUI;
import org.netbeans.swing.plaf.util.UIUtils;

public class PlainAquaToolbarUI
extends BasicToolBarUI
implements ContainerListener {
    private static final AquaTbBorder aquaborder = new AquaTbBorder();
    private static final Color UPPER_GRADIENT_TOP = new Color(255, 255, 255);
    private static final Color UPPER_GRADIENT_BOTTOM = new Color(228, 230, 232);
    private static final Color LOWER_GRADIENT_TOP = new Color(228, 227, 215);
    private static final Color LOWER_GRADIENT_BOTTOM = new Color(249, 249, 249);
    private static Map<Integer, BufferedImage> icache = new HashMap<Integer, BufferedImage>();
    private static final ButtonUI buttonui = new AquaToolBarButtonUI();
    static int arcsize = 13;

    public static ComponentUI createUI(JComponent c) {
        return new PlainAquaToolbarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        UIManager.put("Nb.Editor.Toolbar.border", aquaborder);
        c.setBorder(aquaborder);
        c.setOpaque(true);
        c.addContainerListener(this);
        this.installButtonUIs(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
        c.removeContainerListener(this);
    }

    private BufferedImage getCacheImage(JComponent c) {
        BufferedImage img = icache.get(new Integer(c.getHeight()));
        if (img == null && c.getWidth() > arcsize * 2 + 24 && c.getHeight() > 12) {
            img = new BufferedImage(c.getWidth(), c.getHeight(), 3);
            this.paintInto(img.getGraphics(), c);
            icache.put(c.getHeight(), img);
        }
        return img;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        if (!c.isOpaque() || c.getWidth() < 4 || c.getHeight() < 4) {
            return;
        }
        BufferedImage img = this.getCacheImage(c);
        if (img == null) {
            this.paintInto(g, c);
        } else {
            this.paintImage((Graphics2D)g, img, c);
        }
    }

    private void paintImage(Graphics2D g2d, BufferedImage img, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        int imgw = img.getWidth();
        AffineTransform nullTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        if (w == imgw) {
            g2d.drawRenderedImage(img, nullTransform);
        } else if (w > imgw) {
            BufferedImage mid;
            g2d.drawRenderedImage(img, nullTransform);
            int uncovered = w - (imgw - arcsize * 2);
            int x = imgw - arcsize;
            do {
                mid = img.getSubimage(arcsize, 0, Math.min(uncovered, imgw - arcsize * 2), h);
                g2d.drawRenderedImage(mid, AffineTransform.getTranslateInstance(x, 0.0));
                uncovered -= mid.getWidth();
            } while ((x += mid.getWidth()) < w - arcsize);
            BufferedImage rightEdge = img.getSubimage(imgw - arcsize, 0, arcsize, h);
            g2d.drawRenderedImage(rightEdge, AffineTransform.getTranslateInstance(w - arcsize, 0.0));
        } else if (w < imgw) {
            BufferedImage left = img.getSubimage(0, 0, imgw - arcsize, h);
            g2d.drawRenderedImage(left, nullTransform);
            BufferedImage right = img.getSubimage(imgw - arcsize, 0, arcsize, h);
            g2d.drawRenderedImage(right, AffineTransform.getTranslateInstance(w - arcsize, 0.0));
        }
    }

    private void paintInto(Graphics g, JComponent c) {
        UIUtils.configureRenderingHints(g);
        Color temp = g.getColor();
        Dimension size = c.getSize();
        Shape s = aquaborder.getInteriorShape(size.width, size.height);
        Shape clip = g.getClip();
        if (clip != null) {
            Area a = new Area(clip);
            a.intersect(new Area(s));
            g.setClip(a);
        } else {
            g.setClip(s);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(aquaborder.getUpperPaint(size.width, size.height));
        g2d.fill(aquaborder.getUpperBevelShape(size.width, size.height));
        g2d.setPaint(aquaborder.getLowerPaint(size.width, size.height));
        g2d.fill(aquaborder.getLowerBevelShape(size.width, size.height));
        g.setClip(clip);
        g.setColor(temp);
    }

    protected Border createRolloverBorder() {
        return BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    protected Border createNonRolloverBorder() {
        return this.createRolloverBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return this.createRolloverBorder();
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setBorderPainted(false);
            ((AbstractButton)c).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)c).setOpaque(false);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setBorderPainted(false);
            ((AbstractButton)c).setOpaque(false);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    public void setFloating(boolean b, Point p) {
    }

    private void installButtonUI(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setUI(buttonui);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    private void installButtonUIs(Container parent) {
        Component[] c = parent.getComponents();
        for (int i = 0; i < c.length; ++i) {
            this.installButtonUI(c[i]);
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.installButtonUI(e.getChild());
        Container c = (Container)e.getSource();
        if ("editorToolbar".equals(c.getName())) {
            Dimension min = new Dimension(32, 34);
            ((JComponent)e.getContainer()).setPreferredSize(min);
        }
    }

    public void componentRemoved(ContainerEvent e) {
    }

    private static final boolean isFinderLook(Component c) {
        return Boolean.getBoolean("apple.awt.brushMetalLook");
    }

    private static Color mezi(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    static class AquaTbBorder
    implements Border {
        AquaTbBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 4, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            UIUtils.configureRenderingHints(g);
            boolean finderLook = PlainAquaToolbarUI.isFinderLook(c);
            Color col = finderLook ? PlainAquaToolbarUI.mezi(UIManager.getColor("controlShadow"), UIManager.getColor("control")) : UIManager.getColor("controlShadow");
            g.setColor(col);
            int ytop = y;
            this.drawUpper(g, x, y, ytop, w, h);
            g.setColor(PlainAquaToolbarUI.mezi(col, UIManager.getColor("control")));
            if (finderLook) {
                this.drawUpper(g, x + 1, y, ytop + 1, w - 2, h - 1);
            }
            if (finderLook) {
                col = PlainAquaToolbarUI.mezi(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
                this.drawLower(g, x, y, w, h, col, finderLook);
            } else {
                this.drawLower(g, x, y - 1, w, h, col, finderLook);
                g.setColor(new Color(200, 200, 200));
                g.drawLine(x + arcsize / 2 - 3, y + h - 1, x + w - arcsize / 2, y + h - 1);
            }
        }

        private void drawLower(Graphics g, int x, int y, int w, int h, Color col, boolean finderLook) {
            g.setColor(col);
            g.drawLine(x, y + arcsize / 2, x, y + h - arcsize / 2);
            g.drawLine(x + w - 1, y + arcsize / 2, x + w - 1, y + h - arcsize / 2);
            if (!finderLook) {
                g.setColor(new Color(220, 220, 220));
                g.drawArc(x - 1, y + 1 + h - arcsize, arcsize, arcsize, 180, 90);
                g.drawArc(x + 1 + w - (arcsize + 1), y + 1 + h - (arcsize + 1), arcsize, arcsize, 270, 90);
                g.setColor(col);
            }
            g.drawArc(x, y + h - arcsize, arcsize, arcsize, 180, 90);
            g.drawArc(x + w - (arcsize + 1), y + h - (arcsize + 1), arcsize, arcsize, 270, 90);
            if (!finderLook) {
                g.setColor(new Color(80, 80, 80));
            }
            g.drawLine(x + arcsize / 2 - 3, y + h - 1, x + w - arcsize / 2, y + h - 1);
        }

        private void drawUpper(Graphics g, int x, int y, int ytop, int w, int h) {
            g.drawArc(x, ytop, arcsize, arcsize, 90, 90);
            g.drawArc(x + w - (arcsize + 1), ytop, arcsize, arcsize, 90, -90);
            g.drawLine(x + arcsize / 2, ytop, x + w - arcsize / 2, ytop);
        }

        Paint getUpperPaint(Color top, Color bottom, int w, int h) {
            GradientPaint result = UIUtils.getGradientPaint(0.0f, h / 4, top, 0.0f, h / 2 + h / 4, bottom, false);
            return result;
        }

        Paint getLowerPaint(Color top, Color bottom, int w, int h) {
            GradientPaint result = UIUtils.getGradientPaint(0.0f, h / 2, top, 0.0f, h / 2 + h / 4, bottom, false);
            return result;
        }

        Paint getUpperPaint(int w, int h) {
            return this.getUpperPaint(UPPER_GRADIENT_TOP, UPPER_GRADIENT_BOTTOM, w, h);
        }

        Paint getLowerPaint(int w, int h) {
            return this.getLowerPaint(LOWER_GRADIENT_TOP, LOWER_GRADIENT_BOTTOM, w, h);
        }

        Shape getInteriorShape(int w, int h) {
            RoundRectangle2D.Double r2d = new RoundRectangle2D.Double(0.0, 0.0, w, h, arcsize, arcsize);
            return r2d;
        }

        Shape getUpperBevelShape(int w, int h) {
            int[] xpoints = new int[]{0, 0, h / 2, w - h / 4, w, w, 0};
            int[] ypoints = new int[]{0, h - h / 4, h / 2, h / 2, h / 4, 0, 0};
            Polygon p = new Polygon(xpoints, ypoints, ypoints.length);
            return p;
        }

        Shape getLowerBevelShape(int w, int h) {
            int[] xpoints = new int[]{0, 0, h / 4, w - h / 4, w, w, 0};
            int[] ypoints = new int[]{h, h - h / 4, h / 2, h / 2, h / 4, h, h};
            Polygon p = new Polygon(xpoints, ypoints, ypoints.length);
            return p;
        }
    }
}

