/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtils {
    private static HashMap<RenderingHints.Key, Object> hintsMap = null;
    private static final boolean noAntialias = Boolean.getBoolean("nb.no.antialias");
    private static boolean colorsReady = false;
    private static Boolean openideAvailable = null;
    private static Class<?> utilsClass = null;
    private static Method utilsMethod = null;

    private UIUtils() {
    }

    public static boolean isWindowsLF() {
        if (Boolean.getBoolean("netbeans.winsys.forceclassic")) {
            return false;
        }
        String lfID = UIManager.getLookAndFeel().getID();
        return lfID.endsWith("Windows");
    }

    public static boolean isXPLF() {
        if (!UIUtils.isWindowsLF()) {
            return false;
        }
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    private static final Map<RenderingHints.Key, Object> getHints() {
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public static final void configureRenderingHints(Graphics g) {
        if (noAntialias) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(UIUtils.getHints());
    }

    public static Image loadImage(String s) {
        if (openideAvailable == null) {
            UIUtils.checkOpenide();
        }
        if (Boolean.TRUE.equals(openideAvailable)) {
            return UIUtils.loadWithUtilities(s);
        }
        return UIUtils.loadWithImageIO(s);
    }

    public static Color getMiddle(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    private static void checkOpenide() {
        try {
            utilsClass = Class.forName("org.openide.util.Utilities");
            utilsMethod = utilsClass.getDeclaredMethod("loadImage", String.class);
            openideAvailable = Boolean.TRUE;
        }
        catch (Exception e) {
            openideAvailable = Boolean.FALSE;
        }
    }

    private static Image loadWithUtilities(String s) {
        Image result = null;
        try {
            result = (Image)utilsMethod.invoke(null, s);
        }
        catch (Exception e) {
            System.err.println("Error loading image " + s);
            e.printStackTrace();
        }
        return result;
    }

    private static Image loadWithImageIO(String s) {
        BufferedImage result = null;
        try {
            URL url = UIUtils.class.getResource(s);
            result = ImageIO.read(url);
        }
        catch (Exception e) {
            System.err.println("Error loading image using ImageIO " + s);
            e.printStackTrace();
        }
        return result;
    }

    public static GradientPaint getGradientPaint(float x1, float y1, Color upper, float x2, float y2, Color lower, boolean repeats) {
        return new GradientPaint(x1, y1, upper, x2, y2, lower, repeats);
    }

    public static Color adjustColor(Color c, int rDiff, int gDiff, int bDiff) {
        int red = Math.max(0, Math.min(255, c.getRed() + rDiff));
        int green = Math.max(0, Math.min(255, c.getGreen() + gDiff));
        int blue = Math.max(0, Math.min(255, c.getBlue() + bDiff));
        return new Color(red, green, blue);
    }

    private static float minMax(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    public static boolean isBrighter(Color a, Color b) {
        int[] ac = new int[]{a.getRed(), a.getGreen(), a.getBlue()};
        int[] bc = new int[]{b.getRed(), b.getGreen(), b.getBlue()};
        int dif = 0;
        for (int i = 0; i < 3; ++i) {
            int currDif = ac[i] - bc[i];
            if (Math.abs(currDif) <= Math.abs(dif)) continue;
            dif = currDif;
        }
        return dif > 0;
    }
}

