/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.EmbeddableRoot;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.AbstractNamedComponentReference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentComponent<C extends DocumentComponent<C>>
extends AbstractComponent<C>
implements DocumentComponent<C>,
DocumentModelAccess.NodeUpdater {
    private Element node;

    @Override
    protected abstract void populateChildren(List<C> var1);

    public AbstractDocumentComponent(AbstractDocumentModel model, Element e) {
        super(model);
        this.setRef(e);
    }

    private void setRef(Element n) {
        assert (n != null) : "n must not be null";
        this.node = n;
    }

    @Override
    public synchronized Element getPeer() {
        return this.node;
    }

    @Override
    public String getAttribute(Attribute attr) {
        return this.normalizeUndefinedAttributeValue(this.getPeer().getAttribute(attr.getName()));
    }

    @Override
    public void setAttribute(String eventPropertyName, Attribute attr, Object value) {
        this.verifyWrite();
        Object old = null;
        String s = this.getAttribute(attr);
        if (s != null) {
            try {
                old = this.getAttributeValueOf(attr, s);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        this.setAttributeQuietly(attr, value);
        this.firePropertyChange(eventPropertyName, old, value);
        this.fireValueChanged();
    }

    protected abstract Object getAttributeValueOf(Attribute var1, String var2);

    public String getAnyAttribute(QName attr) {
        assert (attr != null);
        String name = attr.getLocalPart();
        String namespace = attr.getNamespaceURI();
        String prefix = namespace == null ? null : this.lookupPrefix(namespace);
        String attrName = prefix == null ? name : prefix + ":" + name;
        return this.normalizeUndefinedAttributeValue(this.getPeer().getAttribute(attrName));
    }

    private String normalizeUndefinedAttributeValue(String value) {
        String normalizedValue = value;
        if (this.getModel() != null) {
            normalizedValue = this.getAccess().normalizeUndefinedAttributeValue(value);
        }
        return normalizedValue;
    }

    public void setAnyAttribute(QName attr, String value) {
        this.setQNameAttribute(attr.getLocalPart(), attr, value);
    }

    protected void setQNameAttribute(String propertyName, QName attr, String value) {
        assert (attr != null);
        this.verifyWrite();
        String name = this.getPrefixedName(attr, value != null);
        String old = this.getAnyAttribute(attr);
        if (value == null) {
            this.removeAttribute(this.getPeer(), name);
        } else {
            this.setAttribute(this.getPeer(), name, value);
        }
        this.firePropertyChange(propertyName, old, value);
        this.fireValueChanged();
    }

    protected String getPrefixedName(QName q, boolean declarePrefix) {
        String name = q.getLocalPart();
        String namespace = q.getNamespaceURI();
        String prefix = q.getPrefix();
        return this.getPrefixedName(namespace, name, prefix, declarePrefix);
    }

    protected String getPrefixedName(String namespace, String localName) {
        return this.getPrefixedName(namespace, localName, null, false);
    }

    protected String getPrefixedName(String namespace, String name, String prefix, boolean declarePrefix) {
        String localNS;
        if (namespace == null || namespace.length() == 0) {
            declarePrefix = false;
        }
        String existingPrefix = this.lookupPrefix(namespace);
        AbstractDocumentComponent root = (AbstractDocumentComponent)this.getModel().getRootComponent();
        if (existingPrefix == null) {
            existingPrefix = root.lookupPrefix(namespace);
        }
        if (existingPrefix != null && (localNS = this.lookupNamespaceURI(existingPrefix)) != null && !localNS.equals(namespace)) {
            existingPrefix = null;
        }
        if (existingPrefix != null) {
            prefix = existingPrefix;
        } else if (declarePrefix) {
            if (prefix == null) {
                prefix = "ns";
            }
            if (prefix.length() > 0) {
                prefix = root.ensureUnique(prefix, namespace);
            }
            if (this.isInDocumentModel()) {
                root.addPrefix(prefix, namespace);
            } else {
                this.addPrefix(prefix, namespace);
            }
        }
        if (prefix != null && prefix.length() > 0) {
            name = prefix + ":" + name;
        }
        return name;
    }

    protected String ensureUnique(String prefix, String namespace) {
        assert (namespace != null);
        int count = 0;
        String prefixN = prefix;
        String existing = this.lookupNamespaceURI(prefixN);
        while (existing != null && count < 100 && !existing.equals(namespace)) {
            prefixN = prefix + ++count;
            existing = this.lookupNamespaceURI(prefix + count);
        }
        if (count >= 100) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to generate unique prefix for " + namespace);
        }
        return prefixN;
    }

    protected void setAttributeQuietly(Attribute type, Object newVal) {
        if (newVal == null) {
            this.removeAttribute(this.node, type.getName());
        } else {
            String stringValue = newVal.toString();
            if (newVal instanceof NamedComponentReference) {
                NamedComponentReference ref = (NamedComponentReference)newVal;
                QName q = ref.getQName();
                stringValue = this.getPrefixedName(q.getNamespaceURI(), q.getLocalPart(), null, true);
                if (this.getEffectiveParent() == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Referencing while not in tree yet could result in unwanted prefix declaration");
                }
                ((AbstractNamedComponentReference)ref).refresh();
            }
            this.setAttribute(this.node, type.getName(), stringValue);
        }
    }

    protected void removeAttributeQuietly(Element element, String name) {
        this.getAccess().removeAttribute(element, name, this);
    }

    @Override
    protected void appendChildQuietly(C component, List<C> children) {
        this.fixupPrefix(component);
        this.getAccess().appendChild(this.getPeer(), component.getPeer(), this);
        children.add(component);
    }

    @Override
    protected void insertAtIndexQuietly(C newComponent, List<C> children, int index) {
        if (index >= 0 && children.size() > 0 && index < children.size()) {
            this.fixupPrefix(newComponent);
            Element refChild = ((DocumentComponent)children.get(index)).getPeer();
            this.insertBefore(newComponent.getPeer(), refChild);
            children.add(index, newComponent);
        } else {
            this.appendChildQuietly(newComponent, children);
        }
    }

    @Override
    protected void removeChildQuietly(C component, List<C> children) {
        this.removeChild(component.getPeer());
        children.remove(component);
    }

    protected String getNamespaceURI() {
        String ns = this.getPeer().getNamespaceURI();
        if (ns == null && this.getEffectiveParent() != null) {
            String prefix = this.getPeer().getPrefix();
            ns = this.lookupNamespaceURI(prefix);
        }
        return ns;
    }

    public String lookupNamespaceURI(String prefix, boolean optimized) {
        if (optimized) {
            String namespace = this.getPrefixes().get(prefix == null ? "" : prefix);
            if (namespace == null && this.getEffectiveParent() != null) {
                namespace = this.getEffectiveParent().lookupNamespaceURI(prefix, true);
            }
            return namespace;
        }
        return this.lookupNamespaceURI(prefix);
    }

    public String lookupNamespaceURI(String prefix) {
        String ns = this.getPeer().lookupNamespaceURI(prefix);
        if (ns == null && this.getEffectiveParent() != null) {
            ns = this.getEffectiveParent().lookupNamespaceURI(prefix);
        }
        return ns;
    }

    public String lookupPrefix(String namespace) {
        String prefix = this.getPeer().lookupPrefix(namespace);
        if (prefix == null && this.getEffectiveParent() != null) {
            prefix = this.getEffectiveParent().lookupPrefix(namespace);
        }
        return prefix;
    }

    protected String getXmlFragment() {
        return this.getAccess().getXmlFragment(this.getPeer());
    }

    public String getXmlFragmentInclusive() {
        return this.getModel().getAccess().getXmlFragmentInclusive(this.getPeer());
    }

    protected synchronized void setXmlFragment(String propertyName, String text) throws IOException {
        this.verifyWrite();
        String oldVal = this.getText();
        this.getAccess().setXmlFragment(this.getPeer(), text, this);
        this.firePropertyChange(propertyName, oldVal, text);
        this.fireValueChanged();
    }

    protected synchronized void setText(String propertyName, String text) {
        this.verifyWrite();
        String oldVal = this.getText();
        this.getAccess().setText(this.getPeer(), text, this);
        this.firePropertyChange(propertyName, oldVal, text);
        this.fireValueChanged();
    }

    protected String getText() {
        return AbstractDocumentComponent.getText(this.getPeer());
    }

    public static String getText(Element e) {
        StringBuilder text = new StringBuilder();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            text.append(n.getNodeValue());
        }
        return text.toString();
    }

    @Override
    public AbstractDocumentModel getModel() {
        return (AbstractDocumentModel)super.getModel();
    }

    @Override
    public boolean referencesSameNode(Node n) {
        return this.getModel().areSameNodes(this.getPeer(), n);
    }

    @Override
    public synchronized void updateReference(Element element) {
        this.node = element;
    }

    public synchronized <N extends Node> void updateReference(List<N> pathToRoot) {
        AbstractDocumentComponent current = this;
        assert (pathToRoot != null && pathToRoot.size() > 0);
        for (int i = 0; i < pathToRoot.size(); ++i) {
            assert (pathToRoot.get(i) instanceof Element);
            Element e = (Element)pathToRoot.get(i);
            if (current.referencesSameNode(e)) {
                current.updateReference(e, pathToRoot);
                if (current.getEffectiveParent() == null) break;
                current = current.getEffectiveParent();
                continue;
            }
            if (i != pathToRoot.size() - 1) continue;
            throw new IllegalArgumentException("Expect new reference node has same Id as current");
        }
    }

    protected <N extends Node> void updateReference(Element peer, List<N> updatingPath) {
        this.updateReference(peer);
    }

    protected DocumentModelAccess getAccess() {
        this.getChildren();
        return this.getModel().getAccess();
    }

    @Override
    public int findPosition() {
        if (this.getModel() == null) {
            return 0;
        }
        return this.getAccess().findPosition(this.getPeer());
    }

    private void removeAttribute(Element element, String name) {
        this.getAccess().removeAttribute(element, name, this);
    }

    private void setAttribute(Element element, String name, String value) {
        this.getAccess().setAttribute(element, name, value, this);
    }

    private void insertBefore(Node newChild, Node refChild) {
        this.getAccess().insertBefore(this.node, newChild, refChild, this);
    }

    private void removeChild(Node child) {
        this.getAccess().removeChild(this.node, child, this);
    }

    protected void updatePeer(String propertyName, Element newPeer) {
        AbstractDocumentComponent aParent = this.getEffectiveParent();
        Element parentPeer = aParent.getPeer();
        Element oldPeer = this.getPeer();
        this.getAccess().replaceChild(parentPeer, this.getPeer(), newPeer, aParent);
        this.updateReference(newPeer);
        this.firePropertyChange(propertyName, oldPeer, newPeer);
        this.fireValueChanged();
    }

    protected Attribute createPrefixAttribute(String prefix) {
        assert (prefix != null);
        if (prefix.length() == 0) {
            return new PrefixAttribute("xmlns");
        }
        return new PrefixAttribute("xmlns:" + prefix);
    }

    public void addPrefix(String prefix, String namespace) {
        Attribute a = this.createPrefixAttribute(prefix);
        this.setAttribute(a.getName(), a, (Object)namespace);
    }

    public void removePrefix(String prefix) {
        this.setAttribute(prefix, this.createPrefixAttribute(prefix), null);
    }

    public Map<String, String> getPrefixes() {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        NamedNodeMap nodes = this.getPeer().getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            String name = n.getLocalName();
            String prefix = n.getPrefix();
            String xmlns = "xmlns";
            if (!"xmlns".equals(name) && !"xmlns".equals(prefix)) continue;
            String ns = n.getNodeValue();
            prefixes.put(name, ns);
        }
        String defaultNamespace = (String)prefixes.remove("xmlns");
        if (defaultNamespace != null) {
            prefixes.put("", defaultNamespace);
        }
        return prefixes;
    }

    private void fixupPrefix(C newComponent) {
        if (this.getModel().inSync()) {
            return;
        }
        AbstractDocumentComponent child = (AbstractDocumentComponent)newComponent;
        Element e = child.getPeer();
        String childNS = child.getNamespaceURI();
        if (childNS == null || childNS.equals("")) {
            return;
        }
        if (childNS.equals(this.getNamespaceURI())) {
            e.setPrefix(this.getPeer().getPrefix());
        } else if (childNS.equals(this.lookupNamespaceURI(""))) {
            e.setPrefix(null);
        } else {
            this.ensurePrefixDeclaredFor(e, childNS);
        }
        for (DocumentComponent c : newComponent.getChildren()) {
            this.fixupPrefix(c);
        }
    }

    private void ensurePrefixDeclaredFor(Element newComponentElement, String newComponentNS) {
        String existingPrefix = this.lookupPrefix(newComponentNS);
        String prefix = newComponentElement.getPrefix();
        if (existingPrefix == null) {
            if (prefix == null) {
                prefix = "ns";
            }
            prefix = this.ensureUnique(prefix, newComponentNS);
            ((AbstractDocumentComponent)this.getModel().getRootComponent()).addPrefix(prefix, newComponentNS);
            newComponentElement.setPrefix(prefix);
        } else {
            newComponentElement.setPrefix(existingPrefix);
        }
    }

    protected void ensureValueNamespaceDeclared(String newNamespace, String oldNamespace, String preferredPrefix) {
        if (newNamespace == null) {
            return;
        }
        String prefix = null;
        if (oldNamespace != null) {
            prefix = this.lookupPrefix(oldNamespace);
        }
        if (prefix == null) {
            String tnsURI = this.lookupNamespaceURI(preferredPrefix);
            prefix = tnsURI == null ? preferredPrefix : this.ensureUnique(preferredPrefix, newNamespace);
            this.addPrefix(prefix, newNamespace);
        } else {
            this.removePrefix(prefix);
            this.addPrefix(prefix, newNamespace);
        }
    }

    @Override
    public C findChildComponent(Element e) {
        for (DocumentComponent c : this.getChildren()) {
            if (!c.referencesSameNode(e)) continue;
            return (C)c;
        }
        return null;
    }

    public C findChildComponentByIdentity(Element e) {
        ElementIdentity ei = this.getModel().getAccess().getElementIdentity();
        Document doc = this.getModel().getDocument();
        for (DocumentComponent c : this.getChildren()) {
            if (!ei.compareElement(c.getPeer(), e, doc, doc)) continue;
            return (C)c;
        }
        return null;
    }

    @Override
    public DocumentComponent copy(C parent) {
        if (this.getModel() == null) {
            throw new IllegalStateException("Cannot copy component already removed from model");
        }
        Element newPeer = this.getAccess().duplicate(this.getPeer());
        DocumentModel m = parent == null ? this.getModel() : (DocumentModel)parent.getModel();
        return m.createComponent(parent, newPeer);
    }

    @Override
    protected void verifyWrite() {
        if (this.getModel() == null) {
            throw new IllegalStateException("Cannot mutate a component already removed from model.");
        }
        if (this.isInDocumentModel()) {
            this.getModel().validateWrite();
        }
    }

    @Override
    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.isInDocumentModel()) {
            super.firePropertyChange(propName, oldValue, newValue);
        }
    }

    @Override
    protected void fireValueChanged() {
        if (this.isInDocumentModel()) {
            super.fireValueChanged();
        }
    }

    @Override
    protected void fireChildRemoved() {
        if (this.isInDocumentModel()) {
            super.fireChildRemoved();
        }
    }

    @Override
    protected void fireChildAdded() {
        if (this.isInDocumentModel()) {
            super.fireChildAdded();
        }
    }

    @Override
    public boolean isInDocumentModel() {
        if (this.getModel() == null) {
            return false;
        }
        AbstractDocumentComponent root = (AbstractDocumentComponent)this.getModel().getRootComponent();
        if (root == null) {
            return false;
        }
        if (root == this) {
            return true;
        }
        AbstractDocumentComponent myRoot = this.getEffectiveParent();
        if (myRoot == null) {
            return false;
        }
        while (myRoot != null && myRoot.getEffectiveParent() != null) {
            if (myRoot instanceof EmbeddableRoot) {
                root = (AbstractDocumentComponent)myRoot.getEffectiveParent().getModel().getRootComponent();
            }
            myRoot = myRoot.getEffectiveParent();
        }
        return root == myRoot;
    }

    @Override
    public int findAttributePosition(String attributeName) {
        Attr a = this.getPeer().getAttributeNode(attributeName);
        if (a != null) {
            return this.getAccess().findPosition(a);
        }
        return -1;
    }

    public QName getQName() {
        return AbstractDocumentComponent.getQName(this.getPeer());
    }

    public static QName getQName(Node n) {
        String namespace = n.getNamespaceURI();
        String localName = n.getLocalName();
        String prefix = n.getPrefix();
        assert (localName != null);
        if (namespace == null && prefix == null) {
            return new QName(localName);
        }
        if (namespace != null && prefix == null) {
            return new QName(namespace, localName);
        }
        return new QName(namespace, localName, prefix);
    }

    private ModelSource resolveModelSource(String location, ModelSource currentSource, CatalogModel currentCatalog) {
        ModelSource ms = null;
        try {
            if (location != null) {
                ms = currentCatalog.getModelSource(AbstractDocumentComponent.getURI(location), currentSource);
            }
        }
        catch (CatalogModelException nse) {
            Logger l = Logger.getLogger(AbstractDocumentComponent.class.getName());
            l.log(Level.FINE, nse.getMessage());
        }
        return ms;
    }

    protected ModelSource resolveModel(String hint) throws CatalogModelException {
        return this._resolveModel(hint, null);
    }

    private ModelSource _resolveModel(String hint, String backup) throws CatalogModelException {
        CatalogModel nr = (CatalogModel)this.getModel().getModelSource().getLookup().lookup(CatalogModel.class);
        ModelSource ms = this.resolveModelSource(hint, this.getModel().getModelSource(), nr);
        if (ms == null) {
            ms = this.resolveModelSource(backup, this.getModel().getModelSource(), nr);
        }
        if (ms == null) {
            String msg = "Cannot resolve file using hint = " + hint + " backup = " + backup;
            throw new CatalogModelException(msg);
        }
        return ms;
    }

    private static URI getURI(String s) throws CatalogModelException {
        try {
            return new URI(s);
        }
        catch (URISyntaxException ex) {
            throw new CatalogModelException(ex);
        }
    }

    public Map<QName, String> getAttributeMap() {
        return this.getModel().getAccess().getAttributeMap(this.getPeer());
    }

    protected int findDomainIndex(Element e) {
        if (!this.getModel().isDomainElement(e)) {
            return -1;
        }
        int domainInsertIndex = 0;
        NodeList nl = this.getPeer().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i) == e) {
                return domainInsertIndex;
            }
            if (!this.getModel().isDomainElement(nl.item(i))) continue;
            ++domainInsertIndex;
        }
        return -1;
    }

    protected AbstractDocumentComponent getEffectiveParent() {
        AbstractDocumentComponent p = (AbstractDocumentComponent)this.getParent();
        if (p == null && this instanceof EmbeddableRoot) {
            p = (AbstractDocumentComponent)((EmbeddableRoot)((Object)this)).getForeignParent();
        }
        return p;
    }

    protected Element getChildElement(QName qname) {
        NodeList nl = this.getPeer().getElementsByTagName(qname.getLocalPart());
        Element ret = null;
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!qname.equals(AbstractDocumentComponent.getQName(nl.item(i)))) continue;
                ret = (Element)nl.item(i);
                break;
            }
        }
        return ret;
    }

    protected String getChildElementText(QName qname) {
        Element ret = this.getChildElement(qname);
        return ret == null ? null : AbstractDocumentComponent.getText(ret);
    }

    protected void setChildElementText(String propertyName, String text, QName qname) {
        String oldVal;
        this.verifyWrite();
        Element childElement = this.getChildElement(qname);
        String string = oldVal = childElement == null ? null : AbstractDocumentComponent.getText(childElement);
        if (text == null) {
            if (childElement == null) {
                return;
            }
            this.removeChild(childElement);
            if (oldVal == null) {
                return;
            }
        } else if (text.length() == 0) {
            if (childElement != null) {
                this.removeChild(childElement);
            }
            childElement = this.getModel().getDocument().createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            this.getModel().getAccess().appendChild(this.getPeer(), childElement, this);
        } else {
            if (text.equals(oldVal)) {
                return;
            }
            if (childElement == null) {
                childElement = this.getModel().getDocument().createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
                this.getModel().getAccess().appendChild(this.getPeer(), childElement, this);
            }
            this.getModel().getAccess().setText(childElement, text, this);
        }
        this.firePropertyChange(propertyName, oldVal, text);
        this.fireValueChanged();
    }

    protected String getLeadingText(C child) {
        return this.getText(child, true, true);
    }

    protected void setLeadingText(String propName, String text, C child) {
        this.setText(propName, text, child, true, true);
    }

    protected String getTrailingText(C child) {
        return this.getText(child, false, true);
    }

    protected void setTrailingText(String propName, String text, C child) {
        this.setText(propName, text, child, false, true);
    }

    protected String getText(C child, boolean leading, boolean includeComments) {
        Node n;
        int i;
        int domIndex = this.getNodeIndexOf(this.getPeer(), child.getPeer());
        if (domIndex < 0) {
            throw new IllegalArgumentException("Child peer node is not part of children nodes");
        }
        StringBuilder value = null;
        NodeList nl = this.getPeer().getChildNodes();
        int n2 = i = leading ? domIndex - 1 : domIndex + 1;
        while (i > -1 && i < nl.getLength() && !((n = nl.item(i)) instanceof Element)) {
            if (n instanceof Text && (includeComments || n.getNodeType() != 8)) {
                if (value == null) {
                    value = new StringBuilder();
                }
                if (leading) {
                    value.insert(0, n.getNodeValue());
                } else {
                    value.append(n.getNodeValue());
                }
            }
            i = leading ? --i : ++i;
        }
        return value == null ? null : value.toString();
    }

    protected void setText(String propName, String value, C child, boolean leading, boolean includeComments) {
        int i;
        this.verifyWrite();
        StringBuilder oldValue = null;
        ArrayList<Node> toRemove = new ArrayList<Node>();
        NodeList nl = this.getPeer().getChildNodes();
        int domIndex = this.getNodeIndexOf(this.getPeer(), child.getPeer());
        if (domIndex < 0) {
            throw new IllegalArgumentException("Child peer node is not part of children nodes");
        }
        Element ref = leading ? child.getPeer() : null;
        int n = i = leading ? domIndex - 1 : domIndex + 1;
        while (i > -1 && i < nl.getLength()) {
            Node n2 = nl.item(i);
            if (n2 != null && n2.getNodeType() == 1) {
                if (leading) {
                    ref = child.getPeer();
                    break;
                }
                ref = (Element)n2;
                break;
            }
            if (n2 instanceof Text && (includeComments || n2.getNodeType() != 8)) {
                toRemove.add(n2);
                if (oldValue == null) {
                    oldValue = new StringBuilder();
                }
                if (leading) {
                    oldValue.insert(0, n2.getNodeValue());
                } else {
                    oldValue.append(n2.getNodeValue());
                }
            }
            i = leading ? --i : ++i;
        }
        this.getModel().getAccess().removeChildren(this.getPeer(), toRemove, this);
        if (value != null) {
            Text newNode = this.getModel().getDocument().createTextNode(value);
            if (ref != null) {
                this.getModel().getAccess().insertBefore(this.getPeer(), newNode, ref, this);
            } else {
                this.getModel().getAccess().appendChild(this.getPeer(), newNode, this);
            }
        }
        this.firePropertyChange(propName, oldValue == null ? null : oldValue.toString(), value);
        this.fireValueChanged();
    }

    protected int getNodeIndexOf(Node parent, Node child) {
        if (child == null) {
            return -1;
        }
        int nodeIndex = -1;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            Node n = parent.getChildNodes().item(i);
            ++nodeIndex;
            if (!this.getAccess().areSameNodes(n, child)) continue;
            return nodeIndex;
        }
        return -1;
    }

    public static class PrefixAttribute
    implements Attribute {
        private String prefix;

        public PrefixAttribute(String name) {
            this.prefix = name;
        }

        public Class getType() {
            return String.class;
        }

        public String getName() {
            return this.prefix;
        }

        public Class getMemberType() {
            return null;
        }
    }
}

