/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractReference;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedComponentReference<T extends NamedReferenceable>
extends AbstractReference<T>
implements NamedComponentReference<T> {
    protected String prefix;
    protected String localName;
    protected QName qname;

    public AbstractNamedComponentReference(T referenced, Class<T> referencedType, AbstractDocumentComponent parent) {
        super(referenced, referencedType, parent);
    }

    public AbstractNamedComponentReference(Class<T> referencedType, AbstractDocumentComponent parent, String ref) {
        super(referencedType, parent, ref);
        this.initReferenceString(ref);
    }

    @Override
    public boolean references(T target) {
        return target.getName() != null && target.getName().equals(this.getLocalName()) && !this.isBroken() && this.get() == target;
    }

    @Override
    public synchronized String getRefString() {
        if (this.refString == null) {
            assert (super.getReferenced() != null);
            this.prefix = this.getParent().lookupPrefix(this.getEffectiveNamespace());
            this.localName = ((NamedReferenceable)super.getReferenced()).getName();
            this.refString = this.prefix == null || this.prefix.length() == 0 ? this.localName : this.prefix + ":" + this.localName;
        }
        return this.refString;
    }

    private void initReferenceString(String ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Reference string null");
        }
        this.refString = ref;
        String[] parts = this.refString.split(":");
        if (parts.length == 2) {
            this.prefix = parts[0];
            this.localName = parts[1];
        } else {
            this.prefix = null;
            this.localName = parts[0];
        }
    }

    protected String getPrefix() {
        this.getRefString();
        return this.prefix;
    }

    protected String getLocalName() {
        this.getRefString();
        return this.localName;
    }

    @Override
    protected T getReferenced() {
        if (super.getReferenced() == null) {
            this.checkParentPartOfModel();
        } else {
            if (super.getParent().getModel() == null) {
                throw new IllegalStateException("Referencing component has been removed from model.");
            }
            if (((NamedReferenceable)super.getReferenced()).getModel() == null) {
                throw new IllegalStateException("Referenced component has been removed from model.");
            }
        }
        return (T)((NamedReferenceable)super.getReferenced());
    }

    @Override
    public synchronized QName getQName() {
        this.checkParentNotRemovedFromModel();
        if (this.qname == null) {
            if (super.getReferenced() == null) {
                this.qname = this.calculateQNameLocally();
            }
            if (this.qname == null && !this.isBroken()) {
                this.qname = new QName(this.getEffectiveNamespace(), ((NamedReferenceable)this.get()).getName());
            }
            if (this.qname == null) {
                return new QName("");
            }
        }
        return this.qname;
    }

    @Override
    protected AbstractDocumentComponent getParent() {
        return (AbstractDocumentComponent)super.getParent();
    }

    protected void checkParentPartOfModel() {
        if (!this.getParent().isInDocumentModel()) {
            throw new IllegalStateException("Referencing component is not part of model.");
        }
    }

    protected void checkParentNotRemovedFromModel() {
        if (this.getParent().getModel() == null) {
            throw new IllegalStateException("Referencing component has been removed from model.");
        }
    }

    protected QName calculateQNameLocally() {
        String temp;
        assert (this.localName != null);
        String namespace = null;
        namespace = this.getParent().lookupNamespaceURI(this.prefix);
        if (namespace == null && (temp = this.getParent().lookupPrefix(this.prefix)) != null) {
            namespace = this.prefix = temp;
        }
        if (this.prefix == null) {
            return new QName(namespace, this.localName);
        }
        return new QName(namespace, this.localName, this.prefix);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.getParent().equals(((AbstractNamedComponentReference)obj).getParent()) && this.getQName().equals(((AbstractNamedComponentReference)obj).getQName());
    }

    @Override
    public int hashCode() {
        return this.getParent().hashCode();
    }

    public synchronized void refresh() {
        this.getRefString();
        this.setReferenced(null);
    }
}

