/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.ModelAccess;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentModelAccess
extends ModelAccess {
    private long dirtyTimeMillis = 0L;

    public abstract org.w3c.dom.Document getDocumentRoot();

    public AbstractDocumentModel getModel() {
        return null;
    }

    public abstract boolean areSameNodes(Node var1, Node var2);

    public abstract int getElementIndexOf(Node var1, Element var2);

    public abstract void setAttribute(Element var1, String var2, String var3, NodeUpdater var4);

    public abstract void removeAttribute(Element var1, String var2, NodeUpdater var3);

    public abstract void appendChild(Node var1, Node var2, NodeUpdater var3);

    public abstract void insertBefore(Node var1, Node var2, Node var3, NodeUpdater var4);

    public abstract void removeChild(Node var1, Node var2, NodeUpdater var3);

    public void removeChildren(Node node, Collection<Node> children, NodeUpdater updater) {
        throw new UnsupportedOperationException();
    }

    public abstract void replaceChild(Node var1, Node var2, Node var3, NodeUpdater var4);

    public abstract void setText(Element var1, String var2, NodeUpdater var3);

    public abstract void setPrefix(Element var1, String var2);

    public abstract int findPosition(Node var1);

    public abstract Element getContainingElement(int var1);

    public abstract Element duplicate(Element var1);

    public void reorderChildren(Element element, int[] newIndexes, NodeUpdater updater) {
        throw new UnsupportedOperationException("Not support yet by this DocumentModelAccess");
    }

    public String getXmlFragmentInclusive(Element element) {
        if (this.getModel() == null) {
            throw new UnsupportedOperationException("Unavailable because access does not support getModel()");
        }
        DocumentComponent component = this.getModel().findComponent(element);
        if (component == null) {
            throw new IllegalArgumentException("Know nothing about '" + element.getTagName() + "'");
        }
        Node parent = component.getParent() == null ? this.getModel().getDocument() : ((DocumentComponent)component.getParent()).getPeer();
        int end = -1;
        int start = this.findPosition(element);
        assert (start > -1) : "Negative start position";
        try {
            Node next;
            Document doc = this.getModel().getBaseDocument();
            StringBuilder sb = new StringBuilder(doc.getText(0, doc.getLength() - 1));
            if (parent instanceof org.w3c.dom.Document) {
                assert (parent.getDocumentElement() == element);
                end = sb.lastIndexOf(">") + 1;
            } else if (next == null) {
                end = sb.indexOf(parent.getNodeName(), start) - 2;
            } else if (next instanceof Element) {
                end = this.findPosition(next);
            } else {
                for (next = element.getNextSibling(); !(next == null || next instanceof Element || next instanceof CDATASection || next instanceof ProcessingInstruction || next instanceof Comment); next = next.getNextSibling()) {
                }
                end = next instanceof Element ? this.findPosition(next) : (next instanceof CDATASection || next instanceof Comment || next instanceof ProcessingInstruction ? sb.indexOf(next.getNodeValue(), start) : sb.indexOf("</" + parent.getNodeName(), start));
            }
            String result = sb.substring(start, end);
            end = result.lastIndexOf("</" + element.getNodeName());
            end = end < 0 ? result.indexOf(">") + 1 : result.indexOf(">", end) + 1;
            return result.substring(0, end);
        }
        catch (BadLocationException ble) {
            assert (false) : "start=" + start + " end=" + end;
            return "";
        }
    }

    public abstract String getXmlFragment(Element var1);

    public abstract void setXmlFragment(Element var1, String var2, NodeUpdater var3) throws IOException;

    public abstract Map<QName, String> getAttributeMap(Element var1);

    public abstract List<Element> getPathFromRoot(org.w3c.dom.Document var1, Element var2);

    public abstract String getXPath(org.w3c.dom.Document var1, Element var2);

    public String normalizeUndefinedAttributeValue(String value) {
        return value;
    }

    public abstract Node findNode(org.w3c.dom.Document var1, String var2);

    public abstract List<Node> findNodes(org.w3c.dom.Document var1, String var2);

    public abstract ElementIdentity getElementIdentity();

    public abstract void addMergeEventHandler(PropertyChangeListener var1);

    public abstract void removeMergeEventHandler(PropertyChangeListener var1);

    public abstract Node getOldEventNode(PropertyChangeEvent var1);

    public abstract Node getOldEventParentNode(PropertyChangeEvent var1);

    public abstract Node getNewEventNode(PropertyChangeEvent var1);

    public abstract Node getNewEventParentNode(PropertyChangeEvent var1);

    public String lookupNamespaceURI(Node node, List<Node> pathToRoot) {
        String namespace;
        block2: {
            Node n;
            String prefix = node.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if ((namespace = node.lookupNamespaceURI(prefix)) != null) break block2;
            Iterator<Node> i$ = pathToRoot.iterator();
            while (i$.hasNext() && (namespace = (n = i$.next()).lookupNamespaceURI(prefix)) == null) {
            }
        }
        return namespace;
    }

    @Override
    public long dirtyIntervalMillis() {
        if (this.dirtyTimeMillis == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dirtyTimeMillis;
    }

    public void setDirty() {
        this.dirtyTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void unsetDirty() {
        this.dirtyTimeMillis = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeUpdater {
        public void updateReference(Element var1);

        public <T extends Node> void updateReference(List<T> var1);
    }
}

