/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.spi.DocumentModelAccessProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyAccess
extends DocumentModelAccess {
    private AbstractDocumentModel model;
    private org.w3c.dom.Document rootDoc;

    public ReadOnlyAccess(AbstractDocumentModel model) {
        this.model = model;
    }

    @Override
    public AbstractDocumentModel getModel() {
        return this.model;
    }

    @Override
    public void setPrefix(Element node, String prefix) {
        throw new UnsupportedOperationException("setPrefix access not supported.");
    }

    @Override
    public List<Element> getPathFromRoot(org.w3c.dom.Document root, Element node) {
        throw new UnsupportedOperationException("getPathFromRoot access not supported.");
    }

    @Override
    public String getXPath(org.w3c.dom.Document root, Element node) {
        throw new UnsupportedOperationException("getXPath access not supported.");
    }

    @Override
    public Map<QName, String> getAttributeMap(Element element) {
        HashMap<QName, String> qValues = new HashMap<QName, String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (ReadOnlyAccess.isXmlnsAttribute(attr)) continue;
            QName q = AbstractDocumentComponent.getQName(attr);
            qValues.put(q, attr.getValue());
        }
        return qValues;
    }

    public static boolean isXmlnsAttribute(Attr attr) {
        return "xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getName());
    }

    @Override
    public Element duplicate(Element element) {
        throw new UnsupportedOperationException("getXPath access not supported.");
    }

    @Override
    public String getXmlFragment(Element element) {
        String fragment = this.getXmlFragmentInclusive(element);
        if (fragment.endsWith("/>")) {
            return null;
        }
        int start = fragment.indexOf(">");
        int end = fragment.lastIndexOf("<");
        return fragment.substring(++start, end);
    }

    @Override
    public void setXmlFragment(Element element, String text, DocumentModelAccess.NodeUpdater updater) throws IOException {
        throw new UnsupportedOperationException("setXmlFragment access not supported.");
    }

    @Override
    public void setText(Element element, String val, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("setText access not supported.");
    }

    @Override
    public void removeAttribute(Element element, String name, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("removeAttribute access not supported.");
    }

    @Override
    public void setAttribute(Element element, String name, String value, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("setAttribute access not supported.");
    }

    @Override
    public int findPosition(Node node) {
        Element root = this.model.getRootComponent().getPeer();
        Document doc = this.model.getBaseDocument();
        try {
            String buf = doc.getText(0, doc.getLength());
            if (node instanceof Element) {
                int pos = this.getRootElementPosition(buf, root);
                StringScanner scanner = new StringScanner(buf, pos);
                return this.findPosition((Element)node, root, scanner);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return -1;
    }

    private int getRootElementPosition(String buf, Element root) {
        Node n;
        NodeList children = root.getOwnerDocument().getChildNodes();
        int pos = 0;
        for (int i = 0; i < children.getLength() && (n = children.item(i)) != root; ++i) {
            String s = n.getNodeValue();
            assert (s != null) : "Invalid document";
            pos += s.length();
        }
        pos = buf.indexOf(root.getTagName(), pos) - 1;
        assert (pos > 0) : "Root element position should be greater than 0";
        return pos;
    }

    private int findPosition(Element target, Element base, StringScanner scanner) {
        if (target == base) {
            return scanner.pos;
        }
        scanner.skip(">");
        NodeList children = base.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) {
                String s = node.getNodeValue();
                if (s == null) {
                    s = node.getTextContent();
                }
                if (s == null) continue;
                scanner.skip(s.length());
                continue;
            }
            Element current = (Element)children.item(i);
            String tag = "<" + current.getTagName();
            scanner.scanTo(tag);
            if (current == target) {
                return scanner.pos;
            }
            int found = this.findPosition(target, current, scanner);
            if (found <= -1) continue;
            return found;
        }
        if (children.getLength() > 0) {
            scanner.skip(">");
        }
        return -1;
    }

    @Override
    public int getElementIndexOf(Node parent, Element child) {
        throw new UnsupportedOperationException("getElementIndexOf access not supported.");
    }

    @Override
    public List<Node> findNodes(org.w3c.dom.Document root, String xpath) {
        throw new UnsupportedOperationException("findNodes access not supported.");
    }

    @Override
    public Node findNode(org.w3c.dom.Document root, String xpath) {
        throw new UnsupportedOperationException("findNode access not supported.");
    }

    @Override
    public Element getContainingElement(int position) {
        try {
            Document swingDoc = this.model.getBaseDocument();
            String buf = swingDoc.getText(0, swingDoc.getLength());
            Element root = this.model.getDocument().getDocumentElement();
            if (position < 0) {
                return null;
            }
            return this.findElement(position, buf, root, this.getRootElementPosition(buf, root));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getNonElementString(String buf, int basePos, Node node) {
        assert (!(node instanceof Element)) : "Element is not expected";
        String s = node.getNodeValue();
        if (s == null) {
            s = node.getTextContent();
        }
        assert (s != null) : "Expected node has string value";
        return s;
    }

    protected Element findElement(int position, String buf, Element base, int basePos) {
        if (basePos == position) {
            return base;
        }
        NodeList children = base.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String s;
            int endCurrent;
            Node node = children.item(i);
            if (!(node instanceof Element)) {
                String s2 = this.getNonElementString(buf, basePos, node);
                if (position < (basePos = buf.indexOf(s2, basePos))) {
                    return base;
                }
                basePos += s2.length();
                continue;
            }
            Element current = (Element)children.item(i);
            String tag = "<" + current.getTagName();
            basePos = buf.indexOf(tag, basePos);
            if (basePos > position) {
                return base;
            }
            Element found = this.findElement(position, buf, current, basePos);
            if (found != null) {
                return found;
            }
            if (i + 1 >= children.getLength() || children.item(i + 1) instanceof Element || (endCurrent = buf.indexOf(s = this.getNonElementString(buf, basePos, children.item(i + 1)), basePos)) <= position) continue;
            return current;
        }
        return null;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        throw new UnsupportedOperationException("addUndoableEditListener access not supported.");
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        throw new UnsupportedOperationException("removeUndoableEditListener access not supported.");
    }

    @Override
    public void appendChild(Node node, Node newChild, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("appendChild access not supported.");
    }

    @Override
    public void insertBefore(Node node, Node newChild, Node refChild, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("insertBefore access not supported.");
    }

    @Override
    public void removeChild(Node node, Node child, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("removeChild access not supported.");
    }

    @Override
    public void replaceChild(Node node, Node child, Node newChild, DocumentModelAccess.NodeUpdater updater) {
        throw new UnsupportedOperationException("replaceChild access not supported.");
    }

    @Override
    public Model.State sync() throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document buffer = this.model.getBaseDocument();
            String xmlText = buffer.getText(0, buffer.getLength());
            BufferedReader reader = new BufferedReader(new StringReader(xmlText));
            this.rootDoc = db.parse(new InputSource(reader));
            Element rootElement = this.rootDoc.getDocumentElement();
            if (this.model.createRootComponent(rootElement) == null) {
                throw new IOException("Cannot create model with " + new QName(rootElement.getNamespaceURI(), rootElement.getLocalName()));
            }
            return Model.State.VALID;
        }
        catch (ParserConfigurationException pce) {
            IOException ioe = new IOException();
            ioe.initCause(pce);
            throw ioe;
        }
        catch (BadLocationException ble) {
            IOException ioe = new IOException();
            ioe.initCause(ble);
            throw ioe;
        }
        catch (SAXException saxe) {
            IOException ioe = new IOException();
            ioe.initCause(saxe);
            throw ioe;
        }
    }

    @Override
    public ElementIdentity getElementIdentity() {
        throw new UnsupportedOperationException("getElementIdentity access not supported.");
    }

    @Override
    public org.w3c.dom.Document getDocumentRoot() {
        return this.rootDoc;
    }

    @Override
    public void flush() {
    }

    @Override
    public void finishUndoRedo() {
        throw new UnsupportedOperationException("finishUndoRedo access not supported.");
    }

    @Override
    public boolean areSameNodes(Node n1, Node n2) {
        return n1.equals(n2);
    }

    @Override
    public void prepareForUndoRedo() {
        throw new UnsupportedOperationException("prepareForUndoRedo access not supported.");
    }

    @Override
    public void addMergeEventHandler(PropertyChangeListener l) {
    }

    @Override
    public void removeMergeEventHandler(PropertyChangeListener l) {
    }

    @Override
    public Node getOldEventParentNode(PropertyChangeEvent evt) {
        return null;
    }

    @Override
    public Node getOldEventNode(PropertyChangeEvent evt) {
        return null;
    }

    @Override
    public Node getNewEventParentNode(PropertyChangeEvent evt) {
        return null;
    }

    @Override
    public Node getNewEventNode(PropertyChangeEvent evt) {
        return null;
    }

    @Override
    public String normalizeUndefinedAttributeValue(String value) {
        return "".equals(value) ? null : value;
    }

    public static class Provider
    implements DocumentModelAccessProvider {
        private static Provider instance;

        protected Provider() {
        }

        public static Provider getInstance() {
            if (instance == null) {
                instance = new Provider();
            }
            return instance;
        }

        public DocumentModelAccess createModelAccess(AbstractDocumentModel model) {
            return new ReadOnlyAccess(model);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document loadSwingDocument(InputStream in) throws IOException, BadLocationException {
            PlainDocument sd = new PlainDocument();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    sd.insertString(sd.getLength(), line + System.getProperty("line.separator"), null);
                }
            }
            finally {
                br.close();
            }
            return sd;
        }

        public Object getModelSourceKey(ModelSource source) {
            return source.getLookup().lookup(File.class);
        }
    }

    private static class StringScanner {
        String buf;
        int pos = -1;

        public StringScanner(String buf, int pos) {
            this.buf = buf;
            this.pos = pos;
        }

        public void scanTo(String token) {
            this.pos = this.buf.indexOf(token, this.pos);
            if (this.pos == -1) {
                throw new IllegalArgumentException("Scan failed: position -1");
            }
        }

        public void skip(String token) {
            this.scanTo(token);
            this.skip(token.length());
        }

        public void skip(int count) {
            this.pos += count;
        }
    }
}

