/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncUnit {
    private final DocumentComponent target;
    private List<ChangeInfo> changes = new ArrayList<ChangeInfo>();
    private List<DocumentComponent> toRemove = new ArrayList<DocumentComponent>();
    private List<DocumentComponent> toAdd = new ArrayList<DocumentComponent>();
    private Map<String, Attr> removedAttributes = new HashMap<String, Attr>();
    private Map<String, Attr> addedAttributes = new HashMap<String, Attr>();
    private boolean componentChanged;
    private boolean hasTextContentChanges = false;

    public SyncUnit(DocumentComponent syncTarget) {
        if (syncTarget == null) {
            throw new IllegalArgumentException("Null syncTarget");
        }
        this.target = syncTarget;
    }

    public void addChange(ChangeInfo change) {
        if (!this.target.referencesSameNode(change.getParent())) {
            throw new IllegalArgumentException("ChangeInfo does not match target id");
        }
        this.changes.add(change);
        if (change.getChangedNode() instanceof Attr) {
            Attr attr = (Attr)change.getChangedNode();
            if (change.isAdded()) {
                this.addToAddedAttributes(attr);
            } else {
                this.addToRemovedAttributes(attr);
            }
        } else {
            Node actualChanged = change.getActualChangedNode();
            if (!(actualChanged instanceof Attribute || actualChanged instanceof Element || actualChanged.getNodeType() == 3 && ((Text)actualChanged).getNodeValue().trim().length() == 0)) {
                this.setHasTextContentChanges(true);
            }
        }
    }

    public List<ChangeInfo> getChanges() {
        return this.changes;
    }

    public DocumentComponent getTarget() {
        return this.target;
    }

    public List<DocumentComponent> getToRemoveList() {
        return this.toRemove;
    }

    public void addToRemoveList(DocumentComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.toRemove.add(c);
    }

    public List<DocumentComponent> getToAddList() {
        return this.toAdd;
    }

    public void addToAddList(DocumentComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.toAdd.add(c);
    }

    public void setComponentChanged(boolean v) {
        this.componentChanged = v;
    }

    public boolean isComponentChanged() {
        return this.componentChanged;
    }

    public void addToAddedAttributes(Attr attr) {
        this.addedAttributes.put(attr.getName(), attr);
    }

    public Map<String, Attr> getAddedAttributes() {
        return this.addedAttributes;
    }

    public Map<String, Attr> getRemovedAttributes() {
        return this.removedAttributes;
    }

    public void addToRemovedAttributes(Attr attr) {
        this.removedAttributes.put(attr.getName(), attr);
    }

    public void merge(SyncUnit su) {
        if (this.target != su.getTarget()) {
            throw new IllegalArgumentException("Invalid sync unit for merge");
        }
        this.changes.addAll(su.getChanges());
        for (String name : su.getRemovedAttributes().keySet()) {
            this.addToRemovedAttributes(su.getRemovedAttributes().get(name));
        }
        for (String name : su.getAddedAttributes().keySet()) {
            this.addToAddedAttributes(su.getAddedAttributes().get(name));
        }
        if (!su.getToAddList().isEmpty()) {
            HashSet<Element> addSet = new HashSet<Element>();
            for (DocumentComponent component : this.toAdd) {
                addSet.add(component.getPeer());
            }
            for (DocumentComponent component : su.getToAddList()) {
                if (addSet.contains(component.getPeer())) continue;
                this.toAdd.add(component);
            }
        }
        for (DocumentComponent component : su.getToRemoveList()) {
            if (this.toRemove.contains(component)) continue;
            this.toRemove.add(component);
        }
    }

    public void updateTargetReference() {
        AbstractDocumentComponent component = (AbstractDocumentComponent)this.target;
        if (component != null) {
            component.updateReference(this.getParentToRootPath());
        }
    }

    public ChangeInfo getLastChange() {
        if (this.changes.size() > 0) {
            return this.changes.get(this.changes.size() - 1);
        }
        return null;
    }

    public List<Element> getParentToRootPath() {
        if (this.getLastChange() == null) {
            return Collections.emptyList();
        }
        return this.getLastChange().getParentToRootPath();
    }

    public boolean hasTextContentChanges() {
        return this.hasTextContentChanges;
    }

    public void setHasTextContentChanges(boolean val) {
        this.hasTextContentChanges = val;
    }

    public boolean hasWhitespaceChangeOnly() {
        for (ChangeInfo ci : this.getChanges()) {
            if (ci.isDomainElement()) continue;
            Node n = ci.getActualChangedNode();
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text == null || text.trim().length() <= 0) continue;
                return false;
            }
            if (n.getNodeType() == 2) {
                String name = ((Attr)n).getName();
                Attr removed = this.getRemovedAttributes().get(name);
                if (removed == null) {
                    return false;
                }
                Attr added = this.getAddedAttributes().get(name);
                if (added == null) {
                    return false;
                }
                if (removed.getValue() != null && removed.getValue().equals(added.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

