/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.upgrade.PathTransformation;
import org.netbeans.upgrade.systemoptions.Importer;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoUpgrade {
    private static final List VERSION_TO_CHECK = Arrays.asList(".netbeans/5.5", ".netbeans/5.0", ".Creator/2_1", ".Creator/2_0");

    public static void main(String[] args) throws Exception {
        String[] version = new String[1];
        File sourceFolder = AutoUpgrade.checkPrevious(version, VERSION_TO_CHECK);
        if (sourceFolder != null) {
            if (!AutoUpgrade.showUpgradeDialog(sourceFolder)) {
                throw new UserCancelException();
            }
            AutoUpgrade.doUpgrade(sourceFolder, version[0]);
            AutoUpgrade.doNonStandardUpgrade(sourceFolder, version[0]);
            AutoUpgrade.upgradeBuildProperties(sourceFolder, version);
            Importer.doImport();
        }
    }

    private static void upgradeBuildProperties(File sourceFolder, String[] version) throws IOException {
        try {
            if (version[0].startsWith("2_")) {
                File userdir = new File(System.getProperty("netbeans.user", ""));
                Copy.appendSelectedLines(new File(sourceFolder, "build.properties"), userdir, new String[]{".*"});
            } else if ((double)Float.parseFloat(version[0]) >= 5.0) {
                File userdir = new File(System.getProperty("netbeans.user", ""));
                String[] regexForSelection = new String[]{"^nbplatform[.](?!default[.]netbeans[.]dest[.]dir).+[.].+=.+$"};
                Copy.appendSelectedLines(new File(sourceFolder, "build.properties"), userdir, regexForSelection);
            }
        }
        catch (NumberFormatException nex) {
            return;
        }
    }

    private static File checkPrevious(String[] version, List versionsToCheck) {
        String userHome = System.getProperty("user.home");
        File sourceFolder = null;
        if (userHome != null) {
            File userHomeFile = new File(userHome);
            Iterator it = versionsToCheck.iterator();
            while (it.hasNext() && sourceFolder == null) {
                String ver = (String)it.next();
                sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (sourceFolder.isDirectory()) {
                    version[0] = sourceFolder.getName();
                    break;
                }
                sourceFolder = null;
            }
            return sourceFolder;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JOptionPane p = new JOptionPane(new AutoUpgradePanel(source.getAbsolutePath()), 3, 0);
        JDialog d = p.createDialog(null, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        d.setModal(true);
        d.setVisible(true);
        return new Integer(0).equals(p.getValue());
    }

    static void doUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        Set includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStreamReader r = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + oldVersion), "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + ". Importing from " + source + " to " + userdir);
        File oldConfig = new File(source, "config");
        LocalFileSystem lfs = new LocalFileSystem();
        lfs.setRootDirectory(oldConfig);
        XMLFileSystem xmlfs = null;
        try {
            URL url = AutoUpgrade.class.getResource("layer" + oldVersion + ".xml");
            xmlfs = url != null ? new XMLFileSystem(url) : null;
        }
        catch (SAXException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        LocalFileSystem old = xmlfs != null ? AutoUpgrade.createLayeredSystem(lfs, xmlfs) : lfs;
        FileSystem mine = Repository.getDefault().getDefaultFileSystem();
        Copy.copyDeep(old.getRoot(), mine.getRoot(), includeExclude, PathTransformation.getInstance(oldVersion));
    }

    private static void doNonStandardUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        Set includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStream is = AutoUpgrade.class.getResourceAsStream("nonstandard" + oldVersion);
            if (is == null) {
                return;
            }
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion + "nonstandard");
            e.initCause(ex);
            throw e;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + "nonstandard" + ". Importing from " + source + " to " + userdir);
        LocalFileSystem old = new LocalFileSystem();
        old.setRootDirectory(source);
        LocalFileSystem nfs = new LocalFileSystem();
        nfs.setRootDirectory(userdir);
        Copy.copyDeep(old.getRoot(), nfs.getRoot(), includeExclude, PathTransformation.getInstance(oldVersion));
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem lfs, XMLFileSystem xmlfs) {
        MultiFileSystem old = new MultiFileSystem(new FileSystem[]{lfs, xmlfs}){
            {
                this.setPropagateMasks(true);
            }
        };
        return old;
    }

    private static List<FileObject> getFiles(FileObject folder, int depth, String fileName, String extension) {
        if (depth == 0) {
            FileObject result = folder.getFileObject(fileName, extension);
            if (result == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(result);
        }
        Enumeration en = folder.getChildren(false);
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isFolder()) continue;
            result.addAll(AutoUpgrade.getFiles(fo, depth - 1, fileName, extension));
        }
        return result;
    }

    private static void copy(FileObject sourceDir, FileObject destDir) throws IOException {
        Enumeration en = sourceDir.getData(false);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (fo.isFolder()) {
                FileObject newDestDir = destDir.createFolder(fo.getName());
                AutoUpgrade.copy(fo, newDestDir);
                continue;
            }
            try {
                FileObject destFile = FileUtil.copyFile((FileObject)fo, (FileObject)destDir, (String)fo.getName(), (String)fo.getExt());
                FileUtil.copyAttributes((FileObject)fo, (FileObject)destFile);
            }
            catch (IOException ex) {
                if (fo.getNameExt().endsWith("_hidden")) continue;
                throw ex;
            }
        }
    }
}

