/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.PropertiesStorage;
import org.netbeans.upgrade.systemoptions.SystemOptionsParser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Importer {
    private static final String DEFINITION_OF_FILES = "systemoptionsimport";

    private static FileObject getRootOfSystemFileSystem() {
        return Repository.getDefault().getDefaultFileSystem().getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImport() throws IOException {
        Set<FileObject> files = Importer.getImportFiles(Importer.loadImportFilesDefinition());
        Iterator<DefaultResult> it = Importer.parse(files).iterator();
        while (it.hasNext()) {
            Importer.saveResult(it.next());
        }
        for (FileObject fo : files) {
            FileLock fLock = fo.lock();
            try {
                fo.rename(fLock, fo.getName(), "imported");
            }
            finally {
                fLock.releaseLock();
            }
        }
    }

    private static void saveResult(DefaultResult result) throws IOException {
        String absolutePath = "/" + result.getModuleName();
        PropertiesStorage ps = PropertiesStorage.instance(absolutePath);
        Properties props = ps.load();
        String[] propertyNames = result.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String val = result.getProperty(propertyNames[i]);
            if (val == null) continue;
            props.put(propertyNames[i], val);
        }
        if (props.size() > 0) {
            ps.save(props);
        }
    }

    private static Set<DefaultResult> parse(Set<FileObject> files) {
        HashSet<DefaultResult> retval = new HashSet<DefaultResult>();
        for (FileObject f : files) {
            try {
                retval.add(SystemOptionsParser.parse(f, false));
            }
            catch (ClassNotFoundException ex) {
            }
            catch (IOException ex) {}
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadImportFilesDefinition() throws IOException {
        Properties props = new Properties();
        InputStream is = Importer.class.getResourceAsStream(DEFINITION_OF_FILES);
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }

    private static Set<FileObject> getImportFiles(Properties props) {
        HashSet<FileObject> fileobjects = new HashSet<FileObject>();
        for (String string : props.keySet()) {
            FileObject f = Importer.getRootOfSystemFileSystem().getFileObject(string);
            if (f == null) continue;
            fileobjects.add(f);
        }
        return fileobjects;
    }

    private Importer() {
    }
}

