/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.upgrade.systemoptions.ColorProcessor;
import org.netbeans.upgrade.systemoptions.FileProcessor;
import org.netbeans.upgrade.systemoptions.HashMapProcessor;
import org.netbeans.upgrade.systemoptions.HostPropertyProcessor;
import org.netbeans.upgrade.systemoptions.IntrospectedInfoProcessor;
import org.netbeans.upgrade.systemoptions.ListProcessor;
import org.netbeans.upgrade.systemoptions.NbClassPathProcessor;
import org.netbeans.upgrade.systemoptions.StringPropertyProcessor;
import org.netbeans.upgrade.systemoptions.TaskTagsProcessor;
import org.netbeans.upgrade.systemoptions.URLProcessor;
import org.netbeans.upgrade.systemoptions.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PropertyProcessor {
    private String className;
    private static Map<String, String> results;
    private static Map<String, PropertyProcessor> clsname2Delegate;
    private static PropertyProcessor DEFAULT;
    private static PropertyProcessor TYPES;
    private boolean types;

    private static void registerPropertyProcessor(PropertyProcessor instance) {
        if (clsname2Delegate.put(instance.className, instance) != null) {
            throw new IllegalArgumentException();
        }
    }

    private PropertyProcessor(boolean types) {
        this.types = types;
    }

    protected PropertyProcessor(String className) {
        this(false);
        this.className = className;
    }

    static Map<String, String> processProperty(String propertyName, Object value, boolean types) {
        PropertyProcessor p;
        results = new HashMap<String, String>();
        PropertyProcessor propertyProcessor = p = types ? TYPES : PropertyProcessor.findDelegate(value);
        if (p == null) {
            p = DEFAULT;
        }
        assert (p != null);
        p.processPropertyImpl(propertyName, value);
        return results;
    }

    abstract void processPropertyImpl(String var1, Object var2);

    protected final void addProperty(String propertyName, String value) {
        if (results.put(propertyName, value) != null) {
            throw new IllegalArgumentException(propertyName);
        }
    }

    private static PropertyProcessor findDelegate(Object value) {
        String clsName = Utils.getClassNameFromObject(value);
        return clsname2Delegate.get(clsName);
    }

    static {
        clsname2Delegate = new HashMap<String, PropertyProcessor>();
        PropertyProcessor.registerPropertyProcessor(new TaskTagsProcessor());
        PropertyProcessor.registerPropertyProcessor(new HostPropertyProcessor());
        PropertyProcessor.registerPropertyProcessor(new FileProcessor());
        PropertyProcessor.registerPropertyProcessor(new NbClassPathProcessor());
        PropertyProcessor.registerPropertyProcessor(new HashMapProcessor());
        PropertyProcessor.registerPropertyProcessor(new IntrospectedInfoProcessor());
        PropertyProcessor.registerPropertyProcessor(new ListProcessor());
        PropertyProcessor.registerPropertyProcessor(new URLProcessor());
        PropertyProcessor.registerPropertyProcessor(new ColorProcessor());
        PropertyProcessor.registerPropertyProcessor(new StringPropertyProcessor());
        DEFAULT = new PropertyProcessor(false){

            void processPropertyImpl(String propertyName, Object value) {
                String stringvalue = null;
                stringvalue = Utils.valueFromObjectWrapper(value);
                this.addProperty(propertyName, stringvalue);
            }
        };
        TYPES = new PropertyProcessor(true){

            void processPropertyImpl(String propertyName, Object value) {
                this.addProperty(propertyName, Utils.getClassNameFromObject(value));
            }
        };
    }
}

