/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac;

import com.sun.tools.javac.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Server.java\t1.8 06/06/25")
class Server
implements Runnable {
    private final BufferedReader in;
    private final OutputStream out;
    private final boolean isSocket;
    private static final JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
    private static Logger logger = Logger.getLogger("com.sun.tools.javac");
    static StandardJavaFileManager fm = tool.getStandardFileManager(null, null, null);

    private Server(BufferedReader in, OutputStream out, boolean isSocket) {
        this.in = in;
        this.out = out;
        this.isSocket = isSocket;
    }

    private Server(BufferedReader in, OutputStream out) {
        this(in, out, false);
    }

    private Server(Socket socket) throws IOException, UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(socket.getInputStream(), "utf-8")), socket.getOutputStream(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int res;
        block31: {
            ArrayList<String> args;
            block29: {
                args = new ArrayList<String>();
                res = -1;
                try {
                    String line = null;
                    try {
                        line = this.in.readLine();
                    }
                    catch (IOException e) {
                        System.err.println(e.getLocalizedMessage());
                        System.exit(0);
                        line = null;
                    }
                    String cwd = null;
                    while (line != null) {
                        if (line.startsWith("PWD:")) {
                            cwd = line.substring(4);
                        } else {
                            if (line.equals("END")) break;
                            if (!"-XDstdout".equals(line)) {
                                args.add(line);
                            }
                        }
                        try {
                            line = this.in.readLine();
                        }
                        catch (IOException e) {
                            System.err.println(e.getLocalizedMessage());
                            System.exit(0);
                            line = null;
                        }
                    }
                    List<File> path = cwd == null ? null : Arrays.asList(new File(cwd));
                    long msec = System.currentTimeMillis();
                    try {
                        JavaCompiler javaCompiler = tool;
                        synchronized (javaCompiler) {
                            for (StandardLocation location : StandardLocation.values()) {
                                fm.setLocation(location, path);
                            }
                            res = this.compile(this.out, fm, args);
                        }
                    }
                    catch (Throwable ex) {
                        logger.log(Level.SEVERE, ((Object)args).toString(), ex);
                        PrintWriter p = new PrintWriter(this.out, true);
                        ex.printStackTrace(p);
                        p.flush();
                    }
                    if (res >= 3) {
                        logger.severe(String.format("problem: %s", args));
                    } else {
                        logger.info(String.format("success: %s", args));
                    }
                    logger.info(String.format("Real time: %sms", -(msec -= System.currentTimeMillis())));
                    Object var15_17 = null;
                    if (this.isSocket) break block29;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    if (!this.isSocket) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {
                        this.out.write(String.format("EXIT: %s%n", res).getBytes());
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ((Object)args).toString(), ex);
                    }
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ((Object)args).toString(), ex);
                    }
                    logger.info(String.format("EXIT: %s", res));
                    throw throwable;
                }
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                this.out.write(String.format("EXIT: %s%n", res).getBytes());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ((Object)args).toString(), ex);
            }
            try {
                this.out.flush();
                this.out.close();
                break block31;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ((Object)args).toString(), ex);
            }
            {
            }
        }
        logger.info(String.format("EXIT: %s", res));
    }

    public static void main(String ... args) throws FileNotFoundException {
        if (args.length == 2) {
            throw new UnsupportedOperationException("TODO");
        }
        ExecutorService pool = Executors.newCachedThreadPool();
        try {
            ServerSocket socket = new ServerSocket(51966, -1, null);
            while (true) {
                pool.execute(new Server(socket.accept()));
            }
        }
        catch (IOException e) {
            System.err.format("Error: %s%n", e.getLocalizedMessage());
            pool.shutdown();
            return;
        }
    }

    private int compile(OutputStream out, StandardJavaFileManager fm, List<String> args) {
        return tool.run(null, null, out, args.toArray(new String[args.size()]));
    }

    static {
        logger.setLevel(Level.SEVERE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CwdFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        String cwd;

        CwdFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        String getAbsoluteName(String name) {
            if (new File(name).isAbsolute()) {
                return name;
            }
            return new File(this.cwd, name).getPath();
        }
    }
}

