/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Version;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Types.java\t1.86 06/06/26")
public class Types {
    protected static final Context.Key<Types> typesKey = new Context.Key();
    final Symtab syms;
    final Name.Table names;
    final boolean allowBoxing;
    final ClassReader reader;
    final Source source;
    final Check chk;
    List<Warner> warnStack = List.nil();
    final Name capturedName;
    private final MapVisitor<Void> upperBound = new MapVisitor<Void>(){

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void ignored) {
            if (t.isSuperBound()) {
                return t.bound == null ? Types.this.syms.objectType : t.bound.bound;
            }
            return this.visit(t.type);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType t, Void ignored) {
            return this.visit(t.bound);
        }
    };
    private final MapVisitor<Void> lowerBound = new MapVisitor<Void>(){

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void ignored) {
            return t.isExtendsBound() ? Types.this.syms.botType : this.visit(t.type);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType t, Void ignored) {
            return this.visit(t.getLowerBound());
        }
    };
    private final UnaryVisitor<Boolean> isUnbounded = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void ignored) {
            List<Type> parms = t.tsym.type.allparams();
            List<Type> args = t.allparams();
            while (parms.nonEmpty()) {
                Type.WildcardType unb = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)parms.head);
                if (!Types.this.containsType((Type)args.head, unb)) {
                    return false;
                }
                parms = parms.tail;
                args = args.tail;
            }
            return true;
        }
    };
    private final SimpleVisitor<Type, Symbol> asSub = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            if (t.tsym == sym) {
                return t;
            }
            Type base = Types.this.asSuper(sym.type, t.tsym);
            if (base == null) {
                return null;
            }
            ListBuffer<Type> from = new ListBuffer<Type>();
            ListBuffer<Type> to = new ListBuffer<Type>();
            try {
                Types.this.adapt(base, t, from, to);
            }
            catch (AdaptFailure ex) {
                return null;
            }
            Type res = Types.this.subst(sym.type, from.toList(), to.toList());
            if (!Types.this.isSubtype(res, t)) {
                return null;
            }
            ListBuffer openVars = new ListBuffer();
            List<Type> l = sym.type.allparams();
            while (l.nonEmpty()) {
                if (res.contains((Type)l.head) && !t.contains((Type)l.head)) {
                    openVars.append(l.head);
                }
                l = l.tail;
            }
            if (openVars.nonEmpty()) {
                if (t.isRaw()) {
                    res = Types.this.erasure(res);
                } else {
                    List<Type> opens = openVars.toList();
                    ListBuffer<Type.WildcardType> qs = new ListBuffer<Type.WildcardType>();
                    List<Type> iter = opens;
                    while (iter.nonEmpty()) {
                        qs.append(new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)iter.head));
                        iter = iter.tail;
                    }
                    res = Types.this.subst(res, opens, qs.toList());
                }
            }
            return res;
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t.tsym == sym || t.tsym.name == Types.this.names.any ? t : null;
        }
    };
    private TypeRelation isSubtype = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        public Boolean visitType(Type t, Type s) {
            switch (t.tag) {
                case 1: 
                case 2: {
                    return t.tag == s.tag || t.tag + 2 <= s.tag && s.tag <= 7;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return t.tag <= s.tag && s.tag <= 7;
                }
                case 8: 
                case 9: {
                    return t.tag == s.tag;
                }
                case 14: {
                    return Types.this.isSubtypeNoCapture(t.getUpperBound(), s);
                }
                case 17: {
                    return s.tag == 17 || s.tag == 10 || s.tag == 11 || s.tag == 14;
                }
                case 18: {
                    return false;
                }
            }
            throw new AssertionError((Object)("isSubtype " + t.tag));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsTypeRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.containsType(t.getTypeArguments(), s.getTypeArguments());
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return Types.this.containsType(t.getTypeArguments(), this.rewriteSupers(s).getTypeArguments());
        }

        private Type rewriteSupers(Type t) {
            if (!t.isParameterized()) {
                return t;
            }
            ListBuffer from = ListBuffer.lb();
            ListBuffer to = ListBuffer.lb();
            Types.this.adaptSelf(t, from, to);
            if (from.isEmpty()) {
                return t;
            }
            ListBuffer rewrite = ListBuffer.lb();
            boolean changed = false;
            for (Type orig : to.toList()) {
                Type s = this.rewriteSupers(orig);
                if (s.isSuperBound() && !s.isExtendsBound()) {
                    s = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass);
                    changed = true;
                } else if (s != orig) {
                    s = new Type.WildcardType(Types.this.upperBound(s), BoundKind.EXTENDS, Types.this.syms.boundClass);
                    changed = true;
                }
                rewrite.append(s);
            }
            if (changed) {
                return Types.this.subst(t.tsym.type, from.toList(), rewrite.toList());
            }
            return t;
        }

        public Boolean visitClassType(Type.ClassType t, Type s) {
            Type sup = Types.this.asSuper(t, s.tsym);
            return sup != null && sup.tsym == s.tsym && (!s.isParameterized() || this.containsTypeRecursive(s, sup)) && Types.this.isSubtypeNoCapture(sup.getEnclosingType(), s.getEnclosingType());
        }

        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (s.tag == 11) {
                if (t.elemtype.tag <= 8) {
                    return Types.this.isSameType(t.elemtype, Types.this.elemtype(s));
                }
                return Types.this.isSubtypeNoCapture(t.elemtype, Types.this.elemtype(s));
            }
            if (s.tag == 10) {
                Name sname = s.tsym.getQualifiedName();
                return sname == Types.this.names.java_lang_Object || sname == Types.this.names.java_lang_Cloneable || sname == Types.this.names.java_io_Serializable;
            }
            return false;
        }

        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (t == s || t.qtype == s || s.tag == 19 || s.tag == 20) {
                return true;
            }
            if (t.inst != null) {
                return Types.this.isSubtypeNoCapture(t.inst, s);
            }
            t.hibounds = t.hibounds.prepend(s);
            return true;
        }

        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return t == s || t.tsym.name == Types.this.names.any;
        }
    };
    private TypeRelation isSameType = new TypeRelation(){

        public Boolean visitType(Type t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.tag >= 19) {
                return (Boolean)this.visit(s, t);
            }
            switch (t.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    return t.tag == s.tag;
                }
                case 14: {
                    return s.isSuperBound() && !s.isExtendsBound() && (Boolean)this.visit(t, Types.this.upperBound(s)) != false;
                }
            }
            throw new AssertionError((Object)("isSameType " + t.tag));
        }

        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (s.tag >= 19) {
                return (Boolean)this.visit(s, t);
            }
            return false;
        }

        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.tag >= 19) {
                return (Boolean)this.visit(s, t);
            }
            if (s.isSuperBound() && !s.isExtendsBound()) {
                return (Boolean)this.visit(t, Types.this.upperBound(s)) != false && (Boolean)this.visit(t, Types.this.lowerBound(s)) != false;
            }
            if (t.isCompound() && s.isCompound()) {
                if (!((Boolean)this.visit(Types.this.supertype(t), Types.this.supertype(s))).booleanValue()) {
                    return false;
                }
                HashSet<SingletonType> set = new HashSet<SingletonType>();
                for (Type x : Types.this.interfaces(t)) {
                    set.add(new SingletonType(x));
                }
                for (Type x : Types.this.interfaces(s)) {
                    if (set.remove(new SingletonType(x))) continue;
                    return false;
                }
                return set.size() == 0;
            }
            return t.tsym == s.tsym && (Boolean)this.visit(t.getEnclosingType(), s.getEnclosingType()) != false && Types.this.containsTypeEquivalent((List<Type>)t.getTypeArguments(), s.getTypeArguments());
        }

        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.tag >= 19) {
                return (Boolean)this.visit(s, t);
            }
            return s.tag == 11 && Types.this.containsTypeEquivalent(t.elemtype, Types.this.elemtype(s));
        }

        public Boolean visitMethodType(Type.MethodType t, Type s) {
            return Types.this.hasSameArgs(t, s) && (Boolean)this.visit(t.getReturnType(), s.getReturnType()) != false;
        }

        public Boolean visitPackageType(Type.PackageType t, Type s) {
            return t == s;
        }

        public Boolean visitForAll(Type.ForAll t, Type s) {
            if (s.tag != 16) {
                return false;
            }
            Type.ForAll forAll = (Type.ForAll)s;
            return Types.this.hasSameBounds(t, forAll) && (Boolean)this.visit(t.qtype, Types.this.subst(forAll.qtype, forAll.tvars, t.tvars)) != false;
        }

        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (s.tag == 15) {
                return false;
            }
            if (t == s || t.qtype == s || s.tag == 19 || s.tag == 20) {
                return true;
            }
            if (t.inst != null) {
                return (Boolean)this.visit(t.inst, s);
            }
            t.inst = Types.this.fromUnknownFun.apply(s);
            List<Type> l = t.lobounds;
            while (l.nonEmpty()) {
                if (!Types.this.isSubtype((Type)l.head, t.inst)) {
                    return false;
                }
                l = l.tail;
            }
            l = t.hibounds;
            while (l.nonEmpty()) {
                if (!Types.this.isSubtype(t.inst, (Type)l.head)) {
                    return false;
                }
                l = l.tail;
            }
            return true;
        }

        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return t == s || t.tsym.name == Types.this.names.any || s.getKind() == TypeKind.ERROR && (s.tsym.name == Types.this.names.any || t.tsym.name == s.tsym.name);
        }
    };
    public Type.Mapping fromUnknownFun = new Type.Mapping("fromUnknownFun"){

        public Type apply(Type t) {
            if (t.tag == 20) {
                return new Type.UndetVar(t);
            }
            return t.map(this);
        }
    };
    private TypeRelation containsType = new TypeRelation(){

        private Type U(Type t) {
            while (t.tag == 15) {
                Type.WildcardType w = (Type.WildcardType)t;
                if (w.isSuperBound()) {
                    return w.bound == null ? Types.this.syms.objectType : w.bound.bound;
                }
                t = w.type;
            }
            return t;
        }

        private Type L(Type t) {
            while (t.tag == 15) {
                Type.WildcardType w = (Type.WildcardType)t;
                if (w.isExtendsBound()) {
                    return Types.this.syms.botType;
                }
                t = w.type;
            }
            return t;
        }

        public Boolean visitType(Type t, Type s) {
            if (s.tag >= 19) {
                return Types.this.containedBy(s, t);
            }
            return Types.this.isSameType(t, s);
        }

        void debugContainsType(Type.WildcardType t, Type s) {
            System.err.format(" %s U(%s) <: U(%s) %s = %s%n", Types.this.upperBound(s), s, t, Types.this.upperBound(t), t.isSuperBound() || Types.this.isSubtypeNoCapture(Types.this.upperBound(s), Types.this.upperBound(t)));
            System.err.format(" %s L(%s) <: L(%s) %s = %s%n", Types.this.lowerBound(t), t, s, Types.this.lowerBound(s), t.isExtendsBound() || Types.this.isSubtypeNoCapture(Types.this.lowerBound(t), Types.this.lowerBound(s)));
            System.err.println();
        }

        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (s.tag >= 19) {
                return Types.this.containedBy(s, t);
            }
            return !(!t.isExtendsBound() && !Types.this.isSubtypeNoCapture(this.L(t), Types.this.lowerBound(s)) || !t.isSuperBound() && !Types.this.isSubtypeNoCapture(Types.this.upperBound(s), this.U(t)));
        }

        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (s.tag != 15) {
                return Types.this.isSameType(t, s);
            }
            return false;
        }

        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return t == s || t.tsym.name == Types.this.names.any;
        }
    };
    private TypeRelation isCastable = new TypeRelation(){

        public Boolean visitType(Type t, Type s) {
            if (s.tag == 19) {
                return t == s || s.tsym.name == Types.this.names.any;
            }
            switch (t.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return s.tag <= 7;
                }
                case 8: {
                    return s.tag == 8;
                }
                case 9: {
                    return false;
                }
                case 17: {
                    return Types.this.isSubtype(t, s);
                }
            }
            throw new AssertionError();
        }

        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            return Types.this.isCastable(Types.this.upperBound(t), s, (Warner)Types.this.warnStack.head);
        }

        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (s.tag == 19 || s.tag == 17) {
                return true;
            }
            if (s.tag == 14) {
                if (Types.this.isCastable(s.getUpperBound(), t, Warner.noWarnings)) {
                    ((Warner)Types.this.warnStack.head).warnUnchecked();
                    return true;
                }
                return false;
            }
            if (t.isCompound()) {
                if (!((Boolean)this.visit(Types.this.supertype(t), s)).booleanValue()) {
                    return false;
                }
                for (Type intf : Types.this.interfaces(t)) {
                    if (((Boolean)this.visit(intf, s)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            if (s.isCompound()) {
                return this.visitClassType((Type.ClassType)s, t);
            }
            if (s.tag == 10 || s.tag == 11) {
                boolean upcast = Types.this.isSubtype(Types.this.erasure(t), Types.this.erasure(s));
                if (upcast || Types.this.isSubtype(Types.this.erasure(s), Types.this.erasure(t))) {
                    Type highSub;
                    if (!upcast && s.tag == 11) {
                        if (!Types.this.isReifiable(s)) {
                            ((Warner)Types.this.warnStack.head).warnUnchecked();
                        }
                        return true;
                    }
                    if (s.isRaw()) {
                        return true;
                    }
                    if (t.isRaw()) {
                        if (!Types.this.isUnbounded(s)) {
                            ((Warner)Types.this.warnStack.head).warnUnchecked();
                        }
                        return true;
                    }
                    Type a = upcast ? t : s;
                    Type b = upcast ? s : t;
                    boolean HIGH = true;
                    boolean LOW = false;
                    boolean DONT_REWRITE_TYPEVARS = false;
                    Type aHigh = Types.this.rewriteQuantifiers(a, true, false);
                    Type aLow = Types.this.rewriteQuantifiers(a, false, false);
                    Type bHigh = Types.this.rewriteQuantifiers(b, true, false);
                    Type bLow = Types.this.rewriteQuantifiers(b, false, false);
                    Type lowSub = Types.this.asSub(bLow, aLow.tsym);
                    Type type = highSub = lowSub == null ? null : Types.this.asSub(bHigh, aHigh.tsym);
                    if (highSub == null) {
                        boolean REWRITE_TYPEVARS = true;
                        aHigh = Types.this.rewriteQuantifiers(a, true, true);
                        aLow = Types.this.rewriteQuantifiers(a, false, true);
                        bHigh = Types.this.rewriteQuantifiers(b, true, true);
                        bLow = Types.this.rewriteQuantifiers(b, false, true);
                        lowSub = Types.this.asSub(bLow, aLow.tsym);
                        Type type2 = highSub = lowSub == null ? null : Types.this.asSub(bHigh, aHigh.tsym);
                    }
                    if (highSub != null) {
                        assert (a.tsym == highSub.tsym && a.tsym == lowSub.tsym) : a.tsym + " != " + highSub.tsym + " != " + lowSub.tsym;
                        if (!(Types.this.disjointTypes(aHigh.getTypeArguments(), highSub.getTypeArguments()) || Types.this.disjointTypes(aHigh.getTypeArguments(), lowSub.getTypeArguments()) || Types.this.disjointTypes(aLow.getTypeArguments(), highSub.getTypeArguments()) || Types.this.disjointTypes(aLow.getTypeArguments(), lowSub.getTypeArguments()))) {
                            if (upcast ? Types.this.giveWarning(a, highSub) || Types.this.giveWarning(a, lowSub) : Types.this.giveWarning(highSub, a) || Types.this.giveWarning(lowSub, a)) {
                                ((Warner)Types.this.warnStack.head).warnUnchecked();
                            }
                            return true;
                        }
                    }
                    if (Types.this.isReifiable(s)) {
                        return Types.this.isSubtypeUnchecked(a, b);
                    }
                    return Types.this.isSubtypeUnchecked(a, b, (Warner)Types.this.warnStack.head);
                }
                if (s.tag == 10) {
                    if ((s.tsym.flags() & 0x200L) != 0L) {
                        return (t.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(t, s, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(t, s, (Warner)Types.this.warnStack.head);
                    }
                    if ((t.tsym.flags() & 0x200L) != 0L) {
                        return (s.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(t, s, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(t, s, (Warner)Types.this.warnStack.head);
                    }
                    return false;
                }
            }
            return false;
        }

        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            switch (s.tag) {
                case 17: 
                case 19: {
                    return true;
                }
                case 14: {
                    if (Types.this.isCastable(s, t, Warner.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warnUnchecked();
                        return true;
                    }
                    return false;
                }
                case 10: {
                    return Types.this.isSubtype(t, s);
                }
                case 11: {
                    if (Types.this.elemtype((Type)t).tag <= 8) {
                        return Types.this.elemtype((Type)t).tag == Types.this.elemtype((Type)s).tag;
                    }
                    return (Boolean)this.visit(Types.this.elemtype(t), Types.this.elemtype(s));
                }
            }
            return false;
        }

        public Boolean visitTypeVar(Type.TypeVar t, Type s) {
            switch (s.tag) {
                case 17: 
                case 19: {
                    return true;
                }
                case 14: {
                    if (Types.this.isSubtype(t, s)) {
                        return true;
                    }
                    if (Types.this.isCastable(t.bound, s, Warner.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warnUnchecked();
                        return true;
                    }
                    return false;
                }
            }
            return Types.this.isCastable(t.bound, s, (Warner)Types.this.warnStack.head);
        }

        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return t == s || t.tsym.name == Types.this.names.any;
        }
    };
    private TypeRelation disjointType = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        public Boolean visitType(Type t, Type s) {
            if (s.tag == 15) {
                return (Boolean)this.visit(s, t);
            }
            return this.notSoftSubtypeRecursive(t, s) || this.notSoftSubtypeRecursive(s, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCastableRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.isCastable(t, s);
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notSoftSubtypeRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.notSoftSubtype(t, s);
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return false;
        }

        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (t.isUnbound()) {
                return false;
            }
            if (s.tag != 15) {
                if (t.isExtendsBound()) {
                    return this.notSoftSubtypeRecursive(s, t.type);
                }
                return this.notSoftSubtypeRecursive(t.type, s);
            }
            if (s.isUnbound()) {
                return false;
            }
            if (t.isExtendsBound()) {
                if (s.isExtendsBound()) {
                    return !this.isCastableRecursive(t.type, Types.this.upperBound(s));
                }
                if (s.isSuperBound()) {
                    return this.notSoftSubtypeRecursive(Types.this.lowerBound(s), t.type);
                }
            } else if (t.isSuperBound() && s.isExtendsBound()) {
                return this.notSoftSubtypeRecursive(t.type, Types.this.upperBound(s));
            }
            return false;
        }
    };
    private final Type.Mapping lowerBoundMapping = new Type.Mapping("lowerBound"){

        public Type apply(Type t) {
            return Types.this.lowerBound(t);
        }
    };
    private UnaryVisitor<Boolean> isReifiable = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void ignored) {
            if (!t.isParameterized()) {
                return true;
            }
            for (Type param : t.allparams()) {
                if (param.isUnbound()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Void ignored) {
            return (Boolean)this.visit(t.elemtype);
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void ignored) {
            return false;
        }
    };
    private Type.Mapping elemTypeFun = new Type.Mapping("elemTypeFun"){

        public Type apply(Type t) {
            return Types.this.elemtype(t);
        }
    };
    private SimpleVisitor<Type, Symbol> asSuper = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            Type x;
            if (t.tsym == sym) {
                return t;
            }
            Type st = Types.this.supertype(t);
            if ((st.tag == 10 || st.tag == 19) && (x = Types.this.asSuper(st, sym)) != null) {
                return x;
            }
            if ((sym.flags() & 0x200L) != 0L) {
                List<Type> l = Types.this.interfaces(t);
                while (l.nonEmpty()) {
                    Type x2 = Types.this.asSuper((Type)l.head, sym);
                    if (x2 != null) {
                        return x2;
                    }
                    l = l.tail;
                }
            }
            return null;
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Symbol sym) {
            return Types.this.isSubtype(t, sym.type) ? sym.type : null;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Symbol sym) {
            return Types.this.asSuper(t.bound, sym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t.tsym == sym || t.tsym.name == Types.this.names.any ? t : null;
        }
    };
    private SimpleVisitor<Type, Symbol> memberType = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return sym.type;
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Symbol sym) {
            return Types.this.memberType(Types.this.upperBound(t), sym);
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            Type base;
            Symbol owner = sym.owner;
            long flags = sym.flags();
            if ((flags & 8L) == 0L && owner.type.isParameterized() && (base = Types.this.asOuterSuper(t, owner)) != null) {
                List<Type> ownerParams = owner.type.allparams();
                List<Type> baseParams = base.allparams();
                if (ownerParams.nonEmpty()) {
                    if (baseParams.isEmpty()) {
                        return Types.this.erasure(sym.type);
                    }
                    return Types.this.subst(sym.type, ownerParams, baseParams);
                }
            }
            return sym.type;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Symbol sym) {
            return Types.this.memberType(t.bound, sym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t;
        }
    };
    private UnaryVisitor<Type> erasure = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            if (t.tag <= 8) {
                return t;
            }
            return t.map(Types.this.erasureFun);
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void ignored) {
            return Types.this.erasure(Types.this.upperBound(t));
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            return t.tsym.erasure(Types.this);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            return Types.this.erasure(t.bound);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    };
    private Type.Mapping erasureFun = new Type.Mapping("erasure"){

        public Type apply(Type t) {
            return Types.this.erasure(t);
        }
    };
    private UnaryVisitor<Type> supertype = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            if (t.supertype_field == null) {
                Type supertype = ((Symbol.ClassSymbol)t.tsym).getSuperclass();
                if (t.isInterface()) {
                    supertype = ((Type.ClassType)t.tsym.type).supertype_field;
                }
                if (t.supertype_field == null) {
                    List<Type> actuals = Types.this.classBound(t).allparams();
                    List<Type> formals = t.tsym.type.allparams();
                    t.supertype_field = actuals.isEmpty() ? (formals.isEmpty() ? supertype : Types.this.erasure(supertype)) : Types.this.subst(supertype, formals, actuals);
                }
            }
            return t.supertype_field;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            if (t.bound.tag == 14 || !t.bound.isCompound() && !t.bound.isInterface()) {
                return t.bound;
            }
            return Types.this.supertype(t.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void ignored) {
            if (t.elemtype.isPrimitive() || Types.this.isSameType(t.elemtype, Types.this.syms.objectType)) {
                return Types.this.arraySuperType();
            }
            return new Type.ArrayType(Types.this.supertype(t.elemtype), t.tsym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    };
    private UnaryVisitor<List<Type>> interfaces = new UnaryVisitor<List<Type>>(){

        @Override
        public List<Type> visitType(Type t, Void ignored) {
            return List.nil();
        }

        @Override
        public List<Type> visitClassType(Type.ClassType t, Void ignored) {
            if (t.interfaces_field == null) {
                java.util.List interfaces = ((Symbol.ClassSymbol)t.tsym).getInterfaces();
                if (t.interfaces_field == null) {
                    assert (t != t.tsym.type) : t.toString();
                    List<Type> actuals = t.allparams();
                    List<Type> formals = t.tsym.type.allparams();
                    t.interfaces_field = actuals.isEmpty() ? (formals.isEmpty() ? interfaces : Types.this.erasure((List<Type>)interfaces)) : Types.this.upperBounds(Types.this.subst((List<Type>)interfaces, formals, actuals));
                }
            }
            return t.interfaces_field;
        }

        @Override
        public List<Type> visitTypeVar(Type.TypeVar t, Void ignored) {
            if (t.bound.isCompound()) {
                return Types.this.interfaces(t.bound);
            }
            if (t.bound.isInterface()) {
                return List.of(t.bound);
            }
            return List.nil();
        }
    };
    Map<Type, Boolean> isDerivedRawCache = new HashMap<Type, Boolean>();
    private UnaryVisitor<Type> classBound = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            return t;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            Type outer1 = Types.this.classBound(t.getEnclosingType());
            if (outer1 != t.getEnclosingType()) {
                return new Type.ClassType(outer1, (List<Type>)t.getTypeArguments(), t.tsym);
            }
            return t;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            return Types.this.classBound(Types.this.supertype(t));
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    };
    private TypeRelation hasSameArgs = new TypeRelation(){

        public Boolean visitType(Type t, Type s) {
            throw new AssertionError();
        }

        public Boolean visitMethodType(Type.MethodType t, Type s) {
            return s.tag == 12 && Types.this.containsTypeEquivalent(t.argtypes, s.getParameterTypes());
        }

        public Boolean visitForAll(Type.ForAll t, Type s) {
            if (s.tag != 16) {
                return false;
            }
            Type.ForAll forAll = (Type.ForAll)s;
            return Types.this.hasSameBounds(t, forAll) && (Boolean)this.visit(t.qtype, Types.this.subst(forAll.qtype, forAll.tvars, t.tvars)) != false;
        }

        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return false;
        }
    };
    private Type.Mapping newInstanceFun = new Type.Mapping("newInstanceFun"){

        public Type apply(Type t) {
            return new Type.TypeVar(t.tsym, t.getUpperBound(), Types.this.syms.botType);
        }
    };
    private Map<Type, List<Type>> closureCache = new HashMap<Type, List<Type>>();
    Set<TypePair> mergeCache = new HashSet<TypePair>();
    private Type arraySuperType = null;
    private static final UnaryVisitor<Integer> hashCode = new UnaryVisitor<Integer>(){

        @Override
        public Integer visitType(Type t, Void ignored) {
            return t.tag;
        }

        @Override
        public Integer visitClassType(Type.ClassType t, Void ignored) {
            int result = (Integer)this.visit(t.getEnclosingType());
            result *= 127;
            result += t.tsym.flatName().hashCode();
            for (Type s : t.getTypeArguments()) {
                result *= 127;
                result += ((Integer)this.visit(s)).intValue();
            }
            return result;
        }

        @Override
        public Integer visitWildcardType(Type.WildcardType t, Void ignored) {
            int result = t.kind.hashCode();
            if (t.type != null) {
                result *= 127;
                result += ((Integer)this.visit(t.type)).intValue();
            }
            return result;
        }

        @Override
        public Integer visitArrayType(Type.ArrayType t, Void ignored) {
            return (Integer)this.visit(t.elemtype) + 12;
        }

        @Override
        public Integer visitTypeVar(Type.TypeVar t, Void ignored) {
            return System.identityHashCode(t.tsym);
        }

        @Override
        public Integer visitUndetVar(Type.UndetVar t, Void ignored) {
            return System.identityHashCode(t);
        }

        @Override
        public Integer visitErrorType(Type.ErrorType t, Void ignored) {
            return 0;
        }
    };

    public static Types instance(Context context) {
        Types instance = context.get(typesKey);
        if (instance == null) {
            instance = new Types(context);
        }
        return instance;
    }

    protected Types(Context context) {
        context.put(typesKey, this);
        this.syms = Symtab.instance(context);
        this.names = Name.Table.instance(context);
        this.allowBoxing = Source.instance(context).allowBoxing();
        this.reader = ClassReader.instance(context);
        this.source = Source.instance(context);
        this.chk = Check.instance(context);
        this.capturedName = this.names.fromString("<captured wildcard>");
    }

    public Type upperBound(Type t) {
        return this.upperBound.visit(t);
    }

    public Type lowerBound(Type t) {
        return this.lowerBound.visit(t);
    }

    public boolean isUnbounded(Type t) {
        return this.isUnbounded.visit(t);
    }

    public Type asSub(Type t, Symbol sym) {
        return (Type)this.asSub.visit(t, sym);
    }

    public boolean isConvertible(Type t, Type s, Warner warn) {
        boolean sPrimitive;
        boolean tPrimitive = t.isPrimitive();
        if (tPrimitive == (sPrimitive = s.isPrimitive())) {
            return this.isSubtypeUnchecked(t, s, warn);
        }
        if (!this.allowBoxing) {
            return false;
        }
        return tPrimitive ? this.isSubtype(this.boxedClass((Type)t).type, s) : this.isSubtype(this.unboxedType(t), s);
    }

    public boolean isConvertible(Type t, Type s) {
        return this.isConvertible(t, s, Warner.noWarnings);
    }

    public boolean isSubtypeUnchecked(Type t, Type s) {
        return this.isSubtypeUnchecked(t, s, Warner.noWarnings);
    }

    public boolean isSubtypeUnchecked(Type t, Type s, Warner warn) {
        Type t2;
        if (t.tag == 11 && s.tag == 11) {
            return ((Type.ArrayType)t).elemtype.tag <= 8 ? this.isSameType(this.elemtype(t), this.elemtype(s)) : this.isSubtypeUnchecked(this.elemtype(t), this.elemtype(s), warn);
        }
        if (this.isSubtype(t, s)) {
            return true;
        }
        if (!s.isRaw() && (t2 = this.asSuper(t, s.tsym)) != null && t2.isRaw()) {
            if (this.isReifiable(s)) {
                warn.silentUnchecked();
            } else {
                warn.warnUnchecked();
            }
            return true;
        }
        return false;
    }

    public final boolean isSubtype(Type t, Type s) {
        return this.isSubtype(t, s, true);
    }

    public final boolean isSubtypeNoCapture(Type t, Type s) {
        return this.isSubtype(t, s, false);
    }

    public boolean isSubtype(Type t, Type s, boolean capture) {
        if (t == s) {
            return true;
        }
        if (s.tag >= 19) {
            return this.isSuperType(s, t);
        }
        Type lower = this.lowerBound(s);
        if (s != lower) {
            return this.isSubtype(capture ? this.capture(t) : t, lower, false);
        }
        return (Boolean)this.isSubtype.visit(capture ? this.capture(t) : t, s);
    }

    public boolean isSubtypeUnchecked(Type t, List<Type> ts, Warner warn) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (!this.isSubtypeUnchecked(t, (Type)l.head, warn)) {
                return false;
            }
            l = l.tail;
        }
        return true;
    }

    public boolean isSubtypes(List<Type> ts, List<Type> ss) {
        while (ts.tail != null && ss.tail != null && this.isSubtype((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSubtypesUnchecked(List<Type> ts, List<Type> ss, Warner warn) {
        while (ts.tail != null && ss.tail != null && this.isSubtypeUnchecked((Type)ts.head, (Type)ss.head, warn)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSuperType(Type t, Type s) {
        switch (t.tag) {
            case 19: {
                return t == s || t.tsym.name == this.names.any;
            }
            case 21: {
                Type.UndetVar undet = (Type.UndetVar)t;
                if (t == s || undet.qtype == s || s.tag == 19 || s.tag == 17) {
                    return true;
                }
                if (undet.inst != null) {
                    return this.isSubtype(s, undet.inst);
                }
                undet.lobounds = undet.lobounds.prepend(s);
                return true;
            }
        }
        return this.isSubtype(s, t);
    }

    public boolean isSameTypes(List<Type> ts, List<Type> ss) {
        while (ts.tail != null && ss.tail != null && this.isSameType((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSameType(Type t, Type s) {
        return (Boolean)this.isSameType.visit(t, s);
    }

    public boolean containedBy(Type t, Type s) {
        switch (t.tag) {
            case 21: {
                if (s.tag == 15) {
                    Type.UndetVar undetvar = (Type.UndetVar)t;
                    assert (undetvar.lobounds.isEmpty()) : undetvar;
                    undetvar.inst = this.glb(this.upperBound(s), undetvar.inst);
                    return true;
                }
                return this.isSameType(t, s);
            }
            case 19: {
                return t == s || t.tsym.name == this.names.any;
            }
        }
        return this.containsType(s, t);
    }

    boolean containsType(List<Type> ts, List<Type> ss) {
        while (ts.nonEmpty() && ss.nonEmpty() && this.containsType((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.isEmpty() && ss.isEmpty();
    }

    public boolean containsType(Type t, Type s) {
        return (Boolean)this.containsType.visit(t, s);
    }

    public boolean containsTypeEquivalent(List<Type> ts, List<Type> ss) {
        while (ts.nonEmpty() && ss.nonEmpty() && this.containsTypeEquivalent((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.isEmpty() && ss.isEmpty();
    }

    public boolean isCastable(Type t, Type s) {
        return this.isCastable(t, s, Warner.noWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCastable(Type t, Type s, Warner warn) {
        if (t == s) {
            return true;
        }
        if (t.isPrimitive() != s.isPrimitive()) {
            return this.allowBoxing && this.isConvertible(t, s, warn);
        }
        if (warn != this.warnStack.head) {
            try {
                this.warnStack = this.warnStack.prepend(warn);
                boolean bl = (Boolean)this.isCastable.visit(t, s);
                return bl;
            }
            finally {
                this.warnStack = this.warnStack.tail;
            }
        }
        return (Boolean)this.isCastable.visit(t, s);
    }

    public boolean disjointTypes(List<Type> ts, List<Type> ss) {
        while (ts.tail != null && ss.tail != null) {
            if (this.disjointType((Type)ts.head, (Type)ss.head)) {
                return true;
            }
            ts = ts.tail;
            ss = ss.tail;
        }
        return false;
    }

    public boolean disjointType(Type t, Type s) {
        return (Boolean)this.disjointType.visit(t, s);
    }

    public List<Type> lowerBoundArgtypes(Type t) {
        return Type.map(t.getParameterTypes(), this.lowerBoundMapping);
    }

    public boolean notSoftSubtype(Type t, Type s) {
        if (t == s) {
            return false;
        }
        if (t.tag == 14) {
            Type.TypeVar tv = (Type.TypeVar)t;
            if (s.tag == 14) {
                s = s.getUpperBound();
            }
            return !this.isCastable(tv.bound, s, Warner.noWarnings);
        }
        if (s.tag != 15) {
            s = this.upperBound(s);
        }
        if (s.tag == 14) {
            s = s.getUpperBound();
        }
        return !this.isSubtype(t, s);
    }

    public boolean isReifiable(Type t) {
        return this.isReifiable.visit(t);
    }

    public boolean isArray(Type t) {
        while (t.tag == 15) {
            t = this.upperBound(t);
        }
        return t.tag == 11;
    }

    public Type elemtype(Type t) {
        switch (t.tag) {
            case 15: {
                return this.elemtype(this.upperBound(t));
            }
            case 11: {
                return ((Type.ArrayType)t).elemtype;
            }
            case 16: {
                return this.elemtype(((Type.ForAll)t).qtype);
            }
            case 19: {
                return t;
            }
        }
        return null;
    }

    public int dimensions(Type t) {
        int result = 0;
        while (t.tag == 11) {
            ++result;
            t = this.elemtype(t);
        }
        return result;
    }

    public Type asSuper(Type t, Symbol sym) {
        return (Type)this.asSuper.visit(t, sym);
    }

    public Type asOuterSuper(Type t, Symbol sym) {
        switch (t.tag) {
            case 10: {
                do {
                    Type s;
                    if ((s = this.asSuper(t, sym)) != null) {
                        return s;
                    }
                    t = t.getEnclosingType();
                } while (t.tag == 10);
                return null;
            }
            case 11: {
                return this.isSubtype(t, sym.type) ? sym.type : null;
            }
            case 14: {
                return this.asSuper(t, sym);
            }
            case 19: {
                return t.tsym == sym || t.tsym.name == this.names.any ? t : null;
            }
        }
        return null;
    }

    public Type asEnclosingSuper(Type t, Symbol sym) {
        switch (t.tag) {
            case 10: {
                do {
                    Type s;
                    if ((s = this.asSuper(t, sym)) != null) {
                        return s;
                    }
                    Type outer = t.getEnclosingType();
                    Type type = outer.tag == 10 ? outer : (t = t.tsym.owner.enclClass() != null ? t.tsym.owner.enclClass().type : Type.noType);
                } while (t.tag == 10);
                return null;
            }
            case 11: {
                return this.isSubtype(t, sym.type) ? sym.type : null;
            }
            case 14: {
                return this.asSuper(t, sym);
            }
            case 19: {
                return t.tsym == sym || t.tsym.name == this.names.any ? t : null;
            }
        }
        return null;
    }

    public Type memberType(Type t, Symbol sym) {
        return (sym.flags() & 8L) != 0L ? sym.type : (Type)this.memberType.visit(t, sym);
    }

    public boolean isAssignable(Type t, Type s) {
        return this.isAssignable(t, s, Warner.noWarnings);
    }

    public boolean isAssignable(Type t, Type s, Warner warn) {
        if (t.tag == 19) {
            return t.tsym.name == this.names.any;
        }
        if (t.tag <= 4 && t.constValue() != null) {
            int value = ((Number)t.constValue()).intValue();
            switch (s.tag) {
                case 1: {
                    if (-128 > value || value > 127) break;
                    return true;
                }
                case 2: {
                    if (0 > value || value > 65535) break;
                    return true;
                }
                case 3: {
                    if (Short.MIN_VALUE > value || value > Short.MAX_VALUE) break;
                    return true;
                }
                case 4: {
                    return true;
                }
                case 10: {
                    switch (this.unboxedType((Type)s).tag) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return this.isAssignable(t, this.unboxedType(s), warn);
                        }
                    }
                }
            }
        }
        return this.isConvertible(t, s, warn);
    }

    public Type erasure(Type t) {
        if (t.tag <= 8) {
            return t;
        }
        return this.erasure.visit(t);
    }

    public List<Type> erasure(List<Type> ts) {
        return Type.map(ts, this.erasureFun);
    }

    public Type makeCompoundType(List<Type> bounds, Type supertype) {
        Symbol.ClassSymbol bc = new Symbol.ClassSymbol(0x41001401L, Type.moreInfo ? this.names.fromString(bounds.toString()) : this.names.empty, this.syms.noSymbol);
        bc.erasure_field = this.erasure((Type)bounds.head);
        bc.members_field = new Scope(bc);
        Type.ClassType bt = (Type.ClassType)bc.type;
        bt.allparams_field = List.nil();
        if (supertype != null) {
            bt.supertype_field = supertype;
            bt.interfaces_field = bounds;
        } else {
            bt.supertype_field = (Type)bounds.head;
            bt.interfaces_field = bounds.tail;
        }
        assert (bt.supertype_field.tsym.completer != null || !bt.supertype_field.isInterface()) : bt.supertype_field;
        return bt;
    }

    public Type makeCompoundType(List<Type> bounds) {
        Type supertype = (((Type)bounds.head).tsym.flags() & 0x200L) != 0L ? this.supertype((Type)bounds.head) : null;
        return this.makeCompoundType(bounds, supertype);
    }

    public Type makeCompoundType(Type bound1, Type bound2) {
        return this.makeCompoundType(List.of(bound1, bound2));
    }

    public Type supertype(Type t) {
        return this.supertype.visit(t);
    }

    public List<Type> interfaces(Type t) {
        return this.interfaces.visit(t);
    }

    public boolean isDerivedRaw(Type t) {
        Boolean result = this.isDerivedRawCache.get(t);
        if (result == null) {
            result = this.isDerivedRawInternal(t);
            this.isDerivedRawCache.put(t, result);
        }
        return result;
    }

    public boolean isDerivedRawInternal(Type t) {
        if (t.isErroneous()) {
            return false;
        }
        return t.isRaw() || this.supertype(t) != null && this.isDerivedRaw(this.supertype(t)) || this.isDerivedRaw(this.interfaces(t));
    }

    public boolean isDerivedRaw(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty() && !this.isDerivedRaw((Type)l.head)) {
            l = l.tail;
        }
        return l.nonEmpty();
    }

    public void setBounds(Type.TypeVar t, List<Type> bounds, Type supertype) {
        t.bound = bounds.tail.isEmpty() ? (Type)bounds.head : this.makeCompoundType(bounds, supertype);
        t.rank_field = -1;
    }

    public void setBounds(Type.TypeVar t, List<Type> bounds) {
        Type supertype = (((Type)bounds.head).tsym.flags() & 0x200L) != 0L ? this.supertype((Type)bounds.head) : null;
        this.setBounds(t, bounds, supertype);
        t.rank_field = -1;
    }

    public List<Type> getBounds(Type.TypeVar t) {
        if (!t.bound.isCompound()) {
            return List.of(t.bound);
        }
        if ((this.erasure((Type)t).tsym.flags() & 0x200L) == 0L) {
            return this.interfaces(t).prepend(this.supertype(t));
        }
        return this.interfaces(t);
    }

    public Type classBound(Type t) {
        return this.classBound.visit(t);
    }

    public boolean isSubSignature(Type t, Type s) {
        return this.hasSameArgs(t, s) || this.hasSameArgs(t, this.erasure(s));
    }

    public boolean overrideEquivalent(Type t, Type s) {
        return this.hasSameArgs(t, s) || this.hasSameArgs(t, this.erasure(s)) || this.hasSameArgs(this.erasure(t), s);
    }

    public boolean hasSameArgs(Type t, Type s) {
        return (Boolean)this.hasSameArgs.visit(t, s);
    }

    public List<Type> subst(List<Type> ts, List<Type> from, List<Type> to) {
        return new Subst(from, to).subst(ts);
    }

    public Type subst(Type t, List<Type> from, List<Type> to) {
        return new Subst(from, to).subst(t);
    }

    public List<Type> substBounds(List<Type> tvars, List<Type> from, List<Type> to) {
        if (tvars.isEmpty()) {
            return tvars;
        }
        if (tvars.tail.isEmpty()) {
            return List.of(this.substBound((Type.TypeVar)tvars.head, from, to));
        }
        ListBuffer newBoundsBuf = ListBuffer.lb();
        boolean changed = false;
        for (Type t : tvars) {
            Type.TypeVar tv = (Type.TypeVar)t;
            Type bound = this.subst(tv.bound, from, to);
            if (bound != tv.bound) {
                changed = true;
            }
            newBoundsBuf.append(bound);
        }
        if (!changed) {
            return tvars;
        }
        ListBuffer newTvars = ListBuffer.lb();
        for (Type t : tvars) {
            newTvars.append(new Type.TypeVar(t.tsym, null, this.syms.botType));
        }
        List<Object> newBounds = newBoundsBuf.toList();
        from = tvars;
        to = newTvars.toList();
        while (!newBounds.isEmpty()) {
            newBounds.head = this.subst((Type)newBounds.head, from, to);
            newBounds = newBounds.tail;
        }
        newBounds = newBoundsBuf.toList();
        for (Type t : newTvars.toList()) {
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.bound = (Type)newBounds.head;
            newBounds = newBounds.tail;
        }
        return newTvars.toList();
    }

    public Type.TypeVar substBound(Type.TypeVar t, List<Type> from, List<Type> to) {
        Type bound1 = this.subst(t.bound, from, to);
        if (bound1 == t.bound) {
            return t;
        }
        return new Type.TypeVar(t.tsym, bound1, this.syms.botType);
    }

    boolean hasSameBounds(Type.ForAll t, Type.ForAll s) {
        List<Type> l1 = t.tvars;
        List<Type> l2 = s.tvars;
        while (l1.nonEmpty() && l2.nonEmpty() && this.isSameType(((Type)l1.head).getUpperBound(), this.subst(((Type)l2.head).getUpperBound(), s.tvars, t.tvars))) {
            l1 = l1.tail;
            l2 = l2.tail;
        }
        return l1.isEmpty() && l2.isEmpty();
    }

    public List<Type> newInstances(List<Type> tvars) {
        List<Type> tvars1;
        List<Type> l = tvars1 = Type.map(tvars, this.newInstanceFun);
        while (l.nonEmpty()) {
            Type.TypeVar tv = (Type.TypeVar)l.head;
            tv.bound = this.subst(tv.bound, tvars, tvars1);
            l = l.tail;
        }
        return tvars1;
    }

    public int rank(Type t) {
        switch (t.tag) {
            case 10: {
                Type.ClassType cls = (Type.ClassType)t;
                if (cls.rank_field < 0) {
                    Name fullname = cls.tsym.getQualifiedName();
                    if (fullname == null) {
                        Logger.getLogger(Types.class.getName()).fine("fullname==null");
                    }
                    if (fullname != null && fullname == fullname.table.java_lang_Object) {
                        cls.rank_field = 0;
                    } else {
                        int r = this.rank(this.supertype(cls));
                        List<Type> l = this.interfaces(cls);
                        while (l.nonEmpty()) {
                            if (this.rank((Type)l.head) > r) {
                                r = this.rank((Type)l.head);
                            }
                            l = l.tail;
                        }
                        cls.rank_field = r + 1;
                    }
                }
                return cls.rank_field;
            }
            case 14: {
                Type.TypeVar tvar = (Type.TypeVar)t;
                if (tvar.rank_field < 0) {
                    int r = this.rank(this.supertype(tvar));
                    List<Type> l = this.interfaces(tvar);
                    while (l.nonEmpty()) {
                        if (this.rank((Type)l.head) > r) {
                            r = this.rank((Type)l.head);
                        }
                        l = l.tail;
                    }
                    tvar.rank_field = r + 1;
                }
                return tvar.rank_field;
            }
            case 18: 
            case 19: {
                return 0;
            }
        }
        throw new AssertionError();
    }

    public String toString(Type t) {
        if (t.tag == 16) {
            Type.ForAll forAll = (Type.ForAll)t;
            return this.typaramsString(forAll.tvars) + forAll.qtype;
        }
        return "" + t;
    }

    private String typaramsString(List<Type> tvars) {
        StringBuffer s = new StringBuffer();
        s.append('<');
        boolean first = true;
        for (Type t : tvars) {
            if (!first) {
                s.append(", ");
            }
            first = false;
            this.appendTyparamString((Type.TypeVar)t, s);
        }
        s.append('>');
        return s.toString();
    }

    private void appendTyparamString(Type.TypeVar t, StringBuffer buf) {
        buf.append(t);
        if (t.bound == null || t.bound.tsym.getQualifiedName() == this.names.java_lang_Object) {
            return;
        }
        buf.append(" extends ");
        Type bound = t.bound;
        if (!bound.isCompound()) {
            buf.append(bound);
        } else if ((this.erasure((Type)t).tsym.flags() & 0x200L) == 0L) {
            buf.append(this.supertype(t));
            for (Type intf : this.interfaces(t)) {
                buf.append('&');
                buf.append(intf);
            }
        } else {
            boolean first = true;
            for (Type intf : this.interfaces(t)) {
                if (!first) {
                    buf.append('&');
                }
                first = false;
                buf.append(intf);
            }
        }
    }

    public List<Type> closure(Type t) {
        List<Type> cl = this.closureCache.get(t);
        if (cl == null) {
            Type st = this.supertype(t);
            cl = !t.isCompound() ? (st.tag == 10 ? this.insert(this.closure(st), t) : List.of(t)) : this.closure(this.supertype(t));
            List<Type> l = this.interfaces(t);
            while (l.nonEmpty()) {
                cl = this.union(cl, this.closure((Type)l.head));
                l = l.tail;
            }
            this.closureCache.put(t, cl);
        }
        return cl;
    }

    public List<Type> insert(List<Type> cl, Type t) {
        if (cl.isEmpty() || t.tsym.precedes(((Type)cl.head).tsym, this)) {
            return cl.prepend(t);
        }
        if (((Type)cl.head).tsym.precedes(t.tsym, this)) {
            return this.insert(cl.tail, t).prepend((Type)cl.head);
        }
        return cl;
    }

    public List<Type> union(List<Type> cl1, List<Type> cl2) {
        if (cl1.isEmpty()) {
            return cl2;
        }
        if (cl2.isEmpty()) {
            return cl1;
        }
        if (((Type)cl1.head).tsym.precedes(((Type)cl2.head).tsym, this)) {
            return this.union(cl1.tail, cl2).prepend((Type)cl1.head);
        }
        if (((Type)cl2.head).tsym.precedes(((Type)cl1.head).tsym, this)) {
            return this.union(cl1, cl2.tail).prepend((Type)cl2.head);
        }
        return this.union(cl1.tail, cl2.tail).prepend((Type)cl1.head);
    }

    public List<Type> intersect(List<Type> cl1, List<Type> cl2) {
        if (cl1 == cl2) {
            return cl1;
        }
        if (cl1.isEmpty() || cl2.isEmpty()) {
            return List.nil();
        }
        if (((Type)cl1.head).tsym.precedes(((Type)cl2.head).tsym, this)) {
            return this.intersect(cl1.tail, cl2);
        }
        if (((Type)cl2.head).tsym.precedes(((Type)cl1.head).tsym, this)) {
            return this.intersect(cl1, cl2.tail);
        }
        if (this.isSameType((Type)cl1.head, (Type)cl2.head)) {
            return this.intersect(cl1.tail, cl2.tail).prepend((Type)cl1.head);
        }
        if (((Type)cl1.head).tsym == ((Type)cl2.head).tsym && ((Type)cl1.head).tag == 10 && ((Type)cl2.head).tag == 10) {
            if (((Type)cl1.head).isParameterized() && ((Type)cl2.head).isParameterized()) {
                Type merge = this.merge((Type)cl1.head, (Type)cl2.head);
                return this.intersect(cl1.tail, cl2.tail).prepend(merge);
            }
            if (((Type)cl1.head).isRaw() || ((Type)cl2.head).isRaw()) {
                return this.intersect(cl1.tail, cl2.tail).prepend(this.erasure((Type)cl1.head));
            }
        }
        return this.intersect(cl1.tail, cl2.tail);
    }

    private Type merge(Type c1, Type c2) {
        Type.ClassType class1 = (Type.ClassType)c1;
        List act1 = class1.getTypeArguments();
        Type.ClassType class2 = (Type.ClassType)c2;
        List act2 = class2.getTypeArguments();
        ListBuffer merged = new ListBuffer();
        List<Type> typarams = class1.tsym.type.getTypeArguments();
        while (act1.nonEmpty() && act2.nonEmpty() && typarams.nonEmpty()) {
            if (this.containsType((Type)act1.head, (Type)act2.head)) {
                merged.append(act1.head);
            } else if (this.containsType((Type)act2.head, (Type)act1.head)) {
                merged.append(act2.head);
            } else {
                Type.WildcardType m;
                TypePair pair = new TypePair(c1, c2);
                if (this.mergeCache.add(pair)) {
                    m = new Type.WildcardType(this.lub(this.upperBound((Type)act1.head), this.upperBound((Type)act2.head)), BoundKind.EXTENDS, this.syms.boundClass);
                    this.mergeCache.remove(pair);
                } else {
                    m = new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
                }
                merged.append(((Type)m).withTypeVar((Type)typarams.head));
            }
            act1 = act1.tail;
            act2 = act2.tail;
            typarams = typarams.tail;
        }
        assert (act1.isEmpty() && act2.isEmpty() && typarams.isEmpty());
        return new Type.ClassType(class1.getEnclosingType(), merged.toList(), class1.tsym);
    }

    private Type compoundMin(List<Type> cl) {
        if (cl.isEmpty()) {
            return this.syms.objectType;
        }
        List<Type> compound = this.closureMin(cl);
        if (compound.isEmpty()) {
            return null;
        }
        if (compound.tail.isEmpty()) {
            return (Type)compound.head;
        }
        return this.makeCompoundType(compound);
    }

    private List<Type> closureMin(List<Type> cl) {
        ListBuffer classes = ListBuffer.lb();
        ListBuffer interfaces = ListBuffer.lb();
        while (!cl.isEmpty()) {
            Type current = (Type)cl.head;
            if (current.isInterface()) {
                interfaces.append(current);
            } else {
                classes.append(current);
            }
            ListBuffer candidates = ListBuffer.lb();
            for (Type t : cl.tail) {
                if (this.isSubtypeNoCapture(current, t)) continue;
                candidates.append(t);
            }
            cl = candidates.toList();
        }
        return classes.appendList(interfaces).toList();
    }

    public Type lub(Type t1, Type t2) {
        return this.lub(List.of(t1, t2));
    }

    public Type lub(List<Type> ts) {
        boolean ARRAY_BOUND = true;
        int CLASS_BOUND = 2;
        int boundkind = 0;
        block10: for (Type t : ts) {
            switch (t.tag) {
                case 10: {
                    boundkind |= 2;
                    continue block10;
                }
                case 11: {
                    boundkind |= 1;
                    continue block10;
                }
                case 14: {
                    do {
                        t = t.getUpperBound();
                    } while (t.tag == 14);
                    if (t.tag == 11) {
                        boundkind |= 1;
                        continue block10;
                    }
                    boundkind |= 2;
                    continue block10;
                }
            }
            if (!t.isPrimitive()) continue;
            return this.syms.botType;
        }
        switch (boundkind) {
            case 0: {
                return this.syms.botType;
            }
            case 1: {
                List<Type> elements = Type.map(ts, this.elemTypeFun);
                for (Type t : elements) {
                    if (!t.isPrimitive()) continue;
                    Type first = (Type)ts.head;
                    for (Type s : ts.tail) {
                        if (this.isSameType(first, s)) continue;
                        return this.arraySuperType();
                    }
                    return first;
                }
                return new Type.ArrayType(this.lub(elements), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case 2: {
                while (((Type)ts.head).tag != 10 && ((Type)ts.head).tag != 14) {
                    ts = ts.tail;
                }
                assert (!ts.isEmpty());
                List<Type> cl = this.closure((Type)ts.head);
                for (Type t : ts) {
                    if (t.tag != 10 && t.tag != 14) continue;
                    cl = this.intersect(cl, this.closure(t));
                }
                return this.compoundMin(cl);
            }
        }
        List<Type> classes = List.of(this.arraySuperType());
        for (Type t : ts) {
            if (t.tag == 11) continue;
            classes = classes.prepend(t);
        }
        return this.lub(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type arraySuperType() {
        if (this.arraySuperType == null) {
            Types types = this;
            synchronized (types) {
                if (this.arraySuperType == null) {
                    this.arraySuperType = this.makeCompoundType(List.of(this.syms.serializableType, this.syms.cloneableType), this.syms.objectType);
                }
            }
        }
        return this.arraySuperType;
    }

    public Type glb(Type t, Type s) {
        if (s == null) {
            return t;
        }
        if (this.isSubtypeNoCapture(t, s)) {
            return t;
        }
        if (this.isSubtypeNoCapture(s, t)) {
            return s;
        }
        List<Type> closure = this.union(this.closure(t), this.closure(s));
        List<Type> bounds = this.closureMin(closure);
        if (bounds.isEmpty()) {
            return this.syms.objectType;
        }
        if (bounds.tail.isEmpty()) {
            return (Type)bounds.head;
        }
        int classCount = 0;
        for (Type bound : bounds) {
            if (bound.isInterface()) continue;
            ++classCount;
        }
        if (classCount > 1) {
            return this.syms.errType;
        }
        return this.makeCompoundType(bounds);
    }

    public static int hashCode(Type t) {
        return hashCode.visit(t);
    }

    public boolean resultSubtype(Type t, Type s, Warner warner) {
        List<Type> tvars = t.getTypeArguments();
        List<Type> svars = s.getTypeArguments();
        Type tres = t.getReturnType();
        Type sres = this.subst(s.getReturnType(), svars, tvars);
        return this.covariantReturnType(tres, sres, warner);
    }

    public boolean returnTypeSubstitutable(Type r1, Type r2) {
        if (this.hasSameArgs(r1, r2)) {
            return this.resultSubtype(r1, r2, Warner.noWarnings);
        }
        return this.covariantReturnType(r1.getReturnType(), this.erasure(r2.getReturnType()), Warner.noWarnings);
    }

    public boolean returnTypeSubstitutable(Type r1, Type r2, Type r2res, Warner warner) {
        if (this.isSameType(r1.getReturnType(), r2res)) {
            return true;
        }
        if (r1.getReturnType().isPrimitive() || r2res.isPrimitive()) {
            return false;
        }
        if (this.hasSameArgs(r1, r2)) {
            return this.covariantReturnType(r1.getReturnType(), r2res, warner);
        }
        if (!this.source.allowCovariantReturns()) {
            return false;
        }
        if (this.isSubtypeUnchecked(r1.getReturnType(), r2res, warner)) {
            return true;
        }
        if (!this.isSubtype(r1.getReturnType(), this.erasure(r2res))) {
            return false;
        }
        warner.warnUnchecked();
        return true;
    }

    public boolean covariantReturnType(Type t, Type s, Warner warner) {
        return this.isSameType(t, s) || this.source.allowCovariantReturns() && !t.isPrimitive() && !s.isPrimitive() && this.isAssignable(t, s, warner);
    }

    public Symbol.ClassSymbol boxedClass(Type t) {
        return this.reader.enterClass(this.syms.boxedName[t.tag]);
    }

    public Type unboxedType(Type t) {
        if (this.allowBoxing) {
            for (int i = 0; i < this.syms.boxedName.length; ++i) {
                Name box = this.syms.boxedName[i];
                if (box == null || this.asSuper(t, this.reader.enterClass(box)) == null) continue;
                return this.syms.typeOfTag[i];
            }
        }
        return Type.noType;
    }

    public Type capture(Type t) {
        if (t.tag != 10) {
            return t;
        }
        Type.ClassType cls = (Type.ClassType)t;
        if (cls.isRaw() || !cls.isParameterized()) {
            return cls;
        }
        Type.ClassType G = (Type.ClassType)((Symbol.TypeSymbol)cls.asElement()).asType();
        List<Type> A = G.getTypeArguments();
        List T = cls.getTypeArguments();
        List<Type> S = this.freshTypeVariables(T);
        List<Type> currentA = A;
        List currentT = T;
        List<Type> currentS = S;
        boolean captured = false;
        while (!(currentA.isEmpty() || currentT.isEmpty() || currentS.isEmpty())) {
            if (currentS.head != currentT.head) {
                captured = true;
                Type.WildcardType Ti = (Type.WildcardType)currentT.head;
                Type Ui = ((Type)currentA.head).getUpperBound();
                Type.CapturedType Si = (Type.CapturedType)currentS.head;
                if (Ui == null) {
                    Ui = this.syms.objectType;
                }
                switch (Ti.kind) {
                    case UNBOUND: {
                        Si.bound = this.subst(Ui, A, S);
                        Si.lower = this.syms.botType;
                        break;
                    }
                    case EXTENDS: {
                        Si.bound = this.glb(Ti.getExtendsBound(), this.subst(Ui, A, S));
                        Si.lower = this.syms.botType;
                        break;
                    }
                    case SUPER: {
                        Si.bound = this.subst(Ui, A, S);
                        Si.lower = Ti.getSuperBound();
                    }
                }
                if (Si.bound == Si.lower) {
                    currentS.head = Si.bound;
                }
            }
            currentA = currentA.tail;
            currentT = currentT.tail;
            currentS = currentS.tail;
        }
        if (!(currentA.isEmpty() && currentT.isEmpty() && currentS.isEmpty())) {
            return this.erasure(t);
        }
        if (captured) {
            return new Type.ClassType(cls.getEnclosingType(), S, cls.tsym);
        }
        return t;
    }

    private List<Type> freshTypeVariables(List<Type> types) {
        ListBuffer result = ListBuffer.lb();
        for (Type t : types) {
            if (t.tag == 15) {
                Type bound = ((Type.WildcardType)t).getExtendsBound();
                if (bound == null) {
                    bound = this.syms.objectType;
                }
                result.append(new Type.CapturedType(this.capturedName, this.syms.noSymbol, bound, this.syms.botType, (Type.WildcardType)t));
                continue;
            }
            result.append(t);
        }
        return result.toList();
    }

    private List<Type> upperBounds(List<Type> ss) {
        if (ss.isEmpty()) {
            return ss;
        }
        Type head = this.upperBound((Type)ss.head);
        List<Type> tail = this.upperBounds(ss.tail);
        if (head != ss.head || tail != ss.tail) {
            return tail.prepend(head);
        }
        return ss;
    }

    private boolean sideCast(Type from, Type to, Warner warn) {
        boolean reverse = false;
        Type target = to;
        if ((to.tsym.flags() & 0x200L) == 0L) {
            assert ((from.tsym.flags() & 0x200L) != 0L);
            reverse = true;
            to = from;
            from = target;
        }
        List<Type> commonSupers = this.superClosure(to, this.erasure(from));
        boolean giveWarning = commonSupers.isEmpty();
        while (commonSupers.nonEmpty()) {
            Type t1 = this.asSuper(from, ((Type)commonSupers.head).tsym);
            Type t2 = (Type)commonSupers.head;
            if (this.disjointTypes(t1.getTypeArguments(), t2.getTypeArguments())) {
                return false;
            }
            giveWarning = giveWarning || (reverse ? this.giveWarning(t2, t1) : this.giveWarning(t1, t2));
            commonSupers = commonSupers.tail;
        }
        if (giveWarning && !this.isReifiable(to)) {
            warn.warnUnchecked();
        }
        if (!this.source.allowCovariantReturns()) {
            this.chk.checkCompatibleAbstracts(warn.pos(), from, to);
        }
        return true;
    }

    private boolean sideCastFinal(Type from, Type to, Warner warn) {
        boolean reverse = false;
        Type target = to;
        if ((to.tsym.flags() & 0x200L) == 0L) {
            assert ((from.tsym.flags() & 0x200L) != 0L);
            reverse = true;
            to = from;
            from = target;
        }
        assert ((from.tsym.flags() & 0x10L) != 0L);
        Type t1 = this.asSuper(from, to.tsym);
        if (t1 == null) {
            return false;
        }
        Type t2 = to;
        if (this.disjointTypes(t1.getTypeArguments(), t2.getTypeArguments())) {
            return false;
        }
        if (!this.source.allowCovariantReturns()) {
            this.chk.checkCompatibleAbstracts(warn.pos(), from, to);
        }
        if (!this.isReifiable(target) && (reverse ? this.giveWarning(t2, t1) : this.giveWarning(t1, t2))) {
            warn.warnUnchecked();
        }
        return true;
    }

    private boolean giveWarning(Type from, Type to) {
        return to.isParameterized() && !this.containsType(to.getTypeArguments(), from.getTypeArguments());
    }

    private List<Type> superClosure(Type t, Type s) {
        List<Type> cl = List.nil();
        List<Type> l = this.interfaces(t);
        while (l.nonEmpty()) {
            cl = this.isSubtype(s, this.erasure((Type)l.head)) ? this.insert(cl, (Type)l.head) : this.union(cl, this.superClosure((Type)l.head, s));
            l = l.tail;
        }
        return cl;
    }

    private boolean containsTypeEquivalent(Type t, Type s) {
        return this.isSameType(t, s) || this.containsType(t, s) && this.containsType(s, t);
    }

    public void adapt(Type source, Type target, ListBuffer<Type> from, ListBuffer<Type> to) throws AdaptFailure {
        HashMap<Symbol, Type> mapping = new HashMap<Symbol, Type>();
        this.adaptRecursive(source, target, from, to, mapping);
        List<Type> fromList = from.toList();
        List<Type> toList = to.toList();
        while (!fromList.isEmpty()) {
            Type val = (Type)mapping.get(((Type)fromList.head).tsym);
            if (toList.head != val) {
                toList.head = val;
            }
            fromList = fromList.tail;
            toList = toList.tail;
        }
    }

    private void adaptRecursive(Type source, Type target, ListBuffer<Type> from, ListBuffer<Type> to, Map<Symbol, Type> mapping) throws AdaptFailure {
        if (source.tag == 14) {
            Type val = mapping.get(source.tsym);
            if (val != null) {
                if (val.isSuperBound() && target.isSuperBound()) {
                    val = this.isSubtype(this.lowerBound(val), this.lowerBound(target)) ? target : val;
                } else if (val.isExtendsBound() && target.isExtendsBound()) {
                    val = this.isSubtype(this.upperBound(val), this.upperBound(target)) ? val : target;
                } else if (!this.isSameType(val, target)) {
                    throw new AdaptFailure();
                }
            } else {
                val = target;
                from.append(source);
                to.append(target);
            }
            mapping.put(source.tsym, val);
        } else if (source.tag == target.tag) {
            switch (source.tag) {
                case 10: {
                    this.adapt(source.allparams(), target.allparams(), from, to, mapping);
                    break;
                }
                case 11: {
                    this.adaptRecursive(this.elemtype(source), this.elemtype(target), from, to, mapping);
                    break;
                }
                case 15: {
                    if (source.isExtendsBound()) {
                        this.adaptRecursive(this.upperBound(source), this.upperBound(target), from, to, mapping);
                        break;
                    }
                    if (!source.isSuperBound()) break;
                    this.adaptRecursive(this.lowerBound(source), this.lowerBound(target), from, to, mapping);
                }
            }
        }
    }

    private void adapt(List<Type> source, List<Type> target, ListBuffer<Type> from, ListBuffer<Type> to, Map<Symbol, Type> mapping) throws AdaptFailure {
        if (source.length() == target.length()) {
            while (source.nonEmpty()) {
                this.adaptRecursive((Type)source.head, (Type)target.head, from, to, mapping);
                source = source.tail;
                target = target.tail;
            }
        }
    }

    private void adaptSelf(Type t, ListBuffer<Type> from, ListBuffer<Type> to) {
        try {
            this.adapt(t.tsym.type, t, from, to);
        }
        catch (AdaptFailure ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private Type rewriteQuantifiers(Type t, boolean high, boolean rewriteTypeVars) {
        ListBuffer<Type> from = new ListBuffer<Type>();
        ListBuffer<Type> to = new ListBuffer<Type>();
        this.adaptSelf(t, from, to);
        ListBuffer<Type> rewritten = new ListBuffer<Type>();
        List<Type> formals = from.toList();
        boolean changed = false;
        for (Type arg : to.toList()) {
            Type bound;
            if (rewriteTypeVars && arg.tag == 14) {
                Type.TypeVar tv = (Type.TypeVar)arg;
                bound = high ? tv.bound : this.syms.botType;
            } else {
                bound = high ? this.upperBound(arg) : this.lowerBound(arg);
            }
            Type newarg = bound;
            if (arg != bound) {
                changed = true;
                newarg = high ? this.makeExtendsWildcard(bound, (Type.TypeVar)formals.head) : this.makeSuperWildcard(bound, (Type.TypeVar)formals.head);
            }
            rewritten.append(newarg);
            formals = formals.tail;
        }
        if (changed) {
            return this.subst(t.tsym.type, from.toList(), rewritten.toList());
        }
        return t;
    }

    private Type.WildcardType makeExtendsWildcard(Type bound, Type.TypeVar formal) {
        if (bound == this.syms.objectType) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, formal);
        }
        return new Type.WildcardType(bound, BoundKind.EXTENDS, this.syms.boundClass, formal);
    }

    private Type.WildcardType makeSuperWildcard(Type bound, Type.TypeVar formal) {
        if (bound.tag == 17) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, formal);
        }
        return new Type.WildcardType(bound, BoundKind.SUPER, this.syms.boundClass, formal);
    }

    public static class AdaptFailure
    extends Exception {
        static final long serialVersionUID = -7490231548272701566L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DefaultTypeVisitor<R, S>
    implements Type.Visitor<R, S> {
        public final R visit(Type t, S s) {
            return t.accept(this, s);
        }

        @Override
        public R visitClassType(Type.ClassType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitWildcardType(Type.WildcardType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitArrayType(Type.ArrayType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitMethodType(Type.MethodType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitPackageType(Type.PackageType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitTypeVar(Type.TypeVar t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitCapturedType(Type.CapturedType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitForAll(Type.ForAll t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitErrorType(Type.ErrorType t, S s) {
            return this.visitType(t, s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapVisitor<S>
    extends DefaultTypeVisitor<Type, S> {
        public final Type visit(Type t) {
            return (Type)t.accept(this, null);
        }

        @Override
        public Type visitType(Type t, S s) {
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SimpleVisitor<R, S>
    extends DefaultTypeVisitor<R, S> {
        @Override
        public R visitCapturedType(Type.CapturedType t, S s) {
            return this.visitTypeVar(t, s);
        }

        @Override
        public R visitForAll(Type.ForAll t, S s) {
            return this.visit(t.qtype, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar t, S s) {
            return this.visit(t.qtype, s);
        }
    }

    class SingletonType {
        final Type t;

        SingletonType(Type t) {
            this.t = t;
        }

        public int hashCode() {
            return Types.hashCode(this.t);
        }

        public boolean equals(Object obj) {
            return obj instanceof SingletonType && Types.this.isSameType(this.t, ((SingletonType)obj).t);
        }

        public String toString() {
            return this.t.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Subst
    extends UnaryVisitor<Type> {
        List<Type> from;
        List<Type> to;

        public Subst(List<Type> from, List<Type> to) {
            int fromLength;
            int toLength = to.length();
            for (fromLength = from.length(); fromLength > toLength; --fromLength) {
                from = from.tail;
            }
            while (fromLength < toLength) {
                --toLength;
                to = to.tail;
            }
            this.from = from;
            this.to = to;
        }

        Type subst(Type t) {
            if (this.from.tail == null) {
                return t;
            }
            return (Type)this.visit(t);
        }

        List<Type> subst(List<Type> ts) {
            if (this.from.tail == null) {
                return ts;
            }
            boolean wild = false;
            if (ts.nonEmpty() && this.from.nonEmpty()) {
                Type head1 = this.subst((Type)ts.head);
                List<Type> tail1 = this.subst(ts.tail);
                if (head1 != ts.head || tail1 != ts.tail) {
                    return tail1.prepend(head1);
                }
            }
            return ts;
        }

        @Override
        public Type visitType(Type t, Void ignored) {
            return t;
        }

        @Override
        public Type visitMethodType(Type.MethodType t, Void ignored) {
            List<Type> argtypes = this.subst(t.argtypes);
            Type restype = this.subst(t.restype);
            List<Type> thrown = this.subst(t.thrown);
            if (argtypes == t.argtypes && restype == t.restype && thrown == t.thrown) {
                return t;
            }
            return new Type.MethodType(argtypes, restype, thrown, t.tsym);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            List<Type> from = this.from;
            List<Type> to = this.to;
            while (from.nonEmpty()) {
                if (t == from.head) {
                    return ((Type)to.head).withTypeVar(t);
                }
                from = from.tail;
                to = to.tail;
            }
            return t;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            if (!t.isCompound()) {
                java.util.List typarams = t.getTypeArguments();
                List<Type> typarams1 = this.subst((List<Type>)typarams);
                Type outer = t.getEnclosingType();
                Type outer1 = this.subst(outer);
                if (typarams1 == typarams && outer1 == outer) {
                    return t;
                }
                return new Type.ClassType(outer1, typarams1, t.tsym);
            }
            Type st = this.subst(Types.this.supertype(t));
            List is = Types.this.upperBounds(this.subst(Types.this.interfaces(t)));
            if (st == Types.this.supertype(t) && is == Types.this.interfaces(t)) {
                return t;
            }
            return Types.this.makeCompoundType(is.prepend(st));
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void ignored) {
            Type bound = t.type;
            if (t.kind != BoundKind.UNBOUND) {
                bound = this.subst(bound);
            }
            if (bound == t.type) {
                return t;
            }
            if (t.isExtendsBound() && bound.isExtendsBound()) {
                bound = Types.this.upperBound(bound);
            }
            return new Type.WildcardType(bound, t.kind, Types.this.syms.boundClass, t.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void ignored) {
            Type elemtype = this.subst(t.elemtype);
            if (elemtype == t.elemtype) {
                return t;
            }
            return new Type.ArrayType(Types.this.upperBound(elemtype), t.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll t, Void ignored) {
            List<Type> tvars1 = Types.this.substBounds(t.tvars, this.from, this.to);
            Type qtype1 = this.subst(t.qtype);
            if (tvars1 == t.tvars && qtype1 == t.qtype) {
                return t;
            }
            if (tvars1 == t.tvars) {
                return new Type.ForAll(tvars1, qtype1);
            }
            return new Type.ForAll(tvars1, Types.this.subst(qtype1, t.tvars, tvars1));
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    }

    class TypePair {
        final Type t1;
        final Type t2;

        TypePair(Type t1, Type t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            return 127 * Types.hashCode(this.t1) + Types.hashCode(this.t2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair typePair = (TypePair)obj;
            return Types.this.isSameType(this.t1, typePair.t1) && Types.this.isSameType(this.t2, typePair.t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TypeRelation
    extends SimpleVisitor<Boolean, Type> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class UnaryVisitor<R>
    extends SimpleVisitor<R, Void> {
        public final R visit(Type t) {
            return t.accept(this, null);
        }
    }
}

