/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.util.Version;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JavacRoundEnvironment.java\t1.7 06/08/03")
public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean processingOver, boolean errorRaised, Set<? extends Element> rootElements, ProcessingEnvironment processingEnv) {
        this.processingOver = processingOver;
        this.errorRaised = errorRaised;
        this.rootElements = rootElements;
        this.processingEnv = processingEnv;
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        Set result = Collections.emptySet();
        if (a.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        TypeMirror tm = a.asType();
        if (!(tm instanceof DeclaredType)) {
            throw new AssertionError((Object)("Bad implementation type for " + tm));
        }
        DeclaredType annotationTypeElement = (DeclaredType)a.asType();
        AnnotationSetScanner scanner = new AnnotationSetScanner(result);
        for (Element element : this.rootElements) {
            result = (Set)((ElementScanner6)scanner).scan(element, annotationTypeElement);
        }
        return result;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        if (!a.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        String name = a.getCanonicalName();
        if (name == null) {
            return Collections.emptySet();
        }
        TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(name);
        if (annotationType == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(annotationType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationSetScanner
    extends ElementScanner6<Set<Element>, DeclaredType> {
        Set<Element> annotatedElements;

        AnnotationSetScanner(Set<Element> defaultSet) {
            super(defaultSet);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> scan(Element e, DeclaredType p) {
            List<? extends AnnotationMirror> annotationMirrors = JavacRoundEnvironment.this.processingEnv.getElementUtils().getAllAnnotationMirrors(e);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!annotationMirror.getAnnotationType().equals(p)) continue;
                this.annotatedElements.add(e);
            }
            e.accept(this, p);
            return this.annotatedElements;
        }
    }
}

