/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Version;
import java.util.HashSet;
import java.util.Set;
import javax.tools.JavaFileObject;

@Version(value="@(#)MandatoryWarningHandler.java\t1.8 06/02/28")
public class MandatoryWarningHandler {
    private Log log;
    private boolean verbose;
    private String prefix;
    private Set<JavaFileObject> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private JavaFileObject deferredDiagnosticSource;
    private Object deferredDiagnosticArg;

    public MandatoryWarningHandler(Log log, boolean verbose, String prefix) {
        this.log = log;
        this.verbose = verbose;
        this.prefix = prefix;
    }

    public void report(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        JavaFileObject currentSource = this.log.currentSource();
        if (this.verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<JavaFileObject>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.log.mandatoryWarning(pos, msg, args);
                this.sourcesWithReportedWarnings.add(currentSource);
            } else if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(currentSource) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticSource = currentSource;
                this.deferredDiagnosticArg = currentSource;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || MandatoryWarningHandler.equal(this.deferredDiagnosticSource, currentSource))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticSource = currentSource;
            this.deferredDiagnosticArg = currentSource;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !MandatoryWarningHandler.equal(this.deferredDiagnosticSource, currentSource)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
    }

    public void reportDeferredDiagnostic() {
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                this.log.mandatoryNote(this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
            } else {
                this.log.mandatoryNote(this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.verbose) {
                this.log.mandatoryNote(this.prefix + ".recompile", new Object[0]);
            }
        }
    }

    private static boolean equal(Object o1, Object o2) {
        return o1 == null || o2 == null ? o1 == o2 : o1.equals(o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private String value;

        private DeferredDiagnosticKind(String v) {
            this.value = v;
        }

        String getKey(String prefix) {
            return prefix + this.value;
        }
    }
}

