/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.AntSettings;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class AntCustomizer
extends JPanel
implements ActionListener {
    private List<File> classpath;
    private Map<String, String> properties;
    private boolean changed = false;
    private boolean listen = false;
    private File originalAntHome;
    private boolean initialized = false;
    private JButton bAntHome;
    private JButton bAntHomeDefault;
    private JButton bClasspath;
    private JButton bProperties;
    private JCheckBox cbAlwaysShowOutput;
    private JCheckBox cbReuseOutput;
    private JCheckBox cbSaveFiles;
    private JComboBox cbVerbosity;
    private JLabel lAntVersion;
    private JTextField tfAntHome;

    public AntCustomizer() {
        this.initComponents();
        this.bAntHome.addActionListener(this);
        ((DefaultComboBoxModel)this.cbVerbosity.getModel()).removeAllElements();
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_warn"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_info"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_verbose"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_debug"));
        this.bProperties.addActionListener(this);
        this.bClasspath.addActionListener(this);
        this.cbSaveFiles.addActionListener(this);
        this.cbReuseOutput.addActionListener(this);
        this.cbAlwaysShowOutput.addActionListener(this);
        this.cbVerbosity.addActionListener(this);
    }

    void update() {
        this.listen = false;
        this.classpath = AntSettings.getExtraClasspath();
        this.properties = AntSettings.getProperties();
        this.originalAntHome = AntSettings.getAntHome();
        this.tfAntHome.setText(this.originalAntHome != null ? this.originalAntHome.toString() : null);
        this.cbSaveFiles.setSelected(AntSettings.getSaveAll());
        this.cbReuseOutput.setSelected(AntSettings.getAutoCloseTabs());
        this.cbAlwaysShowOutput.setSelected(AntSettings.getAlwaysShowOutput());
        this.cbVerbosity.setSelectedIndex(AntSettings.getVerbosity() - 1);
        this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
        this.changed = false;
        this.initialized = true;
        this.listen = true;
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        String antHome = this.tfAntHome.getText().trim();
        AntSettings.setAntHome(new File(antHome));
        if (AntSettings.getAutoCloseTabs() != this.cbReuseOutput.isSelected()) {
            AntSettings.setAutoCloseTabs(this.cbReuseOutput.isSelected());
        }
        if (AntSettings.getSaveAll() != this.cbSaveFiles.isSelected()) {
            AntSettings.setSaveAll(this.cbSaveFiles.isSelected());
        }
        if (AntSettings.getAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected()) {
            AntSettings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        }
        if (AntSettings.getVerbosity() != this.cbVerbosity.getSelectedIndex() + 1) {
            AntSettings.setVerbosity(this.cbVerbosity.getSelectedIndex() + 1);
        }
        if (!((Object)AntSettings.getProperties()).equals(this.properties)) {
            AntSettings.setProperties(this.properties);
        }
        if (!((Object)AntSettings.getExtraClasspath()).equals(this.classpath)) {
            AntSettings.setExtraClasspath(this.classpath);
        }
        this.changed = false;
    }

    void cancel() {
        if (AntSettings.getAntHome() != this.originalAntHome) {
            AntSettings.setAntHome(this.originalAntHome);
        }
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        Object o = e.getSource();
        if (o == this.cbAlwaysShowOutput) {
            this.changed = true;
        } else if (o == this.cbReuseOutput) {
            this.changed = true;
        } else if (o == this.cbSaveFiles) {
            this.changed = true;
        } else if (o == this.cbVerbosity) {
            this.changed = true;
        } else if (o == this.bAntHome) {
            JFileChooser chooser = new JFileChooser(this.tfAntHome.getText());
            chooser.setFileSelectionMode(1);
            int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(AntCustomizer.class, (String)"Select_Directory"));
            if (r == 0) {
                File file = chooser.getSelectedFile();
                if (!new File(new File(file, "lib"), "ant.jar").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntCustomizer.class, (String)"Not_a_ant_home", (Object)file), 2));
                    return;
                }
                this.tfAntHome.setText(file.getAbsolutePath());
                AntSettings.setAntHome(file);
                this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
                this.changed = true;
            }
        } else if (o == this.bClasspath) {
            PropertyEditor editor = PropertyEditorManager.findEditor(NbClassPath.class);
            editor.setValue(new NbClassPath(this.classpath.toArray(new File[this.classpath.size()])));
            Component customEditor = editor.getCustomEditor();
            DialogDescriptor dd = new DialogDescriptor((Object)customEditor, NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
                String cp = ((NbClassPath)editor.getValue()).getClassPath();
                if (cp.startsWith("\"") && cp.endsWith("\"")) {
                    cp = cp.substring(1, cp.length() - 1);
                }
                this.classpath = new ArrayList<File>();
                for (String f : cp.split(Pattern.quote(File.pathSeparator))) {
                    this.classpath.add(new File(f));
                }
                this.changed = true;
            }
        } else if (o == this.bProperties) {
            PropertyEditor editor = PropertyEditorManager.findEditor(Properties.class);
            Properties p = new Properties();
            p.putAll(this.properties);
            editor.setValue(p);
            Component customEditor = editor.getCustomEditor();
            DialogDescriptor dd = new DialogDescriptor((Object)customEditor, NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            if (dd.getValue() == NotifyDescriptor.OK_OPTION) {
                this.properties = NbCollections.checkedMapByCopy((Map)((Properties)editor.getValue()), String.class, String.class, (boolean)true);
                this.changed = true;
            }
        }
    }

    private void initComponents() {
        JLabel antHomeLabel = new JLabel();
        this.tfAntHome = new JTextField();
        this.bAntHome = new JButton();
        this.bAntHomeDefault = new JButton();
        this.lAntVersion = new JLabel();
        this.cbSaveFiles = new JCheckBox();
        this.cbReuseOutput = new JCheckBox();
        this.cbAlwaysShowOutput = new JCheckBox();
        this.cbVerbosity = new JComboBox();
        JLabel verbosityLabel = new JLabel();
        JPanel propertiesPanel = new JPanel();
        JLabel propertiesLabel = new JLabel();
        this.bProperties = new JButton();
        JPanel classpathPanel = new JPanel();
        JLabel classpathLabel = new JLabel();
        this.bClasspath = new JButton();
        this.setBackground(Color.white);
        antHomeLabel.setLabelFor(this.tfAntHome);
        Mnemonics.setLocalizedText((JLabel)antHomeLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHome, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Button"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHomeDefault, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Default_Button"));
        this.bAntHomeDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AntCustomizer.this.bAntHomeDefaultActionPerformed(evt);
            }
        });
        this.lAntVersion.setBackground(Color.white);
        Mnemonics.setLocalizedText((JLabel)this.lAntVersion, (String)"<Ant version here...>");
        this.cbSaveFiles.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSaveFiles, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Save_Files"));
        this.cbSaveFiles.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSaveFiles.setMargin(new Insets(0, 0, 0, 0));
        this.cbReuseOutput.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Reuse_Output"));
        this.cbReuseOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbReuseOutput.setMargin(new Insets(0, 0, 0, 0));
        this.cbAlwaysShowOutput.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAlwaysShowOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Always_Show_Output"));
        this.cbAlwaysShowOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAlwaysShowOutput.setMargin(new Insets(0, 0, 0, 0));
        this.cbVerbosity.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal"}));
        verbosityLabel.setLabelFor(this.cbVerbosity);
        Mnemonics.setLocalizedText((JLabel)verbosityLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Verbosity"));
        propertiesPanel.setBackground(Color.white);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Panel")));
        Mnemonics.setLocalizedText((JLabel)propertiesLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Text_Area"));
        Mnemonics.setLocalizedText((AbstractButton)this.bProperties, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Button"));
        GroupLayout propertiesPanelLayout = new GroupLayout((Container)propertiesPanel);
        propertiesPanel.setLayout((LayoutManager)propertiesPanelLayout);
        propertiesPanelLayout.setHorizontalGroup((GroupLayout.Group)propertiesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)propertiesPanelLayout.createSequentialGroup().addContainerGap().add((Component)propertiesLabel).addPreferredGap(0, 25, Short.MAX_VALUE).add((Component)this.bProperties).addContainerGap()));
        propertiesPanelLayout.setVerticalGroup((GroupLayout.Group)propertiesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)propertiesPanelLayout.createSequentialGroup().add((GroupLayout.Group)propertiesPanelLayout.createParallelGroup(1).add((Component)propertiesLabel).add((Component)this.bProperties)).addContainerGap(-1, Short.MAX_VALUE)));
        classpathPanel.setBackground(Color.white);
        classpathPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Panel")));
        Mnemonics.setLocalizedText((JLabel)classpathLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Text_Area"));
        Mnemonics.setLocalizedText((AbstractButton)this.bClasspath, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Button"));
        GroupLayout classpathPanelLayout = new GroupLayout((Container)classpathPanel);
        classpathPanel.setLayout((LayoutManager)classpathPanelLayout);
        classpathPanelLayout.setHorizontalGroup((GroupLayout.Group)classpathPanelLayout.createParallelGroup(1).add((GroupLayout.Group)classpathPanelLayout.createSequentialGroup().addContainerGap().add((Component)classpathLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.bClasspath).addContainerGap()));
        classpathPanelLayout.setVerticalGroup((GroupLayout.Group)classpathPanelLayout.createParallelGroup(3).add((Component)classpathLabel).add((Component)this.bClasspath));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)propertiesPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)antHomeLabel).add((Component)verbosityLabel)).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbAlwaysShowOutput).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lAntVersion, -1, 473, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbVerbosity, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbReuseOutput).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbSaveFiles).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tfAntHome, -1, 291, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bAntHome).addPreferredGap(0).add((Component)this.bAntHomeDefault))))).add((Component)classpathPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3, false).add((Component)antHomeLabel).add((Component)this.bAntHomeDefault).add((Component)this.bAntHome).add((Component)this.tfAntHome, -2, -1, -2)).addPreferredGap(0).add((Component)this.lAntVersion, -2, 15, -2).addPreferredGap(0).add((Component)this.cbSaveFiles).addPreferredGap(0).add((Component)this.cbReuseOutput).addPreferredGap(0).add((Component)this.cbAlwaysShowOutput).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cbVerbosity, -2, -1, -2).add((Component)verbosityLabel)).addPreferredGap(0).add((Component)propertiesPanel, -2, -1, -2).addPreferredGap(0).add((Component)classpathPanel, -2, 59, -2).addContainerGap()));
    }

    private void bAntHomeDefaultActionPerformed(ActionEvent evt) {
        AntSettings.setAntHome(null);
        File antHome = AntSettings.getAntHome();
        if (antHome != null) {
            this.tfAntHome.setText(antHome.getAbsolutePath());
        } else {
            this.tfAntHome.setText(null);
        }
        this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
        this.changed = true;
    }
}

