/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.spi.AutomaticExtraClasspathProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntSettings {
    private static final String PROP_VERBOSITY = "verbosity";
    private static final String PROP_PROPERTIES = "properties";
    private static final String PROP_SAVE_ALL = "saveAll";
    private static final String PROP_CUSTOM_DEFS = "customDefs";
    private static final String PROP_ANT_VERSION = "antVersion";
    public static final String PROP_ANT_HOME = "antHome";
    public static final String PROP_EXTRA_CLASSPATH = "extraClasspath";
    public static final String PROP_AUTOMATIC_EXTRA_CLASSPATH = "automaticExtraClasspath";
    private static final String PROP_AUTO_CLOSE_TABS = "autoCloseTabs";
    private static final String PROP_ALWAYS_SHOW_OUTPUT = "alwaysShowOutput";
    private static IntrospectedInfo customDefs;
    private static String antVersion;
    private static File defaultAntHome;
    private static List<File> defAECP;
    private static Lookup.Result<AutomaticExtraClasspathProvider> aecpResult;
    private static final PropertyChangeSupport pcs;

    private AntSettings() {
    }

    private static Preferences prefs() {
        return NbPreferences.forModule(AntSettings.class);
    }

    public static int getVerbosity() {
        return AntSettings.prefs().getInt(PROP_VERBOSITY, 2);
    }

    public static void setVerbosity(int v) {
        AntSettings.prefs().putInt(PROP_VERBOSITY, v);
    }

    public static Map<String, String> getProperties() {
        HashMap<String, String> p = new HashMap<String, String>();
        for (String pair : AntSettings.prefs().get(PROP_PROPERTIES, "build.compiler.emacs=true").split("\n")) {
            String[] nameval = pair.split("=", 2);
            p.put(nameval[0], nameval[1]);
        }
        return p;
    }

    public static void setProperties(Map<String, String> p) {
        if (!(p instanceof SortedMap)) {
            p = new TreeMap<String, String>(p);
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> pair : p.entrySet()) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(pair.getKey());
            b.append('=');
            b.append(pair.getValue());
        }
        AntSettings.prefs().put(PROP_PROPERTIES, b.toString());
    }

    public static boolean getSaveAll() {
        return AntSettings.prefs().getBoolean(PROP_SAVE_ALL, true);
    }

    public static void setSaveAll(boolean sa) {
        AntSettings.prefs().putBoolean(PROP_SAVE_ALL, sa);
    }

    public static synchronized IntrospectedInfo getCustomDefs() {
        if (customDefs == null) {
            customDefs = IntrospectedInfoSerializer.instance.load(AntSettings.prefs().node(PROP_CUSTOM_DEFS));
        }
        return customDefs;
    }

    public static synchronized void setCustomDefs(IntrospectedInfo ii) {
        IntrospectedInfoSerializer.instance.store(AntSettings.prefs().node(PROP_CUSTOM_DEFS), ii);
        customDefs = ii;
    }

    public static String getAntVersion() {
        if (antVersion == null) {
            antVersion = AntBridge.getInterface().getAntVersion();
        }
        return antVersion;
    }

    private static synchronized File getDefaultAntHome() {
        if (defaultAntHome == null) {
            File antJar = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (antJar == null) {
                return null;
            }
            defaultAntHome = antJar.getParentFile().getParentFile();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("getDefaultAntHome: " + defaultAntHome);
            }
        }
        assert (defaultAntHome != null);
        return defaultAntHome;
    }

    public static File getAntHome() {
        String h = AntSettings.prefs().get(PROP_ANT_HOME, null);
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("getAntHomeWithDefault: antHome=" + h);
        }
        if (h != null) {
            return new File(h);
        }
        return AntSettings.getDefaultAntHome();
    }

    public static void setAntHome(File f) {
        if (f != null && f.equals(AntSettings.getDefaultAntHome())) {
            f = null;
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("setAntHome: " + f);
        }
        if (f != null) {
            AntSettings.prefs().put(PROP_ANT_HOME, f.getAbsolutePath());
        } else {
            AntSettings.prefs().remove(PROP_ANT_HOME);
        }
        antVersion = null;
        AntSettings.firePropertyChange(PROP_ANT_HOME);
    }

    public static List<File> getExtraClasspath() {
        ArrayList<File> files = new ArrayList<File>();
        for (String f : AntSettings.prefs().get(PROP_EXTRA_CLASSPATH, "").split(Pattern.quote(File.pathSeparator))) {
            files.add(new File(f));
        }
        return files;
    }

    public static void setExtraClasspath(List<File> p) {
        StringBuilder b = new StringBuilder();
        for (File f : p) {
            if (b.length() > 0) {
                b.append(File.pathSeparatorChar);
            }
            b.append(f);
        }
        AntSettings.prefs().put(PROP_EXTRA_CLASSPATH, b.toString());
        AntSettings.firePropertyChange(PROP_EXTRA_CLASSPATH);
    }

    public static synchronized List<File> getAutomaticExtraClasspath() {
        if (aecpResult == null) {
            aecpResult = Lookup.getDefault().lookupResult(AutomaticExtraClasspathProvider.class);
            aecpResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    defAECP = null;
                    AntSettings.firePropertyChange(AntSettings.PROP_AUTOMATIC_EXTRA_CLASSPATH);
                }
            });
        }
        if (defAECP == null) {
            defAECP = new ArrayList<File>();
            for (AutomaticExtraClasspathProvider provider : aecpResult.allInstances()) {
                defAECP.addAll(Arrays.asList(provider.getClasspathItems()));
            }
        }
        return defAECP;
    }

    public static boolean getAutoCloseTabs() {
        return AntSettings.prefs().getBoolean(PROP_AUTO_CLOSE_TABS, true);
    }

    public static void setAutoCloseTabs(boolean b) {
        AntSettings.prefs().putBoolean(PROP_AUTO_CLOSE_TABS, b);
    }

    public static boolean getAlwaysShowOutput() {
        return AntSettings.prefs().getBoolean(PROP_ALWAYS_SHOW_OUTPUT, false);
    }

    public static void setAlwaysShowOutput(boolean b) {
        AntSettings.prefs().putBoolean(PROP_ALWAYS_SHOW_OUTPUT, b);
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        pcs.addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        pcs.removePropertyChangeListener(l);
    }

    private static void firePropertyChange(String prop) {
        pcs.firePropertyChange(prop, null, null);
    }

    static {
        new IntrospectedInfo();
        defaultAntHome = null;
        defAECP = null;
        aecpResult = null;
        pcs = new PropertyChangeSupport(AntSettings.class);
    }

    public static abstract class IntrospectedInfoSerializer {
        public static IntrospectedInfoSerializer instance;

        public abstract IntrospectedInfo load(Preferences var1);

        public abstract void store(Preferences var1, IntrospectedInfo var2);
    }
}

