/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AuxClassLoader
extends AntBridge.AllPermissionURLClassLoader {
    private final ClassLoader nbLoader;

    private static boolean masked(String name) {
        return name.startsWith("org.apache.tools.") && !name.startsWith("org.apache.tools.ant.module.");
    }

    public AuxClassLoader(ClassLoader nbLoader, ClassLoader antLoader, URL extraJar) {
        super(new URL[]{extraJar}, antLoader);
        this.nbLoader = nbLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!AuxClassLoader.masked(name)) {
            try {
                return this.nbLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            return super.findClass(name);
        }
        catch (UnsupportedClassVersionError e) {
            Exceptions.attachMessage((Throwable)e, (String)("loading: " + name));
            throw e;
        }
    }

    @Override
    public URL findResource(String name) {
        URL u;
        if (!AuxClassLoader.masked(name) && (u = this.nbLoader.getResource(name)) != null) {
            return u;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(this.nbLoader.getResources(name), super.findResources(name)));
    }
}

