/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.tools.ant.module.AntModule;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Hyperlink
implements OutputListener {
    static final Set<Hyperlink> hyperlinks = new WeakSet();
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private Line liveLine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hyperlink(URL url, String message, int line1, int col1, int line2, int col2) {
        this.url = url;
        this.message = message;
        this.line1 = line1;
        this.col1 = col1;
        this.line2 = line2;
        this.col2 = col2;
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int col1) {
        if (this.col1 == -1) {
            this.col1 = col1;
        }
    }

    public void outputLineAction(OutputEvent ev) {
        block10: {
            FileObject file = URLMapper.findFileObject((URL)this.url);
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (this.line1 == -1) {
                        ed.open();
                        break block10;
                    }
                    ed.openDocument();
                    AntModule.err.log("opened document for " + file);
                    try {
                        Line line = this.updateLines(ed);
                        if (line.isDeleted()) break block10;
                        if (this.col1 == -1) {
                            line.show(4);
                            break block10;
                        }
                        line.show(4, this.col1 - 1);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block10;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }
        if (this.message != null) {
            StatusDisplayer.getDefault().setStatusText(this.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line updateLines(EditorCookie ed) {
        Line.Set lineset = ed.getLineSet();
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            assert (this.line1 != -1);
            boolean ran = false;
            boolean encounteredThis = false;
            boolean modifiedThis = false;
            if (this.liveLine == null) {
                ran = true;
                for (Hyperlink h : hyperlinks) {
                    if (h == this) {
                        encounteredThis = true;
                    }
                    if (h.liveLine != null || !h.url.equals(this.url) || h.line1 == -1) continue;
                    Line l = lineset.getOriginal(h.line1 - 1);
                    assert (l != null) : h;
                    h.liveLine = l;
                    if (h != this) continue;
                    modifiedThis = true;
                }
            }
            assert (this.liveLine != null) : "this=" + this + " ran=" + ran + " encounteredThis=" + encounteredThis + " modifiedThis=" + modifiedThis + " hyperlinks=" + hyperlinks + " hyperlinks.contains(this)=" + hyperlinks.contains(this);
            return this.liveLine;
        }
    }

    public void outputLineSelected(OutputEvent ev) {
        FileObject file = URLMapper.findFileObject((URL)this.url);
        if (file == null) {
            return;
        }
        try {
            DataObject dob = DataObject.find((FileObject)file);
            EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
            if (ed != null) {
                Line line;
                if (ed.getDocument() == null) {
                    AntModule.err.log("no document for " + file);
                    return;
                }
                AntModule.err.log("got document for " + file);
                if (this.line1 != -1 && !(line = this.updateLines(ed)).isDeleted()) {
                    if (this.col1 == -1) {
                        line.show(0);
                    } else {
                        line.show(0, this.col1 - 1);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify(16, (Throwable)donfe);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputLineCleared(OutputEvent ev) {
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            this.liveLine = null;
        }
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

