/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;

public final class StandardLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(StandardLogger.class.getName());
    private static final Pattern CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    private static final Pattern CWD_ENTER = Pattern.compile(".*Entering directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern CWD_LEAVE = Pattern.compile(".*Leaving directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern HYPERLINK = Pattern.compile("\"?(.+?)\"?(?::|, line )(?:(\\d+):(?:(\\d+):(?:(\\d+):(\\d+):)?)?)? +(.+)");
    private final long mockTotalTime;

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long mockTotalTime) {
        this.mockTotalTime = mockTotalTime;
    }

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession session) {
        int verb = session.getVerbosity();
        assert (verb >= 0 && verb <= 4) : verb;
        int[] levels = new int[verb + 1];
        for (int i = 0; i <= verb; ++i) {
            levels[i] = i;
        }
        return levels;
    }

    private SessionData getSessionData(AntSession session) {
        SessionData data = (SessionData)session.getCustomData(this);
        if (data == null) {
            data = new SessionData();
            session.putCustomData(this, data);
        }
        return data;
    }

    public void buildInitializationFailed(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Throwable t = event.getException();
        if (event.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(t, event);
        } else {
            event.getSession().println(t.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
        event.consume();
    }

    private static void deliverBlockOfTextAsLines(String lines, AntEvent originalEvent, int level) {
        StringTokenizer tok = new StringTokenizer(lines, "\r\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            originalEvent.getSession().deliverMessageLogged(originalEvent, line, level);
        }
    }

    private static void deliverStackTrace(Throwable t, AntEvent originalEvent) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        StandardLogger.deliverBlockOfTextAsLines(sw.toString(), originalEvent, 0);
    }

    public void buildStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        this.getSessionData((AntSession)event.getSession()).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_running_ant", (Object)event.getSession().getDisplayName()));
        event.consume();
    }

    public void buildFinished(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        AntSession session = event.getSession();
        Throwable t = event.getException();
        long time = System.currentTimeMillis() - this.getSessionData((AntSession)session).startTime;
        if (this.mockTotalTime != 0L) {
            time = this.mockTotalTime;
        }
        if (t == null) {
            session.println(StandardLogger.formatMessageWithTime("FMT_finished_target_printed", time), false, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_finished_target_status", (Object)session.getDisplayName()));
        } else {
            if (t.getCause() instanceof ThreadDeath) {
                t = t.getCause();
            }
            if (!session.isExceptionConsumed(t)) {
                session.consumeException(t);
                if (t.getClass().getName().equals("org.apache.tools.ant.BuildException") && session.getVerbosity() < 3) {
                    String msg = t.toString();
                    StandardLogger.deliverBlockOfTextAsLines(msg, event, 0);
                } else if (!(t instanceof ThreadDeath) || event.getSession().getVerbosity() >= 3) {
                    StandardLogger.deliverStackTrace(t, event);
                }
            }
            if (t instanceof ThreadDeath) {
                event.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_stopped_printed", time), true, null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_stopped_status", (Object)event.getSession().getDisplayName()));
            } else {
                event.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_failed_printed", time), true, null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
            }
        }
        event.consume();
    }

    private static String formatMessageWithTime(String key, long millis) {
        int secs = (int)(millis / 1000L);
        int minutes = secs / 60;
        int seconds = secs % 60;
        return NbBundle.getMessage(StandardLogger.class, (String)key, (Object)new Integer(minutes), (Object)new Integer(seconds));
    }

    public void targetStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        String name = event.getTargetName();
        if (name != null) {
            int minlevel;
            int n = minlevel = name.length() > 0 && name.charAt(0) == '-' ? 3 : 2;
            if (event.getSession().getVerbosity() >= minlevel) {
                event.getSession().println(NbBundle.getMessage(StandardLogger.class, (String)"MSG_target_started_printed", (Object)name), false, null);
            }
        }
        event.consume();
    }

    public void messageLogged(AntEvent event) {
        OutputListener hyperlink;
        Stack<File> stack;
        File d;
        if (event.isConsumed()) {
            return;
        }
        event.consume();
        AntSession session = event.getSession();
        String line = event.getMessage();
        ERR.log(Level.FINE, "Received message: {0}", line);
        if (line.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(line, event, event.getLogLevel());
            return;
        }
        Matcher m = CARET_SHOWING_COLUMN.matcher(line);
        if (m.matches()) {
            ERR.fine("  Looks like a special caret line");
            SessionData data = this.getSessionData(session);
            if (data.lastHyperlink != null) {
                data.lastHyperlink.setColumn1(m.group(1).length() + 1);
                data.lastHyperlink = null;
                return;
            }
        }
        if ((m = CWD_ENTER.matcher(line)).matches()) {
            ERR.fine("  Looks like a change of CWD");
            d = new File(m.group(1));
            if (d.isDirectory()) {
                stack = this.getSessionData((AntSession)session).currentDir;
                stack.push(d);
                ERR.log(Level.FINE, "  ...is a change of CWD; stack now: {0}", stack);
            }
        }
        if ((m = CWD_LEAVE.matcher(line)).matches()) {
            ERR.fine("  Looks like a change of CWD back out");
            d = new File(m.group(1));
            stack = this.getSessionData((AntSession)session).currentDir;
            if (stack.empty()) {
                ERR.log(Level.FINE, "  ...but there was nowhere to change out of");
            } else {
                File previous = stack.pop();
                if (!previous.equals(d)) {
                    ERR.log(Level.FINE, "  ...stack mismatch: {0} vs. {1}", new Object[]{previous, d});
                }
            }
        }
        if ((hyperlink = this.findHyperlink(session, line)) instanceof Hyperlink) {
            this.getSessionData((AntSession)session).lastHyperlink = (Hyperlink)hyperlink;
        }
        event.getSession().println(line, event.getLogLevel() <= 1, hyperlink);
    }

    public void taskFinished(AntEvent event) {
        this.getSessionData((AntSession)event.getSession()).lastHyperlink = null;
    }

    private OutputListener findHyperlink(AntSession session, String line) {
        File file;
        Stack<File> cwd = this.getSessionData((AntSession)session).currentDir;
        Matcher m = HYPERLINK.matcher(line);
        if (!m.matches()) {
            ERR.fine("does not look like a hyperlink");
            return null;
        }
        String path = m.group(1);
        if (path.startsWith("file:")) {
            try {
                file = new File(new URI(path));
            }
            catch (URISyntaxException e) {
                ERR.log(Level.FINE, "invalid URI, skipping", e);
                return null;
            }
            catch (IllegalArgumentException e) {
                ERR.log(Level.FINE, "invalid URI, skipping", e);
                return null;
            }
        } else {
            file = new File(path);
            if (!file.isAbsolute()) {
                if (cwd.isEmpty()) {
                    ERR.fine("Non-absolute path with no CWD, skipping");
                    return null;
                }
                file = new File(cwd.peek(), path);
            }
        }
        if (!file.exists()) {
            ERR.log(Level.FINE, "no such file {0}, skipping", file);
            return null;
        }
        int line1 = -1;
        int col1 = -1;
        int line2 = -1;
        int col2 = -1;
        String num = m.group(2);
        try {
            if (num != null) {
                line1 = Integer.parseInt(num);
                num = m.group(3);
                if (num != null) {
                    col1 = Integer.parseInt(num);
                    num = m.group(4);
                    if (num != null) {
                        line2 = Integer.parseInt(num);
                        col2 = Integer.parseInt(m.group(5));
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            ERR.log(Level.FINE, "bad line/col #", e);
            return null;
        }
        String message = m.group(6);
        file = FileUtil.normalizeFile((File)file);
        ERR.log(Level.FINE, "Hyperlink: {0} [{1}:{2}:{3}:{4}]: {5}", new Object[]{file, line1, col1, line2, col2, message});
        try {
            return session.createStandardHyperlink(file.toURI().toURL(), message, line1, col1, line2, col2);
        }
        catch (MalformedURLException e) {
            assert (false) : e;
            return null;
        }
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
        public Stack<File> currentDir = new Stack();
    }
}

