/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AntProjectSupport
implements AntProjectCookie.ParseStatus,
DocumentListener,
PropertyChangeListener {
    private FileObject fo;
    private Document projDoc = null;
    private Throwable exception = null;
    private boolean parsed = false;
    private Reference<StyledDocument> styledDocRef = null;
    private Object parseLock;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private EditorCookie.Observable editor = null;
    private DocumentBuilder documentBuilder;
    private static final int REPARSE_DELAY = 3000;
    private final RequestProcessor rp;
    private RequestProcessor.Task task = null;

    public AntProjectSupport(FileObject fo) {
        this.fo = fo;
        this.parseLock = new Object();
        this.rp = new RequestProcessor("AntProjectSupport[" + fo + "]");
    }

    private synchronized EditorCookie.Observable getEditor() {
        FileObject fo = this.getFileObject();
        if (fo == null) {
            return null;
        }
        if (this.editor == null) {
            try {
                this.editor = (EditorCookie.Observable)DataObject.find((FileObject)fo).getCookie(EditorCookie.Observable.class);
                if (this.editor != null) {
                    this.editor.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.editor));
                }
            }
            catch (DataObjectNotFoundException donfe) {
                AntModule.err.notify(1, (Throwable)donfe);
            }
        }
        return this.editor;
    }

    public File getFile() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }

    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            return null;
        }
        return this.fo;
    }

    public void setFile(File f) {
        this.fo = FileUtil.toFileObject((File)f);
        this.invalidate();
    }

    public void setFileObject(FileObject fo) {
        this.fo = fo;
        this.invalidate();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() {
        if (this.parsed) {
            return this.projDoc;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                return this.projDoc;
            }
            this.parseDocument();
            return this.projDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getParseException() {
        if (this.parsed) {
            return this.exception;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                return this.exception;
            }
            this.parseDocument();
            return this.exception;
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(ErrHandler.DEFAULT);
        return documentBuilder;
    }

    public static InputSource createInputSource(FileObject fo, final StyledDocument document) throws IOException {
        InputSource in;
        block7: {
            block6: {
                DataObject d;
                if (fo != null && !(d = DataObject.find((FileObject)fo)).isModified()) {
                    try {
                        return new InputSource(fo.getURL().toExternalForm());
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)e);
                    }
                }
            }
            final String[] contents = new String[1];
            document.render(new Runnable(){

                public void run() {
                    try {
                        contents[0] = document.getText(0, document.getLength());
                    }
                    catch (BadLocationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
            in = new InputSource(new StringReader(contents[0]));
            if (fo != null) {
                try {
                    in.setSystemId(fo.getURL().toExternalForm());
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument() {
        block14: {
            assert (Thread.holdsLock(this.parseLock));
            FileObject fo = this.getFileObject();
            AntModule.err.log("AntProjectSupport.parseDocument: fo=" + fo);
            try {
                Document doc;
                EditorCookie.Observable editor;
                if (this.documentBuilder == null) {
                    this.documentBuilder = AntProjectSupport.createDocumentBuilder();
                }
                if ((editor = this.getEditor()) != null) {
                    StyledDocument document = editor.openDocument();
                    if (this.styledDocRef != null && this.styledDocRef.get() != document || this.styledDocRef == null) {
                        document.addDocumentListener(this);
                        this.styledDocRef = new WeakReference<StyledDocument>(document);
                    }
                    InputSource in = AntProjectSupport.createInputSource(fo, document);
                    doc = this.documentBuilder.parse(in);
                } else {
                    if (fo != null) {
                        InputStream is = fo.getInputStream();
                        try {
                            block13: {
                                InputSource in = new InputSource(is);
                                try {
                                    in.setSystemId(fo.getURL().toExternalForm());
                                }
                                catch (FileStateInvalidException e) {
                                    if ($assertionsDisabled) break block13;
                                    throw new AssertionError((Object)e);
                                }
                            }
                            doc = this.documentBuilder.parse(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    this.exception = new FileNotFoundException("Ant script probably deleted");
                    return;
                }
                this.projDoc = doc;
                this.exception = null;
            }
            catch (Exception e) {
                this.exception = e;
                if (this.exception instanceof SAXParseException) break block14;
                AntModule.err.annotate(this.exception, 0, "Strange parse error in " + this, null, null, null);
                AntModule.err.notify(1, this.exception);
            }
        }
        this.fireChangeEvent(false);
        this.parsed = true;
    }

    public Element getProjectElement() {
        Document doc = this.getDocument();
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport other = (AntProjectSupport)o;
        if (this.fo != null) {
            return this.fo.equals(other.fo);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo != null ? this.fo.hashCode() : 0);
    }

    public String toString() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            return fo.toString();
        }
        return "<missing Ant script>";
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(boolean delay) {
        AntModule.err.log("AntProjectSupport.fireChangeEvent: fo=" + this.fo);
        ChangeFirer f = new ChangeFirer();
        AntProjectSupport antProjectSupport = this;
        synchronized (antProjectSupport) {
            if (this.task == null) {
                this.task = this.rp.post((Runnable)f, delay ? 3000 : 0);
            } else if (!delay) {
                this.task.schedule(0);
            }
        }
    }

    public void removeUpdate(DocumentEvent ev) {
        this.invalidate();
    }

    public void changedUpdate(DocumentEvent ev) {
    }

    public void insertUpdate(DocumentEvent ev) {
        this.invalidate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("document".equals(e.getPropertyName())) {
            this.invalidate();
        }
    }

    public void fileDeleted(FileEvent p1) {
    }

    public void fileDataCreated(FileEvent p1) {
    }

    public void fileFolderCreated(FileEvent p1) {
    }

    public void fileRenamed(FileRenameEvent p1) {
    }

    public void fileAttributeChanged(FileAttributeEvent p1) {
    }

    public void fileChanged(FileEvent p1) {
        this.invalidate();
    }

    protected final void invalidate() {
        AntModule.err.log("AntProjectSupport.invalidate: fo=" + this.fo);
        this.parsed = false;
        this.fireChangeEvent(true);
    }

    private final class ChangeFirer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AntModule.err.log("AntProjectSupport.ChangeFirer.run");
            AntProjectSupport antProjectSupport = AntProjectSupport.this;
            synchronized (antProjectSupport) {
                if (AntProjectSupport.this.task == null) {
                    return;
                }
                AntProjectSupport.this.task = null;
            }
            AntProjectSupport.this.cs.fireChange();
        }
    }

    private static final class ErrHandler
    implements ErrorHandler {
        static final ErrorHandler DEFAULT = new ErrHandler();

        private ErrHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

