/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertorImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandlerImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationParser;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LibrariesStorage
extends FileChangeAdapter
implements WritableLibraryProvider {
    private static final String NB_HOME_PROPERTY = "netbeans.home";
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static final String TIME_STAMPS_FILE = "libraries-timestamps.properties";
    private static final String XML_EXT = "xml";
    private FileObject storage = null;
    private Map<String, LibraryImplementation> libraries;
    private Map<String, LibraryImplementation> librariesByFileNames;
    private ResourceBundle bundle;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized;
    private Properties timeStamps;

    public LibrariesStorage() {
    }

    LibrariesStorage(FileObject storage) {
        this();
        this.storage = storage;
    }

    private static final FileObject createStorage() {
        FileSystem storageFS = Repository.getDefault().getDefaultFileSystem();
        try {
            return FileUtil.createFolder((FileObject)storageFS.getRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void loadFromStorage() {
        this.libraries = new HashMap<String, LibraryImplementation>();
        this.librariesByFileNames = new HashMap<String, LibraryImplementation>();
        LibraryDeclarationHandlerImpl handler = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl convertor = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser parser = new LibraryDeclarationParser(handler, convertor);
        for (FileObject descriptorFile : this.storage.getChildren()) {
            if (!XML_EXT.equalsIgnoreCase(descriptorFile.getExt())) continue;
            try {
                handler.setLibrary(null);
                LibrariesStorage.readLibrary(descriptorFile, parser);
                LibraryImplementation impl = handler.getLibrary();
                if (impl == null) continue;
                LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    continue;
                }
                if (this.libraries.keySet().contains(impl.getName())) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Library \"" + impl.getName() + "\" is already defined, skeeping the definition from: " + FileUtil.getFileDisplayName((FileObject)descriptorFile));
                    continue;
                }
                if (!this.isUpToDate(descriptorFile)) {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(descriptorFile);
                }
                this.librariesByFileNames.put(descriptorFile.getPath(), impl);
                this.libraries.put(impl.getName(), impl);
            }
            catch (SAXException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        try {
            this.saveTimeStamps();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    private synchronized void initStorage() {
        if (!this.initialized) {
            if (this.storage == null) {
                this.storage = LibrariesStorage.createStorage();
                if (this.storage == null) {
                    this.libraries = Collections.emptyMap();
                    this.librariesByFileNames = Collections.emptyMap();
                    this.initialized = true;
                    return;
                }
            }
            this.loadFromStorage();
            this.storage.addFileChangeListener((FileChangeListener)this);
            this.initialized = true;
        }
    }

    private static LibraryImplementation readLibrary(FileObject descriptorFile) throws SAXException, ParserConfigurationException, IOException {
        return LibrariesStorage.readLibrary(descriptorFile, (LibraryImplementation)null);
    }

    private static LibraryImplementation readLibrary(FileObject descriptorFile, LibraryImplementation impl) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationHandlerImpl handler = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl convertor = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser parser = new LibraryDeclarationParser(handler, convertor);
        handler.setLibrary(impl);
        LibrariesStorage.readLibrary(descriptorFile, parser);
        return handler.getLibrary();
    }

    private static void readLibrary(FileObject descriptorFile, LibraryDeclarationParser parser) throws SAXException, ParserConfigurationException, IOException {
        URL baseURL = descriptorFile.getURL();
        InputSource input = new InputSource(baseURL.toExternalForm());
        input.setByteStream(descriptorFile.getInputStream());
        try {
            parser.parse(input);
        }
        catch (SAXException e) {
            ErrorManager.getDefault().annotate((Throwable)e, 0, "From " + baseURL, null, null, null);
            throw e;
        }
    }

    private void writeLibrary(final FileObject storage, final LibraryImplementation library) throws IOException {
        storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                String libraryType = library.getType();
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                    return;
                }
                FileObject fo = storage.createData(library.getName(), LibrariesStorage.XML_EXT);
                LibrariesStorage.writeLibraryDefinition(fo, library, libraryTypeProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject definitionFile, LibraryImplementation library, LibraryTypeProvider libraryTypeProvider) throws IOException {
        FileLock lock = null;
        PrintWriter out = null;
        try {
            String[] volumeTypes;
            String localizingBundle;
            lock = definitionFile.lock();
            out = new PrintWriter(new OutputStreamWriter(definitionFile.getOutputStream(lock), "UTF-8"));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            out.println("<library version=\"1.0\">");
            out.println("\t<name>" + library.getName() + "</name>");
            out.println("\t<type>" + library.getType() + "</type>");
            String description = library.getDescription();
            if (description != null && description.length() > 0) {
                out.println("\t<description>" + description + "</description>");
            }
            if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
                out.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)localizingBundle) + "</localizing-bundle>");
            }
            for (String vtype : volumeTypes = libraryTypeProvider.getSupportedVolumeTypes()) {
                out.println("\t<volume>");
                out.println("\t\t<type>" + vtype + "</type>");
                List<URL> volume = library.getContent(vtype);
                if (volume != null) {
                    for (URL url : volume) {
                        out.println("\t\t<resource>" + XMLUtil.toElementContent((String)url.toExternalForm()) + "</resource>");
                    }
                }
                out.println("\t</volume>");
            }
            out.println("</library>");
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public final LibraryImplementation[] getLibraries() {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        return this.libraries.values().toArray(new LibraryImplementation[this.libraries.size()]);
    }

    public void addLibrary(LibraryImplementation library) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        this.writeLibrary(this.storage, library);
    }

    public void removeLibrary(LibraryImplementation library) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String key : this.librariesByFileNames.keySet()) {
            FileObject fo;
            LibraryImplementation lib = this.librariesByFileNames.get(key);
            if (!library.equals(lib) || (fo = this.storage.getFileSystem().findResource(key)) == null) continue;
            fo.delete();
            return;
        }
    }

    public void updateLibrary(LibraryImplementation oldLibrary, final LibraryImplementation newLibrary) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String key : this.librariesByFileNames.keySet()) {
            FileObject fo;
            LibraryImplementation lib = this.librariesByFileNames.get(key);
            if (!oldLibrary.equals(lib) || (fo = this.storage.getFileSystem().findResource(key)) == null) continue;
            String libraryType = newLibrary.getType();
            final LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
            if (libraryTypeProvider == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorageL Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                return;
            }
            this.storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    LibrariesStorage.writeLibraryDefinition(fo, newLibrary, libraryTypeProvider);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDataCreated(FileEvent fe) {
        block10: {
            FileObject fo = fe.getFile();
            try {
                LibraryImplementation impl = LibrariesStorage.readLibrary(fo);
                if (impl == null) break block10;
                LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    break block10;
                }
                LibrariesStorage librariesStorage = this;
                synchronized (librariesStorage) {
                    this.libraries.put(impl.getName(), impl);
                    this.librariesByFileNames.put(fo.getPath(), impl);
                }
                try {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(fo);
                    this.saveTimeStamps();
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, message));
                }
                this.fireLibrariesChanged();
            }
            catch (SAXException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fe) {
        LibraryImplementation impl;
        String fileName = fe.getFile().getPath();
        LibrariesStorage librariesStorage = this;
        synchronized (librariesStorage) {
            impl = this.librariesByFileNames.remove(fileName);
            if (impl != null) {
                this.libraries.remove(impl.getName());
            }
        }
        if (impl != null) {
            LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(impl.getType());
            if (provider == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot invoke LibraryTypeProvider.libraryDeleted(), the library type provider is unknown.");
            } else {
                try {
                    provider.libraryDeleted(impl);
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryDeletedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, message));
                }
            }
            this.fireLibrariesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileEvent fe) {
        LibraryImplementation impl;
        FileObject definitionFile = fe.getFile();
        String fileName = definitionFile.getPath();
        LibrariesStorage librariesStorage = this;
        synchronized (librariesStorage) {
            impl = this.librariesByFileNames.get(fileName);
        }
        if (impl != null) {
            try {
                LibrariesStorage.readLibrary(definitionFile, impl);
                LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                }
                try {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(definitionFile);
                    this.saveTimeStamps();
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, message));
                }
            }
            catch (SAXException se) {
                ErrorManager.getDefault().notify((Throwable)se);
            }
            catch (ParserConfigurationException pce) {
                ErrorManager.getDefault().notify((Throwable)pce);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    protected final ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(LibrariesStorage.class);
        }
        return this.bundle;
    }

    private boolean isUpToDate(FileObject libraryDefinition) {
        Properties timeStamps = this.getTimeStamps();
        String ts = (String)timeStamps.get(libraryDefinition.getNameExt());
        return ts == null ? false : Long.parseLong(ts) >= libraryDefinition.lastModified().getTime();
    }

    private void updateTimeStamp(FileObject libraryDefinition) {
        Properties timeStamps = this.getTimeStamps();
        timeStamps.put(libraryDefinition.getNameExt(), Long.toString(libraryDefinition.lastModified().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTimeStamps() throws IOException {
        if (this.storage != null) {
            FileObject parent;
            FileObject timeStampFile;
            Properties timeStamps = this.getTimeStamps();
            if (timeStamps.get(NB_HOME_PROPERTY) == null) {
                String currNbLoc = LibrariesStorage.getNBRoots();
                timeStamps.put(NB_HOME_PROPERTY, currNbLoc);
            }
            if ((timeStampFile = (parent = this.storage.getParent()).getFileObject(TIME_STAMPS_FILE)) == null) {
                timeStampFile = parent.createData(TIME_STAMPS_FILE);
            }
            FileLock lock = timeStampFile.lock();
            try {
                OutputStream out = timeStampFile.getOutputStream(lock);
                try {
                    timeStamps.store(out, null);
                }
                finally {
                    out.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTimeStamps() {
        if (this.timeStamps == null) {
            FileObject timeStampFile;
            this.timeStamps = new Properties();
            if (this.storage != null && (timeStampFile = this.storage.getParent().getFileObject(TIME_STAMPS_FILE)) != null) {
                try {
                    InputStream in = timeStampFile.getInputStream();
                    try {
                        this.timeStamps.load(in);
                    }
                    finally {
                        in.close();
                    }
                    String nbLoc = (String)this.timeStamps.get(NB_HOME_PROPERTY);
                    String currNbLoc = LibrariesStorage.getNBRoots();
                    if (nbLoc == null || !nbLoc.equals(currNbLoc)) {
                        this.timeStamps.clear();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
        return this.timeStamps;
    }

    private static String getNBRoots() {
        File f;
        TreeSet<String> result = new TreeSet<String>();
        String currentNbLoc = System.getProperty(NB_HOME_PROPERTY);
        if (currentNbLoc != null && (f = FileUtil.normalizeFile((File)new File(currentNbLoc))).isDirectory()) {
            result.add(f.getAbsolutePath());
        }
        if ((currentNbLoc = System.getProperty("netbeans.dirs")) != null) {
            StringTokenizer tok = new StringTokenizer(currentNbLoc, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File f2 = FileUtil.normalizeFile((File)new File(tok.nextToken()));
                result.add(f2.getAbsolutePath());
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

