/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

class LibrariesModel
extends AbstractListModel
implements PropertyChangeListener,
LookupListener {
    private List<LibraryImplementation> actualLibraries;
    private List<LibraryImplementation> addedLibraries = new ArrayList<LibraryImplementation>();
    private List<LibraryImplementation> removedLibraries = new ArrayList<LibraryImplementation>();
    private List<ProxyLibraryImplementation> changedLibraries = new ArrayList<ProxyLibraryImplementation>();
    private Collection<? extends LibraryProvider> currentStorages = Collections.emptySet();
    private Map<LibraryImplementation, LibraryProvider> storageByLib = new HashMap<LibraryImplementation, LibraryProvider>();
    private Lookup.Result<LibraryProvider> lresult;
    private WritableLibraryProvider writableProvider;

    public LibrariesModel() {
        this.getLibraries();
    }

    public Object getElementAt(int index) {
        if (index < 0 || index >= this.actualLibraries.size()) {
            return null;
        }
        return this.actualLibraries.get(index);
    }

    public int getSize() {
        return this.actualLibraries.size();
    }

    public void addLibrary(LibraryImplementation impl) {
        LibraryImplementation tmp;
        int index;
        this.addedLibraries.add(impl);
        LibrariesComparator c = new LibrariesComparator();
        for (index = 0; index < this.actualLibraries.size() && c.compare(impl, tmp = this.actualLibraries.get(index)) >= 0; ++index) {
        }
        this.actualLibraries.add(index, impl);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeLibrary(LibraryImplementation impl) {
        if (this.addedLibraries.contains(impl)) {
            this.addedLibraries.remove(impl);
        } else {
            this.removedLibraries.add(((ProxyLibraryImplementation)impl).getOriginal());
        }
        int index = this.actualLibraries.indexOf(impl);
        this.actualLibraries.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void modifyLibrary(ProxyLibraryImplementation impl) {
        if (!this.addedLibraries.contains(impl) && !this.changedLibraries.contains(impl)) {
            this.changedLibraries.add(impl);
        }
        int index = this.actualLibraries.indexOf(impl);
        this.fireContentsChanged(this, index, index);
    }

    public boolean isLibraryEditable(LibraryImplementation impl) {
        if (this.addedLibraries.contains(impl)) {
            return true;
        }
        LibraryProvider provider = this.storageByLib.get(((ProxyLibraryImplementation)impl).getOriginal());
        return provider == this.writableProvider;
    }

    public void apply() throws IOException {
        LibraryProvider storage;
        for (LibraryImplementation impl : this.removedLibraries) {
            storage = this.storageByLib.get(impl);
            if (storage == this.writableProvider) {
                this.writableProvider.removeLibrary(impl);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + impl.getName());
        }
        if (this.writableProvider != null) {
            for (LibraryImplementation impl : this.addedLibraries) {
                this.writableProvider.addLibrary(impl);
            }
        } else {
            ErrorManager.getDefault().log("Cannot add libraries, no WritableLibraryProvider.");
        }
        for (ProxyLibraryImplementation proxy : this.changedLibraries) {
            storage = this.storageByLib.get(proxy.getOriginal());
            if (storage == this.writableProvider) {
                this.writableProvider.updateLibrary(proxy.getOriginal(), proxy);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + proxy.getOriginal().getName());
        }
        this.cleanUp();
    }

    public void cancel() {
        this.cleanUp();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.storagesChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.storagesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storagesChanged() {
        int oldSize;
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            oldSize = this.actualLibraries == null ? 0 : this.actualLibraries.size();
            this.getLibraries();
        }
        this.fireContentsChanged(this, 0, Math.max(oldSize, this.actualLibraries.size()));
    }

    private LibraryImplementation findModified(LibraryImplementation impl) {
        for (ProxyLibraryImplementation proxy : this.changedLibraries) {
            if (!proxy.getOriginal().equals(impl)) continue;
            return proxy;
        }
        return null;
    }

    private synchronized void cleanUp() {
        this.addedLibraries.clear();
        this.removedLibraries.clear();
        this.changedLibraries.clear();
        for (LibraryProvider libraryProvider : this.currentStorages) {
            libraryProvider.removePropertyChangeListener(this);
        }
        this.currentStorages = Collections.emptySet();
    }

    private synchronized void getLibraries() {
        ArrayList<LibraryImplementation> libraries = new ArrayList<LibraryImplementation>();
        if (this.lresult == null) {
            this.lresult = Lookup.getDefault().lookupResult(LibraryProvider.class);
            this.lresult.addLookupListener((LookupListener)this);
        }
        Collection instances = this.lresult.allInstances();
        HashSet toAdd = new HashSet(instances);
        toAdd.removeAll(this.currentStorages);
        HashSet<? extends LibraryProvider> toRemove = new HashSet<LibraryProvider>(this.currentStorages);
        toRemove.removeAll(instances);
        this.currentStorages = instances;
        this.storageByLib.clear();
        for (LibraryProvider libraryProvider : instances) {
            if (this.writableProvider == null && libraryProvider instanceof WritableLibraryProvider) {
                this.writableProvider = (WritableLibraryProvider)libraryProvider;
            }
            for (LibraryImplementation lib : libraryProvider.getLibraries()) {
                LibraryImplementation proxy = null;
                if (this.removedLibraries.contains(lib)) {
                    this.storageByLib.put(lib, libraryProvider);
                    continue;
                }
                proxy = this.findModified(lib);
                if (proxy != null) {
                    libraries.add(proxy);
                    this.storageByLib.put(lib, libraryProvider);
                    continue;
                }
                libraries.add(new ProxyLibraryImplementation(lib, this));
                this.storageByLib.put(lib, libraryProvider);
            }
        }
        libraries.addAll(this.addedLibraries);
        Collections.sort(libraries, new LibrariesComparator());
        for (LibraryProvider libraryProvider : toRemove) {
            libraryProvider.removePropertyChangeListener(this);
        }
        for (LibraryProvider libraryProvider : toAdd) {
            libraryProvider.addPropertyChangeListener(this);
        }
        this.actualLibraries = libraries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibrariesComparator
    implements Comparator<LibraryImplementation> {
        private LibrariesComparator() {
        }

        @Override
        public int compare(LibraryImplementation lib1, LibraryImplementation lib2) {
            String name1 = LibrariesCustomizer.getLocalizedString(lib1.getLocalizingBundle(), lib1.getName());
            String name2 = LibrariesCustomizer.getLocalizedString(lib2.getLocalizingBundle(), lib2.getName());
            return name1.compareToIgnoreCase(name2);
        }
    }
}

