/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLibraryImplementation
implements LibraryImplementation,
PropertyChangeListener {
    private final LibraryImplementation original;
    private final LibrariesModel model;
    private Map<String, List<URL>> newContents;
    private String newName;
    private String newDescription;
    private PropertyChangeSupport support;

    public ProxyLibraryImplementation(LibraryImplementation original, LibrariesModel model) {
        assert (original != null && model != null);
        this.original = original;
        this.model = model;
        this.original.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.original));
        this.support = new PropertyChangeSupport(this);
    }

    public LibraryImplementation getOriginal() {
        return this.original;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public String getType() {
        return this.original.getType();
    }

    @Override
    public synchronized List<URL> getContent(String volumeType) throws IllegalArgumentException {
        List<URL> result = null;
        if (this.newContents == null || (result = this.newContents.get(volumeType)) == null) {
            return this.original.getContent(volumeType);
        }
        return result;
    }

    @Override
    public synchronized String getDescription() {
        if (this.newDescription != null) {
            return this.newDescription;
        }
        return this.original.getDescription();
    }

    @Override
    public synchronized String getName() {
        if (this.newName != null) {
            return this.newName;
        }
        return this.original.getName();
    }

    @Override
    public synchronized void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
        if (this.newContents == null) {
            this.newContents = new HashMap<String, List<URL>>();
        }
        this.newContents.put(volumeType, path);
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("content", null, null);
    }

    @Override
    public synchronized void setDescription(String text) {
        String oldDescription = this.newDescription == null ? this.original.getDescription() : this.newDescription;
        this.newDescription = text;
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("description", oldDescription, this.newDescription);
    }

    @Override
    public synchronized void setName(String name) {
        String oldName = this.newName == null ? this.original.getName() : this.newName;
        this.newName = name;
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("name", oldName, this.newName);
    }

    @Override
    public String getLocalizingBundle() {
        return this.original.getLocalizingBundle();
    }

    @Override
    public void setLocalizingBundle(String resourceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.support.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public final int hashCode() {
        return this.original.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ProxyLibraryImplementation) {
            return this.original.equals(((ProxyLibraryImplementation)obj).getOriginal());
        }
        return false;
    }

    public final String toString() {
        return "Proxy for: " + this.original.toString();
    }
}

