/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.editor.util.CompactMap;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.PriorityDocumentListenerList;

public final class DocumentUtilities {
    private static final Object TYPING_MODIFICATION_DOCUMENT_PROPERTY = new Object();
    private static final Object TYPING_MODIFICATION_KEY = new Object();
    private static Field numReadersField;
    private static Field currWriterField;

    private DocumentUtilities() {
    }

    public static void addDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        if (!DocumentUtilities.addPriorityDocumentListener(doc, listener, priority)) {
            doc.addDocumentListener(listener);
        }
    }

    public static boolean addPriorityDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)doc.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.add(listener, priority.getPriority());
            return true;
        }
        return false;
    }

    public static void removeDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        if (!DocumentUtilities.removePriorityDocumentListener(doc, listener, priority)) {
            doc.removeDocumentListener(listener);
        }
    }

    public static boolean removePriorityDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)doc.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.remove(listener, priority.getPriority());
            return true;
        }
        return false;
    }

    public static DocumentListener initPriorityListening(Document doc) {
        if (doc.getProperty(PriorityDocumentListenerList.class) != null) {
            throw new IllegalStateException("PriorityDocumentListenerList already initialized for doc=" + doc);
        }
        PriorityDocumentListenerList listener = new PriorityDocumentListenerList();
        doc.putProperty(PriorityDocumentListenerList.class, listener);
        return listener;
    }

    public static void setTypingModification(Document doc, boolean typingModification) {
        doc.putProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY, typingModification);
    }

    public static boolean isTypingModification(Document doc) {
        Boolean b = (Boolean)doc.getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return b != null ? b : false;
    }

    public static boolean isTypingModification(DocumentEvent evt) {
        return DocumentUtilities.isTypingModification(evt.getDocument());
    }

    public static CharSequence getText(Document doc) {
        CharSequence text = (CharSequence)doc.getProperty(CharSequence.class);
        if (text == null) {
            text = new DocumentCharSequence(doc);
            doc.putProperty(CharSequence.class, text);
        }
        return text;
    }

    public static CharSequence getText(Document doc, int offset, int length) throws BadLocationException {
        CharSequence text = (CharSequence)doc.getProperty(CharSequence.class);
        if (text == null) {
            text = new DocumentCharSequence(doc);
            doc.putProperty(CharSequence.class, text);
        }
        try {
            return text.subSequence(offset, offset + length);
        }
        catch (IndexOutOfBoundsException e) {
            int badOffset = offset;
            if (offset >= 0 && offset + length > text.length()) {
                badOffset = length;
            }
            throw new BadLocationException(e.getMessage(), badOffset);
        }
    }

    public static void addEventPropertyStorage(DocumentEvent evt) {
        if (!(evt instanceof UndoableEdit)) {
            throw new IllegalStateException("evt not instanceof UndoableEdit: " + evt);
        }
        ((UndoableEdit)((Object)evt)).addEdit(new EventPropertiesElementChange());
    }

    public static Object getEventProperty(DocumentEvent evt, Object key) {
        EventPropertiesElementChange change = (EventPropertiesElementChange)evt.getChange(EventPropertiesElement.INSTANCE);
        return change != null ? change.getProperty(key) : null;
    }

    public static void putEventProperty(DocumentEvent evt, Object key, Object value) {
        EventPropertiesElementChange change = (EventPropertiesElementChange)evt.getChange(EventPropertiesElement.INSTANCE);
        if (change == null) {
            throw new IllegalStateException("addEventPropertyStorage() not called for evt=" + evt);
        }
        change.putProperty(key, value);
    }

    public static void putEventProperty(DocumentEvent evt, Map.Entry mapEntry) {
        if (mapEntry instanceof CompactMap.MapEntry) {
            EventPropertiesElementChange change = (EventPropertiesElementChange)evt.getChange(EventPropertiesElement.INSTANCE);
            if (change == null) {
                throw new IllegalStateException("addEventPropertyStorage() not called for evt=" + evt);
            }
            change.putEntry((CompactMap.MapEntry)mapEntry);
        } else {
            DocumentUtilities.putEventProperty(evt, mapEntry.getKey(), mapEntry.getValue());
        }
    }

    public static int fixOffset(int offset, DocumentEvent evt) {
        int modOffset = evt.getOffset();
        if (evt.getType() == DocumentEvent.EventType.INSERT) {
            if (offset >= modOffset) {
                offset += evt.getLength();
            }
        } else if (evt.getType() == DocumentEvent.EventType.REMOVE && offset > modOffset) {
            offset = Math.min(offset - evt.getLength(), modOffset);
        }
        return offset;
    }

    public static String getModificationText(DocumentEvent evt) {
        return (String)DocumentUtilities.getEventProperty(evt, String.class);
    }

    public static boolean isReadLocked(Document doc) {
        if (DocumentUtilities.checkAbstractDoc(doc)) {
            if (DocumentUtilities.isWriteLocked(doc)) {
                return true;
            }
            if (numReadersField == null) {
                try {
                    numReadersField = AbstractDocument.class.getDeclaredField("numReaders");
                }
                catch (NoSuchFieldException ex) {
                    throw new IllegalStateException(ex);
                }
                numReadersField.setAccessible(true);
            }
            try {
                return numReadersField.getInt(doc) > 0;
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return false;
    }

    public static boolean isWriteLocked(Document doc) {
        if (DocumentUtilities.checkAbstractDoc(doc)) {
            if (currWriterField == null) {
                try {
                    currWriterField = AbstractDocument.class.getDeclaredField("currWriter");
                }
                catch (NoSuchFieldException ex) {
                    throw new IllegalStateException(ex);
                }
                currWriterField.setAccessible(true);
            }
            try {
                return currWriterField.get(doc) == Thread.currentThread();
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return false;
    }

    private static boolean checkAbstractDoc(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("document is null");
        }
        return doc instanceof AbstractDocument;
    }

    public static Element getParagraphElement(Document doc, int offset) {
        Element paragraph;
        if (doc instanceof StyledDocument) {
            paragraph = ((StyledDocument)doc).getParagraphElement(offset);
        } else {
            int index;
            Element rootElem = doc.getDefaultRootElement();
            paragraph = rootElem.getElement(index = rootElem.getElementIndex(offset));
            if (offset < paragraph.getStartOffset() || offset >= paragraph.getEndOffset()) {
                paragraph = null;
            }
        }
        return paragraph;
    }

    public static Element getParagraphRootElement(Document doc) {
        if (doc instanceof StyledDocument) {
            return ((StyledDocument)doc).getParagraphElement(0).getParentElement();
        }
        return doc.getDefaultRootElement().getElement(0).getParentElement();
    }

    private static final class DocumentCharSequence
    extends AbstractCharSequence.StringLike {
        private final Segment segment = new Segment();
        private final Document doc;

        DocumentCharSequence(Document doc) {
            this.doc = doc;
        }

        public int length() {
            return this.doc.getLength();
        }

        public synchronized char charAt(int index) {
            try {
                this.doc.getText(index, 1, this.segment);
            }
            catch (BadLocationException e) {
                throw new IndexOutOfBoundsException(e.getMessage() + " at offset=" + e.offsetRequested());
            }
            char ch = this.segment.array[this.segment.offset];
            this.segment.array = null;
            return ch;
        }
    }

    private static final class EventPropertiesElement
    implements Element {
        static final EventPropertiesElement INSTANCE = new EventPropertiesElement();

        private EventPropertiesElement() {
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "Helper element for modification text providing";
        }

        public Document getDocument() {
            return null;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class EventPropertiesElementChange
    implements DocumentEvent.ElementChange,
    UndoableEdit {
        private CompactMap eventProperties = new CompactMap();

        private EventPropertiesElementChange() {
        }

        public synchronized Object getProperty(Object key) {
            return this.eventProperties != null ? this.eventProperties.get(key) : null;
        }

        public synchronized Object putProperty(Object key, Object value) {
            return this.eventProperties.put(key, value);
        }

        public synchronized CompactMap.MapEntry putEntry(CompactMap.MapEntry entry) {
            return this.eventProperties.putEntry(entry);
        }

        public int getIndex() {
            return -1;
        }

        public Element getElement() {
            return EventPropertiesElement.INSTANCE;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            return null;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }

        public void undo() throws CannotUndoException {
        }

        public void redo() throws CannotRedoException {
        }

        public boolean isSignificant() {
            return false;
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public String getPresentationName() {
            return "";
        }

        public void die() {
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }
    }
}

