/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocHintProvider
extends AbstractHint {
    private static final int NOPOS = -2;
    private boolean cancel = false;
    private static Access access;
    private boolean createJavadocKind;
    private static final String INITIALIZED = "javadoc-hint-initialized";

    private JavadocHintProvider(boolean createJavadocKind) {
        this.createJavadocKind = createJavadocKind;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    public synchronized void resume() {
        this.cancel = false;
    }

    boolean isCanceled() {
        return this.cancel;
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.VARIABLE);
    }

    public List<ErrorDescription> run(CompilationInfo javac, TreePath path) {
        boolean onLine;
        Severity severity;
        this.resume();
        JavadocHintProvider.readSettings();
        if (Boolean.FALSE.equals(AccessibilityQuery.isPubliclyAccessible((FileObject)javac.getFileObject().getParent()))) {
            return null;
        }
        AbstractHint.HintSeverity hintSeverity = AbstractHint.HintSeverity.values()[this.getPreferences().getInt("severity", AbstractHint.HintSeverity.CURRENT_LINE_WARNING.ordinal())];
        switch (hintSeverity) {
            case ERROR: {
                severity = Severity.ERROR;
                break;
            }
            case WARNING: {
                severity = Severity.WARNING;
                break;
            }
            default: {
                severity = Severity.HINT;
            }
        }
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (doc == null) {
            return null;
        }
        boolean bl = onLine = hintSeverity == AbstractHint.HintSeverity.CURRENT_LINE_WARNING;
        if (onLine && this.isInMethod(path.getParentPath())) {
            return null;
        }
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        Tree leaf = path.getLeaf();
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)javac.getFileObject());
        Analyzer a = new Analyzer(javac, doc, path, severity, hintSeverity);
        switch (leaf.getKind()) {
            case CLASS: {
                if (!access.isAccessible(((ClassTree)leaf).getModifiers().getFlags()) || onLine && !JavadocHintProvider.isInHeader(javac, (ClassTree)leaf, caret)) break;
                a.processNode(path, errors);
                break;
            }
            case METHOD: {
                Tree clazz = path.getParentPath().getLeaf();
                if (clazz.getKind() != Tree.Kind.CLASS || !javac.getTreeUtilities().isInterface((ClassTree)clazz) && !javac.getTreeUtilities().isAnnotation((ClassTree)clazz) && !access.isAccessible(((MethodTree)leaf).getModifiers().getFlags()) || onLine && !JavadocHintProvider.isInHeader(javac, (MethodTree)leaf, caret)) break;
                a.processNode(path, errors);
                break;
            }
            case VARIABLE: {
                Tree clazz = path.getParentPath().getLeaf();
                if (clazz.getKind() != Tree.Kind.CLASS || !access.isAccessible(((VariableTree)leaf).getModifiers().getFlags())) break;
                a.processNode(path, errors);
            }
        }
        return errors;
    }

    private static boolean isInHeader(CompilationInfo info, ClassTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        if (tree.getModifiers() != null) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
        }
        if (tree.getExtendsClause() != null) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getExtendsClause());
        }
        for (Tree tree2 : tree.getImplementsClause()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, tree2);
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE) continue;
            return offset < ts.offset();
        }
        return false;
    }

    private static boolean isInHeader(CompilationInfo info, MethodTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        if (tree.getModifiers() != null) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
        }
        if (tree.getReturnType() != null) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getReturnType());
        }
        for (VariableTree variableTree : tree.getParameters()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, variableTree);
        }
        for (ExpressionTree expressionTree : tree.getThrows()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, expressionTree);
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE) continue;
            return offset < ts.offset();
        }
        return false;
    }

    private boolean isInMethod(TreePath tp) {
        while (tp != null) {
            if (tp.getLeaf().getKind() == Tree.Kind.METHOD || tp.getLeaf().getKind() == Tree.Kind.BLOCK) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    private static void readSettings() {
        if (access != null) {
            return;
        }
        String s = System.getProperty("org.netbeans.modules.javadoc.hints.Visibility");
        access = Access.resolve(s);
    }

    private static SourceVersion resolveSourceVersion(FileObject file) {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
        if (sourceLevel == null) {
            return SourceVersion.latest();
        }
        if (sourceLevel.startsWith("1.6")) {
            return SourceVersion.RELEASE_6;
        }
        if (sourceLevel.startsWith("1.5")) {
            return SourceVersion.RELEASE_5;
        }
        if (sourceLevel.startsWith("1.4")) {
            return SourceVersion.RELEASE_4;
        }
        if (sourceLevel.startsWith("1.3")) {
            return SourceVersion.RELEASE_3;
        }
        if (sourceLevel.startsWith("1.2")) {
            return SourceVersion.RELEASE_2;
        }
        if (sourceLevel.startsWith("1.1")) {
            return SourceVersion.RELEASE_1;
        }
        if (sourceLevel.startsWith("1.0")) {
            return SourceVersion.RELEASE_0;
        }
        return SourceVersion.latest();
    }

    private static void doOpen(final FileObject fo, final int offset) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JavadocHintProvider.doOpenImpl(fo, offset);
            }
        });
    }

    private static boolean doOpenImpl(FileObject fo, int offset) {
        try {
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && offset != -1 && (doc = ec.openDocument()) != null) {
                Line l;
                int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
                int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                int column = offset - lineOffset;
                if (line != -1 && (l = lc.getLineSet().getCurrent(line)) != null) {
                    l.show(2, column);
                    return true;
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return false;
    }

    public String getId() {
        return JavadocHintProvider.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)(this.createJavadocKind ? "DN_CREATE_JAVADOC_HINT" : "DN_ERROR_IN_JAVADOC_HINT"));
    }

    public String getDescription() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)(this.createJavadocKind ? "DESC_CREATE_JAVADOC_HINT" : "DESC_ERROR_IN_JAVADOC_HINT"));
    }

    private AbstractHint.HintSeverity getDefaultHintSeverity() {
        return this.createJavadocKind ? AbstractHint.HintSeverity.CURRENT_LINE_WARNING : AbstractHint.HintSeverity.WARNING;
    }

    private String getSettingsName() {
        return this.createJavadocKind ? "create-javadoc" : "error-in-javadoc";
    }

    public Preferences getPreferences() {
        Preferences p = NbPreferences.forModule(JavadocHintProvider.class).node(this.getSettingsName());
        if (!p.getBoolean(INITIALIZED, false)) {
            p.putInt("severity", this.getDefaultHintSeverity().ordinal());
            p.putBoolean(INITIALIZED, true);
        }
        return p;
    }

    public static JavadocHintProvider createCreateJavadoc() {
        return new JavadocHintProvider(true);
    }

    public static JavadocHintProvider createErrorInJavadoc() {
        return new JavadocHintProvider(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Access {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;


        public static Access resolve(String s) {
            if (s != null) {
                if ("public".equals(s = s.trim().toLowerCase())) {
                    return PUBLIC;
                }
                if ("protected".equals(s)) {
                    return PROTECTED;
                }
                if ("private".equals(s)) {
                    return PRIVATE;
                }
                if ("package".equals(s)) {
                    return PACKAGE;
                }
            }
            return PROTECTED;
        }

        public boolean isAccessible(Set<Modifier> flags) {
            switch (this) {
                case PRIVATE: {
                    return true;
                }
                case PACKAGE: {
                    return !flags.contains((Object)Modifier.PRIVATE);
                }
                case PROTECTED: {
                    return flags.contains((Object)Modifier.PUBLIC) || flags.contains((Object)Modifier.PROTECTED);
                }
                case PUBLIC: {
                    return flags.contains((Object)Modifier.PUBLIC);
                }
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddTagFix
    implements Fix,
    CancellableTask<WorkingCopy> {
        private final ElementHandle methodHandle;
        private final String paramName;
        private final int index;
        private final FileObject file;
        private final SourceVersion spec;
        private final String descKey;
        private final Kind kind;
        private Position insertPosition;
        String insertJavadoc;
        private int openOffset;
        Document doc;

        private AddTagFix(ElementHandle methodHandle, String paramName, int index, FileObject file, SourceVersion spec, String descKey, Kind tagKind) {
            this.methodHandle = methodHandle;
            this.paramName = paramName;
            this.index = index;
            this.file = file;
            this.spec = spec;
            this.descKey = descKey;
            this.kind = tagKind;
        }

        public static Fix createAddParamTagFix(ExecutableElement elm, String paramName, FileObject file, SourceVersion spec) {
            return new AddTagFix(ElementHandle.create((Element)elm), paramName, -1, file, spec, "MISSING_PARAM_HINT", Kind.PARAM);
        }

        public static Fix createAddTypeParamTagFix(TypeElement elm, String paramName, FileObject file, SourceVersion spec) {
            return new AddTagFix(ElementHandle.create((Element)elm), paramName, -1, file, spec, "MISSING_TYPEPARAM_HINT", Kind.TYPEPARAM);
        }

        public static Fix createAddReturnTagFix(ExecutableElement elm, FileObject file, SourceVersion spec) {
            return new AddTagFix(ElementHandle.create((Element)elm), "", -1, file, spec, "MISSING_RETURN_HINT", Kind.RETURN);
        }

        public static Fix createAddThrowsTagFix(ExecutableElement elm, String fqn, int throwIndex, FileObject file, SourceVersion spec) {
            return new AddTagFix(ElementHandle.create((Element)elm), fqn, throwIndex, file, spec, "MISSING_THROWS_HINT", Kind.THROWS);
        }

        public static Fix createAddDeprecatedTagFix(Element elm, FileObject file, SourceVersion spec) {
            return new AddTagFix(ElementHandle.create((Element)elm), "", -1, file, spec, "MISSING_DEPRECATED_HINT", Kind.DEPRECATED);
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)this.descKey, (Object)this.paramName);
        }

        public ChangeInfo implement() {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            try {
                js.runModificationTask((CancellableTask)this).commit();
                if (this.doc == null || this.insertPosition == null || this.insertJavadoc == null) {
                    return null;
                }
                int open = this.insertPosition.getOffset() + this.openOffset;
                this.insertJavadoc();
                JavadocHintProvider.doOpen(this.file, open);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            return null;
        }

        public void run(final WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            final Element elm = this.methodHandle.resolve((CompilationInfo)wc);
            if (elm == null) {
                return;
            }
            final Doc jdoc = wc.getElementUtilities().javaDocFor(elm);
            this.doc = wc.getDocument();
            if (this.doc == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        AddTagFix.this.computeInsertPositionAndJavadoc((CompilationInfo)wc, elm, jdoc);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
        }

        private void computeInsertPositionAndJavadoc(CompilationInfo wc, Element elm, Doc jdoc) throws BadLocationException {
            boolean[] isLastTag = new boolean[1];
            switch (this.kind) {
                case PARAM: {
                    this.insertPosition = this.getParamInsertPosition(wc, this.doc, (ExecutableElement)elm, jdoc, isLastTag);
                    this.insertJavadoc = "@param " + this.paramName + " ";
                    break;
                }
                case TYPEPARAM: {
                    this.insertPosition = this.getTypeParamInsertPosition(wc, this.doc, (TypeElement)elm, jdoc, isLastTag);
                    this.insertJavadoc = "@param " + this.paramName + " ";
                    break;
                }
                case RETURN: {
                    this.insertPosition = this.getReturnInsertPosition(wc, this.doc, jdoc, isLastTag);
                    this.insertJavadoc = "@return ";
                    break;
                }
                case THROWS: {
                    this.insertPosition = this.getThrowsInsertPosition(wc, this.doc, (ExecutableMemberDoc)jdoc, isLastTag);
                    this.insertJavadoc = "@throws " + this.paramName + " ";
                    break;
                }
                case DEPRECATED: {
                    this.insertPosition = this.getDeprecatedInsertPosition(wc, this.doc, jdoc, isLastTag);
                    this.insertJavadoc = "@deprecated ";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Position[] jdBounds = JavadocUtilities.findDocBounds(wc, this.doc, jdoc);
            int jdBeginLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)jdBounds[0].getOffset());
            int jdEndLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)jdBounds[1].getOffset());
            int insertLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.insertPosition.getOffset());
            String indentation = JavadocGenerator.guessJavadocIndentation(wc, this.doc, jdoc);
            if (jdBeginLine == insertLine && insertLine == jdEndLine) {
                this.insertJavadoc = '\n' + indentation + "* " + this.insertJavadoc;
                this.openOffset = this.insertJavadoc.length();
                this.insertJavadoc = this.insertJavadoc + '\n' + indentation;
            } else if (insertLine == jdEndLine && !isLastTag[0]) {
                this.openOffset = 2 + this.insertJavadoc.length();
                this.insertJavadoc = "* " + this.insertJavadoc + '\n' + indentation;
            } else if (isLastTag[0]) {
                this.insertJavadoc = '\n' + indentation + "* " + this.insertJavadoc;
                this.openOffset = this.insertJavadoc.length();
            } else {
                this.openOffset = this.insertJavadoc.length();
                this.insertJavadoc = this.insertJavadoc + '\n' + indentation + "* ";
            }
        }

        private void insertJavadoc() throws BadLocationException {
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        AddTagFix.this.doc.insertString(AddTagFix.this.insertPosition.getOffset(), AddTagFix.this.insertJavadoc, null);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
        }

        public void cancel() {
        }

        private Position getDeprecatedInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
            return this.getTagInsertPosition(wc, doc, jdoc, null, false, isLastTag);
        }

        private Position getTypeParamInsertPosition(CompilationInfo wc, Document doc, TypeElement elm, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
            Tag[] tags = jdoc.tags("@param");
            Tag where = null;
            boolean insertBefore = true;
            if (tags.length > 0) {
                int index = this.findParamIndex(elm.getTypeParameters(), this.paramName);
                where = index < tags.length ? tags[index] : tags[tags.length - 1];
                insertBefore = index < tags.length;
            } else {
                tags = jdoc.tags();
                if (tags.length > 0) {
                    where = tags[0];
                }
            }
            return this.getTagInsertPosition(wc, doc, jdoc, where, insertBefore, isLastTag);
        }

        private Position getThrowsInsertPosition(CompilationInfo wc, Document doc, ExecutableMemberDoc jdoc, boolean[] isLastTag) throws BadLocationException {
            ThrowsTag[] tags = jdoc.throwsTags();
            ThrowsTag where = null;
            boolean insertBefore = true;
            if (tags.length > 0) {
                int index = this.index;
                where = index < tags.length ? tags[index] : tags[tags.length - 1];
                insertBefore = index < tags.length;
            } else {
                tags = jdoc.tags("@return");
                if (tags.length == 0) {
                    tags = jdoc.tags("@param");
                }
                if (tags.length == 0) {
                    tags = jdoc.tags();
                } else {
                    insertBefore = false;
                }
                if (tags.length > 0) {
                    where = tags[0];
                }
            }
            return this.getTagInsertPosition(wc, doc, (Doc)jdoc, (Tag)where, insertBefore, isLastTag);
        }

        private Position getReturnInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
            Tag[] tags = jdoc.tags("@param");
            Tag where = null;
            boolean insertBefore = true;
            if (tags.length > 0) {
                where = tags[tags.length - 1];
                insertBefore = false;
            } else {
                tags = jdoc.tags();
                if (tags.length > 0) {
                    where = tags[0];
                }
            }
            return this.getTagInsertPosition(wc, doc, jdoc, where, insertBefore, isLastTag);
        }

        private Position getParamInsertPosition(CompilationInfo wc, Document doc, ExecutableElement elm, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
            Tag[] tags = jdoc.tags("@param");
            Tag where = null;
            boolean insertBefore = true;
            if (tags.length > 0) {
                int index = this.findParamIndex(elm.getParameters(), this.paramName);
                where = index < tags.length ? tags[index] : tags[tags.length - 1];
                insertBefore = index < tags.length;
            } else {
                tags = jdoc.tags();
                if (tags.length > 0) {
                    where = tags[0];
                }
            }
            return this.getTagInsertPosition(wc, doc, jdoc, where, insertBefore, isLastTag);
        }

        private Position getTagInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, Tag where, boolean insertBefore, boolean[] isLastTag) throws BadLocationException {
            Position[] bounds = null;
            if (where != null) {
                bounds = JavadocUtilities.findTagBounds(wc, doc, where, isLastTag);
                if (insertBefore) {
                    isLastTag[0] = false;
                }
            } else {
                bounds = JavadocUtilities.findLastTokenBounds(wc, doc, jdoc);
                insertBefore = false;
                isLastTag[0] = false;
            }
            return insertBefore ? bounds[0] : bounds[1];
        }

        private int findParamIndex(List<? extends Element> params, String name) {
            int i = 0;
            for (Element element : params) {
                if (name.contentEquals(element.getSimpleName())) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException("Unknown param: " + name);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Kind {
            PARAM,
            RETURN,
            THROWS,
            TYPEPARAM,
            DEPRECATED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Analyzer {
        private final CompilationInfo javac;
        private final SourceVersion spec;
        private final FixAll fixAll = new FixAll();
        private final Document doc;
        private final FileObject file;
        private final Severity severity;
        private final AbstractHint.HintSeverity hintSeverity;
        private final TreePath currentPath;

        Analyzer(CompilationInfo javac, Document doc, TreePath currentPath, Severity severity, AbstractHint.HintSeverity hintSeverity) {
            this.javac = javac;
            this.doc = doc;
            this.file = javac.getFileObject();
            this.currentPath = currentPath;
            this.severity = severity;
            this.hintSeverity = hintSeverity;
            this.spec = JavadocHintProvider.resolveSourceVersion(javac.getFileObject());
        }

        private ErrorDescription createErrorDescription(String message, LazyFixList fixes, Position[] positions) {
            if (this.hintSeverity == AbstractHint.HintSeverity.CURRENT_LINE_WARNING) {
                return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)message, (LazyFixList)fixes, (FileObject)this.file, (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file), (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file));
            }
            return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)message, (LazyFixList)fixes, (Document)this.doc, (Position)positions[0], (Position)positions[1]);
        }

        private ErrorDescription createErrorDescription(String message, List<Fix> fixes, Position[] positions) {
            return this.createErrorDescription(message, ErrorDescriptionFactory.lazyListForFixes(fixes), positions);
        }

        void processNode(TreePath path, List<ErrorDescription> errors) {
            this.checkTaskState();
            Tree node = path.getLeaf();
            if (this.javac.getTreeUtilities().isSynthetic(path)) {
                return;
            }
            Element elm = this.javac.getTrees().getElement(path);
            if (elm == null) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, "Cannot resolve element for " + node + " in " + this.file);
                return;
            }
            if (this.isGuarded(node)) {
                return;
            }
            String jdText = this.javac.getElements().getDocComment(elm);
            if (jdText == null) {
                if (JavadocUtilities.hasInheritedDoc(this.javac, elm)) {
                    return;
                }
                if (!JavadocHintProvider.this.createJavadocKind) {
                    return;
                }
                try {
                    Position[] positions = this.createSignaturePositions(node);
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_JAVADOC_DESC"), this.createGenerateFixes(elm), positions);
                    errors.add(err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            } else {
                if (JavadocHintProvider.this.createJavadocKind) {
                    return;
                }
                try {
                    Doc jDoc = this.javac.getElementUtilities().javaDocFor(elm);
                    if (jDoc.isMethod() || jDoc.isConstructor()) {
                        ExecutableMemberDoc methDoc = (ExecutableMemberDoc)jDoc;
                        ExecutableElement methodEl = (ExecutableElement)elm;
                        MethodTree methodTree = (MethodTree)node;
                        this.processParameters(methodEl, methodTree, methDoc, errors);
                        this.processReturn(methodEl, methodTree, methDoc, errors);
                        this.processThrows(methodEl, methodTree, methDoc, errors);
                    } else if (jDoc.isClass() || jDoc.isInterface()) {
                        TypeElement classEl = (TypeElement)elm;
                        ClassDoc classDoc = (ClassDoc)jDoc;
                        ClassTree classTree = (ClassTree)node;
                        this.processTypeParameters(classEl, classTree, classDoc, errors);
                    } else if (jDoc.isAnnotationType()) {
                        this.processAnnTypeParameters(elm, node, jDoc, errors);
                    } else if (jDoc.isAnnotationTypeElement()) {
                        AnnotationTypeElementDoc annDoc = (AnnotationTypeElementDoc)jDoc;
                        ExecutableElement methodEl = (ExecutableElement)elm;
                        MethodTree methodTree = (MethodTree)node;
                        this.processAnnTypeParameters(methodEl, methodTree, (Doc)annDoc, errors);
                        this.processReturn(methodEl, methodTree, (ExecutableMemberDoc)annDoc, errors);
                        this.processAnnTypeThrows(methodEl, methodTree, annDoc, errors);
                    }
                    this.processDeprecatedAnnotation(elm, jDoc, errors);
                }
                catch (OutOfLimitException ex) {
                    // empty catch block
                }
            }
        }

        private void processDeprecatedAnnotation(Element elm, Doc jDoc, List<ErrorDescription> errors) {
            if (SourceVersion.RELEASE_5.compareTo(this.spec) > 0) {
                return;
            }
            Tag[] deprTags = jDoc.tags("@deprecated");
            AnnotationMirror annMirror = JavadocUtilities.findDeprecated(this.javac, elm);
            if (annMirror != null) {
                if (deprTags.length == 0) {
                    try {
                        Position[] poss = this.createPositions(this.javac.getTrees().getTree(elm, annMirror));
                        ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_DEPRECATED_DESC"), Collections.singletonList(AddTagFix.createAddDeprecatedTagFix(elm, this.file, this.spec)), poss);
                        this.addTagHint(errors, err);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    }
                } else if (deprTags.length > 1) {
                    boolean isFirst = true;
                    for (Tag tag : deprTags) {
                        if (isFirst) {
                            isFirst = false;
                            continue;
                        }
                        this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_DEPRECATED_DESC"), elm, errors);
                    }
                }
            } else {
                if (deprTags.length > 1) {
                    boolean isFirst = true;
                    for (Tag tag : deprTags) {
                        if (isFirst) {
                            isFirst = false;
                            continue;
                        }
                        this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_DEPRECATED_DESC"), elm, errors);
                    }
                }
                if (deprTags.length > 0) {
                    // empty if block
                }
            }
        }

        private void processReturn(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
            Tag tag;
            int i;
            TypeMirror returnType = exec.getReturnType();
            Tree returnTree = node.getReturnType();
            Tag[] tags = jdoc.tags("@return");
            if (returnType.getKind() == TypeKind.VOID) {
                for (i = 0; i < tags.length; ++i) {
                    tag = tags[i];
                    this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)(jdoc.isMethod() ? "WRONG_RETURN_DESC" : "WRONG_CONSTRUCTOR_RETURN_DESC")), exec, errors);
                }
            } else {
                for (i = 0; i < tags.length; ++i) {
                    tag = tags[i];
                    if (i <= 0) continue;
                    this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_RETURN_DESC"), exec, errors);
                }
            }
            if (returnType.getKind() != TypeKind.VOID && tags.length == 0 && JavadocUtilities.findReturnTag(this.javac, (MethodDoc)jdoc, true) == null) {
                try {
                    Position[] poss = this.createPositions(returnTree);
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_RETURN_DESC"), Collections.singletonList(AddTagFix.createAddReturnTagFix(exec, this.file, this.spec)), poss);
                    this.addTagHint(errors, err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processThrows(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
            void var10_13;
            List<? extends ExpressionTree> throwz = node.getThrows();
            ThrowsTag[] tags = jdoc.throwsTags();
            HashMap<String, ThrowsTag> tagNames = new HashMap<String, ThrowsTag>();
            ThrowsTag[] arr$ = tags;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_13 < len$) {
                ThrowsTag throwsTag = arr$[var10_13];
                Type tagType = throwsTag.exceptionType();
                String tagFQN = null;
                tagFQN = tagType != null ? throwsTag.exceptionType().qualifiedTypeName() : throwsTag.exceptionName();
                if (tagNames.containsKey(tagFQN)) {
                    this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
                } else {
                    tagNames.put(tagFQN, throwsTag);
                }
                ++var10_13;
            }
            int index = 0;
            for (ExpressionTree expressionTree : throwz) {
                ++index;
                TreePath path = new TreePath(this.currentPath, expressionTree);
                Element el = this.javac.getTrees().getElement(path);
                TypeElement tel = (TypeElement)el;
                boolean exists = tagNames.remove(tel.getQualifiedName().toString()) != null;
                if (exists || !jdoc.isConstructor() && (!jdoc.isMethod() || JavadocUtilities.findThrowsTag(this.javac, (MethodDoc)jdoc, tel.getQualifiedName().toString(), true) != null)) continue;
                try {
                    Position[] poss = this.createPositions(expressionTree);
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_THROWS_DESC", (Object)tel.getQualifiedName().toString()), Collections.singletonList(AddTagFix.createAddThrowsTagFix(exec, tel.getQualifiedName().toString(), index, this.file, this.spec)), poss);
                    this.addTagHint(errors, err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
            TypeMirror rtException = this.javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
            for (ThrowsTag throwsTag : tagNames.values()) {
                Element throwEl;
                Type throwsType = throwsTag.exceptionType();
                ClassDoc throwClassDoc = null;
                if (throwsType != null) {
                    throwClassDoc = throwsType.asClassDoc();
                }
                if (throwClassDoc != null && (throwEl = this.javac.getElementUtilities().elementFor((Doc)throwClassDoc)) != null && this.javac.getTypes().isSubtype(throwEl.asType(), rtException)) break;
                this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_THROWABLE_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
            }
        }

        private void processAnnTypeThrows(ExecutableElement exec, MethodTree node, AnnotationTypeElementDoc jdoc, List<ErrorDescription> errors) {
            Tag[] tags;
            for (Tag tag : tags = jdoc.tags("@throws")) {
                ThrowsTag throwsTag = (ThrowsTag)tag;
                this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"ILLEGAL_ANNOTATION_TYPE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
            }
        }

        private void processAnnTypeParameters(Element elm, Tree node, Doc jdoc, List<ErrorDescription> errors) {
            Tag[] tags;
            for (Tag tag : tags = jdoc.tags("@param")) {
                ParamTag paramTag = (ParamTag)tag;
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"ILLEGAL_ANNOTATION_TYPE_PARAM_DESC", (Object)paramTag.parameterName()), elm, errors);
            }
        }

        private void processParameters(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
            List<? extends VariableTree> params = node.getParameters();
            Tag[] tags = jdoc.tags("@param");
            HashMap<String, ParamTag> tagNames = new HashMap<String, ParamTag>();
            for (Tag tag : tags) {
                ParamTag paramTag = (ParamTag)tag;
                if (paramTag.isTypeParameter()) continue;
                if (tagNames.containsKey(paramTag.parameterName())) {
                    this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_PARAM_DESC", (Object)paramTag.parameterName()), exec, errors);
                    continue;
                }
                tagNames.put(paramTag.parameterName(), paramTag);
            }
            for (VariableTree variableTree : params) {
                boolean exists = tagNames.remove(variableTree.getName().toString()) != null;
                if (exists || !jdoc.isConstructor() && (!jdoc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)jdoc, variableTree.getName().toString(), true) != null)) continue;
                try {
                    Position[] poss = this.createPositions(variableTree);
                    ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_PARAM_DESC", (Object)variableTree.getName()), Collections.singletonList(AddTagFix.createAddParamTagFix(exec, variableTree.getName().toString(), this.file, this.spec)), poss);
                    this.addTagHint(errors, errorDescription);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
            for (ParamTag paramTag : tagNames.values()) {
                boolean isTypeParam = false;
                for (TypeParameterElement typeParameterElement : exec.getTypeParameters()) {
                    if (!paramTag.parameterName().equals(typeParameterElement.getSimpleName().toString())) continue;
                    isTypeParam = true;
                    break;
                }
                if (isTypeParam) continue;
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), exec, errors);
            }
        }

        private void processTypeParameters(TypeElement elm, ClassTree node, ClassDoc jdoc, List<ErrorDescription> errors) {
            List<? extends TypeParameterTree> params = node.getTypeParameters();
            Tag[] tags = jdoc.tags("@param");
            HashMap<String, ParamTag> tagNames = new HashMap<String, ParamTag>();
            for (Tag tag : tags) {
                ParamTag paramTag = (ParamTag)tag;
                if (tagNames.containsKey(paramTag.parameterName())) {
                    this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_TYPEPARAM_DESC", (Object)paramTag.parameterName()), elm, errors);
                    continue;
                }
                tagNames.put(paramTag.parameterName(), paramTag);
            }
            for (TypeParameterTree typeParameterTree : params) {
                boolean exists = tagNames.remove(typeParameterTree.getName().toString()) != null;
                if (exists) continue;
                try {
                    Position[] poss = this.createPositions(typeParameterTree);
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_TYPEPARAM_DESC", (Object)typeParameterTree.getName()), Collections.singletonList(AddTagFix.createAddTypeParamTagFix(elm, typeParameterTree.getName().toString(), this.file, this.spec)), poss);
                    this.addTagHint(errors, err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
            for (ParamTag paramTag : tagNames.values()) {
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_TYPEPARAM_DESC", (Object)paramTag.parameterName()), elm, errors);
            }
        }

        Position[] createPositions(Tree t) throws BadLocationException {
            Position[] poss = new Position[2];
            int start = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), t);
            int end = (int)this.javac.getTrees().getSourcePositions().getEndPosition(this.javac.getCompilationUnit(), t);
            poss[0] = this.doc.createPosition(start);
            poss[1] = this.doc.createPosition(end);
            return poss;
        }

        Position[] createSignaturePositions(final Tree t) throws BadLocationException {
            final Position[] pos = new Position[2];
            final BadLocationException[] blex = new BadLocationException[1];
            NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        TokenSequence<JavaTokenId> tseq = null;
                        if (t.getKind() == Tree.Kind.METHOD) {
                            tseq = JavadocUtilities.findMethodNameToken(Analyzer.this.javac, (ClassTree)Analyzer.this.currentPath.getParentPath().getLeaf(), (MethodTree)t);
                        } else if (t.getKind() == Tree.Kind.CLASS) {
                            tseq = JavadocUtilities.findClassNameToken(Analyzer.this.javac, (ClassTree)t);
                        } else if (Tree.Kind.VARIABLE == t.getKind()) {
                            tseq = JavadocUtilities.findVariableNameToken(Analyzer.this.javac, (VariableTree)t, Analyzer.this.javac.getTreeUtilities().isEnum((ClassTree)Analyzer.this.currentPath.getParentPath().getLeaf()));
                        }
                        if (tseq != null) {
                            pos[0] = Analyzer.this.doc.createPosition(tseq.offset());
                            pos[1] = Analyzer.this.doc.createPosition(tseq.offset() + tseq.token().length());
                            return;
                        }
                    }
                    catch (BadLocationException ex) {
                        blex[0] = ex;
                    }
                }
            });
            if (blex[0] != null) {
                throw (BadLocationException)new BadLocationException(blex[0].getMessage(), blex[0].offsetRequested()).initCause(blex[0]);
            }
            return pos;
        }

        private boolean isGuarded(Tree node) {
            GuardedSectionManager guards = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)this.doc));
            if (guards != null) {
                try {
                    int startOff = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), node);
                    Position startPos = this.doc.createPosition(startOff);
                    for (GuardedSection guard : guards.getGuardedSections()) {
                        if (!guard.contains(startPos, false)) continue;
                        return true;
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    return true;
                }
            }
            return false;
        }

        private void addRemoveTagFix(Tag tag, String description, Element elm, List<ErrorDescription> errors) {
            try {
                Position[] poss = JavadocUtilities.findTagNameBounds(this.javac, this.doc, tag);
                if (poss == null) {
                    throw new BadLocationException("no position for " + tag, -1);
                }
                ErrorDescription err = this.createErrorDescription(description, Collections.singletonList(new RemoveTagFix(tag.name(), JavadocUtilities.TagHandle.create(tag), ElementHandle.create((Element)elm), this.file, this.spec)), poss);
                this.addTagHint(errors, err);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }

        JavadocLazyFixList createGenerateFixes(Element elm) {
            ArrayList<Fix> fixes = new ArrayList<Fix>(3);
            ElementHandle handle = ElementHandle.create((Element)elm);
            String description = elm.getKind() == ElementKind.CONSTRUCTOR ? elm.getEnclosingElement().getSimpleName().toString() : elm.getSimpleName().toString();
            JavadocLazyFixList fixList = new JavadocLazyFixList(fixes, this.fixAll);
            GenerateJavadocFix jdFix = new GenerateJavadocFix(description, handle, this.javac.getFileObject(), this.spec);
            fixes.add(jdFix);
            this.fixAll.addFix(jdFix);
            return fixList;
        }

        private void addTagHint(List<ErrorDescription> errors, ErrorDescription desc) {
            errors.add(desc);
            this.checkTaskState();
        }

        private void checkTaskState() {
            if (JavadocHintProvider.this.isCanceled()) {
                throw new CancelException();
            }
        }
    }

    private static final class CancelException
    extends RuntimeException {
        private CancelException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    private static final class FixAll
    implements Fix {
        private List<GenerateJavadocFix> allJavadocFixes = new ArrayList<GenerateJavadocFix>();

        private FixAll() {
        }

        public void addFix(GenerateJavadocFix f) {
            this.allJavadocFixes.add(f);
        }

        public boolean isReady() {
            return this.allJavadocFixes.size() > 1;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"FIX_ALL_HINT");
        }

        public ChangeInfo implement() {
            for (GenerateJavadocFix javadocFix : this.allJavadocFixes) {
                javadocFix.implement(false);
            }
            return null;
        }
    }

    private static final class GenerateJavadocFix
    implements Fix {
        private String name;
        private final ElementHandle handle;
        private final FileObject file;
        private Position position;
        private final SourceVersion spec;

        GenerateJavadocFix(String name, ElementHandle handle, FileObject file, SourceVersion spec) {
            this.name = name;
            this.handle = handle;
            this.file = file;
            this.spec = spec;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
        }

        public ChangeInfo implement() {
            return this.implement(true);
        }

        public ChangeInfo implement(final boolean open) {
            final String[] javadocForDocument = new String[1];
            final Document[] docs = new Document[1];
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            try {
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy wc) throws Exception {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        Element elm = GenerateJavadocFix.this.handle.resolve((CompilationInfo)wc);
                        Tree t = null;
                        if (elm != null) {
                            t = SourceUtils.treeFor((CompilationInfo)wc, (Element)elm);
                        }
                        if (t != null) {
                            JavadocGenerator gen = new JavadocGenerator(GenerateJavadocFix.this.spec);
                            String javadocTxt = gen.generateComment(elm, (CompilationInfo)wc);
                            Comment javadoc = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)0, (String)javadocTxt);
                            wc.getTreeMaker().addComment(t, javadoc, true);
                            javadocForDocument[0] = javadocTxt;
                            docs[0] = wc.getDocument();
                            if (docs[0] == null) {
                                return;
                            }
                            GenerateJavadocFix.this.position = docs[0].createPosition((int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), t));
                        }
                    }
                }).commit();
            }
            catch (IOException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            try {
                if (docs[0] == null) {
                    return null;
                }
                NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)docs[0]), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            String tab = JavadocGenerator.guessIndentation(docs[0], GenerateJavadocFix.this.position);
                            String iJavadoc = JavadocGenerator.indentJavadoc(javadocForDocument[0], tab);
                            docs[0].insertString(GenerateJavadocFix.this.position.getOffset(), iJavadoc, null);
                            int offset = iJavadoc.indexOf("\n");
                            offset = iJavadoc.indexOf("\n", offset + 1);
                            offset = GenerateJavadocFix.this.position.getOffset() + offset - iJavadoc.length();
                            if (open) {
                                JavadocHintProvider.doOpen(GenerateJavadocFix.this.file, offset);
                            }
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavadocLazyFixList
    implements LazyFixList {
        private List<Fix> contexFixes;
        private FixAll fixAll;

        public JavadocLazyFixList(List<Fix> contexFixes, FixAll fixAll) {
            this.contexFixes = contexFixes;
            this.fixAll = fixAll;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public List<Fix> getFixes() {
            if (this.fixAll.isReady()) {
                this.contexFixes.add(this.fixAll);
            }
            return this.contexFixes;
        }

        public boolean isComputed() {
            return true;
        }
    }

    private static final class OutOfLimitException
    extends RuntimeException {
        private OutOfLimitException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoveTagFix
    implements Fix,
    CancellableTask<WorkingCopy> {
        private String tagName;
        private final JavadocUtilities.TagHandle tagHandle;
        private final ElementHandle handle;
        private final FileObject file;
        private final SourceVersion spec;
        private Position[] tagBounds;
        private Document doc;

        RemoveTagFix(String tagName, JavadocUtilities.TagHandle tagHandle, ElementHandle elmHandle, FileObject file, SourceVersion spec) {
            this.tagName = tagName;
            this.tagHandle = tagHandle;
            this.handle = elmHandle;
            this.file = file;
            this.spec = spec;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"REMOVE_TAG_HINT", (Object)this.tagName);
        }

        public ChangeInfo implement() {
            return this.implement(true);
        }

        private void removeTag(final CompilationInfo ci, Element elm) throws IOException, BadLocationException {
            Doc jdoc = ci.getElementUtilities().javaDocFor(elm);
            if (jdoc != null) {
                final Tag tag = this.tagHandle.resolve(jdoc);
                if (tag == null) {
                    return;
                }
                final Document doc = ci.getDocument();
                if (doc == null) {
                    return;
                }
                NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            RemoveTagFix.access$1202(RemoveTagFix.this, JavadocUtilities.findTagBounds(ci, doc, tag));
                        }
                        catch (BadLocationException ex) {
                            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                });
            }
        }

        private void removeTag() throws BadLocationException {
            if (this.tagBounds == null || this.doc == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        RemoveTagFix.this.doc.remove(RemoveTagFix.this.tagBounds[0].getOffset(), RemoveTagFix.this.tagBounds[1].getOffset() - RemoveTagFix.this.tagBounds[0].getOffset());
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
        }

        public ChangeInfo implement(boolean open) {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            try {
                js.runModificationTask((CancellableTask)this).commit();
                this.removeTag();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            return null;
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            Element elm = this.handle.resolve((CompilationInfo)wc);
            Tree t = null;
            if (elm != null) {
                t = SourceUtils.treeFor((CompilationInfo)wc, (Element)elm);
            }
            if (t != null) {
                this.removeTag((CompilationInfo)wc, elm);
                this.doc = wc.getDocument();
            }
        }

        static /* synthetic */ Position[] access$1202(RemoveTagFix x0, Position[] x1) {
            x0.tagBounds = x1;
            return x1;
        }
    }
}

