/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocUtilities {
    private static Set<TokenId> IGNORE_TOKES = null;

    private JavadocUtilities() {
    }

    private static TokenSequence<JavadocTokenId> findTokenSequence(CompilationInfo javac, Doc doc) {
        Element e = javac.getElementUtilities().elementFor(doc);
        if (e == null) {
            return null;
        }
        Tree tree = javac.getTrees().getTree(e);
        if (tree == null) {
            return null;
        }
        int elementStartOffset = (int)javac.getTrees().getSourcePositions().getStartPosition(javac.getCompilationUnit(), tree);
        TokenSequence s = javac.getTokenHierarchy().tokenSequence();
        s.move(elementStartOffset);
        while (s.movePrevious() && IGNORE_TOKES.contains(s.token().id())) {
        }
        if (s.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        return s.embedded(JavadocTokenId.language());
    }

    private static void moveToTag(TokenSequence<JavadocTokenId> es, Tag tag, CompilationInfo javac) {
        Doc doc = tag.holder();
        Tag[] tags = doc.tags();
        int index = JavadocUtilities.findIndex(tags, tag);
        if (index == -1) {
            tags = doc.inlineTags();
            index = JavadocUtilities.findIndex(tags, tag);
            assert (index >= 0);
            index = JavadocUtilities.computeTagsWithSameNumberBefore(tags, tag);
        } else {
            index = JavadocUtilities.computeTagsWithSameNumberBefore(tags, tag);
        }
        assert (index >= 0);
        while (index >= 0 && es.moveNext()) {
            if (es.token().id() != JavadocTokenId.TAG || !tag.name().contentEquals(es.token().text()) || --index >= 0) continue;
            return;
        }
        throw new IllegalStateException("Cannot match the tag: '" + tag.toString() + "'\nDoc.dump:\n" + doc.getRawCommentText() + "\nTokenSequence.dump: '" + es.toString() + "'\nElement.dump: " + javac.getElementUtilities().elementFor(doc) + "\nFile.name: " + javac.getFileObject() + "\nFile.dump:\n" + javac.getText());
    }

    public static TokenSequence<JavadocTokenId> tokensFor(CompilationInfo javac, Tag tag) {
        Doc doc = tag.holder();
        TokenSequence<JavadocTokenId> es = JavadocUtilities.findTokenSequence(javac, doc);
        assert (es != null);
        JavadocUtilities.moveToTag(es, tag, javac);
        int offset = es.offset();
        int length = tag.text().length();
        length = length > 0 ? length : tag.name().length();
        TokenSequence s = javac.getTokenHierarchy().tokenSequence();
        return s.embedded(JavadocTokenId.language()).subSequence(offset, offset + length);
    }

    public static Position[] findTagNameBounds(CompilationInfo info, Document doc, Tag tag) throws BadLocationException {
        TokenSequence<JavadocTokenId> tseq = JavadocUtilities.findTokenSequence(info, tag.holder());
        if (tseq == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tseq, tag, info);
        Position[] positions = new Position[]{doc.createPosition(tseq.offset()), doc.createPosition(tseq.offset() + tseq.token().length())};
        return positions;
    }

    public static Position[] findDocBounds(CompilationInfo javac, Document doc, Doc jdoc) throws BadLocationException {
        Element e = javac.getElementUtilities().elementFor(jdoc);
        if (e == null) {
            return null;
        }
        Tree tree = javac.getTrees().getTree(e);
        if (tree == null) {
            return null;
        }
        int elementStartOffset = (int)javac.getTrees().getSourcePositions().getStartPosition(javac.getCompilationUnit(), tree);
        TokenSequence tseq = javac.getTokenHierarchy().tokenSequence();
        tseq.move(elementStartOffset);
        while (tseq.movePrevious() && IGNORE_TOKES.contains(tseq.token().id())) {
        }
        if (tseq.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        Position[] positions = new Position[]{doc.createPosition(tseq.offset()), doc.createPosition(tseq.offset() + tseq.token().length())};
        return positions;
    }

    public static Position[] findTagBounds(CompilationInfo javac, Document doc, Tag tag) throws BadLocationException {
        return JavadocUtilities.findTagBounds(javac, doc, tag, null);
    }

    public static Position[] findTagBounds(CompilationInfo javac, Document doc, Tag tag, boolean[] isLastToken) throws BadLocationException {
        TokenSequence<JavadocTokenId> tseq = JavadocUtilities.findTokenSequence(javac, tag.holder());
        if (tseq == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tseq, tag, javac);
        int start = tseq.offset();
        Token token = null;
        Token last = null;
        while (tseq.moveNext()) {
            if (tseq.token().id() == JavadocTokenId.TAG && last != null && (last.id() != JavadocTokenId.OTHER_TEXT || last.text().charAt(last.text().length() - 1) != '{')) {
                token = tseq.token();
                break;
            }
            last = tseq.token();
        }
        int lastTokenCleanUp = 0;
        if (token == null) {
            tseq.moveEnd();
            tseq.movePrevious();
            lastTokenCleanUp = ((Object)tseq.token().text()).toString().indexOf(10);
            int n = lastTokenCleanUp = lastTokenCleanUp > 0 ? lastTokenCleanUp : 0;
            if (isLastToken != null && isLastToken.length > 0) {
                isLastToken[0] = true;
            } else if (isLastToken != null && isLastToken.length > 0) {
                isLastToken[0] = false;
            }
        }
        Position[] positions = new Position[]{doc.createPosition(start), doc.createPosition(tseq.offset() + lastTokenCleanUp)};
        return positions;
    }

    public static Position[] findLastTokenBounds(CompilationInfo javac, Document doc, Doc jdoc) throws BadLocationException {
        TokenSequence<JavadocTokenId> tseq = JavadocUtilities.findTokenSequence(javac, jdoc);
        if (tseq == null) {
            return null;
        }
        tseq.moveEnd();
        if (tseq.movePrevious()) {
            Position[] positions = new Position[]{doc.createPosition(tseq.offset()), doc.createPosition(tseq.offset() + tseq.token().length())};
            return positions;
        }
        return null;
    }

    public static TokenSequence<JavaTokenId> findMethodNameToken(CompilationInfo javac, ClassTree enclosing, MethodTree t) {
        TokenSequence tseq = javac.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        Tree retType = t.getReturnType();
        if (retType == null) {
            int offset = (int)javac.getTrees().getSourcePositions().getStartPosition(javac.getCompilationUnit(), t);
            tseq.move(offset + 1);
            Token tok = null;
            String name = enclosing.getSimpleName().toString();
            int index = -1;
            while (tseq.moveNext()) {
                if (tok != null && tseq.token().id() == JavaTokenId.LPAREN && name.contentEquals(tok.text())) {
                    tseq.moveIndex(index);
                    tseq.moveNext();
                    break;
                }
                if (tseq.token().id() != JavaTokenId.IDENTIFIER) continue;
                tok = tseq.token();
                index = tseq.index();
            }
        } else {
            int offset = (int)javac.getTrees().getSourcePositions().getEndPosition(javac.getCompilationUnit(), retType);
            tseq.move(offset + 1);
            while (tseq.moveNext() && tseq.token().id() != JavaTokenId.IDENTIFIER) {
            }
        }
        return tseq;
    }

    public static TokenSequence<JavaTokenId> findClassNameToken(CompilationInfo javac, ClassTree t) {
        TokenSequence tseq = javac.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ModifiersTree modifs = t.getModifiers();
        assert (modifs != null);
        int offset = (int)javac.getTrees().getSourcePositions().getEndPosition(javac.getCompilationUnit(), modifs);
        tseq.move(offset + 1);
        while (tseq.moveNext() && tseq.token().id() != JavaTokenId.IDENTIFIER) {
        }
        return tseq;
    }

    public static TokenSequence<JavaTokenId> findVariableNameToken(CompilationInfo javac, VariableTree t, boolean isEnum) {
        Tree start;
        TokenSequence tseq = javac.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        Tree tree = start = isEnum ? t : t.getType();
        if (start == null) {
            start = t.getModifiers();
        }
        assert (start != null);
        int offset = isEnum ? (int)javac.getTrees().getSourcePositions().getStartPosition(javac.getCompilationUnit(), start) : (int)javac.getTrees().getSourcePositions().getEndPosition(javac.getCompilationUnit(), start);
        tseq.move(offset);
        String name = t.getName().toString();
        while (tseq.moveNext() && (tseq.token().id() != JavaTokenId.IDENTIFIER || !name.contentEquals(tseq.token().text()))) {
        }
        return tseq;
    }

    private static int computeTagsWithSameNumberBefore(Tag[] tags, Tag tag) {
        int index = 0;
        for (Tag t : tags) {
            if (t == tag) {
                return index;
            }
            if (!t.name().equals(tag.name())) continue;
            ++index;
        }
        return -1;
    }

    private static int findIndex(Tag[] tags, Tag tag) {
        for (int i = 0; i < tags.length; ++i) {
            if (tag != tags[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDeprecated(CompilationInfo javac, Element elm) {
        return JavadocUtilities.findDeprecated(javac, elm) != null;
    }

    public static AnnotationMirror findDeprecated(CompilationInfo javac, Element elm) {
        TypeElement deprAnn = javac.getElements().getTypeElement("java.lang.Deprecated");
        assert (deprAnn != null);
        for (AnnotationMirror annotationMirror : javac.getElements().getAllAnnotationMirrors(elm)) {
            if (!deprAnn.equals(annotationMirror.getAnnotationType().asElement())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasInheritedDoc(CompilationInfo javac, Element elm) {
        return JavadocUtilities.findInheritedDoc(javac, elm) != null;
    }

    public static MethodDoc findInheritedDoc(CompilationInfo javac, Element elm) {
        if (elm.getKind() == ElementKind.METHOD) {
            TypeElement clazz = (TypeElement)elm.getEnclosingElement();
            return JavadocUtilities.searchInInterfaces(javac, clazz, clazz, (ExecutableElement)elm, new HashSet<TypeElement>());
        }
        return null;
    }

    private static MethodDoc searchInInterfaces(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider, Set<TypeElement> exclude) {
        MethodDoc jdoc;
        TypeElement ifceEl;
        for (TypeMirror typeMirror : class2query.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || exclude.contains(ifceEl = (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            jdoc = JavadocUtilities.searchInMethods(javac, ifceEl, overriderClass, overrider);
            if (jdoc != null) {
                return jdoc;
            }
            exclude.add(ifceEl);
        }
        for (TypeMirror typeMirror : class2query.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || (jdoc = JavadocUtilities.searchInInterfaces(javac, ifceEl = (TypeElement)((DeclaredType)typeMirror).asElement(), overriderClass, overrider, exclude)) == null) continue;
            return jdoc;
        }
        return JavadocUtilities.searchInSuperclass(javac, class2query, overriderClass, overrider, exclude);
    }

    private static MethodDoc searchInSuperclass(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider, Set<TypeElement> exclude) {
        TypeMirror superclassMirror = class2query.getSuperclass();
        if (superclassMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement superclass = (TypeElement)((DeclaredType)superclassMirror).asElement();
        MethodDoc jdoc = JavadocUtilities.searchInMethods(javac, superclass, overriderClass, overrider);
        if (jdoc != null) {
            return jdoc;
        }
        return JavadocUtilities.searchInInterfaces(javac, superclass, overriderClass, overrider, exclude);
    }

    private static MethodDoc searchInMethods(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider) {
        for (Element element : class2query.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !javac.getElements().overrides(overrider, (ExecutableElement)element, overriderClass)) continue;
            Doc jdoc = javac.getElementUtilities().javaDocFor(element);
            return jdoc != null && jdoc.getRawCommentText().length() > 0 ? (MethodDoc)jdoc : null;
        }
        return null;
    }

    public static ParamTag findParamTag(CompilationInfo javac, MethodDoc doc, String paramName, boolean inherited) {
        ExecutableElement overrider = (ExecutableElement)javac.getElementUtilities().elementFor((Doc)doc);
        TypeElement overriderClass = (TypeElement)overrider.getEnclosingElement();
        TypeElement class2query = null;
        HashSet<TypeElement> exclude = null;
        while (doc != null) {
            for (ParamTag paramTag : doc.paramTags()) {
                if (!paramName.equals(paramTag.parameterName())) continue;
                return paramTag;
            }
            if (!inherited) break;
            if (exclude == null) {
                exclude = new HashSet<TypeElement>();
            }
            if (class2query == null) {
                class2query = overriderClass;
            } else {
                Element melm = javac.getElementUtilities().elementFor((Doc)doc);
                class2query = (TypeElement)melm.getEnclosingElement();
            }
            doc = JavadocUtilities.searchInInterfaces(javac, class2query, overriderClass, overrider, exclude);
        }
        return null;
    }

    public static ThrowsTag findThrowsTag(CompilationInfo javac, MethodDoc doc, String fqn, boolean inherited) {
        ExecutableElement overrider = (ExecutableElement)javac.getElementUtilities().elementFor((Doc)doc);
        TypeElement overriderClass = (TypeElement)overrider.getEnclosingElement();
        TypeElement class2query = null;
        HashSet<TypeElement> exclude = null;
        while (doc != null) {
            for (ThrowsTag throwsTag : doc.throwsTags()) {
                Type tagType = throwsTag.exceptionType();
                String tagFQN = null;
                tagFQN = tagType != null ? throwsTag.exceptionType().qualifiedTypeName() : throwsTag.exceptionName();
                if (!tagFQN.equals(fqn)) continue;
                return throwsTag;
            }
            if (!inherited) break;
            if (exclude == null) {
                exclude = new HashSet<TypeElement>();
            }
            if (class2query == null) {
                class2query = overriderClass;
            } else {
                Element melm = javac.getElementUtilities().elementFor((Doc)doc);
                class2query = (TypeElement)melm.getEnclosingElement();
            }
            doc = JavadocUtilities.searchInInterfaces(javac, class2query, overriderClass, overrider, exclude);
        }
        return null;
    }

    public static Tag findReturnTag(CompilationInfo javac, MethodDoc doc, boolean inherited) {
        ExecutableElement overrider = (ExecutableElement)javac.getElementUtilities().elementFor((Doc)doc);
        TypeElement overriderClass = (TypeElement)overrider.getEnclosingElement();
        TypeElement class2query = null;
        HashSet<TypeElement> exclude = null;
        while (doc != null) {
            Tag[] tags = doc.tags("@return");
            if (tags.length > 0) {
                return tags[0];
            }
            if (!inherited) break;
            if (exclude == null) {
                exclude = new HashSet<TypeElement>();
            }
            if (class2query == null) {
                class2query = overriderClass;
            } else {
                Element melm = javac.getElementUtilities().elementFor((Doc)doc);
                class2query = (TypeElement)melm.getEnclosingElement();
            }
            doc = JavadocUtilities.searchInInterfaces(javac, class2query, overriderClass, overrider, exclude);
        }
        return null;
    }

    static {
        IGNORE_TOKES = new HashSet<TokenId>();
        IGNORE_TOKES.add((TokenId)JavaTokenId.WHITESPACE);
        IGNORE_TOKES.add((TokenId)JavaTokenId.BLOCK_COMMENT);
    }

    public static final class TagHandle {
        private final String name;
        private final String text;
        private final int index;

        private TagHandle(Tag tag) {
            this.name = tag.name();
            this.text = tag.text();
            this.index = JavadocUtilities.findIndex(tag.holder().tags(), tag);
        }

        public static TagHandle create(Tag tag) {
            return new TagHandle(tag);
        }

        public Tag resolve(Doc doc) {
            Tag[] tags = doc.tags();
            if (this.index < tags.length && this.name.equals(tags[this.index].name()) && this.text.equals(tags[this.index].text())) {
                return tags[this.index];
            }
            for (Tag tag : tags) {
                if (!this.name.equals(tags[this.index].name()) || !this.text.equals(tags[this.index].text())) continue;
                return tag;
            }
            return null;
        }

        public String toString() {
            return super.toString() + "[index: " + this.index + "name: " + this.name + "text: " + this.text + ']';
        }
    }
}

