/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.javadoc.httpfs.HTTPFileInputStream;
import org.netbeans.modules.javadoc.httpfs.HTTPFileSystem;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

class HTTPFileObject
extends FileObject {
    private static final long serialVersionUID = 200104L;
    transient HTTPFileSystem parentFileSystem;
    String uriStem;
    private transient HTTPFileObject parentFileObject;
    private transient Map childFileObjects;
    transient URL fileURL;
    private transient String fullFileName;
    private transient String fileName;
    private transient String fileExtension;
    private transient boolean wasFileHeaderRead;
    private transient long fileSize;
    private transient String fileMIMEType;
    private transient Date fileDate;
    private transient Hashtable fileAttributes;
    private transient boolean areFolderContentsKnown;
    private transient Vector listeners;

    HTTPFileObject(String uriStem, HTTPFileSystem parentFileSystem) {
        this.initialize(uriStem, parentFileSystem);
    }

    protected HTTPFileObject() {
    }

    private void initialize(String uriStem, HTTPFileSystem parentFileSystem) {
        try {
            this.parentFileSystem = parentFileSystem;
            this.parentFileObject = null;
            this.childFileObjects = Collections.synchronizedMap(new Hashtable());
            this.uriStem = uriStem;
            this.fileURL = new URL(parentFileSystem.baseURL, "." + uriStem);
            this.fileAttributes = new Hashtable(0);
            this.areFolderContentsKnown = true;
            this.listeners = new Vector();
            this.fullFileName = "";
            this.fileName = "";
            this.fileExtension = "";
            if (this.isFolder()) {
                this.wasFileHeaderRead = true;
                this.fullFileName = uriStem.substring(0, uriStem.length() - 1);
            } else {
                this.wasFileHeaderRead = false;
                this.fileSize = -1L;
                this.fileMIMEType = "";
                this.fileDate = new Date();
                this.fullFileName = uriStem;
            }
            this.fullFileName = this.fullFileName.substring(this.fullFileName.lastIndexOf(47) + 1);
            if (this.fullFileName.lastIndexOf(46) != -1) {
                this.fileName = this.fullFileName.substring(0, this.fullFileName.lastIndexOf(46));
                this.fileExtension = this.fullFileName.substring(this.fullFileName.lastIndexOf(46) + 1);
            } else {
                this.fileName = this.fullFileName;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.parentFileSystem.getSystemName());
        out.writeObject(this.uriStem);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String fileSystemName = (String)in.readObject();
        HTTPFileSystem newParentFileSystem = (HTTPFileSystem)Repository.getDefault().findFileSystem(fileSystemName);
        String newURIStem = (String)in.readObject();
        this.initialize(newURIStem, newParentFileSystem);
    }

    private void readFileHeader() {
        try {
            this.getFileConnection("HEAD").disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpURLConnection getFileConnection(String requestMethod) throws IOException {
        HttpURLConnection fileConnection = (HttpURLConnection)this.fileURL.openConnection();
        fileConnection.setUseCaches(true);
        fileConnection.setRequestMethod(requestMethod);
        if (!this.wasFileHeaderRead) {
            this.readFileHeadersFromConnection(fileConnection);
        }
        return fileConnection;
    }

    private HttpURLConnection getFileConnection() throws IOException {
        return this.getFileConnection("GET");
    }

    private void readFileHeadersFromConnection(HttpURLConnection fileConnection) {
        this.fileSize = fileConnection.getContentLength();
        this.fileMIMEType = fileConnection.getContentType();
        this.fileDate = new Date(fileConnection.getLastModified());
        this.wasFileHeaderRead = true;
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        if (this.parentFileSystem != null) {
            return this.parentFileSystem;
        }
        throw new FileStateInvalidException(NbBundle.getMessage(HTTPFileObject.class, (String)"MSG_FilesystemNotFound"));
    }

    public String getName() {
        return this.fileName;
    }

    public String getExt() {
        return this.fileExtension;
    }

    public String getNameExt() {
        return this.fullFileName;
    }

    public long getSize() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileSize;
    }

    public String getMIMEType() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileMIMEType;
    }

    public FileObject getParent() {
        return this.parentFileObject;
    }

    public Date lastModified() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileDate;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValid() {
        return this.fileURL != null;
    }

    public boolean isRoot() {
        return this.uriStem.equals("/");
    }

    public boolean isFolder() {
        return this.uriStem.endsWith("/");
    }

    public boolean isData() {
        return !this.isFolder();
    }

    public FileLock lock() throws IOException {
        return FileLock.NONE;
    }

    public FileObject createData(String fileName, String extension) throws IOException {
        throw new IOException();
    }

    public FileObject createFolder(String fileName) throws IOException {
        throw new IOException();
    }

    public void rename(FileLock lock, String fileName, String extension) throws IOException {
        throw new IOException();
    }

    public void delete(FileLock lock) throws IOException {
        throw new IOException();
    }

    public void setImportant(boolean isImportant) {
    }

    public Enumeration getAttributes() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileAttributes.keys();
    }

    public Object getAttribute(String attributeName) {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileAttributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Object newValue) throws IOException {
        throw new IOException();
    }

    public FileObject[] getChildren() {
        return this.getChildFileObjects(true).values().toArray(new FileObject[0]);
    }

    public FileObject getFileObject(String fileName, String extension) {
        if (extension != null && !extension.equals("")) {
            return this.child(fileName + "." + extension);
        }
        return this.child(fileName);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            return new HTTPFileInputStream(this.getFileConnection());
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException();
    }

    public void addFileChangeListener(FileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        this.listeners.remove(listener);
    }

    void addChild(HTTPFileObject newChildFileObject) {
        newChildFileObject.parentFileObject = this;
        this.childFileObjects.put(newChildFileObject.getNameExt(), newChildFileObject);
        if (!this.listeners.isEmpty() && this.areFolderContentsKnown) {
            if (newChildFileObject.isData()) {
                this.fireFileDataCreatedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)newChildFileObject, true));
            } else {
                this.fireFileFolderCreatedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)newChildFileObject, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllChildren() {
        Map map = this.childFileObjects;
        synchronized (map) {
            Iterator childIterator = this.childFileObjects.values().iterator();
            while (childIterator.hasNext()) {
                HTTPFileObject childFile = (HTTPFileObject)((Object)childIterator.next());
                childIterator.remove();
                childFile.parentFileObject = null;
                if (this.listeners.isEmpty() || !this.areFolderContentsKnown) continue;
                this.fireFileDeletedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)childFile, true));
            }
        }
    }

    void addChild(String newChildFileName) {
        this.addChild(new HTTPFileObject(newChildFileName, this.parentFileSystem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addOptionalChild(String newChildFileName) {
        boolean wasFileAdded;
        HttpURLConnection fileConnection = null;
        try {
            HTTPFileObject childFileObject = new HTTPFileObject(newChildFileName, this.parentFileSystem);
            fileConnection = childFileObject.getFileConnection("HEAD");
            if (fileConnection.getResponseCode() < 400) {
                this.addChild(childFileObject);
                wasFileAdded = true;
            } else {
                wasFileAdded = false;
            }
        }
        catch (Exception e) {
            wasFileAdded = false;
        }
        finally {
            if (fileConnection != null) {
                fileConnection.disconnect();
            }
        }
        return wasFileAdded;
    }

    HTTPFileObject child(String fullFileName) {
        return this.child(fullFileName, true);
    }

    HTTPFileObject child(String fullFileName, boolean readPackageContents) {
        return (HTTPFileObject)((Object)this.getChildFileObjects(readPackageContents).get(fullFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getChildFileObjects(boolean readPackageContents) {
        if (readPackageContents) {
            Map map = this.childFileObjects;
            synchronized (map) {
                if (!this.areFolderContentsKnown) {
                    this.readPackageContents();
                }
            }
        }
        return this.childFileObjects;
    }

    void makePackage() {
        this.areFolderContentsKnown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageContents() {
        HTTPFileObject classUseDirectory;
        HTTPFileObject packageSummaryFile = new HTTPFileObject(this.uriStem + "package-summary.html", this.parentFileSystem);
        this.addChild(packageSummaryFile);
        this.addOptionalChild(this.uriStem + "package-frame.html");
        this.addOptionalChild(this.uriStem + "package-tree.html");
        if (this.addOptionalChild(this.uriStem + "package-use.html")) {
            classUseDirectory = new HTTPFileObject(this.uriStem + "class-use/", this.parentFileSystem);
            this.addChild(classUseDirectory);
        } else {
            classUseDirectory = null;
        }
        try {
            InputStream packageFileInputStream = packageSummaryFile.getInputStream();
            HTMLEditorKit editorKit = new HTMLEditorKit();
            HTMLDocument htmlDoc = (HTMLDocument)editorKit.createDefaultDocument();
            editorKit.read(new InputStreamReader(packageFileInputStream), (Document)htmlDoc, 0);
            HTMLDocument.Iterator tagIterator = htmlDoc.getIterator(HTML.Tag.A);
            while (tagIterator.isValid()) {
                String classFileName = (String)tagIterator.getAttributes().getAttribute(HTML.Attribute.HREF);
                if (!(classFileName == null || classFileName.indexOf(47) != -1 || classFileName.startsWith(".") || classFileName.startsWith("#") || classFileName.indexOf(58) != -1 || classFileName.startsWith("package-"))) {
                    this.addChild(this.uriStem + classFileName);
                    if (classUseDirectory != null) {
                        classUseDirectory.addChild(classUseDirectory.uriStem + classFileName);
                    }
                }
                tagIterator.next();
            }
            packageFileInputStream.close();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
        }
        finally {
            this.areFolderContentsKnown = true;
        }
    }
}

