/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import javax.swing.JEditorPane;
import org.netbeans.modules.javadoc.search.GetJavaWord;
import org.netbeans.modules.javadoc.search.IndexSearch;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

public final class ShowDocAction
extends CookieAction {
    static final long serialVersionUID = 3578357584245478L;

    public ShowDocAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle(ShowDocAction.class).getString("CTL_SHOWDOC_MenuItem");
    }

    protected final Class[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowDocAction.class);
    }

    public void performAction(Node[] nodes) {
        String toFind;
        IndexSearch indexSearch = IndexSearch.getDefault();
        if (nodes.length == 1 && nodes[0] != null && (toFind = this.findTextFromNode(nodes[0])) != null) {
            indexSearch.setTextToFind(toFind);
        }
        indexSearch.open();
        indexSearch.requestActive();
    }

    private String findTextFromNode(Node n) {
        JEditorPane[] panes;
        EditorCookie ec = (EditorCookie)n.getCookie(EditorCookie.class);
        if (ec != null && (panes = ec.getOpenedPanes()) != null) {
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            for (int i = 0; i < panes.length; ++i) {
                if (!activetc.isAncestorOf((Component)panes[i])) continue;
                String s = GetJavaWord.forPane(panes[i]);
                if (s == null) break;
                return s;
            }
        }
        return n.getName();
    }

    protected boolean asynchronous() {
        return false;
    }
}

