/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.DiffPresenter;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffEditorSupport;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public class TextDiffVisualizer
extends DiffVisualizer
implements Serializable {
    private boolean contextMode = true;
    private int contextNumLines = 3;
    static final long serialVersionUID = -2481513747957146261L;
    private static final String CONTEXT_MARK1B = "*** ";
    private static final String CONTEXT_MARK1E = " ****\n";
    private static final String CONTEXT_MARK2B = "--- ";
    private static final String CONTEXT_MARK2E = " ----\n";
    private static final String CONTEXT_MARK_DELIMETER = ",";
    private static final String DIFFERENCE_DELIMETER = "***************\n";
    private static final String LINE_PREP = "  ";
    private static final String LINE_PREP_ADD = "+ ";
    private static final String LINE_PREP_REMOVE = "- ";
    private static final String LINE_PREP_CHANGE = "! ";

    public String getDisplayName() {
        return NbBundle.getMessage(TextDiffVisualizer.class, (String)"TextDiffVisualizer.displayName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TextDiffVisualizer.class, (String)"TextDiffVisualizer.shortDescription");
    }

    public boolean isContextMode() {
        return this.contextMode;
    }

    public void setContextMode(boolean contextMode) {
        this.contextMode = contextMode;
    }

    public int getContextNumLines() {
        return this.contextNumLines;
    }

    public void setContextNumLines(int contextNumLines) {
        this.contextNumLines = contextNumLines;
    }

    public Component createView(Difference[] diffs, String name1, String title1, Reader r1, String name2, String title2, Reader r2, String MIMEType) throws IOException {
        TextDiffInfo diff = new TextDiffInfo(name1, name2, title1, title2, r1, r2, diffs);
        diff.setContextMode(this.contextMode, this.contextNumLines);
        return ((TextDiffEditorSupport)diff.getOpenSupport()).createCloneableTopComponentForMe();
    }

    static InputStream differenceToLineDiffText(Difference[] diffs) {
        StringBuffer content = new StringBuffer();
        block5: for (int i = 0; i < diffs.length; ++i) {
            Difference diff = diffs[i];
            switch (diff.getType()) {
                case 1: {
                    int n3 = diff.getSecondStart();
                    int n4 = diff.getSecondEnd();
                    if (n3 == n4) {
                        content.append(diff.getFirstStart() + "a" + n3 + "\n");
                    } else {
                        content.append(diff.getFirstStart() + "a" + n3 + CONTEXT_MARK_DELIMETER + n4 + "\n");
                    }
                    TextDiffVisualizer.appendText(content, "> ", diff.getSecondText());
                    continue block5;
                }
                case 0: {
                    int n1 = diff.getFirstStart();
                    int n2 = diff.getFirstEnd();
                    if (n1 == n2) {
                        content.append(n1 + "d" + diff.getSecondStart() + "\n");
                    } else {
                        content.append(n1 + CONTEXT_MARK_DELIMETER + n2 + "d" + diff.getSecondStart() + "\n");
                    }
                    TextDiffVisualizer.appendText(content, "< ", diff.getFirstText());
                    continue block5;
                }
                case 2: {
                    int n1 = diff.getFirstStart();
                    int n2 = diff.getFirstEnd();
                    int n3 = diff.getSecondStart();
                    int n4 = diff.getSecondEnd();
                    if (n1 == n2 && n3 == n4) {
                        content.append(n1 + "c" + n3 + "\n");
                    } else if (n1 == n2) {
                        content.append(n1 + "c" + n3 + CONTEXT_MARK_DELIMETER + n4 + "\n");
                    } else if (n3 == n4) {
                        content.append(n1 + CONTEXT_MARK_DELIMETER + n2 + "c" + n3 + "\n");
                    } else {
                        content.append(n1 + CONTEXT_MARK_DELIMETER + n2 + "c" + n3 + CONTEXT_MARK_DELIMETER + n4 + "\n");
                    }
                    TextDiffVisualizer.appendText(content, "< ", diff.getFirstText());
                    content.append("---\n");
                    TextDiffVisualizer.appendText(content, "> ", diff.getSecondText());
                }
            }
        }
        return new ByteArrayInputStream(content.toString().getBytes());
    }

    private static void appendText(StringBuffer buff, String prefix, String text) {
        int endLine;
        if (text == null) {
            return;
        }
        int startLine = 0;
        do {
            if ((endLine = text.indexOf(10, startLine)) < 0) {
                endLine = text.length();
            }
            buff.append(prefix + text.substring(startLine, endLine) + "\n");
        } while ((startLine = endLine + 1) < text.length());
    }

    public static InputStream differenceToContextDiffText(TextDiffInfo diffInfo) throws IOException {
        StringBuffer content = new StringBuffer();
        content.append(CONTEXT_MARK1B);
        content.append(diffInfo.getName1());
        content.append("\n");
        content.append(CONTEXT_MARK2B);
        content.append(diffInfo.getName2());
        content.append("\n");
        int contextNumLines = diffInfo.getContextNumLines();
        Difference[] diffs = diffInfo.getDifferences();
        BufferedReader br1 = new BufferedReader(diffInfo.createFirstReader());
        BufferedReader br2 = new BufferedReader(diffInfo.createSecondReader());
        int line1 = 1;
        int line2 = 1;
        for (int i = 0; i < diffs.length; ++i) {
            int end2;
            StringBuffer context;
            int end1;
            content.append(DIFFERENCE_DELIMETER);
            int[] cr = TextDiffVisualizer.getContextRange(diffs, i, contextNumLines);
            int begin = diffs[i].getFirstStart() - contextNumLines;
            if (diffs[i].getType() == 1) {
                ++begin;
            }
            if (begin < 1) {
                begin = 1;
            }
            int n = end1 = (line1 = TextDiffVisualizer.dumpContext(0, diffs, i, cr[0], context = new StringBuffer(), contextNumLines, br1, line1)) <= cr[1] ? line1 + contextNumLines : cr[1];
            if (line1 <= cr[1] && i == diffs.length - 1) {
                String l;
                int buffer = contextNumLines;
                int existingLines = 0;
                while (buffer-- > 0 && (l = br1.readLine()) != null) {
                    ++existingLines;
                }
                if (existingLines < contextNumLines) {
                    end1 = line1 + existingLines - 1;
                }
            }
            content.append(CONTEXT_MARK1B);
            content.append(begin);
            content.append(CONTEXT_MARK_DELIMETER);
            content.append(end1);
            content.append(CONTEXT_MARK1E);
            content.append(context);
            begin = diffs[i].getSecondStart() - contextNumLines;
            if (diffs[i].getType() == 0) {
                ++begin;
            }
            if (begin < 1) {
                begin = 1;
            }
            int n2 = end2 = (line2 = TextDiffVisualizer.dumpContext(1, diffs, i, cr[0], context = new StringBuffer(), contextNumLines, br2, line2)) <= cr[2] ? line2 + contextNumLines : cr[2];
            if (line2 <= cr[2] && i == diffs.length - 1) {
                String l;
                int buffer = contextNumLines;
                int existingLines = 0;
                while (buffer-- > 0 && (l = br2.readLine()) != null) {
                    ++existingLines;
                }
                if (existingLines < contextNumLines) {
                    end2 = line2 + existingLines - 1;
                }
            }
            content.append(CONTEXT_MARK2B);
            content.append(begin);
            content.append(CONTEXT_MARK_DELIMETER);
            content.append(end2);
            content.append(CONTEXT_MARK2E);
            content.append(context);
            i = cr[0];
        }
        return new ByteArrayInputStream(content.toString().getBytes("utf8"));
    }

    private static int[] getContextRange(Difference[] diffs, int i, int contextNumLines) {
        Difference diff;
        int line1 = diffs[i].getFirstStart();
        int line2 = diffs[i].getSecondStart();
        while (i < diffs.length && (line1 + 2 * contextNumLines >= (diff = diffs[i]).getFirstStart() || line2 + 2 * contextNumLines >= diff.getSecondStart())) {
            line1 = diff.getFirstStart();
            line2 = diff.getSecondStart();
            int l1 = Math.max(0, diff.getFirstEnd() - diff.getFirstStart());
            int l2 = Math.max(0, diff.getSecondEnd() - diff.getSecondStart());
            line1 += l1;
            line2 += l2;
            ++i;
        }
        return new int[]{i - 1, line1 + contextNumLines, line2 + contextNumLines};
    }

    private static int dumpContext(int which, Difference[] diffs, int i, int j, StringBuffer content, int contextNumLines, BufferedReader br, int line) throws IOException {
        int startLine;
        if (which == 0) {
            startLine = diffs[i].getFirstStart() - contextNumLines;
            if (diffs[i].getType() == 1) {
                ++startLine;
            }
        } else {
            startLine = diffs[i].getSecondStart() - contextNumLines;
            if (diffs[i].getType() == 0) {
                ++startLine;
            }
        }
        while (line < startLine) {
            br.readLine();
            ++line;
        }
        int position = content.length();
        boolean isChange = false;
        while (i <= j) {
            Difference diff = diffs[i];
            startLine = which == 0 ? diff.getFirstStart() : diff.getSecondStart();
            while (line < startLine) {
                content.append(LINE_PREP);
                content.append(br.readLine());
                content.append("\n");
                ++line;
            }
            int length = 0;
            String prep = null;
            switch (diffs[i].getType()) {
                case 1: {
                    if (which != 1) break;
                    prep = LINE_PREP_ADD;
                    length = diff.getSecondEnd() - diff.getSecondStart() + 1;
                    break;
                }
                case 0: {
                    if (which != 0) break;
                    prep = LINE_PREP_REMOVE;
                    length = diff.getFirstEnd() - diff.getFirstStart() + 1;
                    break;
                }
                case 2: {
                    prep = LINE_PREP_CHANGE;
                    length = which == 0 ? diff.getFirstEnd() - diff.getFirstStart() + 1 : diff.getSecondEnd() - diff.getSecondStart() + 1;
                }
            }
            if (prep != null) {
                isChange = true;
                int k = 0;
                while (k < length) {
                    content.append(prep);
                    content.append(br.readLine());
                    content.append("\n");
                    ++k;
                    ++line;
                }
            }
            ++i;
        }
        if (!isChange) {
            content.delete(position, content.length());
        } else {
            String lineStr;
            int k = 0;
            while (k < contextNumLines && (lineStr = br.readLine()) != null) {
                content.append(LINE_PREP);
                content.append(lineStr);
                content.append("\n");
                ++k;
                ++line;
            }
        }
        return line;
    }

    public static class TextDiffInfo
    extends DiffPresenter.Info {
        private Reader r1;
        private Reader r2;
        private Difference[] diffs;
        private CloneableOpenSupport openSupport;
        private boolean contextMode;
        private int contextNumLines;

        public TextDiffInfo(String name1, String name2, String title1, String title2, Reader r1, Reader r2, Difference[] diffs) {
            super(name1, name2, title1, title2, null, false, false);
            this.r1 = r1;
            this.r2 = r2;
            this.diffs = diffs;
        }

        public String getName() {
            String componentName = this.getName1();
            String name2 = this.getName2();
            if (name2 != null && name2.length() > 0) {
                componentName = componentName + " <> " + name2;
            }
            return componentName;
        }

        public String getTitle() {
            return this.getTitle1() + " <> " + this.getTitle2();
        }

        public Reader createFirstReader() {
            return this.r1;
        }

        public Reader createSecondReader() {
            return this.r2;
        }

        public Difference[] getDifferences() {
            return this.diffs;
        }

        public CloneableOpenSupport getOpenSupport() {
            if (this.openSupport == null) {
                this.openSupport = new TextDiffEditorSupport(this);
            }
            return this.openSupport;
        }

        public void setContextMode(boolean contextMode, int contextNumLines) {
            this.contextMode = contextMode;
            this.contextNumLines = contextNumLines;
        }

        public boolean isContextMode() {
            return this.contextMode;
        }

        public int getContextNumLines() {
            return this.contextNumLines;
        }
    }
}

