/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.openide.ErrorManager;

class DecoratedEditorPane
extends JEditorPane
implements PropertyChangeListener {
    private Difference[] currentDiff;
    private DiffContentPanel master;

    public DecoratedEditorPane(DiffContentPanel master) {
        this.setBorder(null);
        this.master = master;
        master.getMaster().addPropertyChangeListener(this);
    }

    public boolean isFirst() {
        return this.master.isFirst();
    }

    public DiffContentPanel getMaster() {
        return this.master;
    }

    void setDifferences(Difference[] diff) {
        this.currentDiff = diff;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics gr) {
        block24: {
            super.paintComponent(gr);
            if (this.currentDiff == null) {
                return;
            }
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this);
            Graphics2D g = (Graphics2D)gr.create();
            Rectangle clip = g.getClipBounds();
            Stroke cs = g.getStroke();
            --clip.y;
            ++clip.height;
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)editorUI.getComponent());
            JTextComponent component = editorUI.getComponent();
            if (component == null) {
                return;
            }
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            AbstractDocument doc = (AbstractDocument)component.getDocument();
            doc.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block24;
                    Rectangle rec = textUI.modelToView(component, rootView.getView(startViewIndex).getStartOffset());
                    int y = rec == null ? 0 : rec.y;
                    int clipEndY = clip.y + clip.height;
                    Element rootElem = textUI.getRootView(component).getElement();
                    View view = rootView.getView(startViewIndex);
                    int line = rootElem.getElementIndex(view.getStartOffset());
                    ++line;
                    int curDif = this.master.getMaster().getCurrentDifference();
                    g.setColor(this.master.getMaster().getColorLines());
                    if (this.master.isFirst()) {
                        for (int i = startViewIndex; i < rootViewCount; ++i) {
                            Difference ad;
                            view = rootView.getView(i);
                            line = rootElem.getElementIndex(view.getStartOffset());
                            if ((ad = EditableDiffView.getFirstDifference(this.currentDiff, ++line)) != null) {
                                g.setStroke(curDif >= 0 && curDif < this.currentDiff.length && this.currentDiff[curDif] == ad ? this.master.getMaster().getBoldStroke() : cs);
                                int yy = y + editorUI.getLineHeight();
                                if (ad.getType() == 1) {
                                    g.drawLine(0, yy, this.getWidth(), yy);
                                    ad = null;
                                } else {
                                    if (ad.getFirstStart() == line) {
                                        g.drawLine(0, y, this.getWidth(), y);
                                    }
                                    if (ad.getFirstEnd() == line) {
                                        g.drawLine(0, yy, this.getWidth(), yy);
                                    }
                                }
                            }
                            if ((y += editorUI.getLineHeight()) < clipEndY) continue;
                            break block24;
                        }
                        break block24;
                    }
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        Difference ad;
                        view = rootView.getView(i);
                        line = rootElem.getElementIndex(view.getStartOffset());
                        if ((ad = EditableDiffView.getSecondDifference(this.currentDiff, ++line)) != null) {
                            g.setStroke(curDif >= 0 && curDif < this.currentDiff.length && this.currentDiff[curDif] == ad ? this.master.getMaster().getBoldStroke() : cs);
                            int yy = y + editorUI.getLineHeight();
                            if (ad.getType() == 0) {
                                g.drawLine(0, yy, this.getWidth(), yy);
                                ad = null;
                            } else {
                                if (ad.getSecondStart() == line) {
                                    g.drawLine(0, y, this.getWidth(), y);
                                }
                                if (ad.getSecondEnd() == line) {
                                    g.drawLine(0, yy, this.getWidth(), yy);
                                }
                            }
                        }
                        if ((y += editorUI.getLineHeight()) < clipEndY) continue;
                        break;
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }
}

